/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.display;

import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.display.AngularObjectListener;
import org.apache.zeppelin.display.AngularObjectWatcher;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AngularObject<T>
implements JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AngularObject.class);
    private static final Gson GSON = new Gson();
    private String name;
    private T object;
    private transient AngularObjectListener listener;
    private transient List<AngularObjectWatcher> watchers = new LinkedList<AngularObjectWatcher>();
    private String noteId;
    private String paragraphId;

    public AngularObject() {
    }

    public AngularObject(String name, T o, String noteId, String paragraphId, AngularObjectListener listener) {
        this.name = name;
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.listener = listener;
        this.object = o;
    }

    public String getName() {
        return this.name;
    }

    public void setNoteId(String noteId) {
        this.noteId = noteId;
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getParagraphId() {
        return this.paragraphId;
    }

    public void setParagraphId(String paragraphId) {
        this.paragraphId = paragraphId;
    }

    public boolean isGlobal() {
        return this.noteId == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AngularObject that = (AngularObject)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.noteId, that.noteId) && Objects.equals(this.paragraphId, that.paragraphId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.noteId, this.paragraphId);
    }

    public Object get() {
        return this.object;
    }

    public void emit() {
        if (this.listener != null) {
            this.listener.updated(this);
        }
    }

    public void set(T o) {
        this.set(o, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T o, boolean emit) {
        final T before = this.object;
        final T after = o;
        this.object = o;
        if (emit) {
            this.emit();
        }
        LOGGER.debug("Update angular object: {} with value: {}", (Object)this.name, o);
        final Logger logger = LoggerFactory.getLogger(AngularObject.class);
        LinkedList<AngularObjectWatcher> ws = new LinkedList<AngularObjectWatcher>();
        List<AngularObjectWatcher> list = this.watchers;
        synchronized (list) {
            ws.addAll(this.watchers);
        }
        ExecutorService executor = ExecutorFactory.singleton().createOrGet("angularObjectWatcher", 50);
        for (final AngularObjectWatcher w : ws) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        w.watch(before, after);
                    }
                    catch (Exception e) {
                        logger.error("Exception on watch", (Throwable)e);
                    }
                }
            });
        }
    }

    public void setListener(AngularObjectListener listener) {
        this.listener = listener;
    }

    public AngularObjectListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatcher(AngularObjectWatcher watcher) {
        List<AngularObjectWatcher> list = this.watchers;
        synchronized (list) {
            this.watchers.add(watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatcher(AngularObjectWatcher watcher) {
        List<AngularObjectWatcher> list = this.watchers;
        synchronized (list) {
            this.watchers.remove(watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllWatchers() {
        List<AngularObjectWatcher> list = this.watchers;
        synchronized (list) {
            this.watchers.clear();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AngularObject{");
        sb.append("noteId='").append(this.noteId).append('\'');
        sb.append(", paragraphId='").append(this.paragraphId).append('\'');
        sb.append(", object=").append(this.object);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static AngularObject<?> fromJson(String json) {
        return (AngularObject)GSON.fromJson(json, AngularObject.class);
    }
}

