/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.resource.ResourceId;

public class InvokeResourceMethodEventMessage
implements JsonSerializable {
    private static final Gson gson = new Gson();
    public final ResourceId resourceId;
    public final String methodName;
    public final String[] paramClassnames;
    public final Object[] params;
    public final String returnResourceName;

    public InvokeResourceMethodEventMessage(ResourceId resourceId, String methodName, Class[] paramtypes, Object[] params, String returnResourceName) {
        this.resourceId = resourceId;
        this.methodName = methodName;
        if (paramtypes != null) {
            this.paramClassnames = new String[paramtypes.length];
            for (int i = 0; i < this.paramClassnames.length; ++i) {
                this.paramClassnames[i] = paramtypes[i].getName();
            }
        } else {
            this.paramClassnames = null;
        }
        this.params = params;
        this.returnResourceName = returnResourceName;
    }

    public Class[] getParamTypes() throws ClassNotFoundException {
        if (this.paramClassnames == null) {
            return null;
        }
        Class[] types = new Class[this.paramClassnames.length];
        for (int i = 0; i < this.paramClassnames.length; ++i) {
            types[i] = this.getClass().getClassLoader().loadClass(this.paramClassnames[i]);
        }
        return types;
    }

    public boolean shouldPutResultIntoResourcePool() {
        return this.returnResourceName != null;
    }

    public int hashCode() {
        String hash = this.resourceId.hashCode() + this.methodName;
        if (this.paramClassnames != null) {
            for (String name : this.paramClassnames) {
                hash = hash + name;
            }
        }
        if (this.returnResourceName != null) {
            hash = hash + this.returnResourceName;
        }
        return hash.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof InvokeResourceMethodEventMessage) {
            InvokeResourceMethodEventMessage r = (InvokeResourceMethodEventMessage)o;
            return r.hashCode() == this.hashCode();
        }
        return false;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static InvokeResourceMethodEventMessage fromJson(String json) {
        return (InvokeResourceMethodEventMessage)gson.fromJson(json, InvokeResourceMethodEventMessage.class);
    }
}

