%define		localstatedir /var/lib

Name:		gnome_vfs
Summary:	The GNOME virtual file-system libraries
Version:	1.9.4
Release:	1_cvs
License:	LGPL
Group:		System Environment/Libraries
Source:		ftp://ftp.gnome.org/pub/GNOME/stable/sources/%name/%name-%{version}.tar.gz
URL:		http://www.gnome.org/
BuildRoot:	/var/tmp/%{name}-root
Requires:	control-center
Requires:       glib >= 1.3.9
Requires:	GConf >= 1.1
Requires:       oaf >= @OAF_REQUIRED@
BuildRequires:	gnome-libs-devel, control-center-devel
BuildRequires:	bonobo-activation-devel >= 0.9.1
BuildRequires:	bonobo-devel >= 1.97.0
BuildRequires:	GConf-devel >= 1.1
BuildRequires:	gtk+-devel >= @GTK_REQUIRED@
BuildRequires:	libidl-devel >= 0.7.0
BuildRequires:	ORBit-devel >= 2.3.90

%description
GNOME VFS is the GNOME virtual file system. It is the foundation of the
Nautilus file manager. It provides a modular architecture and ships with
several modules that implement support for file systems, http, ftp and others.
It provides a URI-based API, a backend supporting asynchronous file operations,
a MIME type manipulation library and other features.

%package devel
Summary:	Libraries and include files for developing GNOME VFS applications.
Group:		Development/Libraries
Requires:	%name = %{version}
Requires:	glib-devel
Requires:	bonobo-devel

%description devel
This package provides the necessary development libraries for writing
GNOME VFS modules and applications that use the GNOME VFS APIs.

%prep
%setup -q

%build

%ifarch alpha
    MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

# Needed for snapshot releases.
MYCFLAGS="$RPM_OPT_FLAGS"

if [ ! -f configure ]; then
    CFLAGS="$MYCFLAGS" ./autogen.sh $MYARCH_FLAGS \
	--enable-more-warnings --prefix=%{_prefix} \
	--localstatedir=%{localstatedir} --sysconfdir=%{_sysconfdir} \
	--mandir=%{_mandir} --libdir=%{_libdir} \
	--includedir=%{_includedir} --bindir=%{_bindir}
fi

CFLAGS="$MYCFLAGS" ./configure $MYARCH_FLAGS --enable-more-warnings \
    --prefix=%{_prefix} --localstatedir=%{localstatedir} \
    --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} \
    --libdir=%{_libdir} --includedir=%{_includedir} \
    --bindir=%{_bindir} 

make

%install
rm -rf $RPM_BUILD_ROOT

make -k sysconfdir=$RPM_BUILD_ROOT%{_sysconfdir} \
    prefix=$RPM_BUILD_ROOT%{_prefix} mandir=$RPM_BUILD_ROOT%{_mandir} \
    libdir=$RPM_BUILD_ROOT%{_libdir} bindir=$RPM_BUILD_ROOT\%{_bindir} \
    includedir=$RPM_BUILD_ROOT%{_includedir} install

%find_lang %name

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbinn/ldconfig

%postun -p /sbin/ldconfig

%files -f %{name}.lang
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%config %{_sysconfdir}/vfs/modules/*.conf
%{_libdir}/*.0
%{_libdir}/*.sh
%{_libdir}/*.so
%{_libdir}/vfs/extfs/*
%{_libdir}/vfs/modules/*.0
%{_libdir}/vfs/modules/*.so
%{_mandir}/man5/*.5*

%files devel
%defattr(-, root, root)
%{_includedir}/libgnomevfs
%{_libdir}/vfs/include/*.h
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/vfs/modules/*.a
%{_libdir}/vfs/modules/*.la
%{_bindir}/gnome-vfs-config


%changelog

* Sun Oct 21 2001 Gregory Leblanc <gleblanc@linuxweasel.com>
- some messing around with Requires: and BuildRequires
- cleaned up %files quite a bit (still not quite as good as it could be)
- removed a bunch of unnecessary %defines
