/*
 * This file provides the hack to load the proper libgnome file
 * to get the proper macros for calling the internationalization
 * functions in gnome-print
 *
 */

#ifdef ENABLE_NLS
#    include <libintl.h>
#    undef _
#    define _(String) dgettext (GETTEXT_PACKAGE, String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

/* This is to let the code in gnome-print blindly include gnome.h */
#define __GNOME_I18N_H__

