/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __bookmarks_bonoboui_menu_h
#define __bookmarks_bonoboui_menu_h

#include <glib.h>
#include <glib-object.h>
#include <bonobo/bonobo-ui-component.h>
#include "bookmarks.h"
#include "bookmarks-util.h"
#include "bookmarks-location-source.h"

#define GB_BONOBO_UI_MENU_NAME_MAX_LENGTH 40 /** Max length of a bookmark menu item */
#define GB_BONOBO_UI_MENU_TIP_MAX_LENGTH 30 /** Max length of a bookmark url tooltip */


/* object forward declarations */

typedef struct _GbBonoboUIMenu GbBonoboUIMenu;
typedef struct _GbBonoboUIMenuClass GbBonoboUIMenuClass;
typedef struct _GbBonoboUIMenuPrivate GbBonoboUIMenuPrivate;

/**
 * GbBonoboUIMenu object
 */

#define GB_TYPE_BONOBO_UI_MENU		(gb_bonobo_ui_menu_get_type())
#define GB_BONOBO_UI_MENU(object)	(G_TYPE_CHECK_INSTANCE_CAST((object), GB_TYPE_BONOBO_UI_MENU,\
					 GbBonoboUIMenu))
#define GB_BONOBO_UI_MENU_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GB_TYPE_BONOBO_UI_MENU,\
					 GbBonoboUIMenuClass))
#define GB_IS_BONOBO_UI_MENU(object)	(G_TYPE_CHECK_INSTANCE_TYPE((object), GB_TYPE_BONOBO_UI_MENU))
#define GB_IS_BONOBO_UI_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GB_TYPE_BONOBO_UI_MENU))
#define GB_BONOBO_UI_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), GB_TYPE_BONOBO_UI_MENU,\
					 GbBonoboUIMenuClass))

struct _GbBonoboUIMenuClass
{
	GObjectClass parent_class;

	/* signals */
	GbBookmarkActivatedCallback gb_bonobo_ui_menu_bookmark_activated;

};

/* Remember: fields are public read-only */
struct _GbBonoboUIMenu
{
	GObject parent_object;
	
	GbBonoboUIMenuPrivate *priv;
};

GType		gb_bonobo_ui_menu_get_type		(void);
GbBonoboUIMenu *gb_bonobo_ui_menu_new			(GbFolder *root, BonoboUIComponent *uic, 
							 const gchar *path);
void		gb_bonobo_ui_menu_set_location_source	(GbBonoboUIMenu *buim, GbLocationSource *src);


#endif
