/*
 *  Copyright (C) 2000, 2001, 2002 Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon-embed-popup-control.h"
#include "gul-gobject-misc.h"
#include "gul-bonobo-extensions.h"

#include <gtk/gtkmain.h>

enum
{
        PROP_0,
        PROP_BONOBO_CONTROL
};

struct GaleonEmbedPopupControlPrivate
{
	BonoboControl *control;
};

static void
galeon_embed_popup_control_class_init (GaleonEmbedPopupControlClass *klass);
static void
galeon_embed_popup_control_init (GaleonEmbedPopupControl *gep);
static void
galeon_embed_popup_control_finalize (GObject *object);
static void
galeon_embed_popup_control_set_property (GObject *object,
					 guint prop_id,
					 const GValue *value,
					 GParamSpec *pspec);
static void
galeon_embed_popup_control_get_property (GObject *object,
					 guint prop_id,
					 GValue *value,
					 GParamSpec *pspec);
static void
galeon_embed_popup_control_set_control (GaleonEmbedPopupControl *p, 
					BonoboControl *control);
static void
galeon_embed_popup_control_show_impl (GaleonEmbedPopup *p,
				      GaleonEmbed *embed);

static GaleonEmbedPopupClass *parent_class = NULL;

MAKE_GET_TYPE (galeon_embed_popup_control, "GaleonEmbedPopupControl", GaleonEmbedPopupControl, 
	       galeon_embed_popup_control_class_init, galeon_embed_popup_control_init, 
	       GALEON_EMBED_POPUP_TYPE);

static void
galeon_embed_popup_control_class_init (GaleonEmbedPopupControlClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	
	parent_class = GALEON_EMBED_POPUP_CLASS (g_type_class_peek_parent (klass));
	
        object_class->finalize = galeon_embed_popup_control_finalize;
	object_class->set_property = galeon_embed_popup_control_set_property;
        object_class->get_property = galeon_embed_popup_control_get_property;
	
	g_object_class_install_property (object_class,
                                         PROP_BONOBO_CONTROL,
                                         g_param_spec_object ("BonoboControl",
                                                              "BonoboControl",
                                                              "Bonobo control",
                                                              BONOBO_TYPE_CONTROL,
                                                              G_PARAM_READWRITE));
	
	GALEON_EMBED_POPUP_CLASS (klass)->show = galeon_embed_popup_control_show_impl;
}

static void
galeon_embed_popup_control_init (GaleonEmbedPopupControl *gep)
{
        gep->priv = g_new0 (GaleonEmbedPopupControlPrivate, 1);
	gep->priv->control = NULL;
}

static void
galeon_embed_popup_control_finalize (GObject *object)
{
	GaleonEmbedPopupControl *gep;
	
        g_return_if_fail (object != NULL);
        g_return_if_fail (IS_GALEON_EMBED_POPUP_CONTROL (object));
	
        gep = GALEON_EMBED_POPUP_CONTROL (object);
	
        g_return_if_fail (gep->priv != NULL);
	
        g_free (gep->priv);
	
        G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
galeon_embed_popup_control_set_property (GObject *object,
					 guint prop_id,
					 const GValue *value,
					 GParamSpec *pspec)
{
        GaleonEmbedPopupControl *p = GALEON_EMBED_POPUP_CONTROL (object);
	
        switch (prop_id)
        {
	case PROP_BONOBO_CONTROL:
		galeon_embed_popup_control_set_control (p, g_value_get_object (value));
		break;
        }
}

static void
galeon_embed_popup_control_get_property (GObject *object,
					 guint prop_id,
					 GValue *value,
					 GParamSpec *pspec)
{
        GaleonEmbedPopupControl *p = GALEON_EMBED_POPUP_CONTROL (object);
	
        switch (prop_id)
        {
	case PROP_BONOBO_CONTROL:
		g_value_set_object (value, p->priv->control);
		break;
        }
}

static void
galeon_embed_popup_control_set_control (GaleonEmbedPopupControl *p, 
					BonoboControl *control)
{
	p->priv->control = control;
}

GaleonEmbedPopupControl *
galeon_embed_popup_control_new (BonoboControl *control)
{
	GaleonEmbedPopupControl *p;
	
        p = GALEON_EMBED_POPUP_CONTROL (g_object_new (GALEON_EMBED_POPUP_CONTROL_TYPE, 
						      "BonoboControl", control,
						      NULL));
	
        g_return_val_if_fail (p->priv != NULL, NULL);
	
        return p;
}

static void
galeon_embed_popup_control_show_impl (GaleonEmbedPopup *pp,
				      GaleonEmbed *embed)
{
	GaleonEmbedPopupControl *p = GALEON_EMBED_POPUP_CONTROL (pp);
	GaleonEmbedEvent *event = galeon_embed_popup_get_event (pp);
	BonoboUIComponent *uic = bonobo_control_get_popup_ui_component (p->priv->control);
	const char *path;
	char *path_dst;
	guint button;

	galeon_embed_event_get_mouse_button (event, &button);
	galeon_embed_popup_set_embed (pp, embed);
	path = galeon_embed_popup_get_popup_path (pp);
	path_dst = g_strdup_printf ("/popups/button%d", button);

	/* this is a hack because bonobo apis for showing popups are broken */
	gul_bonobo_replace_path (uic, path, path_dst);

	bonobo_control_do_popup (p->priv->control, button,
				 gtk_get_current_event_time ());

	g_free (path_dst);
}

