/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "galeon-window-bookmark-activated-proxy.h"
#include "gul-gobject-misc.h"
#include "bookmarks-util.h"

/**
 * Private functions, only availble from this file
 */
static void
galeon_window_bookmark_activated_proxy_class_init 	(GaleonWindowBookmarkActivatedProxyClass *klass);

static void
galeon_window_bookmark_activated_proxy_init		(GaleonWindowBookmarkActivatedProxy *wbap);

static void
galeon_window_bookmark_activated_proxy_finalize_impl	(GObject *o);

static void
galeon_window_bookmark_activated_proxy_bookmark_activated_cb (GObject *sender,
							      GbBookmark *b, const gchar *url, 
							      GbBookmarkActivatedFlags f, 
							      GaleonWindowBookmarkActivatedProxy *wbap);

/* this function is defined in galeon-window.c */
void
galeon_window_bookmark_activate (GaleonWindow *w, GbBookmark *b, const gchar *url, 
				 GbBookmarkActivatedFlags f);


static gpointer g_object_class;

/**
 * WindowBookmarkActivatedProxy object
 */

MAKE_GET_TYPE (galeon_window_bookmark_activated_proxy, "GaleonWindowBookmarkActivatedProxy", 
	       GaleonWindowBookmarkActivatedProxy, galeon_window_bookmark_activated_proxy_class_init, 
	       galeon_window_bookmark_activated_proxy_init, G_TYPE_OBJECT);

static void
galeon_window_bookmark_activated_proxy_class_init (GaleonWindowBookmarkActivatedProxyClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = galeon_window_bookmark_activated_proxy_finalize_impl;
	g_object_class = g_type_class_peek_parent (klass);
}

static void 
galeon_window_bookmark_activated_proxy_init (GaleonWindowBookmarkActivatedProxy *wbap)
{
	wbap->window = NULL;
}

static void
galeon_window_bookmark_activated_proxy_finalize_impl (GObject *o)
{
	GaleonWindowBookmarkActivatedProxy *wbap = GALEON_WINDOW_BOOKMARK_ACTIVATED_PROXY (o);

	galeon_window_bookmark_activated_proxy_set_window (wbap, NULL);

	G_OBJECT_CLASS (g_object_class)->finalize (o);

}

GaleonWindowBookmarkActivatedProxy *
galeon_window_bookmark_activated_proxy_new (void)
{
	GaleonWindowBookmarkActivatedProxy *ret = g_object_new
		(GALEON_TYPE_WINDOW_BOOKMARK_ACTIVATED_PROXY, NULL);
	return ret;
}

void
galeon_window_bookmark_activated_proxy_set_window (GaleonWindowBookmarkActivatedProxy *wbap, 
						   GaleonWindow *w)
{
	if (wbap->window)
	{
		g_object_remove_weak_pointer (G_OBJECT (wbap->window),
					      (gpointer *) &wbap->window);
	}

	wbap->window = w;

	if (wbap->window)
	{
		g_object_add_weak_pointer (G_OBJECT (wbap->window), 
					   (gpointer *) &wbap->window);
	}
}

void
galeon_window_bookmark_activated_proxy_connect (GaleonWindowBookmarkActivatedProxy *wbap, 
						GObject *o)
{
	g_signal_connect (o, "bookmark-activated", 
			  G_CALLBACK (galeon_window_bookmark_activated_proxy_bookmark_activated_cb),
			  wbap);
}

static void
galeon_window_bookmark_activated_proxy_bookmark_activated_cb (GObject *sender,
							      GbBookmark *b, const gchar *url, 
							      GbBookmarkActivatedFlags f, 
							      GaleonWindowBookmarkActivatedProxy *wbap)
{
	if (wbap->window)
	{
		galeon_window_bookmark_activate (wbap->window, b, url, f);
	}
	else
	{
		/* create a new window */
		GaleonWindow *w = galeon_window_new ();
		galeon_window_bookmark_activated_proxy_set_window (wbap, w);

		galeon_window_bookmark_activate (wbap->window, b, url, f);
	}
}

