/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __gul_tbi_zoom_h
#define __gul_tbi_zoom_h

#include "gul-toolbar-item.h"

/* object forward declarations */

typedef struct _GulTbiZoom GulTbiZoom;
typedef struct _GulTbiZoomClass GulTbiZoomClass;
typedef struct _GulTbiZoomPrivate GulTbiZoomPrivate;

/**
 * TbiZoom object
 */

#define GUL_TYPE_TBI_ZOOM		(gul_tbi_zoom_get_type())
#define GUL_TBI_ZOOM(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), GUL_TYPE_TBI_ZOOM,\
					 GulTbiZoom))
#define GUL_TBI_ZOOM_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GUL_TYPE_TBI_ZOOM,\
					 GulTbiZoomClass))
#define GUL_IS_TBI_ZOOM(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), GUL_TYPE_TBI_ZOOM))
#define GUL_IS_TBI_ZOOM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GUL_TYPE_TBI_ZOOM))
#define GUL_TBI_ZOOM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), GUL_TYPE_TBI_ZOOM,\
					 GulTbiZoomClass))

struct _GulTbiZoomClass 
{
	GulTbItemClass parent_class;
	
};

/* Remember: fields are public read-only */
struct _GulTbiZoom
{
	GulTbItem parent_object;

	GulTbiZoomPrivate *priv;
};

/* this class is abstract */

GType		gul_tbi_zoom_get_type		(void);
GulTbiZoom *	gul_tbi_zoom_new		(void);

#endif
