/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * nautilus-burn-drive.h: easy to use cd burner software
 *
 * Copyright (C) 2002-2004 Red Hat, Inc.
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Alexander Larsson <alexl@redhat.com>
 *          Bastien Nocera <hadess@hadess.net>
 *          William Jon McCann <mccann@jhu.edu>
 */

#ifndef NAUTILUS_BURN_DRIVE_H
#define NAUTILUS_BURN_DRIVE_H

#include <glib.h>

G_BEGIN_DECLS

typedef enum {
	NAUTILUS_BURN_MEDIA_TYPE_BUSY,
	NAUTILUS_BURN_MEDIA_TYPE_ERROR,
	NAUTILUS_BURN_MEDIA_TYPE_UNKNOWN,
	NAUTILUS_BURN_MEDIA_TYPE_CD,
	NAUTILUS_BURN_MEDIA_TYPE_CDR,
	NAUTILUS_BURN_MEDIA_TYPE_CDRW,
	NAUTILUS_BURN_MEDIA_TYPE_DVD,
	NAUTILUS_BURN_MEDIA_TYPE_DVDR,
	NAUTILUS_BURN_MEDIA_TYPE_DVDRW,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_RAM,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_PLUS_R,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_PLUS_RW,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_PLUS_R_DL,
} NautilusBurnMediaType;

#define NAUTILUS_BURN_MEDIA_SIZE_UNKNOWN -1
#define NAUTILUS_BURN_MEDIA_SIZE_NA      -2
#define NAUTILUS_BURN_MEDIA_SIZE_BUSY    -3

typedef enum {
	NAUTILUS_BURN_DRIVE_TYPE_FILE                   = 1 << 0,
	NAUTILUS_BURN_DRIVE_TYPE_CD_RECORDER            = 1 << 1,
	NAUTILUS_BURN_DRIVE_TYPE_CDRW_RECORDER          = 1 << 2,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_RAM_RECORDER       = 1 << 3,
	/* Drives are usually DVD-R and DVD-RW */
	NAUTILUS_BURN_DRIVE_TYPE_DVD_RW_RECORDER        = 1 << 4,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_PLUS_R_RECORDER    = 1 << 5,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_PLUS_RW_RECORDER   = 1 << 6,
	NAUTILUS_BURN_DRIVE_TYPE_CD_DRIVE               = 1 << 7,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_DRIVE              = 1 << 8,
} NautilusBurnDriveType;

typedef struct NautilusBurnDrivePriv NautilusBurnDrivePriv;

typedef struct {
	NautilusBurnDriveType  type;
	char                  *display_name;
	int                    max_speed_write;
	int                    max_speed_read;
	char                  *cdrecord_id;
	char                  *device;
	NautilusBurnDrivePriv *priv;
} NautilusBurnDrive;

#define NAUTILUS_BURN_DRIVE_SIZE_TO_TIME(size) (size > 0 ? (int) (((size / 1024 / 1024) - 1) * 48 / 7): 0)

GList *               nautilus_burn_drive_get_list                 (gboolean                 recorder_only,
								    gboolean                 add_image);

NautilusBurnDrive *   nautilus_burn_drive_new                      (void);
NautilusBurnDrive *   nautilus_burn_drive_new_from_path            (const char              *device_path);
NautilusBurnDrive *   nautilus_burn_drive_get_file_image           (void);

void                  nautilus_burn_drive_free                     (NautilusBurnDrive       *drive);

gboolean              nautilus_burn_drive_equal                    (NautilusBurnDrive       *a,
								    NautilusBurnDrive       *b);

NautilusBurnDrive *   nautilus_burn_drive_copy                     (NautilusBurnDrive       *drive);
NautilusBurnMediaType nautilus_burn_drive_get_media_type           (NautilusBurnDrive       *drive);

NautilusBurnMediaType nautilus_burn_drive_get_media_type_full      (NautilusBurnDrive       *drive,
								    gboolean                *is_rewritable,
								    gboolean                *is_blank,
								    gboolean                *has_data,
								    gboolean                *has_audio);
gint64                nautilus_burn_drive_get_media_size           (NautilusBurnDrive       *drive);

gboolean              nautilus_burn_drive_lock                     (NautilusBurnDrive       *drive,
								    const char              *reason,
								    char                   **reason_for_failure);
gboolean              nautilus_burn_drive_unlock                   (NautilusBurnDrive       *drive);
gboolean              nautilus_burn_drive_unmount                  (NautilusBurnDrive       *drive);
gboolean              nautilus_burn_drive_eject                    (NautilusBurnDrive       *drive);

gboolean              nautilus_burn_drive_door_is_open             (NautilusBurnDrive       *drive);

const char *          nautilus_burn_drive_media_type_get_string    (NautilusBurnMediaType    type);

/* The following are deprecated */
NautilusBurnMediaType nautilus_burn_drive_get_media_type_from_path (const char              *device_path);
gint64                nautilus_burn_drive_get_media_size_from_path (const char              *device_path);

G_END_DECLS

#endif
