/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * test_blank.c
 * 
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: William Jon McCann
 *
 */

#include <glib.h>
#include <glib/gi18n.h>
#include <glib/gprintf.h>

#include "nautilus-burn-drive.h"

static GMainLoop *loop = NULL;

static void
media_added_cb (NautilusBurnDrive *drive,
		gpointer           data)
{
	g_print ("** media added to device %s\n", drive->device);
}

static void
media_removed_cb (NautilusBurnDrive *drive,
		  gpointer           data)
{
	g_print ("** media removed from device %s\n", drive->device);
}

static gboolean
monitor_drives (void)
{
	GList *drives, *l;

	drives = nautilus_burn_drive_get_list (FALSE, FALSE);

	for (l = drives; l != NULL; l = l->next) {
		NautilusBurnDrive *drive;

		drive = l->data;

		g_print ("Adding monitor for name: %s device: %s\n",
			 drive->display_name,
			 drive->device);

		g_object_set (drive, "enable-monitor", TRUE, NULL);
		g_signal_connect (drive, "media-added", G_CALLBACK (media_added_cb), NULL);
		g_signal_connect (drive, "media-removed", G_CALLBACK (media_removed_cb), NULL);
	}

	return FALSE;
}

int 
main (int argc, char **argv)
{
	g_type_init ();

        g_idle_add ((GSourceFunc)monitor_drives, NULL);

        loop = g_main_loop_new (NULL, FALSE);
        g_main_loop_run (loop);

	return 0;
}
