/*
 *  Copyright (C) 2004 Jean-François rameau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-dbus.h,v 1.1 2006/01/02 21:34:53 chpe Exp $
 */

#ifndef EPHY_DBUS_H
#define EPHY_DBUS_H

#include <glib-object.h>

/* Yes, we know that DBUS API isn't stable yet */
#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS

/* Epiphany's DBUS ids */
#define DBUS_EPHY_SERVICE		"org.gnome.Epiphany"
#define DBUS_EPHY_PATH			"/org/gnome/Epiphany"
#define DBUS_EPHY_INTERFACE		"org.gnome.Epiphany"

/* NetworkManager's DBUS ids */
#define DBUS_NETWORK_MANAGER_SERVICE	"org.freedesktop.NetworkManager"
#define DBUS_NETWORK_MANAGER_PATH	"/org/freedesktop/NetworkManager"
#define DBUS_NETWORK_MANAGER_INTERFACE	"org.freedesktop.NetworkManager"

#define EPHY_TYPE_DBUS		(ephy_dbus_get_type ())
#define EPHY_DBUS(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_TYPE_DBUS, EphyDbus))
#define EPHY_DBUS_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST((k), EPHY_TYPE_DBUS, EphyDbusClass))
#define EPHY_IS_DBUS(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_TYPE_DBUS))
#define EPHY_IS_DBUS_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_TYPE_DBUS))
#define EPHY_DBUS_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), EPHY_TYPE_DBUS, EphyDbusClass))

typedef struct _EphyDbus	EphyDbus;
typedef struct _EphyDbusPrivate	EphyDbusPrivate;
typedef struct _EphyDbusClass	EphyDbusClass;

typedef enum
{
	EPHY_DBUS_SESSION,
	EPHY_DBUS_SYSTEM
} EphyDbusBus;

struct _EphyDbus
{
	GObject parent;
	gboolean is_session_service_owner;

	/*< private >*/
	EphyDbusPrivate *priv;
};

struct _EphyDbusClass
{
	GObjectClass parent_class;

	/* Signals */
	void (* connected)	(EphyDbus *dbus,
				 EphyDbusBus kind);
	void (* disconnected)	(EphyDbus *dbus,
				 EphyDbusBus kind);
};

GType		ephy_dbus_get_type	(void);

void		ephy_dbus_startup	(EphyDbus *dbus);

void		ephy_dbus_shutdown	(EphyDbus *dbus);

DBusGConnection *ephy_dbus_get_bus	(EphyDbus *dbus,
					 EphyDbusBus kind);

DBusGProxy	*ephy_dbus_get_proxy	(EphyDbus *dbus,
					 EphyDbusBus kind);

G_END_DECLS

#endif /* !EPHY_DBUS_H */
