## intltool.m4 - Configure intltool for the target system. -*-Shell-script-*-
## Copyright (C) 2001 Eazel, Inc.
## Author: Maciej Stachowiak <mjs@noisehavoc.org>
##         Kenneth Christiansen <kenneth@gnu.org>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.

dnl IT_PROG_INTLTOOL([MINIMUM-VERSION], [no-xml])
# serial 2 IT_PROG_INTLTOOL
AC_DEFUN([IT_PROG_INTLTOOL],
[AC_PREREQ([2.50])dnl

case "$am__api_version" in
    1.[01234])
	AC_MSG_ERROR([Automake 1.5 or newer is required to use intltool])
    ;;
    *)
    ;;
esac

if test -n "$1"; then
    AC_MSG_CHECKING(for intltool >= $1)

    INTLTOOL_REQUIRED_VERSION_AS_INT=`echo $1 | awk -F. '{ print $ 1 * 100 + $ 2; }'`
    INTLTOOL_APPLIED_VERSION=`awk -F\" '/\\$VERSION / { print $ 2; }' ${ac_aux_dir}/intltool-update.in`
    [INTLTOOL_APPLIED_VERSION_AS_INT=`awk -F\" '/\\$VERSION / { split($ 2, VERSION, "."); print VERSION[1] * 100 + VERSION[2];}' ${ac_aux_dir}/intltool-update.in`
    ]
    AC_MSG_RESULT([$INTLTOOL_APPLIED_VERSION found])
    test "$INTLTOOL_APPLIED_VERSION_AS_INT" -ge "$INTLTOOL_REQUIRED_VERSION_AS_INT" ||
	AC_MSG_ERROR([Your intltool is too old.  You need intltool $1 or later.])
fi

  INTLTOOL_DESKTOP_RULE='%.desktop:   %.desktop.in   $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
INTLTOOL_DIRECTORY_RULE='%.directory: %.directory.in $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
     INTLTOOL_KEYS_RULE='%.keys:      %.keys.in      $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -k -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
     INTLTOOL_PROP_RULE='%.prop:      %.prop.in      $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
      INTLTOOL_OAF_RULE='%.oaf:       %.oaf.in       $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -o -p $(top_srcdir)/po $< [$]@'
     INTLTOOL_PONG_RULE='%.pong:      %.pong.in      $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
   INTLTOOL_SERVER_RULE='%.server:    %.server.in    $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -o -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
    INTLTOOL_SHEET_RULE='%.sheet:     %.sheet.in     $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
INTLTOOL_SOUNDLIST_RULE='%.soundlist: %.soundlist.in $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
       INTLTOOL_UI_RULE='%.ui:        %.ui.in        $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
      INTLTOOL_XML_RULE='%.xml:       %.xml.in       $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
      INTLTOOL_XML_NOMERGE_RULE='%.xml:       %.xml.in       $(INTLTOOL_MERGE) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u /tmp $< [$]@' 
      INTLTOOL_XAM_RULE='%.xam:       %.xml.in       $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
      INTLTOOL_KBD_RULE='%.kbd:       %.kbd.in       $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -x -u -m -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
    INTLTOOL_CAVES_RULE='%.caves:     %.caves.in     $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
  INTLTOOL_SCHEMAS_RULE='%.schemas:   %.schemas.in   $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -s -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
    INTLTOOL_THEME_RULE='%.theme:     %.theme.in     $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@' 
    INTLTOOL_SERVICE_RULE='%.service: %.service.in   $(INTLTOOL_MERGE) $(wildcard $(top_srcdir)/po/*.po) ; LC_ALL=C $(INTLTOOL_MERGE) -d -u -c $(top_builddir)/po/.intltool-merge-cache $(top_srcdir)/po $< [$]@'

AC_SUBST(INTLTOOL_DESKTOP_RULE)
AC_SUBST(INTLTOOL_DIRECTORY_RULE)
AC_SUBST(INTLTOOL_KEYS_RULE)
AC_SUBST(INTLTOOL_PROP_RULE)
AC_SUBST(INTLTOOL_OAF_RULE)
AC_SUBST(INTLTOOL_PONG_RULE)
AC_SUBST(INTLTOOL_SERVER_RULE)
AC_SUBST(INTLTOOL_SHEET_RULE)
AC_SUBST(INTLTOOL_SOUNDLIST_RULE)
AC_SUBST(INTLTOOL_UI_RULE)
AC_SUBST(INTLTOOL_XAM_RULE)
AC_SUBST(INTLTOOL_KBD_RULE)
AC_SUBST(INTLTOOL_XML_RULE)
AC_SUBST(INTLTOOL_XML_NOMERGE_RULE)
AC_SUBST(INTLTOOL_CAVES_RULE)
AC_SUBST(INTLTOOL_SCHEMAS_RULE)
AC_SUBST(INTLTOOL_THEME_RULE)
AC_SUBST(INTLTOOL_SERVICE_RULE)

# Use the tools built into the package, not the ones that are installed.
AC_SUBST(INTLTOOL_EXTRACT, '$(top_builddir)/intltool-extract')
AC_SUBST(INTLTOOL_MERGE, '$(top_builddir)/intltool-merge')
AC_SUBST(INTLTOOL_UPDATE, '$(top_builddir)/intltool-update')

AC_PATH_PROG(INTLTOOL_PERL, perl)
if test -z "$INTLTOOL_PERL"; then
   AC_MSG_ERROR([perl not found; required for intltool])
fi
if test -z "`$INTLTOOL_PERL -v | fgrep '5.' 2> /dev/null`"; then
   AC_MSG_ERROR([perl 5.x required for intltool])
fi
if test "x$2" != "xno-xml"; then
   AC_MSG_CHECKING([for XML::Parser])
   if `$INTLTOOL_PERL -e "require XML::Parser" 2>/dev/null`; then
       AC_MSG_RESULT([ok])
   else
       AC_MSG_ERROR([XML::Parser perl module is required for intltool])
   fi
fi

AC_PATH_PROG(INTLTOOL_ICONV, iconv, iconv)
AC_PATH_PROG(INTLTOOL_MSGFMT, msgfmt, msgfmt)
AC_PATH_PROG(INTLTOOL_MSGMERGE, msgmerge, msgmerge)
AC_PATH_PROG(INTLTOOL_XGETTEXT, xgettext, xgettext)

# Substitute ALL_LINGUAS so we can use it in po/Makefile
AC_SUBST(ALL_LINGUAS)
    
IT_PO_SUBDIR([po])

dnl The following is very similar to
dnl
dnl	AC_CONFIG_FILES([intltool-extract intltool-merge intltool-update])
dnl
dnl with the following slight differences:
dnl  - the *.in files are in ac_aux_dir,
dnl  - if the file haven't changed upon reconfigure, it's not touched,
dnl  - the evaluation of the third parameter enables a hack which computes
dnl    the actual value of $libdir,
dnl  - the user sees "executing intltool commands", instead of
dnl    "creating intltool-extract" and such.
dnl
dnl Nothing crucial here, and we could use AC_CONFIG_FILES, if there were
dnl a reason for it.

AC_CONFIG_COMMANDS([intltool], [

for file in intltool-extract intltool-merge intltool-update; do
  sed -e "s|@INTLTOOL_EXTRACT@|`pwd`/intltool-extract|g" \
      -e "s|@INTLTOOL_LIBDIR@|${INTLTOOL_LIBDIR}|g" \
      -e "s|@INTLTOOL_ICONV@|${INTLTOOL_ICONV}|g" \
      -e "s|@INTLTOOL_MSGFMT@|${INTLTOOL_MSGFMT}|g" \
      -e "s|@INTLTOOL_MSGMERGE@|${INTLTOOL_MSGMERGE}|g" \
      -e "s|@INTLTOOL_XGETTEXT@|${INTLTOOL_XGETTEXT}|g" \
      -e "s|@INTLTOOL_PERL@|${INTLTOOL_PERL}|g" \
	< ${ac_aux_dir}/${file}.in > ${file}.out
  if cmp -s ${file} ${file}.out 2>/dev/null; then
    rm -f ${file}.out
  else
    mv -f ${file}.out ${file}
  fi
  chmod ugo+x ${file}
  chmod u+w ${file}
done

],
[INTLTOOL_PERL='${INTLTOOL_PERL}' ac_aux_dir='${ac_aux_dir}'
prefix="$prefix" exec_prefix="$exec_prefix" INTLTOOL_LIBDIR="$libdir" 
INTLTOOL_EXTRACT='${INTLTOOL_EXTRACT}' INTLTOOL_ICONV='${INTLTOOL_ICONV}'
INTLTOOL_MSGFMT='${INTLTOOL_MSGFMT}' INTLTOOL_MSGMERGE='${INTLTOOL_MSGMERGE}'
INTLTOOL_XGETTEXT='${INTLTOOL_XGETTEXT}'])

])


# IT_PO_SUBDIR(DIRNAME)
# ---------------------
# All po subdirs have to be declared with this macro; the subdir "po" is
# declared by IT_PROG_INTLTOOL.
#
AC_DEFUN([IT_PO_SUBDIR],
[AC_PREREQ([2.53])dnl We use ac_top_srcdir inside AC_CONFIG_COMMANDS.
dnl
dnl The following CONFIG_COMMANDS should be exetuted at the very end
dnl of config.status.
AC_CONFIG_COMMANDS_PRE([
  AC_CONFIG_COMMANDS([$1/stamp-it], [
    rm -f "$1/stamp-it" "$1/stamp-it.tmp" "$1/POTFILES" "$1/Makefile.tmp"
    >"$1/stamp-it.tmp"
    [sed '/^#/d
	 s/^[[].*] *//
	 /^[ 	]*$/d
	'"s|^|	$ac_top_srcdir/|" \
      "$srcdir/$1/POTFILES.in" | sed '$!s/$/ \\/' >"$1/POTFILES"
    ]
    if test ! -f "$1/Makefile"; then
      AC_MSG_ERROR([$1/Makefile is not ready.])
    fi
    mv "$1/Makefile" "$1/Makefile.tmp"
    [sed '/^POTFILES =/,/[^\\]$/ {
		/^POTFILES =/!d
		r $1/POTFILES
	  }
	 ' "$1/Makefile.tmp" >"$1/Makefile"]
    rm -f "$1/Makefile.tmp"
    mv "$1/stamp-it.tmp" "$1/stamp-it"
  ])
])dnl
])


# deprecated macros
AU_ALIAS([AC_PROG_INTLTOOL], [IT_PROG_INTLTOOL])
# A hint is needed for aclocal from Automake <= 1.9.4:
# AC_DEFUN([AC_PROG_INTLTOOL], ...)

