/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-i18n.h>
#include "gul-gobject-misc.h"
#include "galeon-marshal.h"
#include "gul-tb-button.h"
#include "gul-gui.h"
#include "gul-string.h"
#include "galeon-stop-button.h"
#include "galeon-shell.h"
#include <gtk/gtkstock.h>
#include <string.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
#define DEBUG_MSG(x) g_print x
//#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GaleonStopButtonPrivate 
{
	GulTbButton *widget;
	gboolean sensitive;
};

/**
 * Private functions, only availble from this file
 */
static void		galeon_stop_button_class_init			(GaleonStopButtonClass *klass);
static void		galeon_stop_button_init			(GaleonStopButton *tb);
static void		galeon_stop_button_finalize_impl		(GObject *o);
static GtkWidget *	galeon_stop_button_get_widget_impl		(GulTbItem *i);
static GdkPixbuf *	galeon_stop_button_get_icon_impl		(GulTbItem *i);
static gchar *		galeon_stop_button_get_name_human_impl	(GulTbItem *i);
static gchar *		galeon_stop_button_to_string_impl		(GulTbItem *i);
static GulTbItem *	galeon_stop_button_clone_impl			(GulTbItem *i);
static void		galeon_stop_button_parse_properties_impl	(GulTbItem *i, const gchar *props);
static void		galeon_stop_button_clicked_cb			(GtkWidget *w, GaleonStopButton *b);


static gpointer gul_tb_item_class;

/**
 * TbiZoom object
 */

MAKE_GET_TYPE (galeon_stop_button, "GaleonStopButton", GaleonStopButton,
	       galeon_stop_button_class_init, 
	       galeon_stop_button_init, GALEON_TYPE_TBI);

static void
galeon_stop_button_class_init (GaleonStopButtonClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = galeon_stop_button_finalize_impl;
	
	GUL_TB_ITEM_CLASS (klass)->get_widget = galeon_stop_button_get_widget_impl;
	GUL_TB_ITEM_CLASS (klass)->get_icon = galeon_stop_button_get_icon_impl;
	GUL_TB_ITEM_CLASS (klass)->get_name_human = galeon_stop_button_get_name_human_impl;
	GUL_TB_ITEM_CLASS (klass)->to_string = galeon_stop_button_to_string_impl;
	GUL_TB_ITEM_CLASS (klass)->clone = galeon_stop_button_clone_impl;
	GUL_TB_ITEM_CLASS (klass)->parse_properties = galeon_stop_button_parse_properties_impl;

	gul_tb_item_class = g_type_class_peek_parent (klass);
}

static void 
galeon_stop_button_init (GaleonStopButton *tbi)
{
	GaleonStopButtonPrivate *p = g_new0 (GaleonStopButtonPrivate, 1);
	tbi->priv = p;

	p->sensitive = TRUE;
}

GaleonStopButton *
galeon_stop_button_new (void)
{
	GaleonStopButton *ret = g_object_new (GALEON_TYPE_STOP_BUTTON, NULL);
	return ret;
}

static void
galeon_stop_button_finalize_impl (GObject *o)
{
	GaleonStopButton *it = GALEON_STOP_BUTTON (o);
	GaleonStopButtonPrivate *p = it->priv;

	if (p->widget)
	{
		g_object_unref (p->widget);
	}

	g_free (p);
	
	DEBUG_MSG (("GaleonStopButton finalized\n"));
	
	G_OBJECT_CLASS (gul_tb_item_class)->finalize (o);
}

static void
galeon_stop_button_setup_widget (GaleonStopButton *b)
{
	GaleonStopButtonPrivate *p = b->priv;

	if (!p->widget)
	{
		galeon_stop_button_get_widget_impl (GUL_TB_ITEM (b));
	}
	g_assert (GUL_IS_TB_BUTTON (p->widget));

	gul_tb_button_set_label (p->widget, GTK_STOCK_STOP);
	gul_tb_button_set_tooltip_text (p->widget, _("Stop current data transfer"));
	gul_tb_button_set_priority (p->widget, FALSE);
	gul_tb_button_set_show_arrow (p->widget, FALSE);
	gul_tb_button_set_sensitivity (p->widget, p->sensitive);
}

static GaleonEmbed *
galeon_stop_button_get_embed (GaleonStopButton *b)
{
	GaleonWindow *window;
	GaleonEmbed *embed;

	window = galeon_tbi_get_window (GALEON_TBI (b));
	g_return_val_if_fail (window != NULL, NULL);

	embed = galeon_window_get_active_embed (window);
	g_return_val_if_fail (embed != NULL, NULL);

	return embed;
}

static void
galeon_stop_button_stop_this_tab_activate_cb (GtkMenuItem *mi, GaleonStopButton *b)
{
	GaleonEmbed *embed = galeon_stop_button_get_embed (b);
	galeon_embed_stop_load (embed);
}

static void
galeon_stop_button_stop_all_tabs_activate_cb (GtkMenuItem *mi, GaleonStopButton *b)
{
	GList *tabs;
	GaleonWindow *window;
	GList *li;

	window = galeon_tbi_get_window (GALEON_TBI (b));
	g_return_if_fail (window != NULL);

	tabs = galeon_window_get_tabs (window);
	for (li = tabs; li; li = li->next)
	{
		GaleonEmbed *embed = galeon_tab_get_embed (li->data);
		galeon_embed_stop_load (embed);
	}
	
	g_list_free (tabs);
}

static void
galeon_stop_button_stop_all_windows_activate_cb (GtkMenuItem *mi, GaleonStopButton *b)
{
	const GList *windows;
	const GList *lj;
	Session *session;

	session = galeon_shell_get_session (galeon_shell);
	windows = session_get_windows (session);

	for (lj = windows; lj; lj = lj->next)
	{
		GaleonWindow *window = lj->data;
		GList *tabs;
		GList *li;
		
		tabs = galeon_window_get_tabs (window);
		for (li = tabs; li; li = li->next)
		{
			GaleonEmbed *embed = galeon_tab_get_embed (li->data);
			galeon_embed_stop_load (embed);
		}
		
		g_list_free (tabs);
	}
}

static GtkWidget *
galeon_stop_button_get_widget_impl (GulTbItem *i)
{
	GaleonStopButton *iz = GALEON_STOP_BUTTON (i);
	GaleonStopButtonPrivate *p = iz->priv;

	if (!p->widget)
	{
		GtkMenuShell *ms;
		
		p->widget = gul_tb_button_new ();
		g_object_ref (p->widget);
		gtk_object_sink (GTK_OBJECT (p->widget));

		gul_tb_button_set_use_stock (p->widget, TRUE);
		gul_tb_button_set_enable_menu (p->widget, TRUE);
		
		galeon_stop_button_setup_widget (iz);

		gtk_widget_show (GTK_WIDGET (p->widget));
		
		g_signal_connect (gul_tb_button_get_button (p->widget), "clicked",
				  G_CALLBACK (galeon_stop_button_clicked_cb), i);

		ms = gul_tb_button_get_menu (p->widget);

		gul_gui_append_new_menuitem (GTK_WIDGET (ms), _("_Stop Loading This Tab"), 
					     G_CALLBACK (galeon_stop_button_stop_this_tab_activate_cb), i);
		gul_gui_append_new_menuitem (GTK_WIDGET (ms), _("Stop Loading All Tabs in This _Window"), 
					     G_CALLBACK (galeon_stop_button_stop_all_tabs_activate_cb), i);
		gul_gui_append_new_menuitem (GTK_WIDGET (ms), _("Stop Loading _All Tabs"), 
					     G_CALLBACK (galeon_stop_button_stop_all_windows_activate_cb), i);
	}

	return GTK_WIDGET (p->widget);
}

static GdkPixbuf *
galeon_stop_button_get_icon_impl (GulTbItem *i)
{
	static GdkPixbuf *pb_stop = NULL;

	if (!pb_stop)
	{
		/* what's the easier way? */
		GtkWidget *b = gtk_button_new ();
		pb_stop = gtk_widget_render_icon (b,
						GTK_STOCK_STOP,
						GTK_ICON_SIZE_SMALL_TOOLBAR,
						NULL);
		gtk_widget_destroy (b);
	}

	return g_object_ref (pb_stop);
}

static gchar *
galeon_stop_button_get_name_human_impl (GulTbItem *i)
{
	return g_strdup (_("Stop"));
}

static gchar *
galeon_stop_button_to_string_impl (GulTbItem *i)
{
	/* if it had any properties, the string should include them */

	return g_strdup_printf ("%s=stop_button", i->id);
}

static GulTbItem *
galeon_stop_button_clone_impl (GulTbItem *i)
{
	GulTbItem *ret = GUL_TB_ITEM (galeon_stop_button_new ());

	gul_tb_item_set_id (ret, i->id);

	return ret;
}

static void
galeon_stop_button_parse_properties_impl (GulTbItem *it, const gchar *props)
{
	/* we have no properties */
}

void
galeon_stop_button_set_sensitive (GaleonStopButton *b, gboolean s)
{
	GaleonStopButtonPrivate *p = b->priv;
	p->sensitive = s;
	if (p->widget)
	{
		gul_tb_button_set_sensitivity (p->widget, s);
	}
	else
	{
		galeon_stop_button_get_widget_impl (GUL_TB_ITEM (b));
	}
}

static void
galeon_stop_button_clicked_cb (GtkWidget *w, GaleonStopButton *b)
{
	GaleonEmbed *embed = galeon_stop_button_get_embed (b);
	galeon_embed_stop_load (embed);
}
