
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "glib.h"
#include "SRObject.h"

#define SRW_FILL_CELL 		0
#define SRW_DELIMITATOR_CELL	-1

typedef struct _SRWAccCell
{
    gchar 	*ch;
    gint  	id;
    gint  	index;
    gint 	type;
    gint	role;
    SRObject	*source;
} SRWAccCell;

typedef struct
{
    GArray 	*srw_acc_line;
    gboolean 	is_empty;
} SRWAccLine;
typedef  GArray	SRWAccOutput;

typedef enum _SRWAccAlignFlags
{
    SRW_ALIGNF_HSP_ADD_LEADING	= 0x00000001,
    SRW_ALIGNF_HSP_ADD_TRAILING	= 0x00000002,
    SRW_ALIGNF_HSP_ADD_EMBEDDED = 0x00000004,
    SRW_ALIGNF_HSP_ADD		= 0x00000007,

    SRW_ALIGNF_VSP_ADD_LEADING	= 0x00000010,
    SRW_ALIGNF_VSP_ADD_TRAILING	= 0x00000020,
    SRW_ALIGNF_VSP_ADD_EMBEDDED = 0x00000040,
    SRW_ALIGNF_VSP_ADD 		= 0x00000070,
    
    SRW_ALIGNF_ALL 		= 0x00000077
} SRWAccAlignFlags;

int 		screen_review_init 	(SRRectangle 	*clip_rectangle,
					 glong 		align_flags);
void		screen_review_terminate	(void);				  

SRWAccLine *	screen_review_get_line 	(int 		line_number,
					 int 		*y1,
					 int 		*y2);

