/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "galeon-embed.h"
#include "galeon-marshal.h"

#if !defined (ENABLE_MOZILLA_EMBED) && !defined (ENABLE_GTKHTML_EMBED)
#error "At least one embed needs to be enabled"
#endif

#ifdef ENABLE_MOZILLA_EMBED
#include "mozilla-embed.h"
#include "mozilla-embed-shell.h"
#endif

#ifdef ENABLE_GTKHTML_EMBED
#include "gtkhtml-embed.h"
#include "gtkhtml-embed-shell.h"
#endif

enum
{
	NEW_WINDOW,
	LINK_MESSAGE,
	JS_STATUS,
	LOCATION,
	TITLE,
	PROGRESS,
	NET_STATE,
	VISIBILITY,
	DESTROY_BRSR,
	OPEN_URI,
	SIZE_TO,
	DOM_MOUSE_CLICK,
	DOM_MOUSE_DOWN,
	SECURITY_CHANGE,
	ZOOM_CHANGE,
	FAVICON,
	LAST_SIGNAL
};

static void
galeon_embed_base_init (gpointer base_class);

struct GaleonEmbedPrivate
{
	gpointer dummy;
};

static guint galeon_embed_signals[LAST_SIGNAL] = { 0 };

GType 
galeon_embed_get_type (void)
{
        static GType galeon_embed_type = 0;

        if (galeon_embed_type == 0)
        {
                static const GTypeInfo our_info =
                {
                        sizeof (GaleonEmbedClass),
                        galeon_embed_base_init,
                        NULL,
                };

                galeon_embed_type = g_type_register_static (G_TYPE_INTERFACE,
							    "GaleonEmbed",
							    &our_info, 
							    (GTypeFlags)0);
        }

        return galeon_embed_type;
}

static void
galeon_embed_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;
	
  	if (! initialized)
    	{	
	galeon_embed_signals[NEW_WINDOW] =
                g_signal_new ("ge_new_window",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, new_window),
                              NULL, NULL,
                              galeon_marshal_VOID__POINTER_INT,
			      G_TYPE_NONE,
                              2,
                              G_TYPE_POINTER,
			      G_TYPE_INT);
	galeon_embed_signals[LINK_MESSAGE] =
                g_signal_new ("ge_link_message",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, link_message),
                              NULL, NULL,
                              galeon_marshal_VOID__STRING,
                              G_TYPE_NONE,
                              1,
			      G_TYPE_STRING);
	galeon_embed_signals[JS_STATUS] =
                g_signal_new ("ge_js_status",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, js_status),
                              NULL, NULL,
                              galeon_marshal_VOID__STRING,
			      G_TYPE_NONE,
                              1,
			      G_TYPE_STRING);
	galeon_embed_signals[LOCATION] =
                g_signal_new ("ge_location",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, location),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__VOID,
                              G_TYPE_NONE,
                              0);
	galeon_embed_signals[TITLE] =
                g_signal_new ("ge_title",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, title),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__VOID,
                              G_TYPE_NONE,
                              0);
	galeon_embed_signals[PROGRESS] =
                g_signal_new ("ge_progress",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, progress),
                              NULL, NULL,
                              galeon_marshal_VOID__STRING_INT_INT,
                              G_TYPE_NONE,
                              3,
			      G_TYPE_STRING,
			      G_TYPE_INT,
			      G_TYPE_INT);	
	galeon_embed_signals[NET_STATE] =
                g_signal_new ("ge_net_state",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, net_state),
                              NULL, NULL,
                              galeon_marshal_VOID__STRING_INT,
                              G_TYPE_NONE,
                              2,
			      G_TYPE_STRING,
			      G_TYPE_INT);
	galeon_embed_signals[VISIBILITY] =
                g_signal_new ("ge_visibility",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, visibility),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__BOOLEAN,
                              G_TYPE_NONE,
                              1,
			      G_TYPE_BOOLEAN);
	galeon_embed_signals[DESTROY_BRSR] =
                g_signal_new ("ge_destroy_brsr",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, destroy_brsr),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__VOID,
                              G_TYPE_NONE,
                              0);
	galeon_embed_signals[OPEN_URI] =
                g_signal_new ("ge_open_uri",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_LAST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, open_uri),
                              NULL, NULL,
                              galeon_marshal_INT__STRING,
                              G_TYPE_INT,
                              1,
			      G_TYPE_STRING);
	galeon_embed_signals[SIZE_TO] =
                g_signal_new ("ge_size_to",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_LAST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, size_to),
                              NULL, NULL,
                              galeon_marshal_VOID__INT_INT,
                              G_TYPE_NONE,
                              2,
			      G_TYPE_INT,
			      G_TYPE_INT);
	galeon_embed_signals[DOM_MOUSE_DOWN] =
                g_signal_new ("ge_dom_mouse_down",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_LAST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, dom_mouse_down),
                              NULL, NULL,
                              galeon_marshal_INT__OBJECT,
                              G_TYPE_INT,
                              1,
			      G_TYPE_POINTER);
	galeon_embed_signals[DOM_MOUSE_CLICK] =
                g_signal_new ("ge_dom_mouse_click",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_LAST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, dom_mouse_click),
                              NULL, NULL,
                              galeon_marshal_INT__OBJECT,
                              G_TYPE_INT,
                              1,
			      G_TYPE_POINTER);
	galeon_embed_signals[SECURITY_CHANGE] =
                g_signal_new ("ge_security_change",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_LAST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, security_change),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__INT,
                              G_TYPE_NONE,
                              1,
			      G_TYPE_INT);
	galeon_embed_signals[ZOOM_CHANGE] =
                g_signal_new ("ge_zoom_change",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_LAST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, zoom_change),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__INT,
                              G_TYPE_NONE,
                              1,
			      G_TYPE_INT);
	galeon_embed_signals[FAVICON] =
                g_signal_new ("ge_favicon",
                              GALEON_EMBED_TYPE,
                              G_SIGNAL_RUN_FIRST,
                              G_STRUCT_OFFSET (GaleonEmbedClass, favicon),
                              NULL, NULL,
                              g_cclosure_marshal_VOID__STRING,
                              G_TYPE_NONE,
                              1,
			      G_TYPE_STRING);
	initialized = TRUE;
	}
}

GaleonEmbed *
galeon_embed_new (GObject *shell)
{
#ifdef ENABLE_MOZILLA_EMBED
	if (IS_MOZILLA_EMBED_SHELL (shell))
	{	
		return GALEON_EMBED (g_object_new 
			(MOZILLA_EMBED_TYPE, NULL));
	}
#endif
	
#ifdef ENABLE_GTKHTML_EMBED
	if (IS_GTKHTML_EMBED_SHELL (shell))
	{
		return GALEON_EMBED (g_object_new 
			(GTKHTML_EMBED_TYPE, NULL));
	}
#endif

	g_assert_not_reached ();

	return NULL;
}

void 
galeon_embed_get_capabilities (GaleonEmbed *embed,
                               EmbedCapabilities *caps)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        klass->get_capabilities (embed, caps);
}

gresult 
galeon_embed_load_url (GaleonEmbed *embed, 
                       const char *url)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->load_url (embed, url);
}

gresult 
galeon_embed_stop_load (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->stop_load (embed);
}

gresult 
galeon_embed_can_go_back (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->can_go_back (embed);
}

gresult 
galeon_embed_can_go_forward (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->can_go_forward (embed);
}

gresult 
galeon_embed_can_go_up (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->can_go_up (embed);
}

gresult 
galeon_embed_get_go_up_list (GaleonEmbed *embed, GSList **l)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->get_go_up_list (embed, l);
}

gresult 
galeon_embed_go_back (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->go_back (embed);
}

gresult  
galeon_embed_go_forward (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->go_forward (embed);
}

gresult
galeon_embed_go_up (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->go_up (embed);
}

gresult
galeon_embed_render_data (GaleonEmbed *embed, 
                          const char *data,
                          guint32 len,
                          const char *base_uri, 
                          const char *mime_type)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->render_data (embed, data, len, base_uri, mime_type);
}

gresult
galeon_embed_open_stream (GaleonEmbed *embed,
                          const char *base_uri,
                          const char *mime_type)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->open_stream (embed, base_uri, mime_type);
}

gresult
galeon_embed_append_data (GaleonEmbed *embed,
                          const char *data, 
                          guint32 len)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->append_data (embed, data, len);
}

gresult
galeon_embed_close_stream (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->close_stream (embed);
}

gresult
galeon_embed_get_title (GaleonEmbed *embed,
                        char **title)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->get_title (embed, title);
}

gresult 
galeon_embed_get_location (GaleonEmbed *embed, 
                           gboolean toplevel,
                           gboolean requested,
                           char **location)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->get_location (embed, toplevel, requested, location);
}

gresult 
galeon_embed_reload (GaleonEmbed *embed, 
                     EmbedReloadFlags flags)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->reload (embed, flags);
}

gresult
galeon_embed_copy_page (GaleonEmbed *dest,
			GaleonEmbed *source,
			EmbedDisplayType display_type)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (dest);
	return klass->copy_page (dest, source, display_type);
}	

gresult 
galeon_embed_grab_focus (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->grab_focus (embed);
}

gresult
galeon_embed_get_link_tags (GaleonEmbed *embed,
                            const char *link_type,
                            GList **tags)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->get_link_tags (embed, link_type, tags);
}

gresult
galeon_embed_zoom_set (GaleonEmbed *embed, 
                       int zoom, 
                       gboolean reflow)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->zoom_set (embed, zoom, reflow);
}

gresult
galeon_embed_zoom_get (GaleonEmbed *embed,
                       int *zoom)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->zoom_get (embed, zoom);
}

gresult 
galeon_embed_selection_can_cut (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->selection_can_cut (embed);
}

gresult 
galeon_embed_selection_can_copy (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->selection_can_copy (embed);
}

gresult 
galeon_embed_can_paste (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->can_paste (embed);
}

gresult 
galeon_embed_select_all (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->select_all (embed);
}

gresult
galeon_embed_selection_cut (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->selection_cut (embed);
}

gresult
galeon_embed_selection_copy (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->selection_copy (embed);
}

gresult
galeon_embed_paste (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->paste (embed);
}

gresult
galeon_embed_shistory_count  (GaleonEmbed *embed,
                              int *count)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->shistory_count (embed, count);
}

gresult
galeon_embed_shistory_get_nth (GaleonEmbed *embed, 
                               int nth,
                               gboolean is_relative,
                               char **url,
                               char **title)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->shistory_get_nth (embed, nth, is_relative, url, title);
}

gresult
galeon_embed_shistory_get_pos (GaleonEmbed *embed,
                               int *pos)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->shistory_get_pos (embed, pos);
}

gresult
galeon_embed_shistory_go_nth (GaleonEmbed *embed, 
                              int nth)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->shistory_go_nth (embed, nth);
}

gboolean
galeon_embed_shistory_copy (GaleonEmbed *source,
                            GaleonEmbed *dest,
			    gboolean back_history,
			    gboolean forward_history,
			    gboolean set_current)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (source);
        return klass->shistory_copy (source, dest, back_history, forward_history, set_current);
}

gresult
galeon_embed_scroll (GaleonEmbed *embed, 
                     EmbedScrollDirection direction)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->scroll (embed, direction);
}

gresult
galeon_embed_fine_scroll (GaleonEmbed *embed, 
			  int horiz, int vert)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->fine_scroll (embed, horiz, vert);
}

gresult
galeon_embed_get_security_level (GaleonEmbed *embed, 
                                 EmbedSecurityLevel *level,
                                 char **description)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->get_security_level (embed, level, description);
}

gresult
galeon_embed_find (GaleonEmbed *embed,
                   EmbedFindInfo *info)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->find (embed, info);
}

gresult
galeon_embed_set_charset (GaleonEmbed *embed,
                          const char *charset)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->set_charset (embed, charset);
}

gresult
galeon_embed_print (GaleonEmbed *embed, 
                    EmbedPrintInfo *info)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->print (embed, info);
}

gresult
galeon_embed_print_preview_close (GaleonEmbed *embed)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
        return klass->print_preview_close (embed);
}

gresult
galeon_embed_print_preview_num_pages (GaleonEmbed *embed, gint *retNum)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
	return klass->print_preview_num_pages (embed, retNum);
}	

gresult
galeon_embed_print_preview_navigate (GaleonEmbed *embed,
				     EmbedPrintPreviewNavType navType,
				     gint pageNum)
{
	GaleonEmbedClass *klass = GALEON_EMBED_GET_CLASS (embed);
	return klass->print_preview_navigate (embed, navType, pageNum);
}

