/*
   Copyright (C) 2004 James Bowes <bowes@cs.dal.ca>
   Copyright (C) 2004 GNOME Love Project <gnome-love@gnome.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef GNOME_KEYRING_MANAGER_NEW_ITEM_DIALOG_H
#define GNOME_KEYRING_MANAGER_NEW_ITEM_DIALOG_H

#include <config.h>

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GKM_TYPE_NEW_ITEM_DIALOG            (gkm_new_item_dialog_get_type ())
#define GKM_NEW_ITEM_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKM_TYPE_NEW_ITEM_DIALOG, GKMNewItemDialog))
#define GKM_NEW_ITEM_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  GKM_TYPE_NEW_ITEM_DIALOG, GKMNewItemDialogClass))
#define GKM_IS_NEW_ITEM_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKM_TYPE_NEW_ITEM_DIALOG))
#define GKM_IS_NEW_ITEM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GKM_TYPE_NEW_ITEM_DIALOG))
#define GKM_NEW_ITEM_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  GKM_TYPE_NEW_ITEM_DIALOG, GKMNewItemDialogClass))

typedef struct _GKMNewItemDialog         GKMNewItemDialog;
typedef struct _GKMNewItemDialogClass    GKMNewItemDialogClass;
typedef struct _GKMNewItemDialogPrivate  GKMNewItemDialogPrivate;

struct _GKMNewItemDialog
{
  GtkDialog dialog;

  GKMNewItemDialogPrivate *priv;
};

struct _GKMNewItemDialogClass
{
  GtkDialogClass dialog_class;
};

GType gkm_new_item_dialog_get_type (void);

GtkWidget *gkm_new_item_dialog_new (const gchar *keyring_name,
				    GtkWindow   *parent);

GnomeKeyringItemType gkm_new_item_dialog_get_item_type (GKMNewItemDialog *dialog);

const gchar *gkm_new_item_dialog_get_item_name (GKMNewItemDialog *dialog);

gchar *gkm_new_item_dialog_get_item_secret (GKMNewItemDialog *dialog);

GnomeKeyringAttributeList *gkm_new_item_dialog_get_item_attribute_list (GKMNewItemDialog *dialog);

G_END_DECLS

#endif
