#ifndef __GDICT_DEFBOX_H_
#define __GDICT_DEFBOX_H_

/* $Id: gdict-defbox.h,v 1.11 2004/12/13 20:10:20 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Bradford Hovinen <hovinen@udel.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict main window
 *
 */

#include <gtk/gtk.h>
#include "dict.h"

#define GDICT_TYPE_DEFBOX            (gdict_defbox_get_type ())
#define GDICT_DEFBOX(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDICT_TYPE_DEFBOX, GDictDefbox))
#define GDICT_DEFBOX_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GDICT_TYPE_DEFBOX, GDictDefboxClass))
#define GDICT_IS_DEFBOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDICT_TYPE_DEFBOX))
#define GDICT_IS_DEFBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDICT_TYPE_DEFBOX))
#define GDICT_DEFBOX_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GDICT_TYPE_DEFBOX, GDictDefboxClass))

typedef struct _GDictDefbox        GDictDefbox;
typedef struct _GDictDefboxClass   GDictDefboxClass;

#include "gdict-app.h"

struct _GDictDefbox 
{
    GtkTextView    text;
    dict_context_t *context;
    dict_command_t *def_cmd;
    gchar          *database;
    gpointer       gdict;
};

struct _GDictDefboxClass 
{
    GtkTextViewClass    parent_class;
    
    void (*word_lookup_start) (GDictDefbox *);
    void (*word_lookup_done)  (GDictDefbox *);
    void (*word_not_found)    (GDictDefbox *);
    void (*substr_not_found)  (GDictDefbox *);
    void (*socket_error)      (GDictDefbox *, gchar *);
};

GType	   gdict_defbox_get_type   (void);
GtkWidget *gdict_defbox_new        (gpointer gdict);

void 	   defbox_setup_tags 	   (GDictDefbox *defbox);

gint       gdict_defbox_lookup     (GDictDefbox *defbox, gchar *text);
void       gdict_defbox_clear      (GDictDefbox *defbox);
gboolean   gdict_defbox_find       (GDictDefbox *defbox, const gchar *text,
                                    gboolean start);
void       gdict_defbox_reset      (GDictDefbox *defbox,
				    dict_context_t *context);
void gdict_defbox_prepare_print    (GDictDefbox *defbox);
void gdict_defbox_print_preview (GDictDefbox *defbox);
gchar     *gdict_defbox_get_word   (GDictDefbox *defbox);
	
#endif /* __GDICT_DEFBOX_H_ */
