/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2010 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Colin Walters <walters@verbum.org>
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#if defined(GTK_DISABLE_SINGLE_INCLUDES) && !defined (__GTK_H_INSIDE__) && !defined (GTK_COMPILATION)
#error "Only <gtk/gtk.h> can be included directly."
#endif

#ifndef __GTK_APPLICATION_H__
#define __GTK_APPLICATION_H__

#include <gio/gio.h>
#include <gtk/gtkaction.h>
#include <gtk/gtkactiongroup.h>
#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_APPLICATION            (gtk_application_get_type ())
#define GTK_APPLICATION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_APPLICATION, GtkApplication))
#define GTK_APPLICATION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_APPLICATION, GtkApplicationClass))
#define GTK_IS_APPLICATION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_APPLICATION))
#define GTK_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_APPLICATION))
#define GTK_APPLICATION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_APPLICATION, GtkApplicationClass))

typedef struct _GtkApplication        GtkApplication;
typedef struct _GtkApplicationClass   GtkApplicationClass;
typedef struct _GtkApplicationPrivate GtkApplicationPrivate;

struct _GtkApplication
{
  GApplication parent;

  /*< private >*/

  GtkApplicationPrivate *priv;
};

struct _GtkApplicationClass
{
  GApplicationClass parent_class;

  /*< vfuncs >*/
  GtkWindow *(* create_window) (GtkApplication *app);
  void       (* activated)     (GtkApplication *app,
                                GVariant       *args);
  void       (* action)        (GtkApplication *app,
                                const gchar    *action_name);
  gboolean   (* quit)          (GtkApplication *app);
			       

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
  void (*_gtk_reserved9) (void);
  void (*_gtk_reserved10) (void);
};

GType                   gtk_application_get_type         (void) G_GNUC_CONST;
GtkApplication*         gtk_application_new              (const gchar      *appid,
                                                          gint             *argc,
                                                          gchar          ***argv);
void                    gtk_application_set_action_group (GtkApplication   *app,
                                                          GtkActionGroup   *group);
GtkWindow *             gtk_application_create_window    (GtkApplication   *app);
GtkWindow *             gtk_application_get_window       (GtkApplication   *app);
G_CONST_RETURN GSList * gtk_application_get_windows      (GtkApplication   *app);
void                    gtk_application_add_window       (GtkApplication   *app,
                                                          GtkWindow        *window);
void                    gtk_application_run              (GtkApplication   *app);
void                    gtk_application_quit             (GtkApplication   *app);

G_END_DECLS

#endif /* __GTK_APPLICATION_H__ */

