/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#ifndef _OPENDOCUMENT_METASTREAM_LISTENER_H_
#define _OPENDOCUMENT_METASTREAM_LISTENER_H_

// Internal inlcudes
#include "OpenDocument_Stream_Listener.h"

/** Class to handle meta-streams
 *
 */
class ABI_EXPORT OpenDocument_MetaStream_Listener : 
        public OpenDocument_Stream_Listener
{
public:
    OpenDocument_MetaStream_Listener (IE_Imp_OpenDocument* pImporter);
  
    virtual ~OpenDocument_MetaStream_Listener ();
  
    virtual void startElement (const XML_Char* pName, const XML_Char** ppAtts);
  
    virtual void endElement (const XML_Char* pName);
  
    virtual void charData (const XML_Char* pBuffer, int length);


private:

    /**
     * Holds the character data of the element being parsed. 
     */
    UT_UTF8String m_charData;
  
  
    /**
     * Stores the element attributes defined on the element start tag.
     */
    UT_UTF8Hash m_attribs;
    
    
    /**
     * Holds all keywords defined on the meta stream.
     * 
     * This is necessary because OpenDocument defines one keyword per
     * meta:keyword element and AbiWord holds all the keywords on a single
     * abiword:keywords element.
     */
    UT_UTF8String m_keywords;

};




#endif //_OPENDOCUMENT_METASTREAM_LISTENER_H_
