/* 
 * Copyright (c) 2005 Robert Staudinger <robsta@stereolyzer.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __ABI_VIEW_H__
#define __ABI_VIEW_H__


#include <gtk/gtk.h>
#include "abi-view-priv.h"
#include "abi-doc.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ABI_TYPE_VIEW                  (abi_view_get_type ())
#define ABI_VIEW(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), ABI_TYPE_VIEW, AbiView))
#define ABI_VIEW_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), ABI_TYPE_VIEW, AbiViewClass))
#define ABI_IS_VIEW(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ABI_TYPE_VIEW))
#define ABI_IS_VIEW_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), ABI_TYPE_VIEW))
#define ABI_VIEW_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), ABI_TYPE_VIEW, AbiViewClass))


GType      abi_view_get_type         (void) G_GNUC_CONST;
GtkWidget* abi_view_new              (void);
gboolean   abi_view_load_file		 (AbiView *self, const gchar *filename);
/*
AbiDoc*    abi_view_get_doc 		 (AbiView *view);
void	   abi_view_set_doc			 (AbiView *view, AbiDoc *doc);
*/

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ABI_VIEW_H__ */
