/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef _ATOMIXED_THEME_IMG_EDITOR_H 
#define _ATOMIXED_THEME_IMG_EDITOR_H 

#include <gnome.h>
#include "theme.h"

typedef struct _ThemeImgEditor ThemeImgEditor; 
typedef enum _ThemeImgEditorType ThemeImgEditorType;

struct _ThemeImgEditor
{
	gchar *gil_name;
	GnomeIconList *gil;
	ThemeImageKind kind;
	
	Theme *current_theme;
	GList *element_list;
};

ThemeImgEditor* theme_img_editor_new(const gchar *gil_name, ThemeImageKind kind);

void theme_img_editor_destroy(ThemeImgEditor *tie);

void theme_img_editor_set_theme(ThemeImgEditor *tie, Theme *theme);

void theme_img_editor_change_text(ThemeImgEditor *tie, gint num, gchar *text);

void theme_img_editor_show_context_menu(ThemeImgEditor *tie);

#endif /* _ATOMIXED_THEME_IMG_EDITOR_H_ */
