/***************************************************************************
 *            burn.h
 *
 *  ven mar  3 18:50:18 2006
 *  Copyright  2006  Rouquier Philippe
 *  brasero-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BURN_H
#define BURN_H

#include <glib.h>
#include <glib-object.h>

#include <nautilus-burn-drive.h>

#include "burn-basics.h"
#include "burn-caps.h"
#include "burn-session.h"
#include "burn-task.h"
#include "burn-medium.h"

G_BEGIN_DECLS

#define BRASERO_TYPE_BURN         (brasero_burn_get_type ())
#define BRASERO_BURN(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BRASERO_TYPE_BURN, BraseroBurn))
#define BRASERO_BURN_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BRASERO_TYPE_BURN, BraseroBurnClass))
#define BRASERO_IS_BURN(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BRASERO_TYPE_BURN))
#define BRASERO_IS_BURN_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BRASERO_TYPE_BURN))
#define BRASERO_BURN_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BRASERO_TYPE_BURN, BraseroBurnClass))

typedef struct BraseroBurnPrivate BraseroBurnPrivate;

typedef struct {
	GObject parent;
	BraseroBurnPrivate *priv;
} BraseroBurn;

typedef struct {
	GObjectClass parent_class;

	/* signals */
	BraseroBurnResult		(*insert_media_request)		(BraseroBurn *obj,
									 BraseroBurnError error,
									 BraseroMediumInfo required_media);

	BraseroBurnResult		(*ask_disable_joliet)		(BraseroBurn *obj);

	BraseroBurnResult		(*warn_data_loss)		(BraseroBurn *obj);
	BraseroBurnResult		(*warn_previous_session_loss)	(BraseroBurn *obj);
	BraseroBurnResult		(*warn_audio_to_appendable)	(BraseroBurn *obj);
	BraseroBurnResult		(*warn_rewritable)		(BraseroBurn *obj);

	void				(*progress_changed)		(BraseroBurn *obj,
									 gdouble overall_progress,
									 gdouble action_progress,
									 glong time_remaining);
	void				(*action_changed)		(BraseroBurn *obj,
									 BraseroBurnAction action);
} BraseroBurnClass;

GType brasero_burn_get_type ();
BraseroBurn *brasero_burn_new ();

BraseroBurnResult 
brasero_burn_record (BraseroBurn *burn,
		     BraseroBurnFlag flags,
		     NautilusBurnDrive *drive,
		     gint speed,
		     const BraseroTrackSource *source,
		     const gchar *output,
		     GError **error);

BraseroBurnResult
brasero_burn_blank (BraseroBurn *burn,
		    BraseroBurnFlag flags,
		    NautilusBurnDrive *drive,
		    gboolean fast,
		    GError **error);

BraseroBurnResult
brasero_burn_cancel (BraseroBurn *burn, gboolean protect);

BraseroBurnResult
brasero_burn_status (BraseroBurn *burn,
		     BraseroMediumInfo *info,
		     gint64 *isosize,
		     gint64 *written,
		     gint64 *rate);

void
brasero_burn_set_session (BraseroBurn *burn,
			  BraseroBurnSession *session);

void
brasero_burn_get_action_string (BraseroBurn *burn,
				BraseroBurnAction action,
				gchar **string);

#endif /* BURN_H */
