/* cheese-effects-manager.c generated by valac 0.14.2, the Vala compiler
 * generated from cheese-effects-manager.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <cheese-effect.h>
#include <glib/gi18n-lib.h>


#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_effects_manager_parent_class = NULL;

#define GROUP_NAME "Effect"
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
enum  {
	CHEESE_EFFECTS_MANAGER_DUMMY_PROPERTY
};
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
static gboolean cheese_effects_manager_cmp_value (CheeseEffect* a, CheeseEffect* b);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gint cheese_effects_manager_sort_value (CheeseEffect* a, CheeseEffect* b);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
static void cheese_effects_manager_finalize (GObject* obj);


CheeseEffectsManager* cheese_effects_manager_construct (GType object_type) {
	CheeseEffectsManager * self = NULL;
	GeeArrayList* _tmp0_;
	self = (CheeseEffectsManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GEqualFunc) cheese_effects_manager_cmp_value);
	_g_object_unref0 (self->effects);
	self->effects = _tmp0_;
	return self;
}


CheeseEffectsManager* cheese_effects_manager_new (void) {
	return cheese_effects_manager_construct (CHEESE_TYPE_EFFECTS_MANAGER);
}


/**
   * Add the effects into the manager.
   */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void cheese_effects_manager_load_effects (CheeseEffectsManager* self) {
	GList* _tmp0_ = NULL;
	GList* effect_list;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_effect_load_effects ();
	effect_list = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GList* _tmp5_;
				guint _tmp6_ = 0U;
				GeeArrayList* _tmp7_;
				GList* _tmp8_;
				gint _tmp9_;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = effect_list;
				_tmp6_ = g_list_length (_tmp5_);
				if (!(((guint) _tmp4_) < _tmp6_)) {
					break;
				}
				_tmp7_ = self->effects;
				_tmp8_ = effect_list;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (CheeseEffect*) _tmp11_);
			}
		}
	}
	_tmp12_ = self->effects;
	gee_list_sort ((GeeList*) _tmp12_, (GCompareFunc) cheese_effects_manager_sort_value);
	_tmp13_ = self->effects;
	_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ > 0) {
		const gchar* _tmp16_ = NULL;
		CheeseEffect* _tmp17_;
		CheeseEffect* e;
		GeeArrayList* _tmp18_;
		CheeseEffect* _tmp19_;
		_tmp16_ = _ ("No Effect");
		_tmp17_ = cheese_effect_new (_tmp16_, "identity");
		e = _tmp17_;
		_tmp18_ = self->effects;
		_tmp19_ = e;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp18_, 0, _tmp19_);
		_g_object_unref0 (e);
	}
	__g_list_free__g_object_unref0_0 (effect_list);
}


/**
   * Search for and return the requested effect.
   *
   * @param name the name of the effect to search for
   * @return the effect that which matches the supplied name, or null
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name) {
	CheeseEffect* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _eff_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _eff_size;
		gint _eff_index;
		_tmp0_ = self->effects;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_eff_list = _tmp1_;
		_tmp2_ = _eff_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_eff_size = _tmp4_;
		_eff_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			CheeseEffect* eff;
			CheeseEffect* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp5_ = _eff_index;
			_eff_index = _tmp5_ + 1;
			_tmp6_ = _eff_index;
			_tmp7_ = _eff_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _eff_list;
			_tmp9_ = _eff_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			eff = (CheeseEffect*) _tmp10_;
			_tmp11_ = eff;
			_tmp12_ = cheese_effect_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				result = eff;
				_g_object_unref0 (_eff_list);
				return result;
			}
			_g_object_unref0 (eff);
		}
		_g_object_unref0 (_eff_list);
	}
	result = NULL;
	return result;
}


/**
   * Compare two effects by the pipeline description.
   *
   * @param a an effect to compare against
   * @param b another effect to compare against
   * @return true if the effects are the same, false otherwise
   */
static gboolean cheese_effects_manager_cmp_value (CheeseEffect* a, CheeseEffect* b) {
	gboolean result = FALSE;
	CheeseEffect* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	CheeseEffect* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = cheese_effect_get_pipeline_desc (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = b;
	_tmp4_ = cheese_effect_get_pipeline_desc (_tmp3_);
	_tmp5_ = _tmp4_;
	result = g_strcmp0 (_tmp2_, _tmp5_) == 0;
	return result;
}


/**
   * A sort function for effects
   *
   * @param a an effect to sort against
   * @param b another effect to sort against
   * @return -1 if a is less than b, 0 if the effects are the same and 1 if a
   * is greater than b
   */
static gint cheese_effects_manager_sort_value (CheeseEffect* a, CheeseEffect* b) {
	gint result = 0;
	CheeseEffect* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	CheeseEffect* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = cheese_effect_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) (-1));
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = cheese_effect_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) (-1));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strcmp0 (_tmp4_, _tmp9_) < 0;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
	if (_tmp10_) {
		result = -1;
		return result;
	} else {
		CheeseEffect* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		CheeseEffect* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp11_ = a;
		_tmp12_ = cheese_effect_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) (-1));
		_tmp15_ = _tmp14_;
		_tmp16_ = b;
		_tmp17_ = cheese_effect_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) (-1));
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strcmp0 (_tmp15_, _tmp20_) > 0;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp15_);
		if (_tmp21_) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static void cheese_effects_manager_class_init (CheeseEffectsManagerClass * klass) {
	cheese_effects_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = cheese_effects_manager_finalize;
}


static void cheese_effects_manager_instance_init (CheeseEffectsManager * self) {
}


static void cheese_effects_manager_finalize (GObject* obj) {
	CheeseEffectsManager * self;
	self = CHEESE_EFFECTS_MANAGER (obj);
	_g_object_unref0 (self->effects);
	G_OBJECT_CLASS (cheese_effects_manager_parent_class)->finalize (obj);
}


GType cheese_effects_manager_get_type (void) {
	static volatile gsize cheese_effects_manager_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_effects_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseEffectsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_effects_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseEffectsManager), 0, (GInstanceInitFunc) cheese_effects_manager_instance_init, NULL };
		GType cheese_effects_manager_type_id;
		cheese_effects_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseEffectsManager", &g_define_type_info, 0);
		g_once_init_leave (&cheese_effects_manager_type_id__volatile, cheese_effects_manager_type_id);
	}
	return cheese_effects_manager_type_id__volatile;
}



