/* app-background.c - Background configuration application.  */

#include <config.h>
#include <strings.h>
#include "capplet-widget.h"

extern void background_init(void);

gint
main (gint argc, char *argv[])
{
     GnomeClient *client = NULL;
     gchar *session_args[3];

     bindtextdomain (PACKAGE, GNOMELOCALEDIR);
     textdomain (PACKAGE);
    
     switch (gnome_capplet_init("background-properties", VERSION, argc, argv, NULL, 0, NULL)) {
     case -1:
	  g_warning ("an initialization error occurred while starting 'background-properties-capplet'.\n"
		     "aborting...\n");
	  exit (1);
     case 0:
	  break;
     case 1:
	  background_imlib_init ();
	  background_properties_init ();
	  exit (0);
     }
    
     /* setup session management */
     session_args[0] = "screensaver-properties-capplet";
     session_args[1] = "--init-session-settings";
     session_args[2] = NULL;
     client = gnome_master_client ();
     gnome_client_set_restart_style (client, GNOME_RESTART_ANYWAY);
     gnome_client_set_restart_command (client, 2, session_args);
    
     /* this goes somewhere else eventually */
     background_imlib_init ();
    
     background_init();
     capplet_gtk_main();
    
     return 0;
}
