/* -*- mode: c; style: linux -*- */

/* extract-labels.c
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Written by Bradford Hovinen (hovinen@helixcode.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <glib.h>
#include <parser.h>
#include <tree.h>

static void
write_label (xmlNodePtr node, char *attr, FILE *out) 
{
	char *str;

	str = xmlGetProp (node, attr);
	if (!str) return;

	fprintf (out, "gchar *s = N_(\"%s\");\n", str);
}

static void
output_labels (xmlNodePtr element, FILE *out) 
{
	xmlNodePtr node;

	for (node = element->childs; node; node = node->next) {
		write_label (node, "label", out);
		write_label (node, "low-label", out);
		write_label (node, "high-label", out);
		output_labels (node, out);
	}
}

int
main (int argc, char **argv) 
{
	char *out_filename;
	FILE *out;
	xmlDocPtr doc;

	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	if (argc < 2) {
		fprintf (stderr, "Usage: extract-labels <filename>\n");
		exit (-1);
	}

	out_filename = g_strconcat (argv[1], ".h", NULL);

	doc = xmlParseFile (argv[1]);

	if (!doc)
		exit (-1);

	out = fopen (out_filename, "w");

	if (!out) {
		perror ("Could not open output file: ");
		exit (-1);
	}

	fprintf (out, 
		 "/*\n" \
		 " * Translatable strings file generated by extract-labels\n" \
		 " * Add this file to your project's POTFILES.in.\n" \
		 " * DO NOT compile it as part of your application.\n" \
		 " */\n\n");

	output_labels (xmlDocGetRootElement (doc), out);

	return 0;
}
