/*
 *  Copyright (C) 2003 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-favicon-action.h,v 1.5 2003/11/19 19:19:57 chpe Exp $
 */

#ifndef EPHY_FAVICON_ACTION_H
#define EPHY_FAVICON_ACTION_H

#include <gtk/gtkaction.h>

#define EPHY_TYPE_FAVICON_ACTION            (ephy_favicon_action_get_type ())
#define EPHY_FAVICON_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), EPHY_TYPE_FAVICON_ACTION, EphyFaviconAction))
#define EPHY_FAVICON_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), EPHY_TYPE_FAVICON_ACTION, EphyFaviconActionClass))
#define EPHY_IS_FAVICON_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EPHY_TYPE_FAVICON_ACTION))
#define EPHY_IS_FAVICON_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), EPHY_TYPE_FAVICON_ACTION))
#define EPHY_FAVICON_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), EPHY_TYPE_FAVICON_ACTION, EphyFaviconActionClass))

typedef struct _EphyFaviconAction      EphyFaviconAction;
typedef struct _EphyFaviconActionClass EphyFaviconActionClass;
typedef struct EphyFaviconActionPrivate EphyFaviconActionPrivate;

struct _EphyFaviconAction
{
	GtkAction parent;

	/*< private >*/
	EphyFaviconActionPrivate *priv;
};

struct _EphyFaviconActionClass
{
	GtkActionClass parent_class;
};

GType    ephy_favicon_action_get_type   (void);

#endif
