/* import-pidgin.c generated by valac 0.9.7, the Vala compiler
 * generated from import-pidgin.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <stdio.h>


#define FOLKS_TYPE_IMPORTER (folks_importer_get_type ())
#define FOLKS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORTER, FolksImporter))
#define FOLKS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORTER, FolksImporterClass))
#define FOLKS_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORTER))
#define FOLKS_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORTER))
#define FOLKS_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORTER, FolksImporterClass))

typedef struct _FolksImporter FolksImporter;
typedef struct _FolksImporterClass FolksImporterClass;
typedef struct _FolksImporterPrivate FolksImporterPrivate;

#define FOLKS_IMPORTERS_TYPE_PIDGIN (folks_importers_pidgin_get_type ())
#define FOLKS_IMPORTERS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin))
#define FOLKS_IMPORTERS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))
#define FOLKS_IMPORTERS_IS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_IS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_PIDGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))

typedef struct _FolksImportersPidgin FolksImportersPidgin;
typedef struct _FolksImportersPidginClass FolksImportersPidginClass;
typedef struct _FolksImportersPidginPrivate FolksImportersPidginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksImportersPidginImportData FolksImportersPidginImportData;
typedef struct _FolksImportersPidginParseBlistData FolksImportersPidginParseBlistData;
typedef struct _FolksImportersPidginParseGroupData FolksImportersPidginParseGroupData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksImportersPidginParseContactData FolksImportersPidginParseContactData;

typedef enum  {
	FOLKS_IMPORT_ERROR_MALFORMED_INPUT
} FolksImportError;
#define FOLKS_IMPORT_ERROR folks_import_error_quark ()
struct _FolksImporter {
	GObject parent_instance;
	FolksImporterPrivate * priv;
};

struct _FolksImporterClass {
	GObjectClass parent_class;
	void (*import) (FolksImporter* self, FolksPersonaStore* destination_store, const char* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*import_finish) (FolksImporter* self, GAsyncResult* _res_, GError** error);
};

struct _FolksImportersPidgin {
	FolksImporter parent_instance;
	FolksImportersPidginPrivate * priv;
};

struct _FolksImportersPidginClass {
	FolksImporterClass parent_class;
};

struct _FolksImportersPidginPrivate {
	FolksPersonaStore* destination_store;
	guint persona_count;
};

struct _FolksImportersPidginImportData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	FolksPersonaStore* destination_store;
	char* source_filename;
	guint result;
	FolksPersonaStore* _tmp0_;
	char* filename;
	gboolean _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GFile* file;
	GFileInfo* file_info;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	GError * e;
	xmlDoc* xml_doc;
	xmlNode* root_node;
	gboolean _tmp6_;
	gboolean _tmp7_;
	char* _tmp8_;
	xmlNode* iter;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GError * _inner_error_;
};

struct _FolksImportersPidginParseBlistData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	xmlNode* blist_node;
	xmlNode* iter;
	gboolean _tmp0_;
	gboolean _tmp1_;
};

struct _FolksImportersPidginParseGroupData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	xmlNode* group_node;
	char* group_name;
	xmlNode* iter;
	gboolean _tmp0_;
	gboolean _tmp1_;
	FolksPersona* persona;
	gboolean _tmp2_;
	FolksGroups* groupable;
	GError * e;
	GError * _inner_error_;
};

struct _FolksImportersPidginParseContactData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	xmlNode* contact_node;
	FolksPersona* result;
	char* alias;
	GHashTable* im_addresses;
	char* im_address_string;
	xmlNode* iter;
	gboolean _tmp0_;
	gboolean _tmp1_;
	char* blist_protocol;
	char* tp_protocol;
	xmlNode* subiter;
	gboolean _tmp2_;
	char* _tmp3_;
	char* im_address;
	GPtrArray* im_address_array;
	GPtrArray* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	GHashTable* details;
	GValue im_addresses_value;
	FolksPersona* persona;
	FolksPersona* _tmp13_;
	FolksPersona* _tmp14_;
	GError * e;
	gboolean _tmp15_;
	GError * _inner_error_;
};


static gpointer folks_importers_pidgin_parent_class = NULL;

GType folks_importer_get_type (void) G_GNUC_CONST;
GQuark folks_import_error_quark (void);
GType folks_importers_pidgin_get_type (void) G_GNUC_CONST;
#define FOLKS_IMPORTERS_PIDGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginPrivate))
enum  {
	FOLKS_IMPORTERS_PIDGIN_DUMMY_PROPERTY
};
static void folks_importers_pidgin_real_import_data_free (gpointer _data);
static void folks_importers_pidgin_real_import (FolksImporter* base, FolksPersonaStore* destination_store, const char* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_importers_pidgin_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_importers_pidgin_real_import_co (FolksImportersPidginImportData* data);
static void folks_importers_pidgin_parse_blist (FolksImportersPidgin* self, xmlNode* blist_node, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_importers_pidgin_parse_blist_finish (FolksImportersPidgin* self, GAsyncResult* _res_);
static void folks_importers_pidgin_parse_blist_data_free (gpointer _data);
static void folks_importers_pidgin_parse_blist_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_importers_pidgin_parse_blist_co (FolksImportersPidginParseBlistData* data);
static void folks_importers_pidgin_parse_group (FolksImportersPidgin* self, xmlNode* group_node, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_importers_pidgin_parse_group_finish (FolksImportersPidgin* self, GAsyncResult* _res_);
static void folks_importers_pidgin_parse_group_data_free (gpointer _data);
static void folks_importers_pidgin_parse_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_importers_pidgin_parse_group_co (FolksImportersPidginParseGroupData* data);
static void folks_importers_pidgin_parse_contact (FolksImportersPidgin* self, xmlNode* contact_node, GAsyncReadyCallback _callback_, gpointer _user_data_);
static FolksPersona* folks_importers_pidgin_parse_contact_finish (FolksImportersPidgin* self, GAsyncResult* _res_);
static void folks_importers_pidgin_parse_contact_data_free (gpointer _data);
static void folks_importers_pidgin_parse_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_importers_pidgin_parse_contact_co (FolksImportersPidginParseContactData* data);
static char* folks_importers_pidgin_blist_protocol_to_tp_protocol (FolksImportersPidgin* self, const char* blist_protocol);
static GValue* _g_value_dup (GValue* self);
FolksImportersPidgin* folks_importers_pidgin_new (void);
FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type);
FolksImporter* folks_importer_construct (GType object_type);
static void folks_importers_pidgin_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void folks_importers_pidgin_real_import_data_free (gpointer _data) {
	FolksImportersPidginImportData* data;
	data = _data;
	_g_object_unref0 (data->destination_store);
	_g_free0 (data->source_filename);
	g_object_unref (data->self);
	g_slice_free (FolksImportersPidginImportData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_importers_pidgin_real_import (FolksImporter* base, FolksPersonaStore* destination_store, const char* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidgin * self;
	FolksImportersPidginImportData* _data_;
	self = (FolksImportersPidgin*) base;
	_data_ = g_slice_new0 (FolksImportersPidginImportData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_real_import);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_real_import_data_free);
	_data_->self = g_object_ref (self);
	_data_->destination_store = _g_object_ref0 (destination_store);
	_data_->source_filename = g_strdup (source_filename);
	folks_importers_pidgin_real_import_co (_data_);
}


static guint folks_importers_pidgin_real_import_finish (FolksImporter* base, GAsyncResult* _res_, GError** error) {
	guint result;
	FolksImportersPidginImportData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0U;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void folks_importers_pidgin_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginImportData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_importers_pidgin_real_import_co (data);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean folks_importers_pidgin_real_import_co (FolksImportersPidginImportData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
	}
	_state_0:
	data->self->priv->destination_store = (data->_tmp0_ = _g_object_ref0 (data->destination_store), _g_object_unref0 (data->self->priv->destination_store), data->_tmp0_);
	data->filename = g_strdup (data->source_filename);
	if (data->filename == NULL) {
		data->_tmp1_ = TRUE;
	} else {
		data->_tmp1_ = _vala_strcmp0 (data->_tmp2_ = string_strip (data->filename), "") == 0;
		_g_free0 (data->_tmp2_);
	}
	if (data->_tmp1_) {
		data->filename = (data->_tmp3_ = g_build_filename (g_get_home_dir (), ".purple", "blist.xml", NULL, NULL), _g_free0 (data->filename), data->_tmp3_);
	}
	data->file = g_file_new_for_path (data->filename);
	if (!g_file_query_exists (data->file, NULL)) {
		data->_inner_error_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, "File %s does not exist.", data->filename);
		{
			if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		data->_state_ = 6;
		g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, folks_importers_pidgin_import_ready, data);
		return FALSE;
		_state_6:
		data->_tmp4_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		data->file_info = (data->_tmp5_ = data->_tmp4_, _g_object_unref0 (data->file_info), data->_tmp5_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			data->_inner_error_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, "Failed to get information about file %s: %s", data->filename, data->e->message);
			{
				_g_error_free0 (data->e);
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				goto __finally5;
			}
			_g_error_free0 (data->e);
		}
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (!g_file_info_get_attribute_boolean (data->file_info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		data->_inner_error_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, "File %s is not readable.", data->filename);
		{
			if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	data->xml_doc = xmlParseFile (data->filename);
	if (data->xml_doc == NULL) {
		data->_inner_error_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, "The Pidgin buddy list file " "'%s' could not be loaded.", data->filename);
		{
			if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	data->root_node = xmlDocGetRootElement (data->xml_doc);
	if (data->root_node == NULL) {
		data->_tmp7_ = TRUE;
	} else {
		data->_tmp7_ = _vala_strcmp0 (data->root_node->name, "purple") != 0;
	}
	if (data->_tmp7_) {
		data->_tmp6_ = TRUE;
	} else {
		data->_tmp6_ = _vala_strcmp0 (data->_tmp8_ = xmlGetProp (data->root_node, "version"), "1.0") != 0;
		_g_free0 (data->_tmp8_);
	}
	if (data->_tmp6_) {
		xmlFreeDoc (data->xml_doc);
		data->_inner_error_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, "The Pidgin buddy list file " "'%s' could not be loaded: the root element could not be found " "or was not recognised.", data->filename);
		{
			if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_object_unref0 (data->file_info);
				_g_object_unref0 (data->file);
				_g_free0 (data->filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		data->iter = data->root_node->children;
		{
			data->_tmp9_ = TRUE;
			while (TRUE) {
				if (!data->_tmp9_) {
					data->iter = data->iter->next;
				}
				data->_tmp9_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp10_ = TRUE;
				} else {
					data->_tmp10_ = _vala_strcmp0 (data->iter->name, "blist") != 0;
				}
				if (data->_tmp10_) {
					continue;
				}
				data->_state_ = 7;
				folks_importers_pidgin_parse_blist (data->self, data->iter, folks_importers_pidgin_import_ready, data);
				return FALSE;
				_state_7:
				folks_importers_pidgin_parse_blist_finish (data->self, data->_res_);
			}
		}
	}
	xmlFreeDoc (data->xml_doc);
	fprintf (stdout, "Imported %u buddies from '%s'.\n", data->self->priv->persona_count, data->filename);
	data->result = data->self->priv->persona_count;
	_g_object_unref0 (data->file_info);
	_g_object_unref0 (data->file);
	_g_free0 (data->filename);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->file_info);
	_g_object_unref0 (data->file);
	_g_free0 (data->filename);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_importers_pidgin_parse_blist_data_free (gpointer _data) {
	FolksImportersPidginParseBlistData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksImportersPidginParseBlistData, data);
}


static void folks_importers_pidgin_parse_blist (FolksImportersPidgin* self, xmlNode* blist_node, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidginParseBlistData* _data_;
	_data_ = g_slice_new0 (FolksImportersPidginParseBlistData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_parse_blist);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_parse_blist_data_free);
	_data_->self = g_object_ref (self);
	_data_->blist_node = blist_node;
	folks_importers_pidgin_parse_blist_co (_data_);
}


static void folks_importers_pidgin_parse_blist_finish (FolksImportersPidgin* self, GAsyncResult* _res_) {
	FolksImportersPidginParseBlistData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_importers_pidgin_parse_blist_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginParseBlistData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_importers_pidgin_parse_blist_co (data);
}


static gboolean folks_importers_pidgin_parse_blist_co (FolksImportersPidginParseBlistData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 8:
		goto _state_8;
	}
	_state_0:
	{
		data->iter = data->blist_node->children;
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->iter = data->iter->next;
				}
				data->_tmp0_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp1_ = TRUE;
				} else {
					data->_tmp1_ = _vala_strcmp0 (data->iter->name, "group") != 0;
				}
				if (data->_tmp1_) {
					continue;
				}
				data->_state_ = 8;
				folks_importers_pidgin_parse_group (data->self, data->iter, folks_importers_pidgin_parse_blist_ready, data);
				return FALSE;
				_state_8:
				folks_importers_pidgin_parse_group_finish (data->self, data->_res_);
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_importers_pidgin_parse_group_data_free (gpointer _data) {
	FolksImportersPidginParseGroupData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksImportersPidginParseGroupData, data);
}


static void folks_importers_pidgin_parse_group (FolksImportersPidgin* self, xmlNode* group_node, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidginParseGroupData* _data_;
	_data_ = g_slice_new0 (FolksImportersPidginParseGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_parse_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_parse_group_data_free);
	_data_->self = g_object_ref (self);
	_data_->group_node = group_node;
	folks_importers_pidgin_parse_group_co (_data_);
}


static void folks_importers_pidgin_parse_group_finish (FolksImportersPidgin* self, GAsyncResult* _res_) {
	FolksImportersPidginParseGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_importers_pidgin_parse_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginParseGroupData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_importers_pidgin_parse_group_co (data);
}


static gboolean folks_importers_pidgin_parse_group_co (FolksImportersPidginParseGroupData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
	}
	_state_0:
	data->group_name = xmlGetProp (data->group_node, "name");
	{
		data->iter = data->group_node->children;
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->iter = data->iter->next;
				}
				data->_tmp0_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp1_ = TRUE;
				} else {
					data->_tmp1_ = _vala_strcmp0 (data->iter->name, "contact") != 0;
				}
				if (data->_tmp1_) {
					continue;
				}
				data->_state_ = 9;
				folks_importers_pidgin_parse_contact (data->self, data->iter, folks_importers_pidgin_parse_group_ready, data);
				return FALSE;
				_state_9:
				data->persona = folks_importers_pidgin_parse_contact_finish (data->self, data->_res_);
				if (data->persona == NULL) {
					data->_tmp2_ = TRUE;
				} else {
					data->_tmp2_ = !FOLKS_IS_GROUPS (data->persona);
				}
				if (data->_tmp2_) {
					_g_object_unref0 (data->persona);
					continue;
				}
				{
					data->groupable = _g_object_ref0 (FOLKS_GROUPS (data->persona));
					data->_state_ = 10;
					folks_groups_change_group (data->groupable, data->group_name, TRUE, folks_importers_pidgin_parse_group_ready, data);
					return FALSE;
					_state_10:
					folks_groups_change_group_finish (data->groupable, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->groupable);
						goto __catch6_g_error;
					}
					_g_object_unref0 (data->groupable);
				}
				goto __finally6;
				__catch6_g_error:
				{
					data->e = data->_inner_error_;
					data->_inner_error_ = NULL;
					{
						fprintf (stderr, "Error changing group of Pidgin.Persona " "'%s': %s\n", folks_persona_get_iid (data->persona), data->e->message);
						_g_error_free0 (data->e);
					}
				}
				__finally6:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->persona);
					_g_free0 (data->group_name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (data->persona);
			}
		}
	}
	_g_free0 (data->group_name);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_importers_pidgin_parse_contact_data_free (gpointer _data) {
	FolksImportersPidginParseContactData* data;
	data = _data;
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (FolksImportersPidginParseContactData, data);
}


static void folks_importers_pidgin_parse_contact (FolksImportersPidgin* self, xmlNode* contact_node, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidginParseContactData* _data_;
	_data_ = g_slice_new0 (FolksImportersPidginParseContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_parse_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_parse_contact_data_free);
	_data_->self = g_object_ref (self);
	_data_->contact_node = contact_node;
	folks_importers_pidgin_parse_contact_co (_data_);
}


static FolksPersona* folks_importers_pidgin_parse_contact_finish (FolksImportersPidgin* self, GAsyncResult* _res_) {
	FolksPersona* result;
	FolksImportersPidginParseContactData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void folks_importers_pidgin_parse_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginParseContactData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_importers_pidgin_parse_contact_co (data);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gboolean folks_importers_pidgin_parse_contact_co (FolksImportersPidginParseContactData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 11:
		goto _state_11;
	}
	_state_0:
	data->alias = NULL;
	data->im_addresses = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_ptr_array_unref);
	data->im_address_string = g_strdup ("");
	{
		data->iter = data->contact_node->children;
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->iter = data->iter->next;
				}
				data->_tmp0_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp1_ = TRUE;
				} else {
					data->_tmp1_ = _vala_strcmp0 (data->iter->name, "buddy") != 0;
				}
				if (data->_tmp1_) {
					continue;
				}
				data->blist_protocol = xmlGetProp (data->iter, "proto");
				if (data->blist_protocol == NULL) {
					_g_free0 (data->blist_protocol);
					continue;
				}
				data->tp_protocol = folks_importers_pidgin_blist_protocol_to_tp_protocol (data->self, data->blist_protocol);
				if (data->tp_protocol == NULL) {
					_g_free0 (data->tp_protocol);
					_g_free0 (data->blist_protocol);
					continue;
				}
				{
					data->subiter = data->iter->children;
					{
						data->_tmp2_ = TRUE;
						while (TRUE) {
							if (!data->_tmp2_) {
								data->subiter = data->subiter->next;
							}
							data->_tmp2_ = FALSE;
							if (!(data->subiter != NULL)) {
								break;
							}
							if (data->subiter->type != XML_ELEMENT_NODE) {
								continue;
							}
							if (_vala_strcmp0 (data->subiter->name, "alias") == 0) {
								data->alias = (data->_tmp3_ = xmlNodeGetContent (data->subiter), _g_free0 (data->alias), data->_tmp3_);
							} else {
								if (_vala_strcmp0 (data->subiter->name, "name") == 0) {
									data->im_address = xmlNodeGetContent (data->subiter);
									data->im_address_array = _g_ptr_array_ref0 ((GPtrArray*) g_hash_table_lookup (data->im_addresses, data->tp_protocol));
									if (data->im_address_array == NULL) {
										data->im_address_array = (data->_tmp4_ = g_ptr_array_new_with_free_func (g_free), _g_ptr_array_unref0 (data->im_address_array), data->_tmp4_);
										g_hash_table_insert (data->im_addresses, g_strdup (data->tp_protocol), _g_ptr_array_ref0 (data->im_address_array));
									}
									g_ptr_array_add (data->im_address_array, g_strdup (data->im_address));
									data->im_address_string = (data->_tmp6_ = g_strconcat (data->im_address_string, data->_tmp5_ = g_strdup_printf ("    %s\n", data->im_address), NULL), _g_free0 (data->im_address_string), data->_tmp6_);
									_g_free0 (data->_tmp5_);
									_g_ptr_array_unref0 (data->im_address_array);
									_g_free0 (data->im_address);
								}
							}
						}
					}
				}
				_g_free0 (data->tp_protocol);
				_g_free0 (data->blist_protocol);
			}
		}
	}
	if (g_hash_table_size (data->im_addresses) < 2) {
		if (data->alias == NULL) {
			data->_tmp9_ = TRUE;
		} else {
			data->_tmp9_ = _vala_strcmp0 (data->_tmp10_ = string_strip (data->alias), "") == 0;
			_g_free0 (data->_tmp10_);
		}
		if (data->_tmp9_) {
			data->_tmp8_ = TRUE;
		} else {
			data->_tmp8_ = _vala_strcmp0 (data->_tmp11_ = string_strip (data->alias), data->_tmp12_ = string_strip (data->im_address_string)) == 0;
			_g_free0 (data->_tmp12_);
			_g_free0 (data->_tmp11_);
		}
		data->_tmp7_ = data->_tmp8_;
	} else {
		data->_tmp7_ = FALSE;
	}
	if (data->_tmp7_) {
		fprintf (stdout, "Ignoring buddy with no alias and only one IM " "address:\n%s", data->im_address_string);
		data->result = NULL;
		_g_free0 (data->im_address_string);
		_g_hash_table_unref0 (data->im_addresses);
		_g_free0 (data->alias);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->details = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_value_init (&data->im_addresses_value, G_TYPE_HASH_TABLE);
	g_value_set_boxed (&data->im_addresses_value, data->im_addresses);
	g_hash_table_insert (data->details, g_strdup ("im-addresses"), __g_value_dup0 (&data->im_addresses_value));
	{
		data->_state_ = 11;
		folks_persona_store_add_persona_from_details (data->self->priv->destination_store, data->details, folks_importers_pidgin_parse_contact_ready, data);
		return FALSE;
		_state_11:
		data->_tmp13_ = folks_persona_store_add_persona_from_details_finish (data->self->priv->destination_store, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch7_folks_persona_store_error;
			}
			_g_object_unref0 (data->persona);
			G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
			_g_hash_table_unref0 (data->details);
			_g_free0 (data->im_address_string);
			_g_hash_table_unref0 (data->im_addresses);
			_g_free0 (data->alias);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->persona = (data->_tmp14_ = data->_tmp13_, _g_object_unref0 (data->persona), data->_tmp14_);
	}
	goto __finally7;
	__catch7_folks_persona_store_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			fprintf (stderr, "Failed to create new persona for buddy with alias " "'%s' and IM addresses:\n%s\nError: %s\n", data->alias, data->im_address_string, data->e->message);
			data->result = NULL;
			_g_error_free0 (data->e);
			_g_object_unref0 (data->persona);
			G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
			_g_hash_table_unref0 (data->details);
			_g_free0 (data->im_address_string);
			_g_hash_table_unref0 (data->im_addresses);
			_g_free0 (data->alias);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->e);
		}
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->persona);
		G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
		_g_hash_table_unref0 (data->details);
		_g_free0 (data->im_address_string);
		_g_hash_table_unref0 (data->im_addresses);
		_g_free0 (data->alias);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->alias != NULL) {
		data->_tmp15_ = FOLKS_IS_ALIAS (data->persona);
	} else {
		data->_tmp15_ = FALSE;
	}
	if (data->_tmp15_) {
		folks_alias_set_alias (FOLKS_ALIAS (data->persona), data->alias);
	}
	fprintf (stdout, "Created persona '%s' for buddy with alias '%s' and IM " "addresses:\n%s", folks_persona_get_uid (data->persona), data->alias, data->im_address_string);
	data->self->priv->persona_count++;
	data->result = data->persona;
	G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
	_g_hash_table_unref0 (data->details);
	_g_free0 (data->im_address_string);
	_g_hash_table_unref0 (data->im_addresses);
	_g_free0 (data->alias);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->persona);
	G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
	_g_hash_table_unref0 (data->details);
	_g_free0 (data->im_address_string);
	_g_hash_table_unref0 (data->im_addresses);
	_g_free0 (data->alias);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* folks_importers_pidgin_blist_protocol_to_tp_protocol (FolksImportersPidgin* self, const char* blist_protocol) {
	char* result = NULL;
	char* tp_protocol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (blist_protocol != NULL, NULL);
	tp_protocol = g_strdup (blist_protocol);
	if (g_str_has_prefix (blist_protocol, "prpl-")) {
		char* _tmp0_;
		tp_protocol = (_tmp0_ = string_substring (blist_protocol, (glong) 5, -1), _g_free0 (tp_protocol), _tmp0_);
	}
	if (_vala_strcmp0 (tp_protocol, "bonjour") == 0) {
		char* _tmp1_;
		tp_protocol = (_tmp1_ = g_strdup ("local-xmpp"), _g_free0 (tp_protocol), _tmp1_);
	} else {
		if (_vala_strcmp0 (tp_protocol, "novell") == 0) {
			char* _tmp2_;
			tp_protocol = (_tmp2_ = g_strdup ("groupwise"), _g_free0 (tp_protocol), _tmp2_);
		} else {
			if (_vala_strcmp0 (tp_protocol, "gg") == 0) {
				char* _tmp3_;
				tp_protocol = (_tmp3_ = g_strdup ("gadugadu"), _g_free0 (tp_protocol), _tmp3_);
			} else {
				if (_vala_strcmp0 (tp_protocol, "meanwhile") == 0) {
					char* _tmp4_;
					tp_protocol = (_tmp4_ = g_strdup ("sametime"), _g_free0 (tp_protocol), _tmp4_);
				} else {
					if (_vala_strcmp0 (tp_protocol, "simple") == 0) {
						char* _tmp5_;
						tp_protocol = (_tmp5_ = g_strdup ("sip"), _g_free0 (tp_protocol), _tmp5_);
					}
				}
			}
		}
	}
	result = tp_protocol;
	return result;
}


FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type) {
	FolksImportersPidgin * self;
	self = (FolksImportersPidgin*) folks_importer_construct (object_type);
	return self;
}


FolksImportersPidgin* folks_importers_pidgin_new (void) {
	return folks_importers_pidgin_construct (FOLKS_IMPORTERS_TYPE_PIDGIN);
}


static void folks_importers_pidgin_class_init (FolksImportersPidginClass * klass) {
	folks_importers_pidgin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksImportersPidginPrivate));
	FOLKS_IMPORTER_CLASS (klass)->import = folks_importers_pidgin_real_import;
	FOLKS_IMPORTER_CLASS (klass)->import_finish = folks_importers_pidgin_real_import_finish;
	G_OBJECT_CLASS (klass)->finalize = folks_importers_pidgin_finalize;
}


static void folks_importers_pidgin_instance_init (FolksImportersPidgin * self) {
	self->priv = FOLKS_IMPORTERS_PIDGIN_GET_PRIVATE (self);
	self->priv->persona_count = (guint) 0;
}


static void folks_importers_pidgin_finalize (GObject* obj) {
	FolksImportersPidgin * self;
	self = FOLKS_IMPORTERS_PIDGIN (obj);
	_g_object_unref0 (self->priv->destination_store);
	G_OBJECT_CLASS (folks_importers_pidgin_parent_class)->finalize (obj);
}


GType folks_importers_pidgin_get_type (void) {
	static volatile gsize folks_importers_pidgin_type_id__volatile = 0;
	if (g_once_init_enter (&folks_importers_pidgin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImportersPidginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_importers_pidgin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImportersPidgin), 0, (GInstanceInitFunc) folks_importers_pidgin_instance_init, NULL };
		GType folks_importers_pidgin_type_id;
		folks_importers_pidgin_type_id = g_type_register_static (FOLKS_TYPE_IMPORTER, "FolksImportersPidgin", &g_define_type_info, 0);
		g_once_init_leave (&folks_importers_pidgin_type_id__volatile, folks_importers_pidgin_type_id);
	}
	return folks_importers_pidgin_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




