/* tpf-persona-store.c generated by valac, the Vala compiler
 * generated from tpf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>
#include <tp-lowlevel.h>
#include <gio/gio.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>


#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaStorePrivate TpfPersonaStorePrivate;

#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaStorePrepareData TpfPersonaStorePrepareData;
typedef struct _TpfPersonaStoreInitialiseFavouriteContactsData TpfPersonaStoreInitialiseFavouriteContactsData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _TpfPersonaStoreRemovePersonaData TpfPersonaStoreRemovePersonaData;
typedef struct _TpfPersonaStoreChannelGroupPendIncomingAddsData TpfPersonaStoreChannelGroupPendIncomingAddsData;
typedef struct _TpfPersonaStoreChangeGroupMembershipData TpfPersonaStoreChangeGroupMembershipData;
typedef struct _TpfPersonaStoreAddStandardChannelData TpfPersonaStoreAddStandardChannelData;
typedef struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData;
typedef struct _TpfPersonaStoreCreatePersonasFromContactIdsData TpfPersonaStoreCreatePersonasFromContactIdsData;
typedef struct _TpfPersonaStoreAddPersonaFromDetailsData TpfPersonaStoreAddPersonaFromDetailsData;
typedef struct _TpfPersonaStoreChangeIsFavouriteData TpfPersonaStoreChangeIsFavouriteData;
typedef struct _TpfPersonaStoreChangeAliasData TpfPersonaStoreChangeAliasData;

struct _TpfPersonaStore {
	FolksPersonaStore parent_instance;
	TpfPersonaStorePrivate * priv;
};

struct _TpfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _TpfPersonaStorePrivate {
	char** undisplayed_groups;
	gint undisplayed_groups_length1;
	gint _undisplayed_groups_size_;
	GHashTable* _personas;
	GeeHashMap* handle_persona_map;
	GeeHashMap* channel_group_personas_map;
	GeeHashMap* channel_group_incoming_adds;
	GeeHashMap* group_outgoing_adds;
	GeeHashMap* group_outgoing_removes;
	GeeHashMap* standard_channels_unready;
	GeeHashMap* group_channels_unready;
	GeeHashMap* groups;
	GeeHashSet* favourite_handles;
	TpChannel* publish;
	TpChannel* stored;
	TpChannel* subscribe;
	TpConnection* conn;
	FolksTpLowlevel* ll;
	TpAccountManager* account_manager;
	Logger* logger;
	TpAccount* _account;
	char* _type_id;
	char* _id;
};

struct _TpfPersonaStorePrepareData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpAccountManager* _tmp0_;
	TpConnectionStatusReason reason;
	TpConnectionStatus status;
	Logger* _tmp1_;
	Logger* _tmp2_;
	Logger* _tmp3_;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreInitialiseFavouriteContactsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	char** contacts;
	gint _tmp0_;
	char** _tmp1_;
	gint _contacts_size_;
	gint contacts_length1;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreRemovePersonaData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	TpfPersona* tp_persona;
	GError * e1;
	GError * e2;
	GError * e3;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChannelGroupPendIncomingAddsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* adds;
	gboolean create_personas;
	guint _tmp0_;
	guint adds_length;
	gint i;
	gboolean _tmp1_;
	TpHandle channel_handle;
	TpHandle contact_handle;
	TpfPersona* persona;
	GeeHashSet* contact_handles;
	GeeHashSet* _tmp2_;
};

struct _TpfPersonaStoreChangeGroupMembershipData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	char* group;
	gboolean is_member;
	TpfPersona* tp_persona;
	TpChannel* channel;
	GeeHashMap* _tmp0_;
	GeeHashMap* change_map;
	GeeHashSet* change_set;
	GeeHashSet* _tmp1_;
};

struct _TpfPersonaStoreAddStandardChannelData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpConnection* conn;
	char* name;
	TpChannel* result;
	TpChannel* channel;
	TpChannel* _tmp0_;
	TpChannel* _tmp1_;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* channel_handles;
	TpContactFeature* features;
	TpContactFeature* _tmp0_;
	TpContactFeature* _tmp1_;
	gint _features_size_;
	gint features_length1;
	guint* contact_handles;
	guint* _tmp2_;
	guint* _tmp3_;
	gint _contact_handles_size_;
	gint contact_handles_length1;
	gint i;
	gboolean _tmp4_;
	TpHandle channel_handle;
	TpHandle contact_handle;
	TpfPersona* _tmp5_;
	gboolean _tmp6_;
	GList* contacts;
	gboolean _tmp7_;
	TpContact** contacts_array;
	gint _tmp8_;
	TpContact** _tmp9_;
	gint _contacts_array_size_;
	gint contacts_array_length1;
	gint j;
	GList* l;
	gboolean _tmp10_;
	TpContact* _tmp11_;
	GError * e;
	GError * _inner_error_;
};

typedef enum  {
	TPF_PERSONA_ERROR_INVALID_ARGUMENT
} TpfPersonaError;
#define TPF_PERSONA_ERROR tpf_persona_error_quark ()
struct _TpfPersonaStoreCreatePersonasFromContactIdsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	char** contact_ids;
	gint contact_ids_length1;
	GList* result;
	TpContactFeature* features;
	TpContactFeature* _tmp0_;
	TpContactFeature* _tmp1_;
	gint _features_size_;
	gint features_length1;
	GList* contacts;
	GList* personas;
	guint err_count;
	char* err_format;
	GList* l;
	gboolean _tmp2_;
	TpContact* contact;
	TpfPersona* persona;
	char* _tmp3_;
	char* _tmp4_;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	char* contact_id;
	char** contact_ids;
	char** _tmp0_;
	gint _contact_ids_size_;
	gint contact_ids_length1;
	char* _tmp1_;
	GList* personas;
	gboolean _tmp2_;
	TpfPersona* persona;
	TpChannelGroupFlags flags;
	guint _tmp3_;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeIsFavouriteData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gboolean is_favourite;
	char* id;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeAliasData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	char* alias;
};


static gpointer tpf_persona_store_parent_class = NULL;

GType tpf_persona_store_get_type (void) G_GNUC_CONST;
GType tpf_persona_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA_STORE, TpfPersonaStorePrivate))
enum  {
	TPF_PERSONA_STORE_DUMMY_PROPERTY,
	TPF_PERSONA_STORE_ACCOUNT,
	TPF_PERSONA_STORE_TYPE_ID,
	TPF_PERSONA_STORE_ID,
	TPF_PERSONA_STORE_PERSONAS
};
static void tpf_persona_store_reset (TpfPersonaStore* self);
TpfPersonaStore* tpf_persona_store_new (TpAccount* account);
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account);
static void tpf_persona_store_real_prepare_data_free (gpointer _data);
static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self);
static void _lambda2_ (TpAccount* a, TpfPersonaStore* self);
static void __lambda2__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _lambda3_ (TpAccount* a, TpfPersonaStore* self);
static void __lambda3__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _lambda4_ (TpAccount* a, gboolean valid, TpfPersonaStore* self);
static void __lambda4__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self);
static void tpf_persona_store_account_status_changed_cb (TpfPersonaStore* self, guint old_status, guint new_status, guint reason, const char* dbus_error_name, GHashTable* details);
static void _tpf_persona_store_account_status_changed_cb_tp_account_status_changed (TpAccount* _sender, guint old_status, guint new_status, guint reason, const char* dbus_error_name, GHashTable* details, gpointer self);
Logger* logger_new (const char* account_path, GError** error);
Logger* logger_construct (GType object_type, const char* account_path, GError** error);
static void _lambda9_ (TpfPersonaStore* self);
static void __lambda9__logger_invalidated (Logger* _sender, gpointer self);
static void tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, char** added, int added_length1, char** removed, int removed_length1);
static void _tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, char** added, int added_length1, char** removed, int removed_length1, gpointer self);
static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* data);
static void tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data);
static void tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, char** ids, int ids_length1, GError* _error_, gboolean add, GError** error);
static void _lambda8_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, char** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda8__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int handles_length1, guint* handles, char** ids, GError* _error_, gpointer self, GObject* weak_object);
static void tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* data);
static void _lambda10_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, char** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda10__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int handles_length1, guint* handles, char** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _lambda11_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, char** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda11__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int handles_length1, guint* handles, char** ids, GError* _error_, gpointer self, GObject* weak_object);
static void tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, void* data);
static void _tpf_persona_store_new_group_channels_cb_gfunc (void* data, gpointer self);
static void tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const char* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static TpChannel* tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _lambda5_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel);
static void tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static void tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const char* message);
static void _tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const char* message, gpointer self);
static void tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _lambda7_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel);
static void tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details);
static FolksGroupsChangeReason tpf_persona_store_change_reason_from_tp_reason (TpfPersonaStore* self, guint reason);
static void tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const char* message, TpfPersona* actor, FolksGroupsChangeReason reason);
static void _g_list_free_g_object_unref (GList* self);
static void tpf_persona_store_real_remove_persona_data_free (gpointer _data);
static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* data);
static void tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data);
static void tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self);
static gboolean tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* data);
static void tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void _tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _lambda6_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_store_change_group_membership_data_free (gpointer _data);
static void tpf_persona_store_change_group_membership_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* data);
static void tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member);
static void tpf_persona_store_add_standard_channel_data_free (gpointer _data);
static void tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* data);
static void tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data);
static void tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
static void tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1);
static gboolean tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data);
static void tpf_persona_store_create_personas_from_contact_ids_data_free (gpointer _data);
static char** _vala_array_dup1 (char** self, int length);
static void tpf_persona_store_create_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark tpf_persona_error_quark (void);
static TpfPersona* tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, GError** error);
static void tpf_persona_store_create_personas_from_contact_ids (TpfPersonaStore* self, char** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GList* tpf_persona_store_create_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean tpf_persona_store_create_personas_from_contact_ids_co (TpfPersonaStoreCreatePersonasFromContactIdsData* data);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store, GError** error);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store, GError** error);
static gboolean tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const char* group);
static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* data);
static void tpf_persona_store_change_is_favourite_data_free (gpointer _data);
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_add_favourite_contact (Logger* self, const char* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
void logger_remove_favourite_contact (Logger* self, const char* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* data);
static void tpf_persona_store_change_alias_data_free (gpointer _data);
static void tpf_persona_store_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const char* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* data);
static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value);
static void tpf_persona_store_finalize (GObject* obj);
static void tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account) {
	TpfPersonaStore * self;
	g_return_val_if_fail (account != NULL, NULL);
	self = (TpfPersonaStore*) g_object_new (object_type, "account", account, NULL);
	folks_persona_store_set_type_id ((FolksPersonaStore*) self, "telepathy");
	folks_persona_store_set_id ((FolksPersonaStore*) self, tp_proxy_get_object_path ((TpProxy*) account));
	tpf_persona_store_reset (self);
	return self;
}


TpfPersonaStore* tpf_persona_store_new (TpAccount* account) {
	return tpf_persona_store_construct (TPF_TYPE_PERSONA_STORE, account);
}


static void tpf_persona_store_reset (TpfPersonaStore* self) {
	GHashTable* _tmp0_;
	TpConnection* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	TpChannel* _tmp7_;
	TpChannel* _tmp8_;
	TpChannel* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeHashMap* _tmp12_;
	GeeHashSet* _tmp13_;
	FolksTpLowlevel* _tmp14_;
	g_return_if_fail (self != NULL);
	self->priv->_personas = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->_personas), _tmp0_);
	self->priv->conn = (_tmp1_ = NULL, _g_object_unref0 (self->priv->conn), _tmp1_);
	self->priv->handle_persona_map = (_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->handle_persona_map), _tmp2_);
	self->priv->channel_group_personas_map = (_tmp3_ = gee_hash_map_new (TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->channel_group_personas_map), _tmp3_);
	self->priv->channel_group_incoming_adds = (_tmp4_ = gee_hash_map_new (TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->channel_group_incoming_adds), _tmp4_);
	self->priv->group_outgoing_adds = (_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->group_outgoing_adds), _tmp5_);
	self->priv->group_outgoing_removes = (_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->group_outgoing_removes), _tmp6_);
	self->priv->publish = (_tmp7_ = NULL, _g_object_unref0 (self->priv->publish), _tmp7_);
	self->priv->stored = (_tmp8_ = NULL, _g_object_unref0 (self->priv->stored), _tmp8_);
	self->priv->subscribe = (_tmp9_ = NULL, _g_object_unref0 (self->priv->subscribe), _tmp9_);
	self->priv->standard_channels_unready = (_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->standard_channels_unready), _tmp10_);
	self->priv->group_channels_unready = (_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->group_channels_unready), _tmp11_);
	self->priv->groups = (_tmp12_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->groups), _tmp12_);
	self->priv->favourite_handles = (_tmp13_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->favourite_handles), _tmp13_);
	self->priv->ll = (_tmp14_ = folks_tp_lowlevel_new (), _g_object_unref0 (self->priv->ll), _tmp14_);
}


static void tpf_persona_store_real_prepare_data_free (gpointer _data) {
	TpfPersonaStorePrepareData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStorePrepareData, data);
}


static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStorePrepareData* _data_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_prepare_data_free);
	_data_->self = g_object_ref (self);
	tpf_persona_store_real_prepare_co (_data_);
}


static void tpf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePrepareData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_real_prepare_co (data);
}


static void _lambda2_ (TpAccount* a, TpfPersonaStore* self) {
	g_return_if_fail (a != NULL);
	if (self->priv->_account == a) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda2__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_lambda2_ (account, self);
}


static void _lambda3_ (TpAccount* a, TpfPersonaStore* self) {
	g_return_if_fail (a != NULL);
	if (self->priv->_account == a) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda3__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_lambda3_ (account, self);
}


static void _lambda4_ (TpAccount* a, gboolean valid, TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (a != NULL);
	if (!valid) {
		_tmp0_ = self->priv->_account == a;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda4__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self) {
	_lambda4_ (account, valid, self);
}


static void _tpf_persona_store_account_status_changed_cb_tp_account_status_changed (TpAccount* _sender, guint old_status, guint new_status, guint reason, const char* dbus_error_name, GHashTable* details, gpointer self) {
	tpf_persona_store_account_status_changed_cb (self, old_status, new_status, reason, dbus_error_name, details);
}


static void _lambda9_ (TpfPersonaStore* self) {
	Logger* _tmp0_;
	g_warning ("tpf-persona-store.vala:165: lost connection to the telepathy-logger se" \
"rvice");
	self->priv->logger = (_tmp0_ = NULL, _g_object_unref0 (self->priv->logger), _tmp0_);
}


static void __lambda9__logger_invalidated (Logger* _sender, gpointer self) {
	_lambda9_ (self);
}


static void _tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, char** added, int added_length1, char** removed, int removed_length1, gpointer self) {
	tpf_persona_store_favourite_contacts_changed_cb (self, added, added_length1, removed, removed_length1);
}


static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->self->priv->account_manager = (data->_tmp0_ = tp_account_manager_dup (), _g_object_unref0 (data->self->priv->account_manager), data->_tmp0_);
		g_signal_connect_object (data->self->priv->account_manager, "account-disabled", (GCallback) __lambda2__tp_account_manager_account_disabled, data->self, 0);
		g_signal_connect_object (data->self->priv->account_manager, "account-removed", (GCallback) __lambda3__tp_account_manager_account_removed, data->self, 0);
		g_signal_connect_object (data->self->priv->account_manager, "account-validity-changed", (GCallback) __lambda4__tp_account_manager_account_validity_changed, data->self, 0);
		g_signal_connect_object (data->self->priv->_account, "status-changed", (GCallback) _tpf_persona_store_account_status_changed_cb_tp_account_status_changed, data->self, 0);
		data->status = tp_account_get_connection_status (data->self->priv->_account, &data->reason);
		if (data->status != TP_CONNECTION_STATUS_DISCONNECTED) {
			tpf_persona_store_account_status_changed_cb (data->self, (guint) TP_CONNECTION_STATUS_DISCONNECTED, (guint) data->status, (guint) data->reason, NULL, NULL);
		}
		{
			data->_tmp1_ = logger_new (folks_persona_store_get_id ((FolksPersonaStore*) data->self), &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch0_dbus_gerror;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->self->priv->logger = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->self->priv->logger), data->_tmp2_);
			g_signal_connect_object (data->self->priv->logger, "invalidated", (GCallback) __lambda9__logger_invalidated, data->self, 0);
			g_signal_connect_object (data->self->priv->logger, "favourite-contacts-changed", (GCallback) _tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed, data->self, 0);
		}
		goto __finally0;
		__catch0_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:173: couldn't connect to the telepathy-logger s" \
"ervice");
				data->self->priv->logger = (data->_tmp3_ = NULL, _g_object_unref0 (data->self->priv->logger), data->_tmp3_);
				_g_error_free0 (data->e);
			}
		}
		__finally0:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data) {
	TpfPersonaStoreInitialiseFavouriteContactsData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreInitialiseFavouriteContactsData, data);
}


static void tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreInitialiseFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_initialise_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_initialise_favourite_contacts_data_free);
	_data_->self = g_object_ref (self);
	tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_initialise_favourite_contacts_co (data);
}


static void _lambda8_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, char** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	_inner_error_ = NULL;
	{
		tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) h, h_length1, i, i_length1, e, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("tpf-persona-store.vala:205: couldn't get list of favourite contacts: %" \
"s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda8__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int handles_length1, guint* handles, char** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda8_ (connection, handle_type, handles, handles_length1, ids, -1, _error_, self, weak_object);
}


static gboolean tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (data->self->priv->logger == NULL) {
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			data->_state_ = 1;
			logger_get_favourite_contacts (data->self->priv->logger, tpf_persona_store_initialise_favourite_contacts_ready, data);
			return FALSE;
			_state_1:
			data->contacts = (data->_tmp1_ = logger_get_favourite_contacts_finish (data->self->priv->logger, data->_res_, &data->_tmp0_, &data->_inner_error_), data->contacts_length1 = data->_tmp0_, data->_contacts_size_ = data->contacts_length1, data->_tmp1_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch1_dbus_gerror;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			if (data->contacts_length1 == 0) {
				data->contacts = (_vala_array_free (data->contacts, data->contacts_length1, (GDestroyNotify) g_free), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			tp_connection_request_handles (data->self->priv->conn, -1, TP_HANDLE_TYPE_CONTACT, data->contacts, __lambda8__tp_connection_request_handles_cb, g_object_ref (data->self), g_object_unref, (GObject*) data->self);
			data->contacts = (_vala_array_free (data->contacts, data->contacts_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:216: couldn't get list of favourite contacts: %" \
"s", data->e->message);
				_g_error_free0 (data->e);
			}
		}
		__finally1:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, char** ids, int ids_length1, GError* _error_, gboolean add, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (_error_ != NULL) {
		_inner_error_ = _g_error_copy0 (_error_);
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				TpHandle h;
				TpfPersona* p;
				gboolean _tmp1_ = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < handles_length1)) {
					break;
				}
				h = handles[i];
				p = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->handle_persona_map, GUINT_TO_POINTER ((guint) h));
				if (add) {
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->favourite_handles, GUINT_TO_POINTER ((guint) h));
				} else {
					gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->favourite_handles, GUINT_TO_POINTER ((guint) h));
				}
				if (p == NULL) {
					_tmp1_ = gee_map_get_size ((GeeMap*) self->priv->handle_persona_map) > 0;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					g_warning ("tpf-persona-store.vala:245: unknown persona '%s' in favourites list", ids[i]);
					_g_object_unref0 (p);
					continue;
				}
				if (p != NULL) {
					folks_favourite_set_is_favourite ((FolksFavourite*) p, add);
				}
				_g_object_unref0 (p);
			}
		}
	}
}


static void _lambda10_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, char** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	_inner_error_ = NULL;
	{
		tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) h, h_length1, i, i_length1, e, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("tpf-persona-store.vala:274: couldn't add favourite contacts: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda10__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int handles_length1, guint* handles, char** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda10_ (connection, handle_type, handles, handles_length1, ids, -1, _error_, self, weak_object);
}


static void _lambda11_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, char** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	_inner_error_ = NULL;
	{
		tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) h, h_length1, i, i_length1, e, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("tpf-persona-store.vala:294: couldn't remove favourite contacts: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda11__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int handles_length1, guint* handles, char** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda11_ (connection, handle_type, handles, handles_length1, ids, -1, _error_, self, weak_object);
}


static void tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, char** added, int added_length1, char** removed, int removed_length1) {
	g_return_if_fail (self != NULL);
	if (self->priv->conn == NULL) {
		return;
	}
	if (added_length1 > 0) {
		tp_connection_request_handles (self->priv->conn, -1, TP_HANDLE_TYPE_CONTACT, added, __lambda10__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
	if (removed_length1 > 0) {
		tp_connection_request_handles (self->priv->conn, -1, TP_HANDLE_TYPE_CONTACT, removed, __lambda11__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _tpf_persona_store_new_group_channels_cb_gfunc (void* data, gpointer self) {
	tpf_persona_store_new_group_channels_cb (self, data);
}


static void _lambda5_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	TpConnection* c;
	TpConnection* _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	c = _g_object_ref0 (TP_CONNECTION (s));
	folks_tp_lowlevel_connection_connect_to_new_group_channels (self->priv->ll, c, _tpf_persona_store_new_group_channels_cb_gfunc, self);
	tpf_persona_store_add_standard_channel (self, c, "publish", NULL, NULL);
	tpf_persona_store_add_standard_channel (self, c, "stored", NULL, NULL);
	tpf_persona_store_add_standard_channel (self, c, "subscribe", NULL, NULL);
	self->priv->conn = (_tmp0_ = _g_object_ref0 (c), _g_object_unref0 (self->priv->conn), _tmp0_);
	tpf_persona_store_initialise_favourite_contacts (self, NULL, NULL);
	_g_object_unref0 (c);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (_sender, pspec, self);
}


static void tpf_persona_store_account_status_changed_cb (TpfPersonaStore* self, guint old_status, guint new_status, guint reason, const char* dbus_error_name, GHashTable* details) {
	TpConnection* conn;
	g_return_if_fail (self != NULL);
	if (new_status == TP_CONNECTION_STATUS_DISCONNECTED) {
		GList* _tmp0_;
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, _tmp0_ = g_hash_table_get_values (self->priv->_personas), NULL, NULL, 0);
		_g_list_free0 (_tmp0_);
		tpf_persona_store_reset (self);
		return;
	} else {
		if (new_status != TP_CONNECTION_STATUS_CONNECTED) {
			return;
		}
	}
	conn = _g_object_ref0 (tp_account_get_connection (self->priv->_account));
	g_signal_connect_object ((GObject*) conn, "notify::connection-ready", (GCallback) __lambda5__g_object_notify, self, 0);
	tp_proxy_prepare_async ((TpProxy*) conn, NULL, NULL, NULL);
	_g_object_unref0 (conn);
}


static void tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, void* data) {
	TpChannel* channel;
	g_return_if_fail (self != NULL);
	channel = _g_object_ref0 (TP_CHANNEL (data));
	if (channel == NULL) {
		g_warning ("tpf-persona-store.vala:344: error creating channel for NewChannels sig" \
"nal");
		_g_object_unref0 (channel);
		return;
	}
	tpf_persona_store_set_up_new_group_channel (self, channel);
	tpf_persona_store_channel_group_changes_resolve (self, channel);
	_g_object_unref0 (channel);
}


static void tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel) {
	GError * _inner_error_;
	char* group;
	GeeHashMap* change_maps;
	GeeHashSet* _tmp0_;
	gboolean _tmp1_;
	GeeHashSet* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_inner_error_ = NULL;
	group = g_strdup (tp_channel_get_identifier (channel));
	change_maps = gee_hash_map_new (GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	if ((_tmp1_ = (_tmp0_ = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->group_outgoing_adds, group)) != NULL, _g_object_unref0 (_tmp0_), _tmp1_)) {
		GeeHashSet* _tmp2_;
		gee_abstract_map_set ((GeeAbstractMap*) change_maps, _tmp2_ = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->group_outgoing_adds, group), GINT_TO_POINTER (TRUE));
		_g_object_unref0 (_tmp2_);
	}
	if ((_tmp4_ = (_tmp3_ = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->group_outgoing_removes, group)) != NULL, _g_object_unref0 (_tmp3_), _tmp4_)) {
		GeeHashSet* _tmp5_;
		gee_abstract_map_set ((GeeAbstractMap*) change_maps, _tmp5_ = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->group_outgoing_removes, group), GINT_TO_POINTER (FALSE));
		_g_object_unref0 (_tmp5_);
	}
	if (gee_map_get_size ((GeeMap*) change_maps) < 1) {
		_g_object_unref0 (change_maps);
		_g_free0 (group);
		return;
	}
	{
		GeeIterator* _entry_it;
		_entry_it = gee_iterable_iterator ((GeeIterable*) change_maps);
		while (TRUE) {
			GeeMapEntry* entry;
			GeeHashSet* changes;
			if (!gee_iterator_next (_entry_it)) {
				break;
			}
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
			changes = _g_object_ref0 ((GeeHashSet*) gee_map_entry_get_key (entry));
			{
				GeeIterator* _persona_it;
				_persona_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) changes);
				while (TRUE) {
					TpfPersona* persona;
					if (!gee_iterator_next (_persona_it)) {
						break;
					}
					persona = (TpfPersona*) gee_iterator_get (_persona_it);
					{
						folks_tp_lowlevel_channel_group_change_membership (channel, (guint) ((TpHandle) tp_contact_get_handle (tpf_persona_get_contact (persona))), GPOINTER_TO_INT (gee_map_entry_get_value (entry)), &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch5_g_error;
						}
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							const char* _tmp6_;
							_tmp6_ = NULL;
							if (GPOINTER_TO_INT (gee_map_entry_get_value (entry))) {
								_tmp6_ = "true";
							} else {
								_tmp6_ = "false";
							}
							g_warning ("failed to change persona %s group %s membership to " "%s", folks_persona_get_uid ((FolksPersona*) persona), group, _tmp6_);
							_g_error_free0 (e);
						}
					}
					__finally5:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (persona);
						_g_object_unref0 (_persona_it);
						_g_object_unref0 (changes);
						_g_object_unref0 (entry);
						_g_object_unref0 (_entry_it);
						_g_object_unref0 (change_maps);
						_g_free0 (group);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			gee_abstract_collection_clear ((GeeAbstractCollection*) changes);
			_g_object_unref0 (changes);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_g_object_unref0 (change_maps);
	_g_free0 (group);
}


static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	tpf_persona_store_publish_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	tpf_persona_store_stored_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void _tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const char* message, gpointer self) {
	tpf_persona_store_channel_invalidated_cb (self, _sender, domain, code, message);
}


static void _lambda7_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	TpChannel* c;
	char* name;
	TpIntSet* members;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	c = _g_object_ref0 (TP_CHANNEL (s));
	name = g_strdup (tp_channel_get_identifier (c));
	if (_vala_strcmp0 (name, "publish") == 0) {
		TpChannel* _tmp0_;
		self->priv->publish = (_tmp0_ = _g_object_ref0 (c), _g_object_unref0 (self->priv->publish), _tmp0_);
		g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) _tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
	} else {
		if (_vala_strcmp0 (name, "stored") == 0) {
			TpChannel* _tmp1_;
			self->priv->stored = (_tmp1_ = _g_object_ref0 (c), _g_object_unref0 (self->priv->stored), _tmp1_);
			g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) _tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
		} else {
			if (_vala_strcmp0 (name, "subscribe") == 0) {
				TpChannel* _tmp2_;
				self->priv->subscribe = (_tmp2_ = _g_object_ref0 (c), _g_object_unref0 (self->priv->subscribe), _tmp2_);
				g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
			}
		}
	}
	gee_map_remove ((GeeMap*) self->priv->standard_channels_unready, name, NULL);
	g_signal_connect_object ((TpProxy*) c, "invalidated", (GCallback) _tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self, 0);
	members = tp_channel_group_get_members (c);
	if (members != NULL) {
		GArray* _tmp3_;
		tpf_persona_store_channel_group_pend_incoming_adds (self, c, _tmp3_ = tp_intset_to_array (members), TRUE, NULL, NULL);
		_g_array_unref0 (_tmp3_);
	}
	_g_free0 (name);
	_g_object_unref0 (c);
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (_sender, pspec, self);
}


static void tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->standard_channels_unready, tp_channel_get_identifier (channel), channel);
	g_signal_connect_object ((GObject*) channel, "notify::channel-ready", (GCallback) __lambda7__g_object_notify, self, 0);
}


static void tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added->len > 0) {
		tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint handle;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < removed->len)) {
					break;
				}
				handle = g_array_index (removed, guint, (guint) i);
				tpf_persona_store_ignore_by_handle_if_needed (self, handle, details);
			}
		}
	}
}


static void tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added->len > 0) {
		tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint handle;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < removed->len)) {
					break;
				}
				handle = g_array_index (removed, guint, (guint) i);
				tpf_persona_store_ignore_by_handle_if_needed (self, handle, details);
			}
		}
	}
}


static void tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added->len > 0) {
		tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, TRUE, NULL, NULL);
		if (self->priv->publish != NULL) {
			tpf_persona_store_channel_group_pend_incoming_adds (self, self->priv->publish, added, TRUE, NULL, NULL);
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint handle;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < removed->len)) {
					break;
				}
				handle = g_array_index (removed, guint, (guint) i);
				tpf_persona_store_ignore_by_handle_if_needed (self, handle, details);
			}
		}
	}
}


static void tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const char* message) {
	TpChannel* channel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	g_return_if_fail (message != NULL);
	channel = _g_object_ref0 (TP_CHANNEL (proxy));
	gee_map_remove ((GeeMap*) self->priv->channel_group_personas_map, channel, NULL);
	gee_map_remove ((GeeMap*) self->priv->channel_group_incoming_adds, channel, NULL);
	if (proxy == TP_PROXY (self->priv->publish)) {
		TpChannel* _tmp0_;
		self->priv->publish = (_tmp0_ = NULL, _g_object_unref0 (self->priv->publish), _tmp0_);
	} else {
		if (proxy == TP_PROXY (self->priv->subscribe)) {
			TpChannel* _tmp1_;
			self->priv->subscribe = (_tmp1_ = NULL, _g_object_unref0 (self->priv->subscribe), _tmp1_);
		} else {
			GError* _error_;
			char* name;
			_error_ = g_error_new ((GQuark) domain, code, "%s", message);
			name = g_strdup (tp_channel_get_identifier (channel));
			g_signal_emit_by_name (self, "group-removed", name, _error_);
			gee_map_remove ((GeeMap*) self->priv->groups, name, NULL);
			_g_free0 (name);
			_g_error_free0 (_error_);
		}
	}
	_g_object_unref0 (channel);
}


static void tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details) {
	TpIntSet* members;
	char* message;
	gboolean valid = FALSE;
	TpfPersona* actor;
	guint32 actor_handle;
	gboolean _tmp0_ = FALSE;
	FolksGroupsChangeReason reason;
	guint32 tp_reason;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	members = NULL;
	if (self->priv->subscribe != NULL) {
		members = tp_channel_group_get_members (self->priv->subscribe);
		if (tp_intset_is_member (members, handle)) {
			return;
		}
		members = tp_channel_group_get_remote_pending (self->priv->subscribe);
		if (tp_intset_is_member (members, handle)) {
			return;
		}
	}
	if (self->priv->publish != NULL) {
		members = tp_channel_group_get_members (self->priv->publish);
		if (tp_intset_is_member (members, handle)) {
			return;
		}
	}
	message = g_strdup (tp_asv_get_string (details, "message"));
	actor = NULL;
	actor_handle = tp_asv_get_uint32 (details, "actor", &valid);
	if (actor_handle > 0) {
		_tmp0_ = valid;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		TpfPersona* _tmp1_;
		actor = (_tmp1_ = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->handle_persona_map, GUINT_TO_POINTER ((guint) actor_handle)), _g_object_unref0 (actor), _tmp1_);
	}
	reason = FOLKS_GROUPS_CHANGE_REASON_NONE;
	tp_reason = tp_asv_get_uint32 (details, "change-reason", &valid);
	if (valid) {
		reason = tpf_persona_store_change_reason_from_tp_reason (self, (guint) tp_reason);
	}
	tpf_persona_store_ignore_by_handle (self, handle, message, actor, reason);
	_g_object_unref0 (actor);
	_g_free0 (message);
}


static FolksGroupsChangeReason tpf_persona_store_change_reason_from_tp_reason (TpfPersonaStore* self, guint reason) {
	FolksGroupsChangeReason result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = (FolksGroupsChangeReason) reason;
	return result;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const char* message, TpfPersona* actor, FolksGroupsChangeReason reason) {
	TpfPersona* persona;
	GList* personas;
	g_return_if_fail (self != NULL);
	persona = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->handle_persona_map, GUINT_TO_POINTER (handle));
	gee_map_remove ((GeeMap*) self->priv->handle_persona_map, GUINT_TO_POINTER (handle), NULL);
	if (persona == NULL) {
		_g_object_unref0 (persona);
		return;
	}
	{
		GeeIterator* _entry_it;
		_entry_it = gee_iterable_iterator ((GeeIterable*) self->priv->channel_group_personas_map);
		while (TRUE) {
			GeeMapEntry* entry;
			TpChannel* channel;
			GeeHashSet* members;
			if (!gee_iterator_next (_entry_it)) {
				break;
			}
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
			channel = _g_object_ref0 (TP_CHANNEL ((TpChannel*) gee_map_entry_get_key (entry)));
			members = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->channel_group_personas_map, channel);
			if (members != NULL) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) members, persona);
			}
			_g_object_unref0 (members);
			_g_object_unref0 (channel);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	{
		GeeIterator* _entry_it;
		_entry_it = gee_iterable_iterator ((GeeIterable*) self->priv->group_outgoing_adds);
		while (TRUE) {
			GeeMapEntry* entry;
			char* name;
			GeeHashSet* members;
			if (!gee_iterator_next (_entry_it)) {
				break;
			}
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
			name = g_strdup ((const char*) ((const char*) gee_map_entry_get_key (entry)));
			members = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->group_outgoing_adds, name);
			if (members != NULL) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) members, persona);
			}
			_g_object_unref0 (members);
			_g_free0 (name);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	personas = NULL;
	personas = g_list_append (personas, _g_object_ref0 (persona));
	g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, personas, message, (FolksPersona*) actor, reason);
	g_hash_table_remove (self->priv->_personas, folks_persona_get_iid ((FolksPersona*) persona));
	__g_list_free_g_object_unref0 (personas);
	_g_object_unref0 (persona);
}


static void tpf_persona_store_real_remove_persona_data_free (gpointer _data) {
	TpfPersonaStoreRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreRemovePersonaData, data);
}


static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreRemovePersonaData* _data_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_remove_persona_data_free);
	_data_->self = g_object_ref (self);
	_data_->persona = _g_object_ref0 (persona);
	tpf_persona_store_real_remove_persona_co (_data_);
}


static void tpf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreRemovePersonaData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_real_remove_persona_co (data);
}


static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->tp_persona = _g_object_ref0 (TPF_PERSONA (data->persona));
		{
			folks_tp_lowlevel_channel_group_change_membership (data->self->priv->stored, (guint) ((TpHandle) tp_contact_get_handle (tpf_persona_get_contact (data->tp_persona))), FALSE, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			data->e1 = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:626: failed to remove persona '%s' (%s) from st" \
"ored list: %s", folks_persona_get_uid ((FolksPersona*) data->tp_persona), folks_alias_get_alias ((FolksAlias*) data->tp_persona), data->e1->message);
				_g_error_free0 (data->e1);
			}
		}
		__finally6:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		{
			folks_tp_lowlevel_channel_group_change_membership (data->self->priv->subscribe, (guint) ((TpHandle) tp_contact_get_handle (tpf_persona_get_contact (data->tp_persona))), FALSE, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			data->e2 = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:637: failed to remove persona '%s' (%s) from su" \
"bscribe list: %s", folks_persona_get_uid ((FolksPersona*) data->tp_persona), folks_alias_get_alias ((FolksAlias*) data->tp_persona), data->e2->message);
				_g_error_free0 (data->e2);
			}
		}
		__finally7:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		{
			folks_tp_lowlevel_channel_group_change_membership (data->self->priv->publish, (guint) ((TpHandle) tp_contact_get_handle (tpf_persona_get_contact (data->tp_persona))), FALSE, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			data->e3 = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:648: failed to remove persona '%s' (%s) from pu" \
"blish list: %s", folks_persona_get_uid ((FolksPersona*) data->tp_persona), folks_alias_get_alias ((FolksAlias*) data->tp_persona), data->e3->message);
				_g_error_free0 (data->e3);
			}
		}
		__finally8:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (data->tp_persona);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* data;
	data = _data;
	_g_object_unref0 (data->channel);
	_g_array_unref0 (data->adds);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreChannelGroupPendIncomingAddsData, data);
}


static gpointer _g_array_ref0 (gpointer self) {
	return self ? g_array_ref (self) : NULL;
}


static void tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChannelGroupPendIncomingAddsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_channel_group_pend_incoming_adds);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_channel_group_pend_incoming_adds_data_free);
	_data_->self = g_object_ref (self);
	_data_->channel = _g_object_ref0 (channel);
	_data_->adds = _g_array_ref0 (adds);
	_data_->create_personas = create_personas;
	tpf_persona_store_channel_group_pend_incoming_adds_co (_data_);
}


static void tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_channel_group_pend_incoming_adds_co (data);
}


static gboolean tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (data->adds != NULL) {
			data->_tmp0_ = data->adds->len;
		} else {
			data->_tmp0_ = (guint) 0;
		}
		data->adds_length = data->_tmp0_;
		if (data->adds_length >= 1) {
			if (data->create_personas) {
				data->_state_ = 2;
				tpf_persona_store_create_personas_from_channel_handles_async (data->self, data->channel, data->adds, tpf_persona_store_channel_group_pend_incoming_adds_ready, data);
				return FALSE;
				_state_2:
				tpf_persona_store_create_personas_from_channel_handles_finish (data->self, data->_res_);
			}
			{
				data->i = 0;
				{
					data->_tmp1_ = TRUE;
					while (TRUE) {
						if (!data->_tmp1_) {
							data->i++;
						}
						data->_tmp1_ = FALSE;
						if (!(data->i < data->adds->len)) {
							break;
						}
						data->channel_handle = (TpHandle) g_array_index (data->adds, guint, (guint) data->i);
						data->contact_handle = tp_channel_group_get_handle_owner (data->channel, data->channel_handle);
						data->persona = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->handle_persona_map, GUINT_TO_POINTER ((guint) data->contact_handle));
						if (data->persona == NULL) {
							data->contact_handles = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->channel_group_incoming_adds, data->channel);
							if (data->contact_handles == NULL) {
								data->contact_handles = (data->_tmp2_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL), _g_object_unref0 (data->contact_handles), data->_tmp2_);
								gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->channel_group_incoming_adds, data->channel, data->contact_handles);
							}
							gee_abstract_collection_add ((GeeAbstractCollection*) data->contact_handles, GUINT_TO_POINTER ((guint) data->contact_handle));
							_g_object_unref0 (data->contact_handles);
						}
						_g_object_unref0 (data->persona);
					}
				}
			}
		}
		tpf_persona_store_channel_groups_add_new_personas (data->self);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void _tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	tpf_persona_store_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void _lambda6_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	TpChannel* c;
	char* name;
	TpIntSet* members;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	c = _g_object_ref0 (TP_CHANNEL (s));
	name = g_strdup (tp_channel_get_identifier (c));
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->groups, name, c);
	gee_map_remove ((GeeMap*) self->priv->group_channels_unready, name, NULL);
	g_signal_connect_object ((TpProxy*) c, "invalidated", (GCallback) _tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self, 0);
	g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) _tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
	members = tp_channel_group_get_members (c);
	if (members != NULL) {
		GArray* _tmp0_;
		tpf_persona_store_channel_group_pend_incoming_adds (self, c, _tmp0_ = tp_intset_to_array (members), FALSE, NULL, NULL);
		_g_array_unref0 (_tmp0_);
	}
	_g_free0 (name);
	_g_object_unref0 (c);
}


static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda6_ (_sender, pspec, self);
}


static void tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->group_channels_unready, tp_channel_get_identifier (channel), channel);
	g_signal_connect_object ((GObject*) channel, "notify::channel-ready", (GCallback) __lambda6__g_object_notify, self, 0);
}


static void tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added != NULL) {
		tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, FALSE, NULL, NULL);
	}
}


static void tpf_persona_store_change_group_membership_data_free (gpointer _data) {
	TpfPersonaStoreChangeGroupMembershipData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_free0 (data->group);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreChangeGroupMembershipData, data);
}


void tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeGroupMembershipData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_group_membership);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_group_membership_data_free);
	_data_->self = g_object_ref (self);
	_data_->persona = _g_object_ref0 (persona);
	_data_->group = g_strdup (group);
	_data_->is_member = is_member;
	tpf_persona_store_change_group_membership_co (_data_);
}


void tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_group_membership_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeGroupMembershipData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_change_group_membership_co (data);
}


static gboolean tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->tp_persona = _g_object_ref0 (TPF_PERSONA (data->persona));
		data->channel = (TpChannel*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->groups, data->group);
		if (data->is_member) {
			data->_tmp0_ = data->self->priv->group_outgoing_adds;
		} else {
			data->_tmp0_ = data->self->priv->group_outgoing_removes;
		}
		data->change_map = _g_object_ref0 (data->_tmp0_);
		data->change_set = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) data->change_map, data->group);
		if (data->change_set == NULL) {
			data->change_set = (data->_tmp1_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL), _g_object_unref0 (data->change_set), data->_tmp1_);
			gee_abstract_map_set ((GeeAbstractMap*) data->change_map, data->group, data->change_set);
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) data->change_set, data->tp_persona);
		if (data->channel == NULL) {
			folks_tp_lowlevel_connection_create_group_async (data->self->priv->ll, tp_account_get_connection (data->self->priv->_account), data->group);
		} else {
			tpf_persona_store_channel_group_changes_resolve (data->self, data->channel);
		}
		_g_object_unref0 (data->change_set);
		_g_object_unref0 (data->change_map);
		_g_object_unref0 (data->channel);
		_g_object_unref0 (data->tp_persona);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member) {
	GError * _inner_error_;
	TpfPersona* tp_persona;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (persona != NULL);
	_inner_error_ = NULL;
	tp_persona = _g_object_ref0 (TPF_PERSONA (persona));
	{
		folks_tp_lowlevel_channel_group_change_membership (channel, (guint) ((TpHandle) tp_contact_get_handle (tpf_persona_get_contact (tp_persona))), is_member, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			const char* _tmp0_;
			_tmp0_ = NULL;
			if (is_member) {
				_tmp0_ = "true";
			} else {
				_tmp0_ = "false";
			}
			g_warning ("failed to change persona %s contact list %s " "membership to %s", folks_persona_get_uid (persona), tp_channel_get_identifier (channel), _tmp0_);
			_g_error_free0 (e);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tp_persona);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tp_persona);
}


static void tpf_persona_store_add_standard_channel_data_free (gpointer _data) {
	TpfPersonaStoreAddStandardChannelData* data;
	data = _data;
	_g_object_unref0 (data->conn);
	_g_free0 (data->name);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreAddStandardChannelData, data);
}


static void tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const char* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreAddStandardChannelData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_add_standard_channel);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_add_standard_channel_data_free);
	_data_->self = g_object_ref (self);
	_data_->conn = _g_object_ref0 (conn);
	_data_->name = g_strdup (name);
	tpf_persona_store_add_standard_channel_co (_data_);
}


static TpChannel* tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpChannel* result;
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_add_standard_channel_co (data);
}


static gboolean tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->channel = NULL;
		{
			data->_state_ = 3;
			folks_tp_lowlevel_connection_open_contact_list_channel_async (data->self->priv->ll, data->conn, data->name, tpf_persona_store_add_standard_channel_ready, data);
			return FALSE;
			_state_3:
			data->_tmp0_ = folks_tp_lowlevel_connection_open_contact_list_channel_finish (data->self->priv->ll, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			data->channel = (data->_tmp1_ = _g_object_ref0 (data->_tmp0_), _g_object_unref0 (data->channel), data->_tmp1_);
		}
		goto __finally10;
		__catch10_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:797: failed to add channel '%s': %s\n", data->name, data->e->message);
				data->result = NULL;
				_g_error_free0 (data->e);
				_g_object_unref0 (data->channel);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally10:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		tpf_persona_store_set_up_new_standard_channel (data->self, data->channel);
		data->result = data->channel;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->channel);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->channel);
	_g_array_unref0 (data->channel_handles);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData, data);
}


static void tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_create_personas_from_channel_handles_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_create_personas_from_channel_handles_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->channel = _g_object_ref0 (channel);
	_data_->channel_handles = _g_array_ref0 (channel_handles);
	tpf_persona_store_create_personas_from_channel_handles_async_co (_data_);
}


static void tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_create_personas_from_channel_handles_async_co (data);
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->features = (data->_tmp1_ = (data->_tmp0_ = g_new0 (TpContactFeature, 2), data->_tmp0_[0] = TP_CONTACT_FEATURE_ALIAS, data->_tmp0_[1] = TP_CONTACT_FEATURE_PRESENCE, data->_tmp0_), data->features_length1 = 2, data->_features_size_ = data->features_length1, data->_tmp1_);
		data->_tmp2_ = NULL;
		data->contact_handles = (data->_tmp3_ = (data->_tmp2_ = g_new0 (guint, 0), data->_tmp2_), data->contact_handles_length1 = 0, data->_contact_handles_size_ = data->contact_handles_length1, data->_tmp3_);
		{
			data->i = 0;
			{
				data->_tmp4_ = TRUE;
				while (TRUE) {
					if (!data->_tmp4_) {
						data->i++;
					}
					data->_tmp4_ = FALSE;
					if (!(data->i < data->channel_handles->len)) {
						break;
					}
					data->channel_handle = (TpHandle) g_array_index (data->channel_handles, guint, (guint) data->i);
					data->contact_handle = tp_channel_group_get_handle_owner (data->channel, data->channel_handle);
					if ((data->_tmp6_ = (data->_tmp5_ = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->handle_persona_map, GUINT_TO_POINTER ((guint) data->contact_handle))) == NULL, _g_object_unref0 (data->_tmp5_), data->_tmp6_)) {
						_vala_array_add1 (&data->contact_handles, &data->contact_handles_length1, &data->_contact_handles_size_, (guint) data->contact_handle);
					}
				}
			}
		}
		{
			if (data->contact_handles_length1 < 1) {
				data->contact_handles = (g_free (data->contact_handles), NULL);
				data->features = (g_free (data->features), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->_state_ = 4;
			folks_tp_lowlevel_connection_get_contacts_by_handle_async (data->self->priv->ll, data->self->priv->conn, data->contact_handles, (guint) data->contact_handles_length1, (guint*) data->features, (guint) data->features_length1, tpf_persona_store_create_personas_from_channel_handles_async_ready, data);
			return FALSE;
			_state_4:
			data->contacts = folks_tp_lowlevel_connection_get_contacts_by_handle_finish (data->self->priv->ll, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
			if (data->contacts == NULL) {
				data->_tmp7_ = TRUE;
			} else {
				data->_tmp7_ = g_list_length (data->contacts) < 1;
			}
			if (data->_tmp7_) {
				data->contact_handles = (g_free (data->contact_handles), NULL);
				data->features = (g_free (data->features), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->contacts_array = (data->_tmp9_ = g_new0 (TpContact*, (data->_tmp8_ = g_list_length (data->contacts)) + 1), data->contacts_array_length1 = data->_tmp8_, data->_contacts_array_size_ = data->contacts_array_length1, data->_tmp9_);
			data->j = 0;
			data->l = data->contacts;
			{
				data->_tmp10_ = TRUE;
				while (TRUE) {
					if (!data->_tmp10_) {
						data->l = data->l->next;
					}
					data->_tmp10_ = FALSE;
					if (!(data->l != NULL)) {
						break;
					}
					data->contacts_array[data->j] = (data->_tmp11_ = _g_object_ref0 ((TpContact*) data->l->data), _g_object_unref0 (data->contacts_array[data->j]), data->_tmp11_);
					data->j++;
				}
			}
			tpf_persona_store_add_new_personas_from_contacts (data->self, data->contacts_array, data->contacts_array_length1);
			data->contacts_array = (_vala_array_free (data->contacts_array, data->contacts_array_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		goto __finally11;
		__catch11_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("failed to create personas from incoming contacts in " "channel '%s': %s", tp_channel_get_identifier (data->channel), data->e->message);
				_g_error_free0 (data->e);
			}
		}
		__finally11:
		if (data->_inner_error_ != NULL) {
			data->contact_handles = (g_free (data->contact_handles), NULL);
			data->features = (g_free (data->features), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->contact_handles = (g_free (data->contact_handles), NULL);
		data->features = (g_free (data->features), NULL);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_create_personas_from_contact_ids_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* data;
	data = _data;
	data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromContactIdsData, data);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tpf_persona_store_create_personas_from_contact_ids (TpfPersonaStore* self, char** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	char** _tmp1_;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromContactIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_create_personas_from_contact_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_create_personas_from_contact_ids_data_free);
	_data_->self = g_object_ref (self);
	_data_->contact_ids = (_tmp1_ = contact_ids, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, contact_ids_length1));
	_data_->contact_ids_length1 = contact_ids_length1;
	tpf_persona_store_create_personas_from_contact_ids_co (_data_);
}


static GList* tpf_persona_store_create_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	GList* result;
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tpf_persona_store_create_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_create_personas_from_contact_ids_co (data);
}


static gboolean tpf_persona_store_create_personas_from_contact_ids_co (TpfPersonaStoreCreatePersonasFromContactIdsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->features = (data->_tmp1_ = (data->_tmp0_ = g_new0 (TpContactFeature, 2), data->_tmp0_[0] = TP_CONTACT_FEATURE_ALIAS, data->_tmp0_[1] = TP_CONTACT_FEATURE_PRESENCE, data->_tmp0_), data->features_length1 = 2, data->_features_size_ = data->features_length1, data->_tmp1_);
		if (data->contact_ids_length1 > 0) {
			data->_state_ = 5;
			folks_tp_lowlevel_connection_get_contacts_by_id_async (data->self->priv->ll, data->self->priv->conn, data->contact_ids, (guint) data->contact_ids_length1, (guint*) data->features, (guint) data->features_length1, tpf_persona_store_create_personas_from_contact_ids_ready, data);
			return FALSE;
			_state_5:
			data->contacts = folks_tp_lowlevel_connection_get_contacts_by_id_finish (data->self->priv->ll, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				data->features = (g_free (data->features), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->personas = NULL;
			data->err_count = (guint) 0;
			data->err_format = g_strdup ("");
			{
				data->l = data->contacts;
				data->_tmp2_ = TRUE;
				while (TRUE) {
					if (!data->_tmp2_) {
						data->l = data->l->next;
					}
					data->_tmp2_ = FALSE;
					if (!(data->l != NULL)) {
						break;
					}
					data->contact = _g_object_ref0 ((TpContact*) data->l->data);
					{
						data->persona = tpf_persona_store_add_persona_from_contact (data->self, data->contact, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							if (data->_inner_error_->domain == TPF_PERSONA_ERROR) {
								goto __catch12_tpf_persona_error;
							}
							_g_object_unref0 (data->contact);
							_g_free0 (data->err_format);
							__g_list_free_g_object_unref0 (data->personas);
							data->features = (g_free (data->features), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
							g_clear_error (&data->_inner_error_);
							return FALSE;
						}
						if (data->persona != NULL) {
							data->personas = g_list_prepend (data->personas, _g_object_ref0 (data->persona));
						}
						_g_object_unref0 (data->persona);
					}
					goto __finally12;
					__catch12_tpf_persona_error:
					{
						data->e = data->_inner_error_;
						data->_inner_error_ = NULL;
						{
							if (data->err_count == 0) {
								data->err_format = (data->_tmp3_ = g_strdup ("failed to create %u personas:\n"), _g_free0 (data->err_format), data->_tmp3_);
							}
							data->err_format = (data->_tmp4_ = g_strdup_printf ("%s        '%s' (%p): %s\n", data->err_format, tp_contact_get_alias (data->contact), data->contact, data->e->message), _g_free0 (data->err_format), data->_tmp4_);
							data->err_count++;
							_g_error_free0 (data->e);
						}
					}
					__finally12:
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						_g_object_unref0 (data->contact);
						_g_free0 (data->err_format);
						__g_list_free_g_object_unref0 (data->personas);
						data->features = (g_free (data->features), NULL);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
					}
					_g_object_unref0 (data->contact);
				}
			}
			if (data->err_count > 0) {
				data->_inner_error_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, data->err_format, data->err_count);
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_free0 (data->err_format);
					__g_list_free_g_object_unref0 (data->personas);
					data->features = (g_free (data->features), NULL);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
			if (data->personas != NULL) {
				g_signal_emit_by_name ((FolksPersonaStore*) data->self, "personas-changed", data->personas, NULL, NULL, NULL, 0);
			}
			data->result = data->personas;
			_g_free0 (data->err_format);
			data->features = (g_free (data->features), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_free0 (data->err_format);
			__g_list_free_g_object_unref0 (data->personas);
		}
		data->result = NULL;
		data->features = (g_free (data->features), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->features = (g_free (data->features), NULL);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static TpfPersona* tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, GError** error) {
	TpfPersona* result = NULL;
	GError * _inner_error_;
	TpHandle h;
	TpfPersona* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_inner_error_ = NULL;
	h = tp_contact_get_handle (contact);
	if ((_tmp1_ = (_tmp0_ = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->handle_persona_map, GUINT_TO_POINTER ((guint) h))) == NULL, _g_object_unref0 (_tmp0_), _tmp1_)) {
		TpfPersona* persona;
		persona = tpf_persona_new (contact, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TPF_PERSONA_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_hash_table_insert (self->priv->_personas, g_strdup (folks_persona_get_iid ((FolksPersona*) persona)), _g_object_ref0 (persona));
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->handle_persona_map, GUINT_TO_POINTER ((guint) h), persona);
		folks_favourite_set_is_favourite ((FolksFavourite*) persona, gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->favourite_handles, GUINT_TO_POINTER ((guint) h)));
		result = persona;
		return result;
	}
	result = NULL;
	return result;
}


static void tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1) {
	GError * _inner_error_;
	GList* personas;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	personas = NULL;
	{
		TpContact** contact_collection;
		int contact_collection_length1;
		int contact_it;
		contact_collection = contacts;
		contact_collection_length1 = contacts_length1;
		for (contact_it = 0; contact_it < contacts_length1; contact_it = contact_it + 1) {
			TpContact* contact;
			contact = _g_object_ref0 (contact_collection[contact_it]);
			{
				{
					TpfPersona* persona;
					persona = tpf_persona_store_add_persona_from_contact (self, contact, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TPF_PERSONA_ERROR) {
							goto __catch13_tpf_persona_error;
						}
						_g_object_unref0 (contact);
						__g_list_free_g_object_unref0 (personas);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					if (persona != NULL) {
						personas = g_list_prepend (personas, _g_object_ref0 (persona));
					}
					_g_object_unref0 (persona);
				}
				goto __finally13;
				__catch13_tpf_persona_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_warning ("tpf-persona-store.vala:954: failed to create persona from contact '%s'" \
" (%p)", tp_contact_get_alias (contact), contact);
						_g_error_free0 (e);
					}
				}
				__finally13:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (contact);
					__g_list_free_g_object_unref0 (personas);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (contact);
			}
		}
	}
	tpf_persona_store_channel_groups_add_new_personas (self);
	if (personas != NULL) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", personas, NULL, NULL, NULL, 0);
	}
	__g_list_free_g_object_unref0 (personas);
}


static void tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it;
		_entry_it = gee_iterable_iterator ((GeeIterable*) self->priv->channel_group_incoming_adds);
		while (TRUE) {
			GeeMapEntry* entry;
			TpChannel* channel;
			GList* members_added;
			GeeHashSet* members;
			GeeHashSet* contact_handles;
			gboolean _tmp1_ = FALSE;
			char* name;
			gboolean _tmp2_ = FALSE;
			if (!gee_iterator_next (_entry_it)) {
				break;
			}
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
			channel = _g_object_ref0 (TP_CHANNEL ((TpChannel*) gee_map_entry_get_key (entry)));
			members_added = NULL;
			members = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->channel_group_personas_map, channel);
			if (members == NULL) {
				GeeHashSet* _tmp0_;
				members = (_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL), _g_object_unref0 (members), _tmp0_);
			}
			contact_handles = _g_object_ref0 ((GeeHashSet*) gee_map_entry_get_value (entry));
			if (contact_handles != NULL) {
				_tmp1_ = gee_collection_get_size ((GeeCollection*) contact_handles) > 0;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				GeeHashSet* contact_handles_added;
				contact_handles_added = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
				{
					GeeIterator* _contact_handle_it;
					_contact_handle_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) contact_handles);
					while (TRUE) {
						guint contact_handle;
						TpfPersona* persona;
						if (!gee_iterator_next (_contact_handle_it)) {
							break;
						}
						contact_handle = GPOINTER_TO_UINT (gee_iterator_get (_contact_handle_it));
						persona = (TpfPersona*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->handle_persona_map, GUINT_TO_POINTER (contact_handle));
						if (persona != NULL) {
							gee_abstract_collection_add ((GeeAbstractCollection*) members, persona);
							members_added = g_list_prepend (members_added, _g_object_ref0 (persona));
							gee_abstract_collection_add ((GeeAbstractCollection*) contact_handles_added, GUINT_TO_POINTER (contact_handle));
						}
						_g_object_unref0 (persona);
					}
					_g_object_unref0 (_contact_handle_it);
				}
				{
					GeeIterator* _handle_it;
					_handle_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) contact_handles_added);
					while (TRUE) {
						guint handle;
						if (!gee_iterator_next (_handle_it)) {
							break;
						}
						handle = GPOINTER_TO_UINT (gee_iterator_get (_handle_it));
						gee_abstract_collection_remove ((GeeAbstractCollection*) contact_handles, GUINT_TO_POINTER (handle));
					}
					_g_object_unref0 (_handle_it);
				}
				_g_object_unref0 (contact_handles_added);
			}
			if (gee_collection_get_size ((GeeCollection*) members) > 0) {
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->channel_group_personas_map, channel, members);
			}
			name = g_strdup (tp_channel_get_identifier (channel));
			if (tpf_persona_store_group_is_display_group (self, name)) {
				_tmp2_ = g_list_length (members_added) > 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				members_added = g_list_reverse (members_added);
				g_signal_emit_by_name (self, "group-members-changed", name, members_added, NULL);
			}
			_g_free0 (name);
			_g_object_unref0 (contact_handles);
			_g_object_unref0 (members);
			__g_list_free_g_object_unref0 (members_added);
			_g_object_unref0 (channel);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


static gboolean tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const char* group) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->undisplayed_groups_length1)) {
					break;
				}
				if (_vala_strcmp0 (self->priv->undisplayed_groups[i], group) == 0) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	TpfPersonaStoreAddPersonaFromDetailsData* data;
	data = _data;
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_add_persona_from_details_data_free);
	_data_->self = g_object_ref (self);
	_data_->details = _g_hash_table_ref0 (details);
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* tpf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_real_add_persona_from_details_co (data);
}


static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->contact_id = g_strdup (tp_asv_get_string (data->details, "contact"));
		if (data->contact_id == NULL) {
			data->_inner_error_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, "persona store (%s, %s) requires the following details:\n" "    contact (provided: '%s')\n", folks_persona_store_get_type_id ((FolksPersonaStore*) data->self), folks_persona_store_get_id ((FolksPersonaStore*) data->self), data->contact_id);
			{
				if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_free0 (data->contact_id);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				} else {
					_g_free0 (data->contact_id);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
		}
		data->contact_ids = (data->_tmp0_ = g_new0 (char*, 1 + 1), data->contact_ids_length1 = 1, data->_contact_ids_size_ = data->contact_ids_length1, data->_tmp0_);
		data->contact_ids[0] = (data->_tmp1_ = g_strdup (data->contact_id), _g_free0 (data->contact_ids[0]), data->_tmp1_);
		{
			data->_state_ = 6;
			tpf_persona_store_create_personas_from_contact_ids (data->self, data->contact_ids, data->contact_ids_length1, tpf_persona_store_add_persona_from_details_ready, data);
			return FALSE;
			_state_6:
			data->personas = tpf_persona_store_create_personas_from_contact_ids_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch14_g_error;
			}
			if (data->personas != NULL) {
				data->_tmp2_ = g_list_length (data->personas) == 1;
			} else {
				data->_tmp2_ = FALSE;
			}
			if (data->_tmp2_) {
				data->persona = _g_object_ref0 ((TpfPersona*) data->personas->data);
				if (data->self->priv->subscribe != NULL) {
					tpf_persona_store_change_standard_contact_list_membership (data->self, data->self->priv->subscribe, (FolksPersona*) data->persona, TRUE);
				}
				if (data->self->priv->publish != NULL) {
					data->flags = tp_channel_group_get_flags (data->self->priv->publish);
					if ((data->flags & TP_CHANNEL_GROUP_FLAG_CAN_ADD) == TP_CHANNEL_GROUP_FLAG_CAN_ADD) {
						tpf_persona_store_change_standard_contact_list_membership (data->self, data->self->priv->publish, (FolksPersona*) data->persona, TRUE);
					}
				}
				data->result = (FolksPersona*) data->persona;
				__g_list_free_g_object_unref0 (data->personas);
				data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->contact_id);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_object_unref0 (data->persona);
			} else {
				if (data->personas == NULL) {
					data->_tmp3_ = (guint) 0;
				} else {
					data->_tmp3_ = g_list_length (data->personas);
				}
				g_warning ("tpf-persona-store.vala:1065: requested a single persona, but got %u ba" \
"ck", data->_tmp3_);
			}
			__g_list_free_g_object_unref0 (data->personas);
		}
		goto __finally14;
		__catch14_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:1071: failed to add a persona from details: %s", data->e->message);
				_g_error_free0 (data->e);
			}
		}
		__finally14:
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->contact_id);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->contact_id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = NULL;
		data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->contact_id);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->contact_id);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaStoreChangeIsFavouriteData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreChangeIsFavouriteData, data);
}


void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_is_favourite_data_free);
	_data_->self = g_object_ref (self);
	_data_->persona = _g_object_ref0 (persona);
	_data_->is_favourite = is_favourite;
	tpf_persona_store_change_is_favourite_co (_data_);
}


void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_change_is_favourite_co (data);
}


static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (data->self->priv->logger == NULL) {
			g_warning ("tpf-persona-store.vala:1090: %s", "failed to change favourite without connection to the " "telepathy-logger service");
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			data->id = g_strdup (tp_contact_get_identifier (tpf_persona_get_contact (TPF_PERSONA (data->persona))));
			if (data->is_favourite) {
				data->_state_ = 7;
				logger_add_favourite_contact (data->self->priv->logger, data->id, tpf_persona_store_change_is_favourite_ready, data);
				return FALSE;
				_state_7:
				logger_add_favourite_contact_finish (data->self->priv->logger, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->id);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch15_dbus_gerror;
					}
					_g_free0 (data->id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			} else {
				data->_state_ = 8;
				logger_remove_favourite_contact (data->self->priv->logger, data->id, tpf_persona_store_change_is_favourite_ready, data);
				return FALSE;
				_state_8:
				logger_remove_favourite_contact_finish (data->self->priv->logger, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->id);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch15_dbus_gerror;
					}
					_g_free0 (data->id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			_g_free0 (data->id);
		}
		goto __finally15;
		__catch15_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tpf-persona-store.vala:1108: failed to change a persona's favourite st" \
"atus");
				_g_error_free0 (data->e);
			}
		}
		__finally15:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tpf_persona_store_change_alias_data_free (gpointer _data) {
	TpfPersonaStoreChangeAliasData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_free0 (data->alias);
	g_object_unref (data->self);
	g_slice_free (TpfPersonaStoreChangeAliasData, data);
}


void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const char* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_alias_data_free);
	_data_->self = g_object_ref (self);
	_data_->persona = _g_object_ref0 (persona);
	_data_->alias = g_strdup (alias);
	tpf_persona_store_change_alias_co (_data_);
}


void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_store_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tpf_persona_store_change_alias_co (data);
}


static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_debug ("tpf-persona-store.vala:1114: Changing alias of persona %u to '%s'.", tp_contact_get_handle (tpf_persona_get_contact (data->persona)), data->alias);
		folks_tp_lowlevel_connection_set_contact_alias (data->self->priv->ll, data->self->priv->conn, (guint) ((TpHandle) tp_contact_get_handle (tpf_persona_get_contact (data->persona))), data->alias);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self) {
	TpAccount* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_account;
	return result;
}


static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value) {
	TpAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_account = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_account), _tmp0_);
	g_object_notify ((GObject *) self, "account");
}


static const char* tpf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const char* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_type_id;
	return result;
}


static void tpf_persona_store_real_set_type_id (FolksPersonaStore* base, const char* value) {
	TpfPersonaStore* self;
	char* _tmp0_;
	self = (TpfPersonaStore*) base;
	self->priv->_type_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_type_id), _tmp0_);
	g_object_notify ((GObject *) self, "type-id");
}


static const char* tpf_persona_store_real_get_id (FolksPersonaStore* base) {
	const char* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_id;
	return result;
}


static void tpf_persona_store_real_set_id (FolksPersonaStore* base, const char* value) {
	TpfPersonaStore* self;
	char* _tmp0_;
	self = (TpfPersonaStore*) base;
	self->priv->_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_id), _tmp0_);
	g_object_notify ((GObject *) self, "id");
}


static GHashTable* tpf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GHashTable* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_personas;
	return result;
}


static void tpf_persona_store_class_init (TpfPersonaStoreClass * klass) {
	tpf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = tpf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = tpf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = tpf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = tpf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = tpf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = tpf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = tpf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->set_type_id = tpf_persona_store_real_set_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_id = tpf_persona_store_real_get_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->set_id = tpf_persona_store_real_set_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = tpf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = tpf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = tpf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ACCOUNT, g_param_spec_object ("account", "account", "account", TP_TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_TYPE_ID, "type-id");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ID, "id");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_PERSONAS, "personas");
	g_signal_new ("group_members_changed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER);
	g_signal_new ("group_removed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_POINTER);
}


static void tpf_persona_store_instance_init (TpfPersonaStore * self) {
	char** _tmp0_ = NULL;
	self->priv = TPF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->undisplayed_groups = (_tmp0_ = g_new0 (char*, 3 + 1), _tmp0_[0] = g_strdup ("publish"), _tmp0_[1] = g_strdup ("stored"), _tmp0_[2] = g_strdup ("subscribe"), _tmp0_);
	self->priv->undisplayed_groups_length1 = 3;
	self->priv->_undisplayed_groups_size_ = self->priv->undisplayed_groups_length1;
}


static void tpf_persona_store_finalize (GObject* obj) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (obj);
	self->priv->undisplayed_groups = (_vala_array_free (self->priv->undisplayed_groups, self->priv->undisplayed_groups_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->handle_persona_map);
	_g_object_unref0 (self->priv->channel_group_personas_map);
	_g_object_unref0 (self->priv->channel_group_incoming_adds);
	_g_object_unref0 (self->priv->group_outgoing_adds);
	_g_object_unref0 (self->priv->group_outgoing_removes);
	_g_object_unref0 (self->priv->standard_channels_unready);
	_g_object_unref0 (self->priv->group_channels_unready);
	_g_object_unref0 (self->priv->groups);
	_g_object_unref0 (self->priv->favourite_handles);
	_g_object_unref0 (self->priv->publish);
	_g_object_unref0 (self->priv->stored);
	_g_object_unref0 (self->priv->subscribe);
	_g_object_unref0 (self->priv->conn);
	_g_object_unref0 (self->priv->ll);
	_g_object_unref0 (self->priv->account_manager);
	_g_object_unref0 (self->priv->logger);
	_g_object_unref0 (self->priv->_account);
	_g_free0 (self->priv->_type_id);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (tpf_persona_store_parent_class)->finalize (obj);
}


GType tpf_persona_store_get_type (void) {
	static volatile gsize tpf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersonaStore), 0, (GInstanceInitFunc) tpf_persona_store_instance_init, NULL };
		GType tpf_persona_store_type_id;
		tpf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "TpfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&tpf_persona_store_type_id__volatile, tpf_persona_store_type_id);
	}
	return tpf_persona_store_type_id__volatile;
}


static void tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		g_value_set_object (value, tpf_persona_store_get_account (self));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_ID:
		g_value_set_string (value, folks_persona_store_get_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_PERSONAS:
		g_value_set_boxed (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		tpf_persona_store_set_account (self, g_value_get_object (value));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		folks_persona_store_set_type_id ((FolksPersonaStore*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_STORE_ID:
		folks_persona_store_set_id ((FolksPersonaStore*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}



