/* presence.c generated by valac, the Vala compiler
 * generated from presence.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_PRESENCE_TYPE (folks_presence_type_get_type ())

#define FOLKS_TYPE_PRESENCE (folks_presence_get_type ())
#define FOLKS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PRESENCE, FolksPresence))
#define FOLKS_IS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PRESENCE))
#define FOLKS_PRESENCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PRESENCE, FolksPresenceIface))

typedef struct _FolksPresence FolksPresence;
typedef struct _FolksPresenceIface FolksPresenceIface;

typedef enum  {
	FOLKS_PRESENCE_TYPE_UNSET,
	FOLKS_PRESENCE_TYPE_OFFLINE,
	FOLKS_PRESENCE_TYPE_AVAILABLE,
	FOLKS_PRESENCE_TYPE_AWAY,
	FOLKS_PRESENCE_TYPE_EXTENDED_AWAY,
	FOLKS_PRESENCE_TYPE_HIDDEN,
	FOLKS_PRESENCE_TYPE_BUSY,
	FOLKS_PRESENCE_TYPE_UNKNOWN,
	FOLKS_PRESENCE_TYPE_ERROR
} FolksPresenceType;

struct _FolksPresenceIface {
	GTypeInterface parent_iface;
	FolksPresenceType (*get_presence_type) (FolksPresence* self);
	void (*set_presence_type) (FolksPresence* self, FolksPresenceType value);
	const char* (*get_presence_message) (FolksPresence* self);
	void (*set_presence_message) (FolksPresence* self, const char* value);
};



GType folks_presence_type_get_type (void);
GType folks_presence_get_type (void);
static guint folks_presence_type_availability (FolksPresenceType type);
guint folks_presence_typecmp (FolksPresenceType type_a, FolksPresenceType type_b);
FolksPresenceType folks_presence_get_presence_type (FolksPresence* self);
gboolean folks_presence_is_online (FolksPresence* self);
void folks_presence_set_presence_type (FolksPresence* self, FolksPresenceType value);
const char* folks_presence_get_presence_message (FolksPresence* self);
void folks_presence_set_presence_message (FolksPresence* self, const char* value);



GType folks_presence_type_get_type (void) {
	static volatile gsize folks_presence_type_type_id__volatile = 0;
	if (g_once_init_enter (&folks_presence_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_PRESENCE_TYPE_UNSET, "FOLKS_PRESENCE_TYPE_UNSET", "unset"}, {FOLKS_PRESENCE_TYPE_OFFLINE, "FOLKS_PRESENCE_TYPE_OFFLINE", "offline"}, {FOLKS_PRESENCE_TYPE_AVAILABLE, "FOLKS_PRESENCE_TYPE_AVAILABLE", "available"}, {FOLKS_PRESENCE_TYPE_AWAY, "FOLKS_PRESENCE_TYPE_AWAY", "away"}, {FOLKS_PRESENCE_TYPE_EXTENDED_AWAY, "FOLKS_PRESENCE_TYPE_EXTENDED_AWAY", "extended-away"}, {FOLKS_PRESENCE_TYPE_HIDDEN, "FOLKS_PRESENCE_TYPE_HIDDEN", "hidden"}, {FOLKS_PRESENCE_TYPE_BUSY, "FOLKS_PRESENCE_TYPE_BUSY", "busy"}, {FOLKS_PRESENCE_TYPE_UNKNOWN, "FOLKS_PRESENCE_TYPE_UNKNOWN", "unknown"}, {FOLKS_PRESENCE_TYPE_ERROR, "FOLKS_PRESENCE_TYPE_ERROR", "error"}, {0, NULL, NULL}};
		GType folks_presence_type_type_id;
		folks_presence_type_type_id = g_enum_register_static ("FolksPresenceType", values);
		g_once_init_leave (&folks_presence_type_type_id__volatile, folks_presence_type_type_id);
	}
	return folks_presence_type_type_id__volatile;
}


static guint folks_presence_type_availability (FolksPresenceType type) {
	guint result = 0U;
	switch (type) {
		case FOLKS_PRESENCE_TYPE_UNSET:
		{
			result = (guint) 0;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			result = (guint) 1;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			result = (guint) 2;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		{
			result = (guint) 3;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			result = (guint) 4;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = (guint) 5;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		{
			result = (guint) 6;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			result = (guint) 7;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		{
			result = (guint) 8;
			return result;
		}
		default:
		{
			result = (guint) 1;
			return result;
		}
	}
}


guint folks_presence_typecmp (FolksPresenceType type_a, FolksPresenceType type_b) {
	guint result = 0U;
	result = folks_presence_type_availability (type_a) - folks_presence_type_availability (type_b);
	return result;
}


gboolean folks_presence_is_online (FolksPresence* self) {
	gboolean result = FALSE;
	result = folks_presence_typecmp (folks_presence_get_presence_type (self), FOLKS_PRESENCE_TYPE_OFFLINE) > 0;
	return result;
}


FolksPresenceType folks_presence_get_presence_type (FolksPresence* self) {
	return FOLKS_PRESENCE_GET_INTERFACE (self)->get_presence_type (self);
}


void folks_presence_set_presence_type (FolksPresence* self, FolksPresenceType value) {
	FOLKS_PRESENCE_GET_INTERFACE (self)->set_presence_type (self, value);
}


const char* folks_presence_get_presence_message (FolksPresence* self) {
	return FOLKS_PRESENCE_GET_INTERFACE (self)->get_presence_message (self);
}


void folks_presence_set_presence_message (FolksPresence* self, const char* value) {
	FOLKS_PRESENCE_GET_INTERFACE (self)->set_presence_message (self, value);
}


static void folks_presence_base_init (FolksPresenceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_enum ("presence-type", "presence-type", "presence-type", FOLKS_TYPE_PRESENCE_TYPE, FOLKS_PRESENCE_TYPE_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("presence-message", "presence-message", "presence-message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType folks_presence_get_type (void) {
	static volatile gsize folks_presence_type_id__volatile = 0;
	if (g_once_init_enter (&folks_presence_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPresenceIface), (GBaseInitFunc) folks_presence_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_presence_type_id;
		folks_presence_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPresence", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_presence_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_presence_type_id__volatile, folks_presence_type_id);
	}
	return folks_presence_type_id__volatile;
}




