/* kf-backend.c generated by valac 0.10.0, the Vala compiler
 * generated from kf-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define FOLKS_BACKENDS_KF_TYPE_BACKEND (folks_backends_kf_backend_get_type ())
#define FOLKS_BACKENDS_KF_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackend))
#define FOLKS_BACKENDS_KF_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackendClass))
#define FOLKS_BACKENDS_KF_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_BACKEND))
#define FOLKS_BACKENDS_KF_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_BACKEND))
#define FOLKS_BACKENDS_KF_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackendClass))

typedef struct _FolksBackendsKfBackend FolksBackendsKfBackend;
typedef struct _FolksBackendsKfBackendClass FolksBackendsKfBackendClass;
typedef struct _FolksBackendsKfBackendPrivate FolksBackendsKfBackendPrivate;

#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsKfBackendPrepareData FolksBackendsKfBackendPrepareData;

struct _FolksBackendsKfBackend {
	FolksBackend parent_instance;
	FolksBackendsKfBackendPrivate * priv;
};

struct _FolksBackendsKfBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsKfBackendPrivate {
	char* _name;
	GHashTable* _persona_stores;
};

struct _FolksBackendsKfBackendPrepareData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfBackend* self;
	GFile* file;
	char* path;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	char* _tmp3_;
	GFile* _tmp4_;
	FolksBackendsKfPersonaStore* store;
};


static gpointer folks_backends_kf_backend_parent_class = NULL;

GType folks_backends_kf_backend_get_type (void) G_GNUC_CONST;
GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackendPrivate))
enum  {
	FOLKS_BACKENDS_KF_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_NAME,
	FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES
};
FolksBackendsKfBackend* folks_backends_kf_backend_new (GError** error);
FolksBackendsKfBackend* folks_backends_kf_backend_construct (GType object_type, GError** error);
static void folks_backends_kf_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_kf_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backends_kf_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_kf_backend_real_prepare_co (FolksBackendsKfBackendPrepareData* data);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file);
static void folks_backends_kf_backend_store_removed_cb (FolksBackendsKfBackend* self, FolksPersonaStore* store);
static void _folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_kf_backend_finalize (GObject* obj);
static void folks_backends_kf_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_backends_kf_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
   * {@inheritDoc}
   */
FolksBackendsKfBackend* folks_backends_kf_backend_construct (GType object_type, GError** error) {
	FolksBackendsKfBackend * self;
	self = (FolksBackendsKfBackend*) g_object_new (object_type, "name", "key-file", NULL);
	return self;
}


FolksBackendsKfBackend* folks_backends_kf_backend_new (GError** error) {
	return folks_backends_kf_backend_construct (FOLKS_BACKENDS_KF_TYPE_BACKEND, error);
}


static void folks_backends_kf_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsKfBackendPrepareData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksBackendsKfBackendPrepareData, data);
}


static void folks_backends_kf_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfBackend * self;
	FolksBackendsKfBackendPrepareData* _data_;
	self = (FolksBackendsKfBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsKfBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_backend_real_prepare_data_free);
	_data_->self = g_object_ref (self);
	folks_backends_kf_backend_real_prepare_co (_data_);
}


static void folks_backends_kf_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfBackendPrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_kf_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfBackendPrepareData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backends_kf_backend_real_prepare_co (data);
}


/**
   * {@inheritDoc}
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_backends_kf_backend_store_removed_cb (self, _sender);
}


static gboolean folks_backends_kf_backend_real_prepare_co (FolksBackendsKfBackendPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->path = g_strdup (g_getenv ("FOLKS_BACKEND_KEY_FILE_PATH"));
	if (data->path == NULL) {
		data->file = (data->_tmp0_ = g_file_new_for_path (g_get_user_data_dir ()), _g_object_unref0 (data->file), data->_tmp0_);
		data->file = (data->_tmp1_ = g_file_get_child (data->file, "folks"), _g_object_unref0 (data->file), data->_tmp1_);
		data->file = (data->_tmp2_ = g_file_get_child (data->file, "relationships.ini"), _g_object_unref0 (data->file), data->_tmp2_);
		g_debug ("Using built-in key file '%s' (override with environment " "variable FOLKS_BACKEND_KEY_FILE_PATH)", data->_tmp3_ = g_file_get_path (data->file));
		_g_free0 (data->_tmp3_);
	} else {
		data->file = (data->_tmp4_ = g_file_new_for_path (data->path), _g_object_unref0 (data->file), data->_tmp4_);
		g_debug ("Using environment variable FOLKS_BACKEND_KEY_FILE_PATH = '%s'" " to load the key file.", data->path);
	}
	data->store = folks_backends_kf_persona_store_new (data->file);
	g_hash_table_insert (folks_backend_get_persona_stores ((FolksBackend*) data->self), g_strdup (folks_persona_store_get_id ((FolksPersonaStore*) data->store)), _g_object_ref0 ((FolksPersonaStore*) data->store));
	g_signal_connect_object ((FolksPersonaStore*) data->store, "removed", (GCallback) _folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed, data->self, 0);
	g_signal_emit_by_name ((FolksBackend*) data->self, "persona-store-added", (FolksPersonaStore*) data->store);
	_g_object_unref0 (data->store);
	_g_free0 (data->path);
	_g_object_unref0 (data->file);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_backends_kf_backend_store_removed_cb (FolksBackendsKfBackend* self, FolksPersonaStore* store) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", store);
	g_hash_table_remove (folks_backend_get_persona_stores ((FolksBackend*) self), folks_persona_store_get_id (store));
}


static const char* folks_backends_kf_backend_real_get_name (FolksBackend* base) {
	const char* result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = self->priv->_name;
	return result;
}


static void folks_backends_kf_backend_real_set_name (FolksBackend* base, const char* value) {
	FolksBackendsKfBackend* self;
	char* _tmp0_;
	self = (FolksBackendsKfBackend*) base;
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


static GHashTable* folks_backends_kf_backend_real_get_persona_stores (FolksBackend* base) {
	GHashTable* result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = self->priv->_persona_stores;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_kf_backend_real_set_persona_stores (FolksBackend* base, GHashTable* value) {
	FolksBackendsKfBackend* self;
	GHashTable* _tmp0_;
	self = (FolksBackendsKfBackend*) base;
	self->priv->_persona_stores = (_tmp0_ = _g_hash_table_ref0 (value), _g_hash_table_unref0 (self->priv->_persona_stores), _tmp0_);
	g_object_notify ((GObject *) self, "persona-stores");
}


static void folks_backends_kf_backend_class_init (FolksBackendsKfBackendClass * klass) {
	folks_backends_kf_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_kf_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_kf_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_kf_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->set_name = folks_backends_kf_backend_real_set_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_kf_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->set_persona_stores = folks_backends_kf_backend_real_set_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = folks_backends_kf_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_backends_kf_backend_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES, "persona-stores");
}


static void folks_backends_kf_backend_instance_init (FolksBackendsKfBackend * self) {
	self->priv = FOLKS_BACKENDS_KF_BACKEND_GET_PRIVATE (self);
}


static void folks_backends_kf_backend_finalize (GObject* obj) {
	FolksBackendsKfBackend * self;
	self = FOLKS_BACKENDS_KF_BACKEND (obj);
	_g_free0 (self->priv->_name);
	_g_hash_table_unref0 (self->priv->_persona_stores);
	G_OBJECT_CLASS (folks_backends_kf_backend_parent_class)->finalize (obj);
}


/**
 * A backend which loads {@link Persona}s from a simple key file in
 * (XDG_DATA_HOME/folks/) and presents them through a single
 * {@link PersonaStore}.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_backend_get_type (void) {
	static volatile gsize folks_backends_kf_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfBackend), 0, (GInstanceInitFunc) folks_backends_kf_backend_instance_init, NULL };
		GType folks_backends_kf_backend_type_id;
		folks_backends_kf_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsKfBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_kf_backend_type_id__volatile, folks_backends_kf_backend_type_id);
	}
	return folks_backends_kf_backend_type_id__volatile;
}


static void folks_backends_kf_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfBackend * self;
	self = FOLKS_BACKENDS_KF_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES:
		g_value_set_boxed (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_backends_kf_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsKfBackend * self;
	self = FOLKS_BACKENDS_KF_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_BACKEND_NAME:
		folks_backend_set_name ((FolksBackend*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES:
		folks_backend_set_persona_stores ((FolksBackend*) self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




