/* groupable.c generated by valac 0.11.5.3-fe751, the Vala compiler
 * generated from groupable.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_GROUPABLE (folks_groupable_get_type ())
#define FOLKS_GROUPABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GROUPABLE, FolksGroupable))
#define FOLKS_IS_GROUPABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GROUPABLE))
#define FOLKS_GROUPABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GROUPABLE, FolksGroupableIface))

typedef struct _FolksGroupable FolksGroupable;
typedef struct _FolksGroupableIface FolksGroupableIface;

#define FOLKS_GROUPABLE_TYPE_CHANGE_REASON (folks_groupable_change_reason_get_type ())

struct _FolksGroupableIface {
	GTypeInterface parent_iface;
	void (*change_group) (FolksGroupable* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_group_finish) (FolksGroupable* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_groups) (FolksGroupable* self);
	void (*set_groups) (FolksGroupable* self, GHashTable* value);
};

typedef enum  {
	FOLKS_GROUPABLE_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPABLE_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPABLE_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPABLE_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPABLE_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPABLE_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPABLE_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPABLE_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPABLE_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPABLE_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPABLE_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPABLE_CHANGE_REASON_SEPARATED = 11
} FolksGroupableChangeReason;



GType folks_groupable_get_type (void) G_GNUC_CONST;
GType folks_groupable_change_reason_get_type (void) G_GNUC_CONST;
void folks_groupable_change_group (FolksGroupable* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_groupable_change_group_finish (FolksGroupable* self, GAsyncResult* _res_, GError** error);
GHashTable* folks_groupable_get_groups (FolksGroupable* self);
void folks_groupable_set_groups (FolksGroupable* self, GHashTable* value);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


/**
   * The reason a group member has changed its membership in the group.
   *
   * These closely follow the
   * [[http://telepathy.freedesktop.org/spec/Channel_Interface_Group.html#Channel_Group_Change_Reason|Channel_Group_Change_Reason]]
   * interface in the Telepathy specification.
   */
GType folks_groupable_change_reason_get_type (void) {
	static volatile gsize folks_groupable_change_reason_type_id__volatile = 0;
	if (g_once_init_enter (&folks_groupable_change_reason_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_GROUPABLE_CHANGE_REASON_NONE, "FOLKS_GROUPABLE_CHANGE_REASON_NONE", "none"}, {FOLKS_GROUPABLE_CHANGE_REASON_OFFLINE, "FOLKS_GROUPABLE_CHANGE_REASON_OFFLINE", "offline"}, {FOLKS_GROUPABLE_CHANGE_REASON_KICKED, "FOLKS_GROUPABLE_CHANGE_REASON_KICKED", "kicked"}, {FOLKS_GROUPABLE_CHANGE_REASON_BUSY, "FOLKS_GROUPABLE_CHANGE_REASON_BUSY", "busy"}, {FOLKS_GROUPABLE_CHANGE_REASON_INVITED, "FOLKS_GROUPABLE_CHANGE_REASON_INVITED", "invited"}, {FOLKS_GROUPABLE_CHANGE_REASON_BANNED, "FOLKS_GROUPABLE_CHANGE_REASON_BANNED", "banned"}, {FOLKS_GROUPABLE_CHANGE_REASON_ERROR, "FOLKS_GROUPABLE_CHANGE_REASON_ERROR", "error"}, {FOLKS_GROUPABLE_CHANGE_REASON_INVALID_MEMBER, "FOLKS_GROUPABLE_CHANGE_REASON_INVALID_MEMBER", "invalid-member"}, {FOLKS_GROUPABLE_CHANGE_REASON_NO_ANSWER, "FOLKS_GROUPABLE_CHANGE_REASON_NO_ANSWER", "no-answer"}, {FOLKS_GROUPABLE_CHANGE_REASON_RENAMED, "FOLKS_GROUPABLE_CHANGE_REASON_RENAMED", "renamed"}, {FOLKS_GROUPABLE_CHANGE_REASON_PERMISSION_DENIED, "FOLKS_GROUPABLE_CHANGE_REASON_PERMISSION_DENIED", "permission-denied"}, {FOLKS_GROUPABLE_CHANGE_REASON_SEPARATED, "FOLKS_GROUPABLE_CHANGE_REASON_SEPARATED", "separated"}, {0, NULL, NULL}};
		GType folks_groupable_change_reason_type_id;
		folks_groupable_change_reason_type_id = g_enum_register_static ("FolksGroupableChangeReason", values);
		g_once_init_leave (&folks_groupable_change_reason_type_id__volatile, folks_groupable_change_reason_type_id);
	}
	return folks_groupable_change_reason_type_id__volatile;
}


void folks_groupable_change_group (FolksGroupable* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_GROUPABLE_GET_INTERFACE (self)->change_group (self, group, is_member, _callback_, _user_data_);
}


void folks_groupable_change_group_finish (FolksGroupable* self, GAsyncResult* _res_, GError** error) {
	FOLKS_GROUPABLE_GET_INTERFACE (self)->change_group_finish (self, _res_, error);
}


GHashTable* folks_groupable_get_groups (FolksGroupable* self) {
	return FOLKS_GROUPABLE_GET_INTERFACE (self)->get_groups (self);
}


void folks_groupable_set_groups (FolksGroupable* self, GHashTable* value) {
	FOLKS_GROUPABLE_GET_INTERFACE (self)->set_groups (self, value);
}


static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void folks_groupable_base_init (FolksGroupableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of group ID to whether the contact is a member.
		   *
		   * Freeform group IDs are mapped to a boolean which is `true` if the
		   * contact is a member of the group, and `false` otherwise.
		   */
		g_object_interface_install_property (iface, g_param_spec_boxed ("groups", "groups", "groups", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Emitted when the contact's membership status changes for a group.
		   *
		   * This is emitted if the contact becomes a member of a group they weren't in
		   * before, or leaves a group they were in.
		   *
		   * @param group a freeform group identifier for the group being left or joined
		   * @param is_member whether the contact is joining or leaving the group
		   * @since 0.1.11
		   */
		g_signal_new ("group_changed", FOLKS_TYPE_GROUPABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	}
}


/**
 * Interface for {@link Persona}s or {@link Individual}s which can be grouped
 * into sets of similar objects.
 */
GType folks_groupable_get_type (void) {
	static volatile gsize folks_groupable_type_id__volatile = 0;
	if (g_once_init_enter (&folks_groupable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksGroupableIface), (GBaseInitFunc) folks_groupable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_groupable_type_id;
		folks_groupable_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksGroupable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_groupable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_groupable_type_id__volatile, folks_groupable_type_id);
	}
	return folks_groupable_type_id__volatile;
}



