/* linked-hash-set.c generated by valac 0.11.5.3-fe751, the Vala compiler
 * generated from linked-hash-set.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Eitan Isaacson <eitan.isaacson@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define FOLKS_TYPE_LINKED_HASH_SET (folks_linked_hash_set_get_type ())
#define FOLKS_LINKED_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSet))
#define FOLKS_LINKED_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSetClass))
#define FOLKS_IS_LINKED_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_LINKED_HASH_SET))
#define FOLKS_IS_LINKED_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_LINKED_HASH_SET))
#define FOLKS_LINKED_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSetClass))

typedef struct _FolksLinkedHashSet FolksLinkedHashSet;
typedef struct _FolksLinkedHashSetClass FolksLinkedHashSetClass;
typedef struct _FolksLinkedHashSetPrivate FolksLinkedHashSetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksLinkedHashSet {
	GeeAbstractList parent_instance;
	FolksLinkedHashSetPrivate * priv;
};

struct _FolksLinkedHashSetClass {
	GeeAbstractListClass parent_class;
};

struct _FolksLinkedHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashSet* _hash_set;
	GeeLinkedList* _linked_list;
};


static gpointer folks_linked_hash_set_parent_class = NULL;
static GeeSetIface* folks_linked_hash_set_gee_set_parent_iface = NULL;

GType folks_linked_hash_set_get_type (void) G_GNUC_CONST;
#define FOLKS_LINKED_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSetPrivate))
enum  {
	FOLKS_LINKED_HASH_SET_DUMMY_PROPERTY,
	FOLKS_LINKED_HASH_SET_G_TYPE,
	FOLKS_LINKED_HASH_SET_G_DUP_FUNC,
	FOLKS_LINKED_HASH_SET_G_DESTROY_FUNC,
	FOLKS_LINKED_HASH_SET_SIZE
};
FolksLinkedHashSet* folks_linked_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
FolksLinkedHashSet* folks_linked_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
static gboolean folks_linked_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
static gboolean folks_linked_hash_set_real_add (GeeAbstractCollection* base, gconstpointer item);
static gboolean folks_linked_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void folks_linked_hash_set_real_clear (GeeAbstractCollection* base);
static gpointer folks_linked_hash_set_real_get (GeeAbstractList* base, gint index);
static void folks_linked_hash_set_real_set (GeeAbstractList* base, gint index, gconstpointer item);
static void folks_linked_hash_set_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
static gint folks_linked_hash_set_real_index_of (GeeAbstractList* base, gconstpointer item);
static gpointer folks_linked_hash_set_real_remove_at (GeeAbstractList* base, gint index);
static GeeList* folks_linked_hash_set_real_slice (GeeAbstractList* base, gint start, gint stop);
static gpointer folks_linked_hash_set_real_first (GeeAbstractList* base);
static gpointer folks_linked_hash_set_real_last (GeeAbstractList* base);
static gboolean folks_linked_hash_set_real_add_all (GeeAbstractCollection* base, GeeCollection* collection);
static GeeIterator* folks_linked_hash_set_real_iterator (GeeAbstractCollection* base);
static GeeListIterator* folks_linked_hash_set_real_list_iterator (GeeAbstractList* base);
static void folks_linked_hash_set_finalize (GObject* obj);
static void _vala_folks_linked_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_linked_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
   * Constructs a new empty set.
   *
   * If no function parameters are provided, the default functions for the
   * set's item type are used.
   *
   * @param hash_func an optional hash function
   * @param equal_func an optional equality testing function
   *
   * @since 0.3.4
   */
FolksLinkedHashSet* folks_linked_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	FolksLinkedHashSet * self = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_;
	GeeLinkedList* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_;
	self = (FolksLinkedHashSet*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = gee_hash_set_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, hash_func, equal_func);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_hash_set);
	self->priv->_hash_set = _tmp1_;
	_tmp2_ = gee_linked_list_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, equal_func);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_linked_list);
	self->priv->_linked_list = _tmp3_;
	return self;
}


FolksLinkedHashSet* folks_linked_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	return folks_linked_hash_set_construct (FOLKS_TYPE_LINKED_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
}


/**
   * Returns whether this structure contains the given item.
   *
   * @param item the element to find
   *
   * @return `true` if this collection contains the specified item.
   * @see Gee.AbstractCollection.contains
   *
   * @since 0.3.4
   */
static gboolean folks_linked_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	FolksLinkedHashSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_hash_set, item);
	result = _tmp0_;
	return result;
}


/**
   * Add the given element.
   *
   * @param item element to add
   *
   * @return `true` if the element was added.
   * @see Gee.AbstractCollection.add
   *
   * @since 0.3.4
   */
static gboolean folks_linked_hash_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
	FolksLinkedHashSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_hash_set, item);
	if (_tmp0_) {
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_linked_list, item);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
   * Remove the instance of the given element.
   *
   * @param item element to remove
   *
   * @return `true` if the element was removed.
   * @see Gee.AbstractCollection.remove
   *
   * @since 0.3.4
   */
static gboolean folks_linked_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	FolksLinkedHashSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_hash_set, item);
	if (_tmp0_) {
		gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_linked_list, item);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
   * Removes all items from this collection. Must not be called on read-only
   * collections.
   *
   * @see Gee.AbstractCollection.clear
   *
   * @since 0.3.4
   */
static void folks_linked_hash_set_real_clear (GeeAbstractCollection* base) {
	FolksLinkedHashSet * self;
	self = (FolksLinkedHashSet*) base;
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->_hash_set);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->_linked_list);
}


/**
   * Returns the item at the given position.
   *
   * @param index the position of an element to retrieve.
   *
   * @return the item at the specified index in this list.
   * @see Gee.AbstractList.get
   *
   * @since 0.3.4
   */
static gpointer folks_linked_hash_set_real_get (GeeAbstractList* base, gint index) {
	FolksLinkedHashSet * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_linked_list, index);
	result = _tmp0_;
	return result;
}


/**
   * Unimplemented method (incompatable with ordered set).
   */
static void folks_linked_hash_set_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	FolksLinkedHashSet * self;
	self = (FolksLinkedHashSet*) base;
	g_assert_not_reached ();
}


/**
   * Unimplemented method (incompatable with ordered set).
   */
static void folks_linked_hash_set_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	FolksLinkedHashSet * self;
	self = (FolksLinkedHashSet*) base;
	g_assert_not_reached ();
}


/**
   * Returns the position of the given item.
   *
   * @param item an element to find within this structure.
   *
   * @return the index of the occurence of the specified item in this list.
   * @see Gee.AbstractList.index_of
   *
   * @since 0.3.4
   */
static gint folks_linked_hash_set_real_index_of (GeeAbstractList* base, gconstpointer item) {
	FolksLinkedHashSet * self;
	gint result = 0;
	gboolean _tmp0_;
	gint _tmp1_;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_hash_set, item);
	if (!_tmp0_) {
		result = -1;
		return result;
	}
	_tmp1_ = gee_abstract_list_index_of ((GeeAbstractList*) self->priv->_linked_list, item);
	result = _tmp1_;
	return result;
}


/**
   * Remove the element at the given index.
   *
   * @param index position of the element to remove.
   *
   * @return the removed element.
   * @see Gee.AbstractList.remove_at
   *
   * @since 0.3.4
   */
static gpointer folks_linked_hash_set_real_remove_at (GeeAbstractList* base, gint index) {
	FolksLinkedHashSet * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	gpointer item;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->_linked_list, index);
	item = _tmp0_;
	if (item != NULL) {
		gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_hash_set, item);
	}
	result = item;
	return result;
}


/**
   * Returns a new sub-list of this structure. Caller does not own the new
   * list's elements.
   *
   * @param start position of first element in sub-list
   * @param stop position of last element in sub-list
   *
   * @return the sub-list specified by start and stop.
   * @see Gee.AbstractList.slice
   *
   * @since 0.3.4
   */
static GeeList* folks_linked_hash_set_real_slice (GeeAbstractList* base, gint start, gint stop) {
	FolksLinkedHashSet * self;
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_list_slice ((GeeAbstractList*) self->priv->_linked_list, start, stop);
	result = _tmp0_;
	return result;
}


/**
   * Returns the first element in this structure.
   *
   * @return the first element in the structure. Fails if the structure is
   * empty.
   * @see Gee.AbstractList.first
   *
   * @since 0.3.4
   */
static gpointer folks_linked_hash_set_real_first (GeeAbstractList* base) {
	FolksLinkedHashSet * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_list_first ((GeeAbstractList*) self->priv->_linked_list);
	result = _tmp0_;
	return result;
}


/**
   * Returns the first element in this structure.
   *
   * @return the last element in the structure. Fails if the structure is empty.
   * @see Gee.AbstractList.last
   *
   * @since 0.3.4
   */
static gpointer folks_linked_hash_set_real_last (GeeAbstractList* base) {
	FolksLinkedHashSet * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_list_last ((GeeAbstractList*) self->priv->_linked_list);
	result = _tmp0_;
	return result;
}


/**
   * Adds all the elements of the given collection to this one (as necessary).
   *
   * @param collection a {@link Gee.Collection} of elements to add.
   *
   * @return `true` if new elements were added to the collection.
   * @see Gee.AbstractCollection.add_all
   *
   * @since 0.3.4
   */
static gboolean folks_linked_hash_set_real_add_all (GeeAbstractCollection* base, GeeCollection* collection) {
	FolksLinkedHashSet * self;
	gboolean result = FALSE;
	gboolean modified;
	self = (FolksLinkedHashSet*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	modified = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _item_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			gpointer item;
			gboolean _tmp3_;
			_tmp1_ = gee_iterator_next (_item_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_item_it);
			item = _tmp2_;
			_tmp3_ = gee_abstract_collection_add ((GeeAbstractCollection*) self, item);
			modified = modified | _tmp3_;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = modified;
	return result;
}


/**
   * Returns the Iterator for this structure.
   *
   * @return a {@link Gee.Iterator} that can be used for iteration over this
   * structure.
   * @see Gee.Iterator
   *
   * @since 0.3.4
   */
static GeeIterator* folks_linked_hash_set_real_iterator (GeeAbstractCollection* base) {
	FolksLinkedHashSet * self;
	GeeIterator* result = NULL;
	GeeIterator* _tmp0_ = NULL;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_linked_list);
	result = _tmp0_;
	return result;
}


/**
   * Returns the ListIterator for this structure.
   *
   * @return a {@link Gee.ListIterator} that can be used for iteration over this
   * structure (as a list).
   * @see Gee.ListIterator
   *
   * @since 0.3.4
   */
static GeeListIterator* folks_linked_hash_set_real_list_iterator (GeeAbstractList* base) {
	FolksLinkedHashSet * self;
	GeeListIterator* result = NULL;
	GeeListIterator* _tmp0_ = NULL;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_abstract_list_list_iterator ((GeeAbstractList*) self->priv->_linked_list);
	result = _tmp0_;
	return result;
}


static gint folks_linked_hash_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	FolksLinkedHashSet* self;
	gint _tmp0_;
	self = (FolksLinkedHashSet*) base;
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->_linked_list);
	result = _tmp0_;
	return result;
}


static void folks_linked_hash_set_class_init (FolksLinkedHashSetClass * klass) {
	folks_linked_hash_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksLinkedHashSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = folks_linked_hash_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = folks_linked_hash_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = folks_linked_hash_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = folks_linked_hash_set_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = folks_linked_hash_set_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = folks_linked_hash_set_real_set;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = folks_linked_hash_set_real_insert;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = folks_linked_hash_set_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = folks_linked_hash_set_real_remove_at;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = folks_linked_hash_set_real_slice;
	GEE_ABSTRACT_LIST_CLASS (klass)->first = folks_linked_hash_set_real_first;
	GEE_ABSTRACT_LIST_CLASS (klass)->last = folks_linked_hash_set_real_last;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = folks_linked_hash_set_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = folks_linked_hash_set_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = folks_linked_hash_set_real_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = folks_linked_hash_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_linked_hash_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_linked_hash_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_linked_hash_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_LINKED_HASH_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_LINKED_HASH_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_LINKED_HASH_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The number of items in this collection.
	   *
	   * @see Gee.AbstractCollection.size
	   *
	   * @since 0.3.4
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_LINKED_HASH_SET_SIZE, "size");
}


static void folks_linked_hash_set_gee_set_interface_init (GeeSetIface * iface) {
	folks_linked_hash_set_gee_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_read_only_view = (GeeSet* (*) (GeeSet *)) gee_abstract_list_get_read_only_view;
}


static void folks_linked_hash_set_instance_init (FolksLinkedHashSet * self) {
	self->priv = FOLKS_LINKED_HASH_SET_GET_PRIVATE (self);
}


static void folks_linked_hash_set_finalize (GObject* obj) {
	FolksLinkedHashSet * self;
	self = FOLKS_LINKED_HASH_SET (obj);
	_g_object_unref0 (self->priv->_hash_set);
	_g_object_unref0 (self->priv->_linked_list);
	G_OBJECT_CLASS (folks_linked_hash_set_parent_class)->finalize (obj);
}


/**
 * Linked list implementation of the {@link Gee.Set} interface.
 * This implementation provides an ordered set with predictable iteration.
 *
 * @since 0.3.4
 */
GType folks_linked_hash_set_get_type (void) {
	static volatile gsize folks_linked_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&folks_linked_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksLinkedHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_linked_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksLinkedHashSet), 0, (GInstanceInitFunc) folks_linked_hash_set_instance_init, NULL };
		static const GInterfaceInfo gee_set_info = { (GInterfaceInitFunc) folks_linked_hash_set_gee_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_linked_hash_set_type_id;
		folks_linked_hash_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "FolksLinkedHashSet", &g_define_type_info, 0);
		g_type_add_interface_static (folks_linked_hash_set_type_id, GEE_TYPE_SET, &gee_set_info);
		g_once_init_leave (&folks_linked_hash_set_type_id__volatile, folks_linked_hash_set_type_id);
	}
	return folks_linked_hash_set_type_id__volatile;
}


static void _vala_folks_linked_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksLinkedHashSet * self;
	self = FOLKS_LINKED_HASH_SET (object);
	switch (property_id) {
		case FOLKS_LINKED_HASH_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_linked_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksLinkedHashSet * self;
	self = FOLKS_LINKED_HASH_SET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case FOLKS_LINKED_HASH_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case FOLKS_LINKED_HASH_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case FOLKS_LINKED_HASH_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}



