/* swf-persona.c generated by valac 0.12.0, the Vala compiler
 * generated from swf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>


#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
typedef struct _SwfPersonaPrivate SwfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;

struct _SwfPersona {
	FolksPersona parent_instance;
	SwfPersonaPrivate * priv;
};

struct _SwfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _SwfPersonaPrivate {
	GFile* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksGender _gender;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashMultiMap* _im_addresses;
	GeeHashMultiMap* _web_service_addresses;
};


static gpointer swf_persona_parent_class = NULL;
static FolksAvatarDetailsIface* swf_persona_folks_avatar_details_parent_iface = NULL;
static FolksGenderDetailsIface* swf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* swf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* swf_persona_folks_name_details_parent_iface = NULL;
static FolksUrlDetailsIface* swf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* swf_persona_folks_web_service_details_parent_iface = NULL;

GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA, SwfPersonaPrivate))
enum  {
	SWF_PERSONA_DUMMY_PROPERTY,
	SWF_PERSONA_LINKABLE_PROPERTIES,
	SWF_PERSONA_AVATAR,
	SWF_PERSONA_STRUCTURED_NAME,
	SWF_PERSONA_FULL_NAME,
	SWF_PERSONA_NICKNAME,
	SWF_PERSONA_GENDER,
	SWF_PERSONA_URLS,
	SWF_PERSONA_IM_ADDRESSES,
	SWF_PERSONA_WEB_SERVICE_ADDRESSES
};
gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
GType swf_persona_store_get_type (void) G_GNUC_CONST;
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* swf_persona_get_contact_id (SwContact* contact);
void swf_persona_update (SwfPersona* self, SwContact* contact);
static void swf_persona_finalize (GObject* obj);
static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SWF_PERSONA__linkable_properties[2] = {"im-addresses", "web-service-addresses"};

/**
   * Build the Facebook JID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return the Facebook JID or null if it is not a Facebook contact
   *
   * @since 0.5.0
   */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch0_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch0_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (lsw_id != NULL, NULL);
	facebook_jid = NULL;
	if (g_strcmp0 (store_id, "facebook") == 0) {
		gboolean _tmp1_;
		_tmp1_ = string_contains (lsw_id, "facebook-");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = string_replace (lsw_id, "facebook", "");
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "@chat.facebook.com", NULL);
		_g_free0 (facebook_jid);
		facebook_jid = _tmp4_;
		_g_free0 (_tmp3_);
	}
	result = facebook_jid;
	return result;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gchar* iid = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (lsw_id != NULL, NULL);
	facebook_jid = NULL;
	_tmp0_ = _swf_persona_build_facebook_jid (store_id, lsw_id);
	_g_free0 (facebook_jid);
	facebook_jid = _tmp0_;
	if (facebook_jid != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strconcat ("jabber:", facebook_jid, NULL);
		_g_free0 (iid);
		iid = _tmp1_;
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_strconcat (store_id, ":", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, lsw_id, NULL);
		_g_free0 (iid);
		iid = _tmp4_;
		_g_free0 (_tmp3_);
	}
	result = iid;
	_g_free0 (facebook_jid);
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the libsocialweb contact given by `contact`.
   */
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact) {
	SwfPersona * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* id;
	gchar* _tmp1_ = NULL;
	gchar* service;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* uid;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* iid;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* facebook_jid;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = swf_persona_get_contact_id (contact);
	id = _tmp0_;
	_tmp1_ = g_strdup (contact->service);
	service = _tmp1_;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp3_ = folks_persona_build_uid (BACKEND_NAME, _tmp2_, id);
	uid = _tmp3_;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp5_ = _swf_persona_build_iid (_tmp4_, id);
	iid = _tmp5_;
	self = (SwfPersona*) g_object_new (object_type, "display-id", id, "uid", uid, "iid", iid, "store", store, "is-user", FALSE, NULL);
	_tmp6_ = folks_persona_store_get_display_name ((FolksPersonaStore*) store);
	g_debug ("swf-persona.vala:192: Creating new Sw.Persona '%s' for %s UID '%s': %p", uid, _tmp6_, id, self);
	_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp8_ = _swf_persona_build_facebook_jid (_tmp7_, id);
	facebook_jid = _tmp8_;
	if (facebook_jid != NULL) {
		gchar* _tmp9_ = NULL;
		gchar* facebook_jid_copy;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* normalised_addr;
		gchar* _tmp18_;
		gchar* im_proto;
		_tmp9_ = g_strdup (facebook_jid);
		facebook_jid_copy = _tmp9_;
		_tmp10_ = facebook_jid_copy;
		facebook_jid_copy = NULL;
		_tmp11_ = _tmp10_;
		_tmp12_ = folks_im_details_normalise_im_address (_tmp11_, "jabber", &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_free0 (facebook_jid_copy);
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch1_folks_im_details_error;
			}
			_g_free0 (facebook_jid_copy);
			_g_free0 (facebook_jid);
			_g_free0 (iid);
			_g_free0 (uid);
			_g_free0 (service);
			_g_free0 (id);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp15_ = NULL;
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		normalised_addr = _tmp17_;
		_tmp18_ = g_strdup ("jabber");
		im_proto = _tmp18_;
		gee_multi_map_set ((GeeMultiMap*) self->priv->_im_addresses, im_proto, normalised_addr);
		_g_free0 (im_proto);
		_g_free0 (normalised_addr);
		_g_free0 (facebook_jid_copy);
		goto __finally1;
		__catch1_folks_im_details_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("swf-persona.vala:209: %s", e->message);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (facebook_jid);
			_g_free0 (iid);
			_g_free0 (uid);
			_g_free0 (service);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	gee_multi_map_set ((GeeMultiMap*) self->priv->_web_service_addresses, service, id);
	swf_persona_update (self, contact);
	_g_free0 (facebook_jid);
	_g_free0 (iid);
	_g_free0 (uid);
	_g_free0 (service);
	_g_free0 (id);
	return self;
}


SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact) {
	return swf_persona_construct (SWF_TYPE_PERSONA, store, contact);
}


gchar* swf_persona_get_contact_id (SwContact* contact) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = sw_contact_get_value (contact, "id");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void swf_persona_update (SwfPersona* self, SwContact* contact) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* nickname;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* avatar_path;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	FolksStructuredName* _tmp10_ = NULL;
	FolksStructuredName* structured_name;
	gboolean _tmp11_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* full_name;
	const gchar* _tmp15_ = NULL;
	GeeHashSet* _tmp16_ = NULL;
	GeeHashSet* urls;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* website;
	GeeSet* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* gender_string;
	FolksGender gender = 0;
	gboolean _tmp24_ = FALSE;
	FolksGender _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = sw_contact_get_value (contact, "name");
	_tmp1_ = g_strdup (_tmp0_);
	nickname = _tmp1_;
	if (nickname != NULL) {
		_tmp2_ = g_strcmp0 (self->priv->_nickname, nickname) != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (nickname);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp3_;
		g_object_notify ((GObject*) self, "nickname");
	}
	_tmp4_ = sw_contact_get_value (contact, "icon");
	_tmp5_ = g_strdup (_tmp4_);
	avatar_path = _tmp5_;
	if (avatar_path != NULL) {
		GFile* _tmp6_ = NULL;
		GFile* avatar_file;
		GFile* _tmp7_ = NULL;
		_tmp6_ = g_file_new_for_path (avatar_path);
		avatar_file = _tmp6_;
		_tmp7_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
		if (_tmp7_ != avatar_file) {
			folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, avatar_file);
		}
		_g_object_unref0 (avatar_file);
	}
	_tmp8_ = sw_contact_get_value (contact, "n.family");
	_tmp9_ = sw_contact_get_value (contact, "n.given");
	_tmp10_ = folks_structured_name_new_simple (_tmp8_, _tmp9_);
	structured_name = _tmp10_;
	_tmp11_ = folks_structured_name_is_empty (structured_name);
	if (!_tmp11_) {
		folks_name_details_set_structured_name ((FolksNameDetails*) self, structured_name);
	} else {
		FolksStructuredName* _tmp12_ = NULL;
		_tmp12_ = folks_name_details_get_structured_name ((FolksNameDetails*) self);
		if (_tmp12_ != NULL) {
			folks_name_details_set_structured_name ((FolksNameDetails*) self, NULL);
		}
	}
	_tmp13_ = sw_contact_get_value (contact, "fn");
	_tmp14_ = g_strdup (_tmp13_);
	full_name = _tmp14_;
	_tmp15_ = folks_name_details_get_full_name ((FolksNameDetails*) self);
	if (g_strcmp0 (_tmp15_, full_name) != 0) {
		folks_name_details_set_full_name ((FolksNameDetails*) self, full_name);
	}
	_tmp16_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	urls = _tmp16_;
	_tmp17_ = sw_contact_get_value (contact, "url");
	_tmp18_ = g_strdup (_tmp17_);
	website = _tmp18_;
	if (website != NULL) {
		FolksFieldDetails* _tmp19_ = NULL;
		FolksFieldDetails* _tmp20_;
		_tmp19_ = folks_field_details_new (website);
		_tmp20_ = _tmp19_;
		gee_abstract_collection_add ((GeeAbstractCollection*) urls, _tmp20_);
		_g_object_unref0 (_tmp20_);
	}
	_tmp21_ = folks_url_details_get_urls ((FolksUrlDetails*) self);
	if (_tmp21_ != urls) {
		folks_url_details_set_urls ((FolksUrlDetails*) self, (GeeSet*) urls);
	}
	_tmp22_ = sw_contact_get_value (contact, "x-gender");
	_tmp23_ = g_strdup (_tmp22_);
	gender_string = _tmp23_;
	if (gender_string != NULL) {
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		_tmp25_ = g_utf8_strdown (gender_string, (gssize) (-1));
		_tmp26_ = _tmp25_;
		_tmp24_ = g_strcmp0 (_tmp26_, "male") == 0;
		_g_free0 (_tmp26_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gender = FOLKS_GENDER_MALE;
	} else {
		gboolean _tmp27_ = FALSE;
		if (gender_string != NULL) {
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			_tmp28_ = g_utf8_strdown (gender_string, (gssize) (-1));
			_tmp29_ = _tmp28_;
			_tmp27_ = g_strcmp0 (_tmp29_, "female") == 0;
			_g_free0 (_tmp29_);
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			gender = FOLKS_GENDER_FEMALE;
		} else {
			gender = FOLKS_GENDER_UNSPECIFIED;
		}
	}
	_tmp30_ = folks_gender_details_get_gender ((FolksGenderDetails*) self);
	if (_tmp30_ != gender) {
		folks_gender_details_set_gender ((FolksGenderDetails*) self, gender);
	}
	_g_free0 (gender_string);
	_g_free0 (website);
	_g_object_unref0 (urls);
	_g_free0 (full_name);
	_g_object_unref0 (structured_name);
	_g_free0 (avatar_path);
	_g_free0 (nickname);
}


static gchar** swf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	const gchar** _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = SWF_PERSONA__linkable_properties;
	*result_length1 = G_N_ELEMENTS (SWF_PERSONA__linkable_properties);
	result = _tmp0_;
	return result;
}


static GFile* swf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GFile* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = self->priv->_avatar;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void swf_persona_real_set_avatar (FolksAvatarDetails* base, GFile* value) {
	SwfPersona* self;
	GFile* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp0_;
	g_object_notify ((GObject *) self, "avatar");
}


static FolksStructuredName* swf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = self->priv->_structured_name;
	return result;
}


static void swf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_structured_name);
	self->priv->_structured_name = _tmp0_;
	g_object_notify ((GObject *) self, "structured-name");
}


static const gchar* swf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = self->priv->_full_name;
	return result;
}


static void swf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp0_;
	g_object_notify ((GObject *) self, "full-name");
}


static const gchar* swf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = self->priv->_nickname;
	return result;
}


static FolksGender swf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = self->priv->_gender;
	return result;
}


static void swf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	SwfPersona* self;
	self = (SwfPersona*) base;
	self->priv->_gender = value;
	g_object_notify ((GObject *) self, "gender");
}


static GeeSet* swf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = self->priv->_urls_ro;
	return result;
}


static void swf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	SwfPersona* self;
	GeeHashSet* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	self = (SwfPersona*) base;
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp0_;
	_tmp1_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp1_;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _ps_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) value);
		_ps_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			FolksFieldDetails* ps;
			_tmp3_ = gee_iterator_next (_ps_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_ps_it);
			ps = (FolksFieldDetails*) _tmp4_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_urls, ps);
			_g_object_unref0 (ps);
		}
		_g_object_unref0 (_ps_it);
	}
	g_object_notify ((GObject *) self, "urls");
}


static GeeMultiMap* swf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = (GeeMultiMap*) self->priv->_im_addresses;
	return result;
}


static void swf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	self = (SwfPersona*) base;
	g_object_notify ((GObject *) self, "im-addresses");
}


static GeeMultiMap* swf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	self = (SwfPersona*) base;
	result = (GeeMultiMap*) self->priv->_web_service_addresses;
	return result;
}


static void swf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	self = (SwfPersona*) base;
	g_object_notify ((GObject *) self, "web-service-addresses");
}


static void swf_persona_class_init (SwfPersonaClass * klass) {
	swf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = swf_persona_real_get_linkable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_swf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = swf_persona_finalize;
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.HasAvatar.avatar}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STRUCTURED_NAME, "structured-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_FULL_NAME, "full-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_NICKNAME, "nickname");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_GENDER, "gender");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_URLS, "urls");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
}


static void swf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	swf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = swf_persona_real_get_avatar;
	iface->set_avatar = swf_persona_real_set_avatar;
}


static void swf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	swf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_gender = swf_persona_real_get_gender;
	iface->set_gender = swf_persona_real_set_gender;
}


static void swf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	swf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = swf_persona_real_get_im_addresses;
	iface->set_im_addresses = swf_persona_real_set_im_addresses;
}


static void swf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	swf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = swf_persona_real_get_structured_name;
	iface->set_structured_name = swf_persona_real_set_structured_name;
	iface->get_full_name = swf_persona_real_get_full_name;
	iface->set_full_name = swf_persona_real_set_full_name;
	iface->get_nickname = swf_persona_real_get_nickname;
}


static void swf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	swf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = swf_persona_real_get_urls;
	iface->set_urls = swf_persona_real_set_urls;
}


static void swf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	swf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_web_service_addresses = swf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = swf_persona_real_set_web_service_addresses;
}


static void swf_persona_instance_init (SwfPersona * self) {
	GeeHashMultiMap* _tmp0_ = NULL;
	GeeHashMultiMap* _tmp1_ = NULL;
	self->priv = SWF_PERSONA_GET_PRIVATE (self);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	self->priv->_im_addresses = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	self->priv->_web_service_addresses = _tmp1_;
}


static void swf_persona_finalize (GObject* obj) {
	SwfPersona * self;
	const gchar* _tmp0_ = NULL;
	self = SWF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	g_debug ("swf-persona.vala:220: Destroying Sw.Persona '%s': %p", _tmp0_, self);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_web_service_addresses);
	G_OBJECT_CLASS (swf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single libsocialweb contact.
 */
GType swf_persona_get_type (void) {
	static volatile gsize swf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersona), 0, (GInstanceInitFunc) swf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) swf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) swf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) swf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) swf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) swf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) swf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType swf_persona_type_id;
		swf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "SwfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&swf_persona_type_id__volatile, swf_persona_type_id);
	}
	return swf_persona_type_id__volatile;
}


static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	int length;
	self = SWF_PERSONA (object);
	switch (property_id) {
		case SWF_PERSONA_LINKABLE_PROPERTIES:
		g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		break;
		case SWF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case SWF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case SWF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case SWF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
	switch (property_id) {
		case SWF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case SWF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case SWF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



