/* command-backends.c generated by valac 0.12.0, the Vala compiler
 * generated from command-backends.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS (folks_inspect_commands_backends_get_type ())
#define FOLKS_INSPECT_COMMANDS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackends))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))

typedef struct _FolksInspectCommandsBackends FolksInspectCommandsBackends;
typedef struct _FolksInspectCommandsBackendsClass FolksInspectCommandsBackendsClass;
typedef struct _FolksInspectCommandsBackendsPrivate FolksInspectCommandsBackendsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsBackends {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsBackendsPrivate * priv;
};

struct _FolksInspectCommandsBackendsClass {
	FolksInspectCommandClass parent_class;
};


static gpointer folks_inspect_commands_backends_parent_class = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_backends_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_BACKENDS_DUMMY_PROPERTY
};
FolksInspectCommandsBackends* folks_inspect_commands_backends_new (FolksInspectClient* client);
FolksInspectCommandsBackends* folks_inspect_commands_backends_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_backends_real_run (FolksInspectCommand* base, const gchar* command_string);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
static gchar** folks_inspect_commands_backends_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsBackends* folks_inspect_commands_backends_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsBackends* self = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommandsBackends*) folks_inspect_command_construct (object_type, client);
	return self;
}


FolksInspectCommandsBackends* folks_inspect_commands_backends_new (FolksInspectClient* client) {
	return folks_inspect_commands_backends_construct (FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, client);
}


static void folks_inspect_commands_backends_real_run (FolksInspectCommand* base, const gchar* command_string) {
	FolksInspectCommandsBackends * self;
	self = (FolksInspectCommandsBackends*) base;
	if (command_string == NULL) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* backends;
		gint _tmp2_;
		_tmp0_ = folks_inspect_client_get_backend_store (((FolksInspectCommand*) self)->client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		backends = _tmp1_;
		_tmp2_ = gee_collection_get_size (backends);
		folks_inspect_utils_print_line ("%u backends:", (guint) _tmp2_);
		folks_inspect_utils_indent ();
		{
			GeeIterator* _tmp3_ = NULL;
			GeeIterator* _backend_it;
			_tmp3_ = gee_iterable_iterator ((GeeIterable*) backends);
			_backend_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				FolksBackend* backend;
				const gchar* _tmp6_ = NULL;
				_tmp4_ = gee_iterator_next (_backend_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_backend_it);
				backend = (FolksBackend*) _tmp5_;
				_tmp6_ = folks_backend_get_name (backend);
				folks_inspect_utils_print_line ("%s", _tmp6_);
				_g_object_unref0 (backend);
			}
			_g_object_unref0 (_backend_it);
		}
		folks_inspect_utils_unindent ();
		_g_object_unref0 (backends);
	} else {
		FolksBackendStore* _tmp7_ = NULL;
		FolksBackend* _tmp8_ = NULL;
		FolksBackend* backend;
		const gchar* _tmp9_ = NULL;
		GeeMap* _tmp10_ = NULL;
		gint _tmp11_;
		_tmp7_ = folks_inspect_client_get_backend_store (((FolksInspectCommand*) self)->client);
		_tmp8_ = folks_backend_store_dup_backend_by_name (_tmp7_, command_string);
		backend = _tmp8_;
		if (backend == NULL) {
			folks_inspect_utils_print_line ("Unrecognised backend name '%s'.", command_string);
			_g_object_unref0 (backend);
			return;
		}
		_tmp9_ = folks_backend_get_name (backend);
		_tmp10_ = folks_backend_get_persona_stores (backend);
		_tmp11_ = gee_map_get_size (_tmp10_);
		folks_inspect_utils_print_line ("Backend '%s' with %u persona stores " "(type ID, ID ('display name')):", _tmp9_, _tmp11_);
		folks_inspect_utils_indent ();
		{
			GeeMap* _tmp12_ = NULL;
			GeeCollection* _tmp13_ = NULL;
			GeeCollection* _tmp14_;
			GeeIterator* _tmp15_ = NULL;
			GeeIterator* _tmp16_;
			GeeIterator* _store_it;
			_tmp12_ = folks_backend_get_persona_stores (backend);
			_tmp13_ = gee_map_get_values (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp14_);
			_store_it = _tmp16_;
			while (TRUE) {
				gboolean _tmp17_;
				gpointer _tmp18_ = NULL;
				FolksPersonaStore* store;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				_tmp17_ = gee_iterator_next (_store_it);
				if (!_tmp17_) {
					break;
				}
				_tmp18_ = gee_iterator_get (_store_it);
				store = (FolksPersonaStore*) _tmp18_;
				_tmp19_ = folks_persona_store_get_type_id (store);
				_tmp20_ = folks_persona_store_get_id (store);
				_tmp21_ = folks_persona_store_get_display_name (store);
				folks_inspect_utils_print_line ("%s, %s ('%s')", _tmp19_, _tmp20_, _tmp21_);
				_g_object_unref0 (store);
			}
			_g_object_unref0 (_store_it);
		}
		folks_inspect_utils_unindent ();
		_g_object_unref0 (backend);
	}
}


static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_backend_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** folks_inspect_commands_backends_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsBackends * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	self = (FolksInspectCommandsBackends*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp1_ = _tmp0_ = rl_completion_matches (subcommand, _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t);
	_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, _vala_array_length (_tmp0_)));
	_tmp4_ = _tmp2_;
	*result_length1 = _vala_array_length (_tmp0_);
	result = _tmp4_;
	return result;
}


static const gchar* folks_inspect_commands_backends_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsBackends* self;
	self = (FolksInspectCommandsBackends*) base;
	result = "backends";
	return result;
}


static const gchar* folks_inspect_commands_backends_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsBackends* self;
	self = (FolksInspectCommandsBackends*) base;
	result = "Inspect the backends loaded by the aggregator.";
	return result;
}


static const gchar* folks_inspect_commands_backends_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsBackends* self;
	self = (FolksInspectCommandsBackends*) base;
	result = "backends                   List all known backends.\n" "backends [backend name]    Display the details of the " "specified backend and list its persona stores.";
	return result;
}


static void folks_inspect_commands_backends_class_init (FolksInspectCommandsBackendsClass * klass) {
	folks_inspect_commands_backends_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_backends_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_backends_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_backends_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_backends_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_backends_real_get_help;
}


static void folks_inspect_commands_backends_instance_init (FolksInspectCommandsBackends * self) {
}


GType folks_inspect_commands_backends_get_type (void) {
	static volatile gsize folks_inspect_commands_backends_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_backends_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsBackendsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_backends_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsBackends), 0, (GInstanceInitFunc) folks_inspect_commands_backends_instance_init, NULL };
		GType folks_inspect_commands_backends_type_id;
		folks_inspect_commands_backends_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsBackends", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_backends_type_id__volatile, folks_inspect_commands_backends_type_id);
	}
	return folks_inspect_commands_backends_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



