/* folks.vapi generated by valac 0.12.0, do not modify. */

[CCode (cprefix = "Folks", lower_case_cprefix = "folks_")]
namespace Folks {
	[CCode (cheader_filename = "folks.h")]
	public abstract class Backend : GLib.Object {
		public Backend ();
		public abstract async void prepare () throws GLib.Error;
		public abstract async void unprepare () throws GLib.Error;
		public abstract bool is_prepared { get; }
		public abstract string name { get; }
		public abstract GLib.HashTable<string,Folks.PersonaStore> persona_stores { get; }
		public signal void persona_store_added (Folks.PersonaStore store);
		public signal void persona_store_removed (Folks.PersonaStore store);
	}
	[CCode (cheader_filename = "folks.h")]
	public class BackendStore : GLib.Object {
		public static string KEY_FILE_GROUP_ALL_OTHERS;
		public void add_backend (Folks.Backend backend);
		public async void disable_backend (string name);
		public static Folks.BackendStore dup ();
		public Folks.Backend? dup_backend_by_name (string name);
		public async void enable_backend (string name);
		public Gee.Collection<Folks.Backend> list_backends ();
		public async void load_backends () throws GLib.Error;
		public async void prepare ();
		public GLib.List<Folks.Backend> enabled_backends {
		[CCode (cname = "folks_backend_store_dup_enabled_backends")] owned get; private set; }
		public bool is_prepared { get; private set; }
		public signal void backend_available (Folks.Backend backend);
	}
	[CCode (cheader_filename = "folks.h")]
	public class FieldDetails : GLib.Object {
		public FieldDetails (string value);
		public void add_parameter (string parameter_name, string parameter_value);
		public void extend_parameters (GLib.HashTable<string,GLib.List<string>> additional);
		public unowned GLib.List<string> get_parameter_values (string parameter_name);
		public void remove_parameter_all (string parameter_name);
		public void set_parameter (string parameter_name, string parameter_value);
		public GLib.HashTable<string,GLib.List<string>> parameters { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public class Individual : GLib.Object, Folks.AliasDetails, Folks.AvatarDetails, Folks.BirthdayDetails, Folks.EmailDetails, Folks.FavouriteDetails, Folks.GenderDetails, Folks.GroupDetails, Folks.ImDetails, Folks.LocalIdDetails, Folks.NameDetails, Folks.NoteDetails, Folks.PresenceDetails, Folks.PhoneDetails, Folks.PostalAddressDetails, Folks.RoleDetails, Folks.UrlDetails, Folks.WebServiceDetails {
		public Individual (GLib.List<Folks.Persona>? personas);
		public string id { get; private set; }
		public bool is_user { get; private set; }
		public GLib.List<Folks.Persona> personas { get; set; }
		public Folks.TrustLevel trust_level { get; private set; }
		public signal void personas_changed (GLib.List<Folks.Persona>? added, GLib.List<Folks.Persona>? removed);
		public signal void removed (Folks.Individual? replacement_individual);
	}
	[CCode (cheader_filename = "folks.h")]
	public class IndividualAggregator : GLib.Object {
		public IndividualAggregator ();
		public async Folks.Persona? add_persona_from_details (Folks.Individual? parent, Folks.PersonaStore persona_store, GLib.HashTable<string,GLib.Value?> details) throws Folks.IndividualAggregatorError;
		public Gee.HashMap<Folks.Individual,Gee.HashMap<Folks.Individual,Folks.MatchResult>> get_all_potential_matches (Folks.MatchResult min_threshold = MatchResult.VERY_HIGH);
		public Gee.HashMap<Folks.Individual,Folks.MatchResult> get_potential_matches (Folks.Individual matchee, Folks.MatchResult min_threshold = MatchResult.VERY_HIGH);
		public async void link_personas (void* personas_in) throws Folks.IndividualAggregatorError;
		public async void prepare () throws GLib.Error;
		public async void remove_individual (Folks.Individual individual) throws GLib.Error;
		public async void remove_persona (Folks.Persona persona) throws GLib.Error;
		public async void unlink_individual (Folks.Individual individual) throws GLib.Error;
		public GLib.HashTable<string,Folks.Individual> individuals { get; private set; }
		public bool is_prepared { get; }
		public Folks.PersonaStore primary_store { get; }
		public Folks.Individual user { get; private set; }
		public signal void individuals_changed (GLib.List<Folks.Individual>? added, GLib.List<Folks.Individual>? removed, string? message, Folks.Persona? actor, Folks.GroupDetails.ChangeReason reason);
	}
	[CCode (cheader_filename = "folks.h")]
	public class LinkedHashSet<G> : Gee.AbstractList<G>, Gee.Set<G> {
		public LinkedHashSet (GLib.HashFunc? hash_func = null, GLib.EqualFunc? equal_func = null);
		public override bool add (G item);
		public override bool add_all (Gee.Collection<G> collection);
		public override void clear ();
		public override bool contains (G item);
		public override G first ();
		public override G @get (int index);
		public override int index_of (G item);
		public override void insert (int index, G item);
		public override Gee.Iterator<G> iterator ();
		public override G last ();
		public override Gee.ListIterator<G> list_iterator ();
		public override bool remove (G item);
		public override G remove_at (int index);
		public override void @set (int index, G item);
		public override Gee.List<G>? slice (int start, int stop);
		public override int size { get; }
	}
	[CCode (cheader_filename = "folks.h")]
	public class Note : GLib.Object {
		public Note (string content, string? uid = null);
		public static bool equal (Folks.Note a, Folks.Note b);
		public static uint hash (Folks.Note r);
		public string content { get; set; }
		public string uid { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class Persona : GLib.Object {
		[CCode (cheader_filename = "folks.h")]
		public delegate void LinkablePropertyCallback (string link);
		public Persona ();
		public static string build_uid (string backend_name, string persona_store_id, string persona_id);
		public virtual void linkable_property_to_links (string prop_name, Folks.Persona.LinkablePropertyCallback callback);
		public static void split_uid (string uid, out string backend_name, out string persona_store_id, out string persona_id);
		public string display_id { get; construct; }
		public string iid { get; construct; }
		public bool is_user { get; construct; }
		public abstract string[] linkable_properties { get; }
		public Folks.PersonaStore store { get; construct; }
		public string uid { get; construct; }
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class PersonaStore : GLib.Object {
		public PersonaStore ();
		public abstract async Folks.Persona? add_persona_from_details (GLib.HashTable<string,GLib.Value?> details) throws Folks.PersonaStoreError;
		public static unowned string detail_key (Folks.PersonaDetail detail);
		public virtual async void flush ();
		public abstract async void prepare () throws GLib.Error;
		public abstract async void remove_persona (Folks.Persona persona) throws GLib.Error;
		public abstract Folks.MaybeBool can_add_personas { get; }
		public abstract Folks.MaybeBool can_alias_personas { get; }
		public abstract Folks.MaybeBool can_group_personas { get; }
		public abstract Folks.MaybeBool can_remove_personas { get; }
		public string display_name { get; construct; }
		public string id { get; construct; }
		public abstract bool is_prepared { get; }
		public bool is_writeable { get; set; }
		public abstract GLib.HashTable<string,Folks.Persona> personas { get; }
		public Folks.PersonaStoreTrust trust_level { get; set; }
		public abstract string type_id { get; }
		public signal void personas_changed (GLib.List<Folks.Persona>? added, GLib.List<Folks.Persona>? removed, string? message, Folks.Persona? actor, Folks.GroupDetails.ChangeReason reason);
		public signal void removed ();
	}
	[CCode (cheader_filename = "folks.h")]
	public class PostalAddress : GLib.Object {
		public PostalAddress (string? po_box, string? extension, string? street, string? locality, string? region, string? postal_code, string? country, string? address_format, GLib.List<string> types, string? uid);
		public bool equal (Folks.PostalAddress with);
		public string to_string ();
		public string address_format { get; set construct; }
		public string country { get; set construct; }
		public string extension { get; set construct; }
		public string locality { get; set construct; }
		public string po_box { get; set construct; }
		public string postal_code { get; set construct; }
		public string region { get; set construct; }
		public string street { get; set construct; }
		public GLib.List<string> types { get; set construct; }
		public string uid { get; set construct; }
	}
	[CCode (cheader_filename = "folks.h")]
	public class PotentialMatch : GLib.Object {
		public static Gee.HashSet<string> known_email_aliases;
		public PotentialMatch ();
		public void _inspect_im_addresses ();
		public double jaro_dist (string s1, string s2);
		public Folks.MatchResult potential_match (Folks.Individual a, Folks.Individual b);
		public static string result_to_string (Folks.MatchResult result);
	}
	[CCode (cheader_filename = "folks.h")]
	public class Role : GLib.Object {
		public Role (string? title = null, string? organisation_name = null, string? uid = null);
		public static bool equal (Folks.Role a, Folks.Role b);
		public static uint hash (Folks.Role r);
		public string to_string ();
		public string organisation_name { get; set; }
		public string title { get; set; }
		public string uid { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public class StructuredName : GLib.Object {
		public StructuredName (string? family_name, string? given_name, string? additional_names, string? prefixes, string? suffixes);
		public bool equal (Folks.StructuredName other);
		public bool is_empty ();
		public StructuredName.simple (string? family_name, string? given_name);
		public string to_string ();
		public string additional_names { get; set construct; }
		public string family_name { get; set construct; }
		public string given_name { get; set construct; }
		public string prefixes { get; set construct; }
		public string suffixes { get; set construct; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface AliasDetails : GLib.Object {
		public abstract string alias { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface AvatarDetails : GLib.Object {
		public abstract GLib.File avatar { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface BirthdayDetails : GLib.Object {
		public abstract GLib.DateTime birthday { get; set; }
		public abstract string calendar_event_id { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface EmailDetails : GLib.Object {
		public abstract GLib.List<Folks.FieldDetails> email_addresses { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface FavouriteDetails : GLib.Object {
		public abstract bool is_favourite { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface GenderDetails : GLib.Object {
		public abstract Folks.Gender gender { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface GroupDetails : GLib.Object {
		[CCode (cprefix = "FOLKS_GROUP_DETAILS_CHANGE_REASON_", cheader_filename = "folks.h")]
		public enum ChangeReason {
			NONE,
			OFFLINE,
			KICKED,
			BUSY,
			INVITED,
			BANNED,
			ERROR,
			INVALID_MEMBER,
			NO_ANSWER,
			RENAMED,
			PERMISSION_DENIED,
			SEPARATED
		}
		public abstract async void change_group (string group, bool is_member) throws GLib.Error;
		public abstract GLib.HashTable<string,bool> groups { get; set; }
		public signal void group_changed (string group, bool is_member);
	}
	[CCode (cheader_filename = "folks.h")]
	public interface ImDetails : GLib.Object {
		public static string normalise_im_address (string im_address, string protocol) throws Folks.ImDetailsError;
		public abstract GLib.HashTable<string,Folks.LinkedHashSet<string>> im_addresses { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface LocalIdDetails : GLib.Object {
		public abstract Gee.HashSet<string> local_ids { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface NameDetails : GLib.Object {
		public abstract string full_name { get; set; }
		public abstract string nickname { get; }
		public abstract Folks.StructuredName structured_name { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface NoteDetails : GLib.Object {
		public abstract Gee.HashSet<Folks.Note> notes { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface PhoneDetails : GLib.Object {
		public static string normalise_number (string number);
		public static bool numbers_equal (string number1, string number2);
		public abstract GLib.List<Folks.FieldDetails> phone_numbers { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface PostalAddressDetails : GLib.Object {
		public abstract GLib.List<Folks.PostalAddress> postal_addresses { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface PresenceDetails : GLib.Object {
		public bool is_online ();
		public static int typecmp (Folks.PresenceType type_a, Folks.PresenceType type_b);
		public abstract string presence_message { get; set; }
		public abstract Folks.PresenceType presence_type { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface RoleDetails : GLib.Object {
		public abstract Gee.HashSet<Folks.Role> roles { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface UrlDetails : GLib.Object {
		public abstract GLib.List<Folks.FieldDetails> urls { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface WebServiceDetails : GLib.Object {
		public abstract Gee.HashMap<string,Folks.LinkedHashSet<string>> web_service_addresses { get; set; }
	}
	[CCode (cprefix = "FOLKS_GENDER_", cheader_filename = "folks.h")]
	public enum Gender {
		UNSPECIFIED,
		MALE,
		FEMALE
	}
	[CCode (cprefix = "FOLKS_MATCH_RESULT_", cheader_filename = "folks.h")]
	public enum MatchResult {
		VERY_LOW,
		LOW,
		MEDIUM,
		HIGH,
		VERY_HIGH,
		MIN,
		MAX
	}
	[CCode (cprefix = "FOLKS_MAYBE_BOOL_", cheader_filename = "folks.h")]
	public enum MaybeBool {
		UNSET,
		FALSE,
		TRUE
	}
	[CCode (cprefix = "FOLKS_PERSONA_DETAIL_", cheader_filename = "folks.h")]
	public enum PersonaDetail {
		ALIAS,
		AVATAR,
		BIRTHDAY,
		EMAIL_ADDRESSES,
		FULL_NAME,
		GENDER,
		IM_ADDRESSES,
		IS_FAVOURITE,
		LOCAL_IDS,
		NOTES,
		PHONE_NUMBERS,
		POSTAL_ADDRESSES,
		ROLES,
		STRUCTURED_NAME,
		URLS,
		WEB_SERVICE_ADDRESSES
	}
	[CCode (cprefix = "FOLKS_PERSONA_STORE_TRUST_", cheader_filename = "folks.h")]
	public enum PersonaStoreTrust {
		NONE,
		PARTIAL,
		FULL
	}
	[CCode (cprefix = "FOLKS_PRESENCE_TYPE_", cheader_filename = "folks.h")]
	public enum PresenceType {
		UNSET,
		OFFLINE,
		AVAILABLE,
		AWAY,
		EXTENDED_AWAY,
		HIDDEN,
		BUSY,
		UNKNOWN,
		ERROR
	}
	[CCode (cprefix = "FOLKS_TRUST_LEVEL_", cheader_filename = "folks.h")]
	public enum TrustLevel {
		NONE,
		PERSONAS
	}
	[CCode (cprefix = "FOLKS_IM_DETAILS_ERROR_", cheader_filename = "folks.h")]
	public errordomain ImDetailsError {
		INVALID_IM_ADDRESS,
	}
	[CCode (cprefix = "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_", cheader_filename = "folks.h")]
	public errordomain IndividualAggregatorError {
		ADD_FAILED,
		NO_WRITEABLE_STORE,
		STORE_OFFLINE,
	}
	[CCode (cprefix = "FOLKS_PERSONA_STORE_ERROR_", cheader_filename = "folks.h")]
	public errordomain PersonaStoreError {
		INVALID_ARGUMENT,
		CREATE_FAILED,
		UNSUPPORTED_ON_USER,
		STORE_OFFLINE,
		READ_ONLY,
	}
}
