/* name-details.c generated by valac 0.12.0, the Vala compiler
 * generated from name-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;
typedef struct _FolksStructuredNamePrivate FolksStructuredNamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_NAME_DETAILS (folks_name_details_get_type ())
#define FOLKS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetails))
#define FOLKS_IS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NAME_DETAILS))
#define FOLKS_NAME_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetailsIface))

typedef struct _FolksNameDetails FolksNameDetails;
typedef struct _FolksNameDetailsIface FolksNameDetailsIface;

struct _FolksStructuredName {
	GObject parent_instance;
	FolksStructuredNamePrivate * priv;
};

struct _FolksStructuredNameClass {
	GObjectClass parent_class;
};

struct _FolksStructuredNamePrivate {
	gchar* _family_name;
	gchar* _given_name;
	gchar* _additional_names;
	gchar* _prefixes;
	gchar* _suffixes;
};

struct _FolksNameDetailsIface {
	GTypeInterface parent_iface;
	FolksStructuredName* (*get_structured_name) (FolksNameDetails* self);
	void (*set_structured_name) (FolksNameDetails* self, FolksStructuredName* value);
	const gchar* (*get_full_name) (FolksNameDetails* self);
	void (*set_full_name) (FolksNameDetails* self, const gchar* value);
	const gchar* (*get_nickname) (FolksNameDetails* self);
};


static gpointer folks_structured_name_parent_class = NULL;

GType folks_structured_name_get_type (void) G_GNUC_CONST;
#define FOLKS_STRUCTURED_NAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNamePrivate))
enum  {
	FOLKS_STRUCTURED_NAME_DUMMY_PROPERTY,
	FOLKS_STRUCTURED_NAME_FAMILY_NAME,
	FOLKS_STRUCTURED_NAME_GIVEN_NAME,
	FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES,
	FOLKS_STRUCTURED_NAME_PREFIXES,
	FOLKS_STRUCTURED_NAME_SUFFIXES
};
FolksStructuredName* folks_structured_name_new (const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes);
FolksStructuredName* folks_structured_name_construct (GType object_type, const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes);
FolksStructuredName* folks_structured_name_new_simple (const gchar* family_name, const gchar* given_name);
FolksStructuredName* folks_structured_name_construct_simple (GType object_type, const gchar* family_name, const gchar* given_name);
gboolean folks_structured_name_is_empty (FolksStructuredName* self);
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self);
const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self);
gchar* folks_structured_name_to_string (FolksStructuredName* self);
void folks_structured_name_set_family_name (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_given_name (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_additional_names (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_prefixes (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_suffixes (FolksStructuredName* self, const gchar* value);
static void folks_structured_name_finalize (GObject* obj);
static void _vala_folks_structured_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_structured_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_name_details_get_type (void) G_GNUC_CONST;
FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self);
void folks_name_details_set_structured_name (FolksNameDetails* self, FolksStructuredName* value);
const gchar* folks_name_details_get_full_name (FolksNameDetails* self);
void folks_name_details_set_full_name (FolksNameDetails* self, const gchar* value);
const gchar* folks_name_details_get_nickname (FolksNameDetails* self);


/**
   * Create a StructuredName.
   *
   * You can pass `null` if a component is not set.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @param additional_names additional names
   * @param prefixes prefixes of the name
   * @param suffixes suffixes of the name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName* folks_structured_name_construct (GType object_type, const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes) {
	FolksStructuredName * self = NULL;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", family_name, "given-name", given_name, "additional-names", additional_names, "prefixes", prefixes, "suffixes", suffixes, NULL);
	return self;
}


FolksStructuredName* folks_structured_name_new (const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes) {
	return folks_structured_name_construct (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name, additional_names, prefixes, suffixes);
}


/**
   * Create a StructuredName.
   *
   * Shorthand for the common case of just having the family and given
   * name of a contact. It's equivalent to calling
   * {@link StructuredName.StructuredName} and passing `null` for all
   * the other components.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName* folks_structured_name_construct_simple (GType object_type, const gchar* family_name, const gchar* given_name) {
	FolksStructuredName * self = NULL;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", family_name, "given-name", given_name, NULL);
	return self;
}


FolksStructuredName* folks_structured_name_new_simple (const gchar* family_name, const gchar* given_name) {
	return folks_structured_name_construct_simple (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name);
}


/**
   * Whether none of the components is set.
   *
   * @return `true` if all the components are the empty string, `false`
   * otherwise.
   *
   * @since 0.3.5
   */
gboolean folks_structured_name_is_empty (FolksStructuredName* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_strcmp0 (self->priv->_family_name, "") == 0) {
		_tmp3_ = g_strcmp0 (self->priv->_given_name, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = g_strcmp0 (self->priv->_additional_names, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (self->priv->_prefixes, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (self->priv->_suffixes, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Whether two StructuredNames are the same.
   *
   * @return `true` if all the components are the same, `false`
   * otherwise.
   *
   * @since 0.5.0
   */
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp4_ = folks_structured_name_get_family_name (other);
	if (g_strcmp0 (self->priv->_family_name, _tmp4_) == 0) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = folks_structured_name_get_given_name (other);
		_tmp3_ = g_strcmp0 (self->priv->_given_name, _tmp5_) == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = folks_structured_name_get_additional_names (other);
		_tmp2_ = g_strcmp0 (self->priv->_additional_names, _tmp6_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = folks_structured_name_get_prefixes (other);
		_tmp1_ = g_strcmp0 (self->priv->_prefixes, _tmp7_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = folks_structured_name_get_suffixes (other);
		_tmp0_ = g_strcmp0 (self->priv->_suffixes, _tmp8_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Formatted version of the structured name.
   *
   * @since 0.4.0
   */
gchar* folks_structured_name_to_string (FolksStructuredName* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("%s, %s, %s, %s, %s");
	str = _tmp0_;
	_tmp1_ = folks_structured_name_get_prefixes (self);
	_tmp2_ = folks_structured_name_get_given_name (self);
	_tmp3_ = folks_structured_name_get_family_name (self);
	_tmp4_ = folks_structured_name_get_additional_names (self);
	_tmp5_ = folks_structured_name_get_suffixes (self);
	_tmp6_ = g_strdup_printf (str, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	result = _tmp6_;
	_g_free0 (str);
	return result;
}


const gchar* folks_structured_name_get_family_name (FolksStructuredName* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_family_name;
	return result;
}


void folks_structured_name_set_family_name (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_family_name);
	self->priv->_family_name = _tmp1_;
	g_object_notify ((GObject *) self, "family-name");
}


const gchar* folks_structured_name_get_given_name (FolksStructuredName* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_given_name;
	return result;
}


void folks_structured_name_set_given_name (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_given_name);
	self->priv->_given_name = _tmp1_;
	g_object_notify ((GObject *) self, "given-name");
}


const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_additional_names;
	return result;
}


void folks_structured_name_set_additional_names (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_additional_names);
	self->priv->_additional_names = _tmp1_;
	g_object_notify ((GObject *) self, "additional-names");
}


const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_prefixes;
	return result;
}


void folks_structured_name_set_prefixes (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_prefixes);
	self->priv->_prefixes = _tmp1_;
	g_object_notify ((GObject *) self, "prefixes");
}


const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_suffixes;
	return result;
}


void folks_structured_name_set_suffixes (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_suffixes);
	self->priv->_suffixes = _tmp1_;
	g_object_notify ((GObject *) self, "suffixes");
}


static void folks_structured_name_class_init (FolksStructuredNameClass * klass) {
	folks_structured_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksStructuredNamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_structured_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_structured_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_structured_name_finalize;
	/**
	   * The family name.
	   *
	   * The family name (also known as surname or last name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_FAMILY_NAME, g_param_spec_string ("family-name", "family-name", "family-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The given name.
	   *
	   * The family name (also known as first name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_GIVEN_NAME, g_param_spec_string ("given-name", "given-name", "given-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * Additional names.
	   *
	   * The additional names of a contact, for instance the contact's
	   * middle name.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES, g_param_spec_string ("additional-names", "additional-names", "additional-names", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The prefixes of a name.
	   *
	   * The prefixes used in front of the name (for instance "Mr", "Mrs",
	   * "Doctor" or honorific titles).
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_PREFIXES, g_param_spec_string ("prefixes", "prefixes", "prefixes", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The suffixes of a name.
	   *
	   * The suffixes used after a name (for instance "PhD" or "Junior").
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_SUFFIXES, g_param_spec_string ("suffixes", "suffixes", "suffixes", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void folks_structured_name_instance_init (FolksStructuredName * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = FOLKS_STRUCTURED_NAME_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_family_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_given_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_additional_names = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_prefixes = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_suffixes = _tmp4_;
}


static void folks_structured_name_finalize (GObject* obj) {
	FolksStructuredName * self;
	self = FOLKS_STRUCTURED_NAME (obj);
	_g_free0 (self->priv->_family_name);
	_g_free0 (self->priv->_given_name);
	_g_free0 (self->priv->_additional_names);
	_g_free0 (self->priv->_prefixes);
	_g_free0 (self->priv->_suffixes);
	G_OBJECT_CLASS (folks_structured_name_parent_class)->finalize (obj);
}


/**
 * Object for a full name split in its constituent parts (given name,
 * family name, etc.). This structure corresponds to the "N" field in
 * VCards.  The parts of the name are never null, an empty string
 * indicates that a property is not set.
 *
 * @since 0.3.5
 */
GType folks_structured_name_get_type (void) {
	static volatile gsize folks_structured_name_type_id__volatile = 0;
	if (g_once_init_enter (&folks_structured_name_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksStructuredNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_structured_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksStructuredName), 0, (GInstanceInitFunc) folks_structured_name_instance_init, NULL };
		GType folks_structured_name_type_id;
		folks_structured_name_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksStructuredName", &g_define_type_info, 0);
		g_once_init_leave (&folks_structured_name_type_id__volatile, folks_structured_name_type_id);
	}
	return folks_structured_name_type_id__volatile;
}


static void _vala_folks_structured_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksStructuredName * self;
	self = FOLKS_STRUCTURED_NAME (object);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME:
		g_value_set_string (value, folks_structured_name_get_family_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME:
		g_value_set_string (value, folks_structured_name_get_given_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES:
		g_value_set_string (value, folks_structured_name_get_additional_names (self));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES:
		g_value_set_string (value, folks_structured_name_get_prefixes (self));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES:
		g_value_set_string (value, folks_structured_name_get_suffixes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_structured_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksStructuredName * self;
	self = FOLKS_STRUCTURED_NAME (object);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME:
		folks_structured_name_set_family_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME:
		folks_structured_name_set_given_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES:
		folks_structured_name_set_additional_names (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES:
		folks_structured_name_set_prefixes (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES:
		folks_structured_name_set_suffixes (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self) {
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_structured_name (self);
}


void folks_name_details_set_structured_name (FolksNameDetails* self, FolksStructuredName* value) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_structured_name (self, value);
}


const gchar* folks_name_details_get_full_name (FolksNameDetails* self) {
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_full_name (self);
}


void folks_name_details_set_full_name (FolksNameDetails* self, const gchar* value) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_full_name (self, value);
}


const gchar* folks_name_details_get_nickname (FolksNameDetails* self) {
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_nickname (self);
}


static void folks_name_details_base_init (FolksNameDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The contact name split in its constituent parts.
		   *
		   * Note that most of the time the structured name is not set (i.e.
		   * it's `null`) or just some of the components are set.
		   * The components are immutable. To get notification of changes of
		   * the structured name, you just have to connect to the `notify` signal
		   * of this property.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * The full name of the contact.
		   *
		   * The full name is the name of the contact written in the way the contact
		   * prefers. For instance for English names this is usually the given name
		   * followed by the family name, but Chinese names are usually the family
		   * name followed by the given name.
		   * The full name could or could not contain additional names (like a
		   * middle name), prefixes or suffixes.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * The nickname of the contact.
		   *
		   * The nickname is the name that the contact chose for himself. This is
		   * different from {@link AliasDetails.alias} as aliases can be chosen by
		   * the user and not by the contacts themselves.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


/**
 * Interface for classes which represent contacts with names, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
GType folks_name_details_get_type (void) {
	static volatile gsize folks_name_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_name_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksNameDetailsIface), (GBaseInitFunc) folks_name_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_name_details_type_id;
		folks_name_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksNameDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_name_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_name_details_type_id__volatile, folks_name_details_type_id);
	}
	return folks_name_details_type_id__volatile;
}



