/* note-details.c generated by valac 0.12.0, the Vala compiler
 * generated from note-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define FOLKS_TYPE_NOTE (folks_note_get_type ())
#define FOLKS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NOTE, FolksNote))
#define FOLKS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_NOTE, FolksNoteClass))
#define FOLKS_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NOTE))
#define FOLKS_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_NOTE))
#define FOLKS_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_NOTE, FolksNoteClass))

typedef struct _FolksNote FolksNote;
typedef struct _FolksNoteClass FolksNoteClass;
typedef struct _FolksNotePrivate FolksNotePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_NOTE_DETAILS (folks_note_details_get_type ())
#define FOLKS_NOTE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NOTE_DETAILS, FolksNoteDetails))
#define FOLKS_IS_NOTE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NOTE_DETAILS))
#define FOLKS_NOTE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NOTE_DETAILS, FolksNoteDetailsIface))

typedef struct _FolksNoteDetails FolksNoteDetails;
typedef struct _FolksNoteDetailsIface FolksNoteDetailsIface;

struct _FolksNote {
	GObject parent_instance;
	FolksNotePrivate * priv;
};

struct _FolksNoteClass {
	GObjectClass parent_class;
};

struct _FolksNotePrivate {
	gchar* _content;
	gchar* _uid;
};

struct _FolksNoteDetailsIface {
	GTypeInterface parent_iface;
	GeeHashSet* (*get_notes) (FolksNoteDetails* self);
	void (*set_notes) (FolksNoteDetails* self, GeeHashSet* value);
};


static gpointer folks_note_parent_class = NULL;

GType folks_note_get_type (void) G_GNUC_CONST;
#define FOLKS_NOTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_NOTE, FolksNotePrivate))
enum  {
	FOLKS_NOTE_DUMMY_PROPERTY,
	FOLKS_NOTE_CONTENT,
	FOLKS_NOTE_UID
};
FolksNote* folks_note_new (const gchar* content, const gchar* uid);
FolksNote* folks_note_construct (GType object_type, const gchar* content, const gchar* uid);
gboolean folks_note_equal (FolksNote* a, FolksNote* b);
const gchar* folks_note_get_content (FolksNote* self);
guint folks_note_hash (FolksNote* r);
const gchar* folks_note_get_uid (FolksNote* self);
void folks_note_set_content (FolksNote* self, const gchar* value);
void folks_note_set_uid (FolksNote* self, const gchar* value);
static void folks_note_finalize (GObject* obj);
static void _vala_folks_note_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_note_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_note_details_get_type (void) G_GNUC_CONST;
GeeHashSet* folks_note_details_get_notes (FolksNoteDetails* self);
void folks_note_details_set_notes (FolksNoteDetails* self, GeeHashSet* value);


/**
   * Default constructor.
   *
   * @param content the note's content
   * @param uid the note's UID (may be null)
   * @return a new Note
   *
   * @since 0.4.0
   */
FolksNote* folks_note_construct (GType object_type, const gchar* content, const gchar* uid) {
	FolksNote * self = NULL;
	g_return_val_if_fail (content != NULL, NULL);
	if (uid == NULL) {
		uid = "";
	}
	self = (FolksNote*) g_object_new (object_type, "uid", uid, "content", content, NULL);
	return self;
}


FolksNote* folks_note_new (const gchar* content, const gchar* uid) {
	return folks_note_construct (FOLKS_TYPE_NOTE, content, uid);
}


/**
   * Compare if 2 notes are equal
   */
gboolean folks_note_equal (FolksNote* a, FolksNote* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = g_strcmp0 (a->priv->_content, b->priv->_content) == 0;
	return result;
}


/**
   * Hash function for the class.
   */
guint folks_note_hash (FolksNote* r) {
	guint result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (r != NULL, 0U);
	_tmp0_ = g_str_hash (r->priv->_uid);
	_tmp1_ = g_str_hash (r->priv->_content);
	result = _tmp0_ + _tmp1_;
	return result;
}


const gchar* folks_note_get_content (FolksNote* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_content;
	return result;
}


void folks_note_set_content (FolksNote* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp0_;
	g_object_notify ((GObject *) self, "content");
}


const gchar* folks_note_get_uid (FolksNote* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uid;
	return result;
}


void folks_note_set_uid (FolksNote* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp0_;
	g_object_notify ((GObject *) self, "uid");
}


static void folks_note_class_init (FolksNoteClass * klass) {
	folks_note_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksNotePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_note_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_note_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_note_finalize;
	/**
	   * The note's content.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_NOTE_CONTENT, g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The UID of the note (if any).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_NOTE_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_note_instance_init (FolksNote * self) {
	self->priv = FOLKS_NOTE_GET_PRIVATE (self);
}


static void folks_note_finalize (GObject* obj) {
	FolksNote * self;
	self = FOLKS_NOTE (obj);
	_g_free0 (self->priv->_content);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_note_parent_class)->finalize (obj);
}


/**
 * Representation of a Note that might be attached to a {@link Persona}.
 *
 * @since 0.4.0
 */
GType folks_note_get_type (void) {
	static volatile gsize folks_note_type_id__volatile = 0;
	if (g_once_init_enter (&folks_note_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksNoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_note_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksNote), 0, (GInstanceInitFunc) folks_note_instance_init, NULL };
		GType folks_note_type_id;
		folks_note_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksNote", &g_define_type_info, 0);
		g_once_init_leave (&folks_note_type_id__volatile, folks_note_type_id);
	}
	return folks_note_type_id__volatile;
}


static void _vala_folks_note_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksNote * self;
	self = FOLKS_NOTE (object);
	switch (property_id) {
		case FOLKS_NOTE_CONTENT:
		g_value_set_string (value, folks_note_get_content (self));
		break;
		case FOLKS_NOTE_UID:
		g_value_set_string (value, folks_note_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_note_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksNote * self;
	self = FOLKS_NOTE (object);
	switch (property_id) {
		case FOLKS_NOTE_CONTENT:
		folks_note_set_content (self, g_value_get_string (value));
		break;
		case FOLKS_NOTE_UID:
		folks_note_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GeeHashSet* folks_note_details_get_notes (FolksNoteDetails* self) {
	return FOLKS_NOTE_DETAILS_GET_INTERFACE (self)->get_notes (self);
}


void folks_note_details_set_notes (FolksNoteDetails* self, GeeHashSet* value) {
	FOLKS_NOTE_DETAILS_GET_INTERFACE (self)->set_notes (self, value);
}


static void folks_note_details_base_init (FolksNoteDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The notes about the contact.
		   *
		   * @since 0.4.0
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("notes", "notes", "notes", GEE_TYPE_HASH_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * This interface represents the list of notes associated
 * to a {@link Persona} and {@link Individual}.
 *
 * @since 0.4.0
 */
GType folks_note_details_get_type (void) {
	static volatile gsize folks_note_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_note_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksNoteDetailsIface), (GBaseInitFunc) folks_note_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_note_details_type_id;
		folks_note_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksNoteDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_note_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_note_details_type_id__volatile, folks_note_details_type_id);
	}
	return folks_note_details_type_id__volatile;
}



