/* backend.c generated by valac 0.12.0, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors :Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdio.h>
#include <gio/gio.h>
#include <folks-tracker.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TEST_TYPE_BACKEND (tracker_test_backend_get_type ())
#define TRACKER_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend))
#define TRACKER_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))
#define TRACKER_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))

typedef struct _TrackerTestBackend TrackerTestBackend;
typedef struct _TrackerTestBackendClass TrackerTestBackendClass;
typedef struct _TrackerTestBackendPrivate TrackerTestBackendPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerTestParamSpecBackend TrackerTestParamSpecBackend;

typedef enum  {
	TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED
} TrackerTestBackendSetupError;
#define TRACKER_TEST_BACKEND_SETUP_ERROR tracker_test_backend_setup_error_quark ()
struct _TrackerTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerTestBackendPrivate * priv;
};

struct _TrackerTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerTestBackend *self);
};

struct _TrackerTestBackendPrivate {
	gboolean _debug;
	GList* _contacts;
	TrackerSparqlConnection* _connection;
};

struct _TrackerTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer tracker_test_backend_parent_class = NULL;

GQuark tracker_test_backend_setup_error_quark (void);
gpointer tracker_test_backend_ref (gpointer instance);
void tracker_test_backend_unref (gpointer instance);
GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_test_value_set_backend (GValue* value, gpointer v_object);
void tracker_test_value_take_backend (GValue* value, gpointer v_object);
gpointer tracker_test_value_get_backend (const GValue* value);
GType tracker_test_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendPrivate))
enum  {
	TRACKER_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define TRACKER_TEST_BACKEND_URN "urn:contact"
#define TRACKER_TEST_BACKEND_URLS "nco:urls"
TrackerTestBackend* tracker_test_backend_new (void);
TrackerTestBackend* tracker_test_backend_construct (GType object_type);
void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value);
void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c);
static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig);
void tracker_test_backend_tear_down (TrackerTestBackend* self);
void tracker_test_backend_reset (TrackerTestBackend* self);
void tracker_test_backend_set_up (TrackerTestBackend* self);
static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error);
static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error);
gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject);
static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query);
gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite);
gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id);
gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn);
gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c);
gboolean tracker_test_backend_get_debug (TrackerTestBackend* self);
static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact);
static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s);
static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1);
static void tracker_test_backend_finalize (TrackerTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark tracker_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("tracker_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


TrackerTestBackend* tracker_test_backend_construct (GType object_type) {
	TrackerTestBackend* self = NULL;
	self = (TrackerTestBackend*) g_type_create_instance (object_type);
	tracker_test_backend_set_debug (self, FALSE);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	self->priv->_contacts = NULL;
	return self;
}


TrackerTestBackend* tracker_test_backend_new (void) {
	return tracker_test_backend_construct (TRACKER_TEST_TYPE_BACKEND);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* contact;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = _tracker_test_backend_copy_hash_map (self, c);
	contact = _tmp0_;
	_tmp1_ = _g_object_ref0 (contact);
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
	_g_object_unref0 (contact);
}


void tracker_test_backend_tear_down (TrackerTestBackend* self) {
	g_return_if_fail (self != NULL);
}


void tracker_test_backend_reset (TrackerTestBackend* self) {
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	self->priv->_contacts = NULL;
}


void tracker_test_backend_set_up (TrackerTestBackend* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tracker_test_backend_setup_connection (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
			goto __catch0_tracker_test_backend_setup_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tracker_test_backend_add_contacts (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
			goto __catch0_tracker_test_backend_setup_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally0;
	__catch0_tracker_test_backend_setup_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("backend.vala:71: unable to create test data: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject) {
	gboolean result = FALSE;
	static const char delete_query_t[] = "DELETE { %s %s ?a } WHERE " "{ ?p a nco:PersonContact " " ; %s ?a . FILTER(?p = %s ) } ";
	static const char update_query_t[] = "INSERT { %s %s '%s' } ";
	gchar* _tmp0_ = NULL;
	gchar* delete_query;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* update_query;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contact_urn != NULL, FALSE);
	g_return_val_if_fail (predicate != NULL, FALSE);
	g_return_val_if_fail (literal_subject != NULL, FALSE);
	_tmp0_ = g_strdup_printf (delete_query_t, contact_urn, predicate, predicate, contact_urn);
	delete_query = _tmp0_;
	_tmp1_ = _tracker_test_backend_do_update_query (self, delete_query);
	if (_tmp1_ == FALSE) {
		g_warning ("backend.vala:87: Couldn't delete the old triplet");
		result = FALSE;
		_g_free0 (delete_query);
		return result;
	}
	_tmp2_ = g_strdup_printf (update_query_t, contact_urn, predicate, literal_subject);
	update_query = _tmp2_;
	_tmp3_ = _tracker_test_backend_do_update_query (self, update_query);
	if (_tmp3_ == FALSE) {
		g_warning ("backend.vala:95: Couldn't insert the triplet");
		result = FALSE;
		_g_free0 (update_query);
		_g_free0 (delete_query);
		return result;
	}
	result = TRUE;
	_g_free0 (update_query);
	_g_free0 (delete_query);
	return result;
}


gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* q;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contact_urn != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	q = _tmp0_;
	if (is_favourite) {
		gchar* _tmp1_;
		_tmp1_ = g_strconcat (q, "INSERT { ", NULL);
		_g_free0 (q);
		q = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strconcat (q, "DELETE { ", NULL);
		_g_free0 (q);
		q = _tmp2_;
	}
	_tmp3_ = g_strconcat (contact_urn, " nao:hasTag nao:predefined-tag-favorite } ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (q, _tmp4_, NULL);
	_g_free0 (q);
	q = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = _tracker_test_backend_do_update_query (self, q);
	if (_tmp6_ == FALSE) {
		g_warning ("backend.vala:118: Couldn't change favourite status");
		result = FALSE;
		_g_free0 (q);
		return result;
	}
	result = TRUE;
	_g_free0 (q);
	return result;
}


gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* delete_query;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = g_strdup ("DELETE { ?p a nco:PersonContact } ");
	delete_query = _tmp0_;
	_tmp1_ = g_strconcat (delete_query, "WHERE { ?p a nco:PersonContact . FILTER(tracker:id(?p) ", NULL);
	_g_free0 (delete_query);
	delete_query = _tmp1_;
	_tmp2_ = g_strconcat ("= ", tracker_id, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ") } ", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (delete_query, _tmp5_, NULL);
	_g_free0 (delete_query);
	delete_query = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp7_ = _tracker_test_backend_do_update_query (self, delete_query);
	if (_tmp7_ == FALSE) {
		g_warning ("backend.vala:133: Couldn't delete the contact");
		result = FALSE;
		_g_free0 (delete_query);
		return result;
	}
	result = TRUE;
	_g_free0 (delete_query);
	return result;
}


gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* _tmp0_ = NULL;
	TrackerSparqlBuilder* builder;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subject_urn != NULL, FALSE);
	g_return_val_if_fail (pred != NULL, FALSE);
	g_return_val_if_fail (object_urn != NULL, FALSE);
	_tmp0_ = tracker_sparql_builder_new_update ();
	builder = _tmp0_;
	tracker_sparql_builder_delete_open (builder, NULL);
	tracker_sparql_builder_subject (builder, subject_urn);
	tracker_sparql_builder_predicate (builder, pred);
	tracker_sparql_builder_object (builder, object_urn);
	tracker_sparql_builder_delete_close (builder);
	_tmp1_ = tracker_sparql_builder_get_result (builder);
	_tmp2_ = _tracker_test_backend_do_update_query (self, _tmp1_);
	if (_tmp2_ == FALSE) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = tracker_sparql_builder_get_result (builder);
		g_warning ("backend.vala:152: Couldn't delete triplet with query: %s\n", _tmp3_);
		result = FALSE;
		_g_object_unref0 (builder);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (builder);
	return result;
}


gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* _tmp0_ = NULL;
	TrackerSparqlBuilder* builder;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subject_iri != NULL, FALSE);
	g_return_val_if_fail (pred != NULL, FALSE);
	g_return_val_if_fail (object_iri != NULL, FALSE);
	_tmp0_ = tracker_sparql_builder_new_update ();
	builder = _tmp0_;
	tracker_sparql_builder_insert_open (builder, NULL);
	tracker_sparql_builder_subject (builder, subject_iri);
	tracker_sparql_builder_predicate (builder, pred);
	tracker_sparql_builder_object (builder, object_iri);
	if (pred_b != NULL) {
		tracker_sparql_builder_predicate (builder, pred_b);
		tracker_sparql_builder_object_string (builder, obj_literal_b);
	}
	if (pred_c != NULL) {
		tracker_sparql_builder_predicate (builder, pred_c);
		tracker_sparql_builder_object_string (builder, obj_literal_c);
	}
	tracker_sparql_builder_insert_close (builder);
	_tmp1_ = tracker_sparql_builder_get_result (builder);
	_tmp2_ = _tracker_test_backend_do_update_query (self, _tmp1_);
	if (_tmp2_ == FALSE) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = tracker_sparql_builder_get_result (builder);
		g_warning ("backend.vala:187: Couldn't insert triplet with query: %s\n", _tmp3_);
		result = FALSE;
		_g_object_unref0 (builder);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (builder);
	return result;
}


static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query) {
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (query != NULL, FALSE);
	ret = FALSE;
	if (self->priv->_debug) {
		fprintf (stdout, "_do_update_query : %s\n", query);
	}
	tracker_sparql_connection_update (self->priv->_connection, query, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch1_g_io_error;
		}
		if (_inner_error_->domain == G_DBUS_ERROR) {
			goto __catch1_g_dbus_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = TRUE;
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError * e1;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("backend.vala:211: Problem getting connection : %s\n", e1->message);
		_g_error_free0 (e1);
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError * e2;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("backend.vala:215: Problem saving data : %s\n", e2->message);
		_g_error_free0 (e2);
	}
	goto __finally1;
	__catch1_g_dbus_error:
	{
		GError * e3;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("backend.vala:219: Problem with the D-Bus connection : %s\n", e3->message);
		_g_error_free0 (e3);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = ret;
	return result;
}


static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* copy;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	copy = _tmp0_;
	{
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _k_it;
		_tmp1_ = gee_map_get_keys ((GeeMap*) orig);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_k_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			gchar* k;
			gpointer _tmp7_ = NULL;
			gchar* v;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp5_ = gee_iterator_next (_k_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_k_it);
			k = (gchar*) _tmp6_;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) orig, k);
			v = (gchar*) _tmp7_;
			_tmp8_ = g_strdup (k);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup (v);
			_tmp11_ = _tmp10_;
			gee_abstract_map_set ((GeeAbstractMap*) copy, _tmp9_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_g_free0 (v);
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	result = copy;
	return result;
}


static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error) {
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch2_g_io_error;
		}
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch2_tracker_sparql_error;
		}
		if (_inner_error_->domain == G_DBUS_ERROR) {
			goto __catch2_g_dbus_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	goto __finally2;
	__catch2_g_io_error:
	{
		GError * e1;
		GError* _tmp2_ = NULL;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", e1->message);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e1);
		goto __finally2;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError * e2;
		GError* _tmp3_ = NULL;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", e2->message);
		_inner_error_ = _tmp3_;
		_g_error_free0 (e2);
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_dbus_error:
	{
		GError * e3;
		GError* _tmp4_ = NULL;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", e3->message);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e3);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error) {
	gchar* _tmp0_;
	gchar* query;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	query = _tmp0_;
	self->priv->_contacts = g_list_reverse (self->priv->_contacts);
	{
		GList* c_collection;
		GList* c_it;
		c_collection = self->priv->_contacts;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			GeeHashMap* _tmp1_;
			GeeHashMap* c;
			_tmp1_ = _g_object_ref0 ((GeeHashMap*) c_it->data);
			c = _tmp1_;
			{
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp2_ = g_strconcat (query, "\n", NULL);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tracker_test_backend_get_insert_query (self, c);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
				_g_free0 (query);
				query = _tmp6_;
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	tracker_sparql_connection_update (self->priv->_connection, query, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch3_tracker_sparql_error;
		}
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch3_g_io_error;
		}
		if (_inner_error_->domain == G_DBUS_ERROR) {
			goto __catch3_g_dbus_error;
		}
		_g_free0 (query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError * e1;
		GError* _tmp7_ = NULL;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Problem getting connection : %s\n", e1->message);
		_inner_error_ = _tmp7_;
		_g_error_free0 (e1);
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError * e2;
		GError* _tmp8_ = NULL;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", e2->message);
		_inner_error_ = _tmp8_;
		_g_error_free0 (e2);
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		GError * e3;
		GError* _tmp9_ = NULL;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", e3->message);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e3);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (query);
			return;
		} else {
			_g_free0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (query);
}


static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact) {
	gchar* result = NULL;
	static const char q_photo_uri_t[] = " . <%s> a nfo:Image, " "nie:DataObject ; nie:url '%s' ; nie:title '%s' ";
	static const char im_addr_t[] = " . <%s> a nco:IMAddress, " "nie:InformationElement; nco:imProtocol " "'%s' ; nco:imID '%s';   " "nco:imNickname '%s'; " "nco:imPresence nco:presence-status-available " " . <%smyimaccount> a nco:IMAccount; " "nco:imDisplayName '%s'; nco:hasIMContact " "<%s>  ";
	static const char affl_t[] = " . <%smyaffiliation> a nco:Affiliation " " . <%smyaffiliation> nco:hasIMAddress " " <%s>  ";
	static const char af_t[] = " . <affl:001> a nco:Affiliation; " "nco:role '%s'; nco:department '%s' ";
	static const char postal_t[] = " . <affl:001> a nco:Affiliation ; " "nco:hasPostalAddress <postal:001> . " " <postal:001> a nco:PostalAddress ; " "nco:pobox '%s'; " "nco:district '%s'; " "nco:county '%s'; " "nco:locality '%s'; " "nco:postalcode '%s'; " "nco:streetAddress '%s'; " "nco:addressLocation '%s'; " "nco:extendedAddress '%s'; " "nco:country '%s'; " "nco:region '%s' ";
	gchar* urn_contact = NULL;
	gpointer _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* _tmp3_;
	gchar* photo_uri;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* q;
	GeeHashMap* addresses;
	gchar** phones;
	gint phones_length1;
	gint _phones_size_;
	gchar** emails;
	gint emails_length1;
	gint _emails_size_;
	gchar** urls;
	gint urls_length1;
	gint _urls_size_;
	gchar* _tmp8_;
	gchar* affiliation;
	gchar* _tmp9_;
	gchar* postal_address;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp90_ = FALSE;
	gchar* _tmp107_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp1_ = gee_abstract_map_unset ((GeeAbstractMap*) contact, TRACKER_TEST_BACKEND_URN, &_tmp0_);
	_g_free0 (urn_contact);
	urn_contact = _tmp0_;
	if (_tmp1_ == FALSE) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("_:x");
		_g_free0 (urn_contact);
		urn_contact = _tmp2_;
	}
	_tmp3_ = g_strdup ("");
	photo_uri = _tmp3_;
	_tmp4_ = g_strconcat ("INSERT { ", urn_contact, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, " a nco:PersonContact  ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	q = _tmp7_;
	addresses = NULL;
	phones = NULL;
	phones_length1 = 0;
	_phones_size_ = 0;
	emails = NULL;
	emails_length1 = 0;
	_emails_size_ = 0;
	urls = NULL;
	urls_length1 = 0;
	_urls_size_ = 0;
	_tmp8_ = g_strdup ("");
	affiliation = _tmp8_;
	_tmp9_ = g_strdup ("");
	postal_address = _tmp9_;
	{
		GeeSet* _tmp10_ = NULL;
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_;
		GeeIterator* _k_it;
		_tmp10_ = gee_map_get_keys ((GeeMap*) contact);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_k_it = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_;
			gpointer _tmp15_ = NULL;
			gchar* k;
			gpointer _tmp16_ = NULL;
			gchar* v;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* s;
			gchar* _tmp64_;
			_tmp14_ = gee_iterator_next (_k_it);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = gee_iterator_get (_k_it);
			k = (gchar*) _tmp15_;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) contact, k);
			v = (gchar*) _tmp16_;
			if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_PHOTO) == 0) {
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = g_strdup (v);
				_g_free0 (photo_uri);
				photo_uri = _tmp17_;
				_tmp18_ = g_strconcat ("<", v, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp19_, ">", NULL);
				_g_free0 (v);
				v = _tmp20_;
				_g_free0 (_tmp19_);
			} else {
				if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_IMADDRESS) == 0) {
					GeeHashMap* _tmp21_ = NULL;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = _tracker_test_backend_parse_addrs (self, v);
					_g_object_unref0 (addresses);
					addresses = _tmp21_;
					_tmp22_ = g_strdup ("");
					_g_free0 (k);
					k = _tmp22_;
					_tmp23_ = g_strdup ("");
					_g_free0 (v);
					v = _tmp23_;
					{
						GeeSet* _tmp24_ = NULL;
						GeeSet* _tmp25_;
						GeeIterator* _tmp26_ = NULL;
						GeeIterator* _tmp27_;
						GeeIterator* _addr_it;
						_tmp24_ = gee_map_get_keys ((GeeMap*) addresses);
						_tmp25_ = _tmp24_;
						_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
						_tmp27_ = _tmp26_;
						_g_object_unref0 (_tmp25_);
						_addr_it = _tmp27_;
						while (TRUE) {
							gboolean _tmp28_;
							gpointer _tmp29_ = NULL;
							gchar* addr;
							gchar* vtemp = NULL;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp37_;
							_tmp28_ = gee_iterator_next (_addr_it);
							if (!_tmp28_) {
								break;
							}
							_tmp29_ = gee_iterator_get (_addr_it);
							addr = (gchar*) _tmp29_;
							_tmp30_ = g_strdup (" nco:hasAffiliation [ a nco:Affiliation ; ");
							_g_free0 (vtemp);
							vtemp = _tmp30_;
							_tmp31_ = g_strconcat ("nco:hasIMAddress <", addr, NULL);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_strconcat (_tmp32_, "> ] ", NULL);
							_tmp34_ = _tmp33_;
							_tmp35_ = g_strconcat (vtemp, _tmp34_, NULL);
							_g_free0 (vtemp);
							vtemp = _tmp35_;
							_g_free0 (_tmp34_);
							_g_free0 (_tmp32_);
							if (g_strcmp0 (v, "") != 0) {
								gchar* _tmp36_;
								_tmp36_ = g_strconcat (v, "; ", NULL);
								_g_free0 (v);
								v = _tmp36_;
							}
							_tmp37_ = g_strconcat (v, vtemp, NULL);
							_g_free0 (v);
							v = _tmp37_;
							_g_free0 (vtemp);
							_g_free0 (addr);
						}
						_g_object_unref0 (_addr_it);
					}
				} else {
					if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP) == 0) {
						gchar** _tmp38_;
						gchar** _tmp39_ = NULL;
						gchar* _tmp40_;
						gchar* _tmp41_ = NULL;
						_tmp39_ = _tmp38_ = g_strsplit (v, ",", 0);
						phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
						phones = _tmp39_;
						phones_length1 = _vala_array_length (_tmp38_);
						_phones_size_ = _vala_array_length (_tmp38_);
						_tmp40_ = g_strdup ("");
						_g_free0 (k);
						k = _tmp40_;
						_tmp41_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, phones, phones_length1);
						_g_free0 (v);
						v = _tmp41_;
					} else {
						if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP) == 0) {
							gchar** _tmp42_;
							gchar** _tmp43_ = NULL;
							gchar* _tmp44_;
							gchar* _tmp45_ = NULL;
							_tmp43_ = _tmp42_ = g_strsplit (v, ",", 0);
							emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
							emails = _tmp43_;
							emails_length1 = _vala_array_length (_tmp42_);
							_emails_size_ = _vala_array_length (_tmp42_);
							_tmp44_ = g_strdup ("");
							_g_free0 (k);
							k = _tmp44_;
							_tmp45_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, emails, emails_length1);
							_g_free0 (v);
							v = _tmp45_;
						} else {
							if (g_strcmp0 (k, TRACKER_TEST_BACKEND_URLS) == 0) {
								gchar** _tmp46_;
								gchar** _tmp47_ = NULL;
								gchar* _tmp48_;
								gchar* _tmp49_ = NULL;
								_tmp47_ = _tmp46_ = g_strsplit (v, ",", 0);
								urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
								urls = _tmp47_;
								urls_length1 = _vala_array_length (_tmp46_);
								_urls_size_ = _vala_array_length (_tmp46_);
								_tmp48_ = g_strdup ("");
								_g_free0 (k);
								k = _tmp48_;
								_tmp49_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, urls, urls_length1);
								_g_free0 (v);
								v = _tmp49_;
							} else {
								if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NAO_TAG) == 0) {
									gchar* _tmp50_;
									_tmp50_ = g_strdup (TRF_ONTOLOGY_DEFS_NAO_FAVORITE);
									_g_free0 (v);
									v = _tmp50_;
								} else {
									if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION) == 0) {
										gchar* _tmp51_;
										gchar* _tmp52_;
										_tmp51_ = g_strdup (v);
										_g_free0 (affiliation);
										affiliation = _tmp51_;
										_tmp52_ = g_strdup ("<affl:001>");
										_g_free0 (v);
										v = _tmp52_;
									} else {
										if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_GENDER) == 0) {
										} else {
											if (g_strcmp0 (k, TRF_ONTOLOGY_DEFS_NCO_POSTAL_ADDRESS) == 0) {
												gchar* _tmp53_;
												gchar* _tmp54_;
												gchar* _tmp55_;
												_tmp53_ = g_strdup (v);
												_g_free0 (postal_address);
												postal_address = _tmp53_;
												_tmp54_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION);
												_g_free0 (k);
												k = _tmp54_;
												_tmp55_ = g_strdup ("<affl:001>");
												_g_free0 (v);
												v = _tmp55_;
											} else {
												gchar* _tmp56_;
												gchar* _tmp57_;
												gchar* _tmp58_;
												_tmp56_ = g_strconcat ("'", v, NULL);
												_tmp57_ = _tmp56_;
												_tmp58_ = g_strconcat (_tmp57_, "'", NULL);
												_g_free0 (v);
												v = _tmp58_;
												_g_free0 (_tmp57_);
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp59_ = g_strconcat (q, "; ", NULL);
			_g_free0 (q);
			q = _tmp59_;
			_tmp60_ = g_strconcat (k, " ", NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = g_strconcat (_tmp61_, v, NULL);
			_tmp63_ = _tmp62_;
			_g_free0 (_tmp61_);
			s = _tmp63_;
			_tmp64_ = g_strconcat (q, s, NULL);
			_g_free0 (q);
			q = _tmp64_;
			_g_free0 (s);
			_g_free0 (v);
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	if (g_strcmp0 (photo_uri, "") != 0) {
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_;
		gchar* _tmp67_;
		_tmp65_ = g_strdup_printf (q_photo_uri_t, photo_uri, photo_uri, photo_uri);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (q, _tmp66_, NULL);
		_g_free0 (q);
		q = _tmp67_;
		_g_free0 (_tmp66_);
	}
	if (addresses != NULL) {
		gint _tmp69_;
		_tmp69_ = gee_map_get_size ((GeeMap*) addresses);
		_tmp68_ = _tmp69_ > 0;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		{
			GeeSet* _tmp70_ = NULL;
			GeeSet* _tmp71_;
			GeeIterator* _tmp72_ = NULL;
			GeeIterator* _tmp73_;
			GeeIterator* _addr_it;
			_tmp70_ = gee_map_get_keys ((GeeMap*) addresses);
			_tmp71_ = _tmp70_;
			_tmp72_ = gee_iterable_iterator ((GeeIterable*) _tmp71_);
			_tmp73_ = _tmp72_;
			_g_object_unref0 (_tmp71_);
			_addr_it = _tmp73_;
			while (TRUE) {
				gboolean _tmp74_;
				gpointer _tmp75_ = NULL;
				gchar* addr;
				gpointer _tmp76_ = NULL;
				gchar* proto;
				gchar* _tmp77_ = NULL;
				gchar* q1;
				gchar* _tmp78_ = NULL;
				gchar* q2;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp74_ = gee_iterator_next (_addr_it);
				if (!_tmp74_) {
					break;
				}
				_tmp75_ = gee_iterator_get (_addr_it);
				addr = (gchar*) _tmp75_;
				_tmp76_ = gee_abstract_map_get ((GeeAbstractMap*) addresses, addr);
				proto = (gchar*) _tmp76_;
				_tmp77_ = g_strdup_printf (im_addr_t, addr, proto, addr, addr, addr, addr, addr);
				q1 = _tmp77_;
				_tmp78_ = g_strdup_printf (affl_t, addr, addr, addr);
				q2 = _tmp78_;
				_tmp79_ = g_strdup_printf ("%s%s", q1, q2);
				_tmp80_ = _tmp79_;
				_tmp81_ = g_strconcat (q, _tmp80_, NULL);
				_g_free0 (q);
				q = _tmp81_;
				_g_free0 (_tmp80_);
				_g_free0 (q2);
				_g_free0 (q1);
				_g_free0 (proto);
				_g_free0 (addr);
			}
			_g_object_unref0 (_addr_it);
		}
	}
	if (phones != NULL) {
		_tmp82_ = phones_length1 > 0;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		{
			gchar** p_collection;
			int p_collection_length1;
			int p_it;
			p_collection = phones;
			p_collection_length1 = phones_length1;
			for (p_it = 0; p_it < phones_length1; p_it = p_it + 1) {
				gchar* _tmp83_;
				gchar* p;
				_tmp83_ = g_strdup (p_collection[p_it]);
				p = _tmp83_;
				{
					gchar* _tmp84_ = NULL;
					gchar* phone_urn;
					gchar* _tmp85_ = NULL;
					gchar* affl;
					_tmp84_ = g_strdup_printf ("<phone:%s>", p);
					phone_urn = _tmp84_;
					_tmp85_ = g_strdup_printf ("<%s>", p);
					affl = _tmp85_;
					tracker_test_backend_insert_triplet (self, phone_urn, "a", TRF_ONTOLOGY_DEFS_NCO_PHONE, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP, p, NULL, NULL);
					tracker_test_backend_insert_triplet (self, affl, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
					tracker_test_backend_insert_triplet (self, affl, TRF_ONTOLOGY_DEFS_NCO_HAS_PHONE, phone_urn, NULL, NULL, NULL, NULL);
					_g_free0 (affl);
					_g_free0 (phone_urn);
					_g_free0 (p);
				}
			}
		}
	}
	if (emails != NULL) {
		_tmp86_ = emails_length1 > 0;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		{
			gchar** p_collection;
			int p_collection_length1;
			int p_it;
			p_collection = emails;
			p_collection_length1 = emails_length1;
			for (p_it = 0; p_it < emails_length1; p_it = p_it + 1) {
				gchar* _tmp87_;
				gchar* p;
				_tmp87_ = g_strdup (p_collection[p_it]);
				p = _tmp87_;
				{
					gchar* _tmp88_ = NULL;
					gchar* email_urn;
					gchar* _tmp89_ = NULL;
					gchar* affl;
					_tmp88_ = g_strdup_printf ("<email:%s>", p);
					email_urn = _tmp88_;
					_tmp89_ = g_strdup_printf ("<%s>", p);
					affl = _tmp89_;
					tracker_test_backend_insert_triplet (self, email_urn, "a", TRF_ONTOLOGY_DEFS_NCO_EMAIL, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP, p, NULL, NULL);
					tracker_test_backend_insert_triplet (self, affl, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
					tracker_test_backend_insert_triplet (self, affl, TRF_ONTOLOGY_DEFS_NCO_HAS_EMAIL, email_urn, NULL, NULL, NULL, NULL);
					_g_free0 (affl);
					_g_free0 (email_urn);
					_g_free0 (p);
				}
			}
		}
	}
	if (urls != NULL) {
		_tmp90_ = urls_length1 > 0;
	} else {
		_tmp90_ = FALSE;
	}
	if (_tmp90_) {
		gint i;
		i = 0;
		{
			gchar** p_collection;
			int p_collection_length1;
			int p_it;
			p_collection = urls;
			p_collection_length1 = urls_length1;
			for (p_it = 0; p_it < urls_length1; p_it = p_it + 1) {
				gchar* _tmp91_;
				gchar* p;
				_tmp91_ = g_strdup (p_collection[p_it]);
				p = _tmp91_;
				{
					gchar* _tmp92_;
					gchar* website_type;
					gchar* _tmp93_ = NULL;
					gchar* affl;
					_tmp92_ = g_strdup ("");
					website_type = _tmp92_;
					_tmp93_ = g_strdup_printf ("<%s>", p);
					affl = _tmp93_;
					switch (i % 3) {
						case 0:
						{
							gchar* _tmp94_;
							_tmp94_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_WEBSITE);
							_g_free0 (website_type);
							website_type = _tmp94_;
							break;
						}
						case 1:
						{
							gchar* _tmp95_;
							_tmp95_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_BLOG);
							_g_free0 (website_type);
							website_type = _tmp95_;
							break;
						}
						case 2:
						{
							gchar* _tmp96_;
							_tmp96_ = g_strdup ("nco:url");
							_g_free0 (website_type);
							website_type = _tmp96_;
							break;
						}
						default:
						break;
					}
					tracker_test_backend_insert_triplet (self, affl, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, website_type, p, NULL, NULL);
					i++;
					_g_free0 (affl);
					_g_free0 (website_type);
					_g_free0 (p);
				}
			}
		}
	}
	if (g_strcmp0 (affiliation, "") != 0) {
		gchar** _tmp97_;
		gchar** _tmp98_ = NULL;
		gchar** role_info;
		gint role_info_length1;
		gint _role_info_size_;
		gchar* _tmp99_ = NULL;
		gchar* _tmp100_;
		gchar* _tmp101_;
		_tmp98_ = _tmp97_ = g_strsplit (affiliation, ",", 0);
		role_info = _tmp98_;
		role_info_length1 = _vala_array_length (_tmp97_);
		_role_info_size_ = _vala_array_length (_tmp97_);
		_tmp99_ = g_strdup_printf (af_t, role_info[0], role_info[1]);
		_tmp100_ = _tmp99_;
		_tmp101_ = g_strconcat (q, _tmp100_, NULL);
		_g_free0 (q);
		q = _tmp101_;
		_g_free0 (_tmp100_);
		role_info = (_vala_array_free (role_info, role_info_length1, (GDestroyNotify) g_free), NULL);
	}
	if (g_strcmp0 (postal_address, "") != 0) {
		gchar** _tmp102_;
		gchar** _tmp103_ = NULL;
		gchar** postal_info;
		gint postal_info_length1;
		gint _postal_info_size_;
		gchar* _tmp104_ = NULL;
		gchar* _tmp105_;
		gchar* _tmp106_;
		_tmp103_ = _tmp102_ = g_strsplit (postal_address, ":", 0);
		postal_info = _tmp103_;
		postal_info_length1 = _vala_array_length (_tmp102_);
		_postal_info_size_ = _vala_array_length (_tmp102_);
		_tmp104_ = g_strdup_printf (postal_t, postal_info[0], postal_info[1], postal_info[2], postal_info[3], postal_info[4], postal_info[5], postal_info[6], postal_info[7], postal_info[8], postal_info[9]);
		_tmp105_ = _tmp104_;
		_tmp106_ = g_strconcat (q, _tmp105_, NULL);
		_g_free0 (q);
		q = _tmp106_;
		_g_free0 (_tmp105_);
		postal_info = (_vala_array_free (postal_info, postal_info_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp107_ = g_strconcat (q, " . }", NULL);
	_g_free0 (q);
	q = _tmp107_;
	if (self->priv->_debug) {
		fprintf (stdout, "_get_insert_query : %s\n", q);
	}
	result = q;
	_g_free0 (postal_address);
	_g_free0 (affiliation);
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
	phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (addresses);
	_g_free0 (photo_uri);
	_g_free0 (urn_contact);
	return result;
}


static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* ret;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (addr_s != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (addr_s, ",", 0);
	im_addrs = _tmp2_;
	im_addrs_length1 = _vala_array_length (_tmp1_);
	_im_addrs_size_ = _vala_array_length (_tmp1_);
	{
		gchar** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = im_addrs;
		a_collection_length1 = im_addrs_length1;
		for (a_it = 0; a_it < im_addrs_length1; a_it = a_it + 1) {
			gchar* _tmp3_;
			gchar* a;
			_tmp3_ = g_strdup (a_collection[a_it]);
			a = _tmp3_;
			{
				gchar** _tmp4_;
				gchar** _tmp5_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar* _tmp6_;
				gchar* proto;
				gchar* _tmp7_;
				gchar* addr;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp5_ = _tmp4_ = g_strsplit (a, "#", 0);
				info = _tmp5_;
				info_length1 = _vala_array_length (_tmp4_);
				_info_size_ = _vala_array_length (_tmp4_);
				_tmp6_ = g_strdup (info[0]);
				proto = _tmp6_;
				_tmp7_ = g_strdup (info[1]);
				addr = _tmp7_;
				_tmp8_ = addr;
				addr = NULL;
				_tmp9_ = _tmp8_;
				_tmp10_ = proto;
				proto = NULL;
				_tmp11_ = _tmp10_;
				gee_abstract_map_set ((GeeAbstractMap*) ret, _tmp9_, _tmp11_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				_g_free0 (addr);
				_g_free0 (proto);
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (a);
			}
		}
	}
	result = ret;
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (predicate != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	{
		gchar** obj_collection;
		int obj_collection_length1;
		int obj_it;
		obj_collection = objects;
		obj_collection_length1 = objects_length1;
		for (obj_it = 0; obj_it < objects_length1; obj_it = obj_it + 1) {
			gchar* _tmp1_;
			gchar* obj;
			_tmp1_ = g_strdup (obj_collection[obj_it]);
			obj = _tmp1_;
			{
				gchar* vtemp1 = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp10_;
				_tmp2_ = g_strconcat (" ", predicate, NULL);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat (_tmp3_, " <", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp5_, obj, NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (_tmp7_, "> ", NULL);
				_g_free0 (vtemp1);
				vtemp1 = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
				if (g_strcmp0 (ret, "") != 0) {
					gchar* _tmp9_;
					_tmp9_ = g_strconcat (ret, "; ", NULL);
					_g_free0 (ret);
					ret = _tmp9_;
				}
				_tmp10_ = g_strconcat (ret, vtemp1, NULL);
				_g_free0 (ret);
				ret = _tmp10_;
				_g_free0 (vtemp1);
				_g_free0 (obj);
			}
		}
	}
	result = ret;
	return result;
}


gboolean tracker_test_backend_get_debug (TrackerTestBackend* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug;
	return result;
}


void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_debug = value;
}


static void tracker_test_value_backend_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_test_value_backend_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_test_backend_unref (value->data[0].v_pointer);
	}
}


static void tracker_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_test_backend_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_test_value_backend_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerTestBackend* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_test_backend_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_test_backend_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerTestParamSpecBackend* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TEST_TYPE_BACKEND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_test_value_get_backend (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND), NULL);
	return value->data[0].v_pointer;
}


void tracker_test_value_set_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_test_backend_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_test_backend_unref (old);
	}
}


void tracker_test_value_take_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_test_backend_unref (old);
	}
}


static void tracker_test_backend_class_init (TrackerTestBackendClass * klass) {
	tracker_test_backend_parent_class = g_type_class_peek_parent (klass);
	TRACKER_TEST_BACKEND_CLASS (klass)->finalize = tracker_test_backend_finalize;
	g_type_class_add_private (klass, sizeof (TrackerTestBackendPrivate));
}


static void tracker_test_backend_instance_init (TrackerTestBackend * self) {
	self->priv = TRACKER_TEST_BACKEND_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void tracker_test_backend_finalize (TrackerTestBackend* obj) {
	TrackerTestBackend * self;
	self = TRACKER_TEST_BACKEND (obj);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	_g_object_unref0 (self->priv->_connection);
}


GType tracker_test_backend_get_type (void) {
	static volatile gsize tracker_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_test_value_backend_init, tracker_test_value_backend_free_value, tracker_test_value_backend_copy_value, tracker_test_value_backend_peek_pointer, "p", tracker_test_value_backend_collect_value, "p", tracker_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTestBackend), 0, (GInstanceInitFunc) tracker_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_test_backend_type_id;
		tracker_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_test_backend_type_id__volatile, tracker_test_backend_type_id);
	}
	return tracker_test_backend_type_id__volatile;
}


gpointer tracker_test_backend_ref (gpointer instance) {
	TrackerTestBackend* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_test_backend_unref (gpointer instance) {
	TrackerTestBackend* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_TEST_BACKEND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



