/* aggregation.c generated by valac 0.12.0, the Vala compiler
 * generated from aggregation.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Alban Crequy <alban.crequy@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <libsocialweb-test.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <folks.h>
#include <gee.h>


#define TYPE_AGGREGATION_TESTS (aggregation_tests_get_type ())
#define AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATION_TESTS, AggregationTests))
#define AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATION_TESTS, AggregationTestsClass))
#define IS_AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATION_TESTS))
#define IS_AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATION_TESTS))
#define AGGREGATION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATION_TESTS, AggregationTestsClass))

typedef struct _AggregationTests AggregationTests;
typedef struct _AggregationTestsClass AggregationTestsClass;
typedef struct _AggregationTestsPrivate AggregationTestsPrivate;
#define _libsocialweb_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (libsocialweb_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _AggregationTests {
	FolksTestCase parent_instance;
	AggregationTestsPrivate * priv;
};

struct _AggregationTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AggregationTestsPrivate {
	LibsocialwebTestBackend* _lsw_backend;
};

struct _Block1Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	LibsocialwebTestLibsocialwebServiceTest* mysocialnetwork1;
	LibsocialwebTestLibsocialwebServiceTest* mysocialnetwork2;
	FolksIndividualAggregator* aggregator;
	FolksIndividual** individual_gathered;
	gint individual_gathered_length1;
	gint _individual_gathered_size_;
	GList* personas;
};

struct _Block2Data {
	int _ref_count_;
	AggregationTests * self;
	gchar* path;
};

struct _Block3Data {
	int _ref_count_;
	AggregationTests * self;
	gchar* path;
};


static gpointer aggregation_tests_parent_class = NULL;

GType aggregation_tests_get_type (void) G_GNUC_CONST;
#define AGGREGATION_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATION_TESTS, AggregationTestsPrivate))
enum  {
	AGGREGATION_TESTS_DUMMY_PROPERTY
};
#define AGGREGATION_TESTS_STORE_FILE_PATH "folks-test-libsocialweb-aggregation-store.ini"
#define AGGREGATION_TESTS_KF_RELATIONSHIPS_FILE_PATH "folks-test-libsocialweb-aggregation-relationships.ini"
AggregationTests* aggregation_tests_new (void);
AggregationTests* aggregation_tests_construct (GType object_type);
void aggregation_tests_test_aggregation_libsocialweb (AggregationTests* self);
static void _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method (gpointer self);
static void aggregation_tests_real_set_up (FolksTestCase* base);
static void aggregation_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__libsocialweb_test_backend_ready (LibsocialwebTestBackend* _sender, gpointer self);
static gboolean _lambda1_ (AggregationTests* self);
static gboolean __lambda1__gsource_func (gpointer self);
static void _lambda2_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_);
static void _lambda3_ (const gchar* path, AggregationTests* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda4_ (Block2Data* _data2_);
static gboolean __lambda4__gsource_func (gpointer self);
static void __lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self);
static void __lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self);
static void _lambda5_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_);
static void _lambda6_ (const gchar* path, AggregationTests* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _lambda7_ (Block3Data* _data3_);
static gboolean __lambda7__gsource_func (gpointer self);
static void __lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self);
static void __lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self);
static void _lambda8_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_);
static void _vala_array_add1 (FolksIndividual*** array, int* length, int* size, FolksIndividual* value);
static void __lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda9_ (AggregationTests* self);
static gboolean __lambda9__gsource_func (gpointer self);
static void _lambda10_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_);
static void __lambda10__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda11_ (Block1Data* _data1_);
static gboolean __lambda11__gsource_func (gpointer self);
static gboolean _lambda12_ (AggregationTests* self);
static gboolean __lambda12__gsource_func (gpointer self);
static void aggregation_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_aggregation_libsocialweb (self);
}


AggregationTests* aggregation_tests_construct (GType object_type) {
	AggregationTests * self = NULL;
	LibsocialwebTestBackend* _tmp0_ = NULL;
	self = (AggregationTests*) folks_test_case_construct (object_type, "Aggregation");
	_tmp0_ = libsocialweb_test_backend_new ();
	_libsocialweb_test_backend_unref0 (self->priv->_lsw_backend);
	self->priv->_lsw_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "libsocialweb aggregation", _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method, self);
	return self;
}


AggregationTests* aggregation_tests_new (void) {
	return aggregation_tests_construct (TYPE_AGGREGATION_TESTS);
}


static void aggregation_tests_real_set_up (FolksTestCase* base) {
	AggregationTests * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* kf_relationships_path;
	gchar* _tmp2_;
	gchar* kf_relationships_data;
	GFile* _tmp3_ = NULL;
	GFile* kf_relationships_f;
	gint _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* kf_path;
	GKeyFile* _tmp7_ = NULL;
	GKeyFile* kf;
	GFile* _tmp8_ = NULL;
	GFile* backend_f;
	gchar* _tmp9_ = NULL;
	gchar* data;
	gint _tmp10_;
	GError * _inner_error_ = NULL;
	self = (AggregationTests*) base;
	_tmp0_ = g_get_tmp_dir ();
	_tmp1_ = g_build_filename (_tmp0_, AGGREGATION_TESTS_KF_RELATIONSHIPS_FILE_PATH, NULL, NULL);
	kf_relationships_path = _tmp1_;
	g_setenv ("FOLKS_BACKEND_KEY_FILE_PATH", kf_relationships_path, TRUE);
	_tmp2_ = g_strdup ("#\n");
	kf_relationships_data = _tmp2_;
	_tmp3_ = g_file_new_for_path (kf_relationships_path);
	kf_relationships_f = _tmp3_;
	_tmp4_ = strlen (kf_relationships_data);
	g_file_replace_contents (kf_relationships_f, kf_relationships_data, (gsize) _tmp4_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("aggregation.vala:61: Could not write relationship file '%s': %s", kf_relationships_path, e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (kf_relationships_f);
		_g_free0 (kf_relationships_data);
		_g_free0 (kf_relationships_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = g_get_tmp_dir ();
	_tmp6_ = g_build_filename (_tmp5_, AGGREGATION_TESTS_STORE_FILE_PATH, NULL, NULL);
	kf_path = _tmp6_;
	g_remove (kf_path);
	_tmp7_ = g_key_file_new ();
	kf = _tmp7_;
	g_key_file_set_boolean (kf, "all-others", "enabled", FALSE);
	g_key_file_set_boolean (kf, "libsocialweb", "enabled", TRUE);
	g_key_file_set_boolean (kf, "key-file", "enabled", TRUE);
	_tmp8_ = g_file_new_for_path (kf_path);
	backend_f = _tmp8_;
	_tmp9_ = g_key_file_to_data (kf, NULL, NULL);
	data = _tmp9_;
	_tmp10_ = strlen (data);
	g_file_replace_contents (backend_f, data, (gsize) _tmp10_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_object_unref0 (backend_f);
		goto __catch1_g_error;
	}
	_g_free0 (data);
	_g_object_unref0 (backend_f);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("aggregation.vala:86: Could not write updated backend key file '%s': %s", kf_path, e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (kf);
		_g_free0 (kf_path);
		_g_object_unref0 (kf_relationships_f);
		_g_free0 (kf_relationships_data);
		_g_free0 (kf_relationships_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_setenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH", kf_path, TRUE);
	_g_key_file_free0 (kf);
	_g_free0 (kf_path);
	_g_object_unref0 (kf_relationships_f);
	_g_free0 (kf_relationships_data);
	_g_free0 (kf_relationships_path);
}


static void aggregation_tests_real_tear_down (FolksTestCase* base) {
	AggregationTests * self;
	self = (AggregationTests*) base;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_list_free0 (_data1_->personas);
		_data1_->individual_gathered = (_vala_array_free (_data1_->individual_gathered, _data1_->individual_gathered_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data1_->aggregator);
		_g_object_unref0 (_data1_->mysocialnetwork2);
		_g_object_unref0 (_data1_->mysocialnetwork1);
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (Block1Data* _data1_) {
	AggregationTests * self;
	self = _data1_->self;
	g_main_loop_quit (_data1_->main_loop);
}


static void __lambda0__libsocialweb_test_backend_ready (LibsocialwebTestBackend* _sender, gpointer self) {
	_lambda0_ (self);
}


static gboolean _lambda1_ (AggregationTests* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->path);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda4_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* text;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
	GDBusConnection* _tmp2_ = NULL;
	GDBusConnection* conn;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	_tmp0_ = g_strdup ("([('mysocialnetwork1', 'garg', %x, " "{'id': ['garg'], 'name': ['Gargantua']})],)");
	text = _tmp0_;
	_tmp1_ = g_variant_new_parsed (text, 1300792578, NULL);
	v = g_variant_ref_sink (_tmp1_);
	_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch2_g_io_error;
		}
		goto __catch2_g_error;
	}
	g_dbus_connection_emit_signal (conn, NULL, _data2_->path, "com.meego.libsocialweb.ContactView", "ContactsAdded", v, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conn);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch2_g_io_error;
		}
		goto __catch2_g_error;
	}
	_g_object_unref0 (conn);
	goto __finally2;
	__catch2_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (v);
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_variant_unref0 (v);
	_g_free0 (text);
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static void _lambda3_ (const gchar* path, AggregationTests* self) {
	Block2Data* _data2_;
	g_return_if_fail (path != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->path = g_strdup (path);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda4__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void __lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self) {
	_lambda3_ (path, self);
}


static void _lambda2_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_) {
	AggregationTests * self;
	gpointer _tmp0_ = NULL;
	LibsocialwebTestLibsocialwebContactViewTest* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (query != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) _data1_->mysocialnetwork1->contact_views, path);
	_tmp1_ = (LibsocialwebTestLibsocialwebContactViewTest*) _tmp0_;
	g_signal_connect_object (_tmp1_, "start-called", (GCallback) __lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called, self, 0);
	_g_object_unref0 (_tmp1_);
}


static void __lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self) {
	_lambda2_ (query, p, path, self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_free0 (_data3_->path);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda7_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* text;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
	GDBusConnection* _tmp2_ = NULL;
	GDBusConnection* conn;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	_tmp0_ = g_strdup ("([('mysocialnetwork2', 'panta', %x, " "{'id': ['panta'], 'name': ['Pantagruel']})],)");
	text = _tmp0_;
	_tmp1_ = g_variant_new_parsed (text, 1300792579, NULL);
	v = g_variant_ref_sink (_tmp1_);
	_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch3_g_io_error;
		}
		goto __catch3_g_error;
	}
	g_dbus_connection_emit_signal (conn, NULL, _data3_->path, "com.meego.libsocialweb.ContactView", "ContactsAdded", v, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conn);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch3_g_io_error;
		}
		goto __catch3_g_error;
	}
	_g_object_unref0 (conn);
	goto __finally3;
	__catch3_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (v);
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_variant_unref0 (v);
	_g_free0 (text);
	return result;
}


static gboolean __lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


static void _lambda6_ (const gchar* path, AggregationTests* self) {
	Block3Data* _data3_;
	g_return_if_fail (path != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->path = g_strdup (path);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda7__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void __lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self) {
	_lambda6_ (path, self);
}


static void _lambda5_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_) {
	AggregationTests * self;
	gpointer _tmp0_ = NULL;
	LibsocialwebTestLibsocialwebContactViewTest* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (query != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) _data1_->mysocialnetwork2->contact_views, path);
	_tmp1_ = (LibsocialwebTestLibsocialwebContactViewTest*) _tmp0_;
	g_signal_connect_object (_tmp1_, "start-called", (GCallback) __lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called, self, 0);
	_g_object_unref0 (_tmp1_);
}


static void __lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self) {
	_lambda5_ (query, p, path, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksIndividual*** array, int* length, int* size, FolksIndividual* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksIndividual*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _lambda8_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_) {
	AggregationTests * self;
	self = _data1_->self;
	g_debug ("aggregation.vala:181: initial individuals_changed");
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				FolksIndividual* _tmp1_;
				_tmp1_ = _g_object_ref0 (i);
				_vala_array_add1 (&_data1_->individual_gathered, &_data1_->individual_gathered_length1, &_data1_->_individual_gathered_size_, _tmp1_);
				_g_object_unref0 (i);
			}
		}
	}
	if (_data1_->individual_gathered_length1 >= 2) {
		g_main_loop_quit (_data1_->main_loop);
	}
}


static void __lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda8_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda9_ (AggregationTests* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda9_ (self);
	return result;
}


static void _lambda10_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_) {
	AggregationTests * self;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gconstpointer _tmp4_ = NULL;
	FolksIndividual* _tmp5_;
	FolksIndividual* i;
	GList* _tmp6_ = NULL;
	guint _tmp7_;
	GList* _tmp8_ = NULL;
	guint _tmp9_;
	self = _data1_->self;
	_tmp0_ = g_list_length (added);
	_tmp1_ = g_list_length (removed);
	g_debug ("aggregation.vala:209: individuals_changed after link: added:%u removed" \
":%u", _tmp0_, _tmp1_);
	_tmp2_ = g_list_length (added);
	g_assert (_tmp2_ == 1);
	_tmp3_ = g_list_length (removed);
	g_assert (_tmp3_ == 2);
	_tmp4_ = g_list_nth_data (added, (guint) 0);
	_tmp5_ = _g_object_ref0 ((FolksIndividual*) _tmp4_);
	i = _tmp5_;
	_tmp6_ = folks_individual_get_personas (i);
	_tmp7_ = g_list_length (_tmp6_);
	g_assert (_tmp7_ == 3);
	_tmp8_ = folks_individual_get_personas (i);
	_tmp9_ = g_list_length (_tmp8_);
	g_debug ("aggregation.vala:215: individuals_changed: 1 individual containing %u " \
"personas", _tmp9_);
	g_main_loop_quit (_data1_->main_loop);
	_g_object_unref0 (i);
}


static void __lambda10__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda10_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda11_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data1_->self;
	folks_individual_aggregator_link_personas (_data1_->aggregator, _data1_->personas, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


static gboolean _lambda12_ (AggregationTests* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


void aggregation_tests_test_aggregation_libsocialweb (AggregationTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	guint _tmp1_;
	guint timer_id;
	LibsocialwebTestLibsocialwebServiceTest* _tmp2_ = NULL;
	LibsocialwebTestLibsocialwebServiceTest* _tmp3_ = NULL;
	FolksIndividualAggregator* _tmp4_ = NULL;
	FolksIndividual** _tmp5_ = NULL;
	gulong _tmp6_;
	gulong handler_id;
	guint _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	GList* personas1;
	GList* _tmp15_ = NULL;
	GList* _tmp16_ = NULL;
	GList* personas2;
	GList* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
	GList* _tmp20_ = NULL;
	guint _tmp21_;
	guint _tmp22_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp0_;
	g_signal_connect_data (self->priv->_lsw_backend, "ready", (GCallback) __lambda0__libsocialweb_test_backend_ready, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	timer_id = _tmp1_;
	libsocialweb_test_backend_set_up (self->priv->_lsw_backend);
	g_main_loop_run (_data1_->main_loop);
	g_source_remove (timer_id);
	_tmp2_ = libsocialweb_test_backend_add_service (self->priv->_lsw_backend, "mysocialnetwork1");
	_data1_->mysocialnetwork1 = _tmp2_;
	_tmp3_ = libsocialweb_test_backend_add_service (self->priv->_lsw_backend, "mysocialnetwork2");
	_data1_->mysocialnetwork2 = _tmp3_;
	g_signal_connect_data (_data1_->mysocialnetwork1, "open-view-called", (GCallback) __lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data (_data1_->mysocialnetwork2, "open-view-called", (GCallback) __lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp4_ = folks_individual_aggregator_new ();
	_data1_->aggregator = _tmp4_;
	_tmp5_ = g_new0 (FolksIndividual*, 0 + 1);
	_data1_->individual_gathered = _tmp5_;
	_data1_->individual_gathered_length1 = 0;
	_data1_->_individual_gathered_size_ = 0;
	_tmp6_ = g_signal_connect_data (_data1_->aggregator, "individuals-changed", (GCallback) __lambda8__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	handler_id = _tmp6_;
	folks_individual_aggregator_prepare (_data1_->aggregator, NULL, NULL);
	_tmp7_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda9__gsource_func, g_object_ref (self), g_object_unref);
	timer_id = _tmp7_;
	g_main_loop_run (_data1_->main_loop);
	g_source_remove (timer_id);
	g_signal_handler_disconnect ((GObject*) _data1_->aggregator, handler_id);
	g_assert (_data1_->individual_gathered_length1 == 2);
	_tmp10_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_data1_->individual_gathered[0]));
	if (g_strcmp0 (_tmp10_, "Gargantua") == 0) {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_data1_->individual_gathered[1]));
		_tmp9_ = g_strcmp0 (_tmp11_, "Pantagruel") == 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		_tmp13_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_data1_->individual_gathered[0]));
		if (g_strcmp0 (_tmp13_, "Pantagruel") == 0) {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_data1_->individual_gathered[1]));
			_tmp12_ = g_strcmp0 (_tmp14_, "Gargantua") == 0;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp8_ = _tmp12_;
	}
	g_assert (_tmp8_);
	g_signal_connect_data (_data1_->aggregator, "individuals-changed", (GCallback) __lambda10__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	personas1 = NULL;
	_tmp15_ = folks_individual_get_personas (_data1_->individual_gathered[0]);
	_tmp16_ = g_list_copy (_tmp15_);
	personas1 = g_list_concat (personas1, _tmp16_);
	personas2 = NULL;
	_tmp17_ = folks_individual_get_personas (_data1_->individual_gathered[1]);
	_tmp18_ = g_list_copy (_tmp17_);
	personas2 = g_list_concat (personas2, _tmp18_);
	_data1_->personas = NULL;
	_tmp19_ = g_list_copy (personas1);
	_data1_->personas = g_list_concat (_data1_->personas, _tmp19_);
	_tmp20_ = g_list_copy (personas2);
	_data1_->personas = g_list_concat (_data1_->personas, _tmp20_);
	_tmp21_ = g_list_length (_data1_->personas);
	g_assert (_tmp21_ == 2);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda11__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_tmp22_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda12__gsource_func, g_object_ref (self), g_object_unref);
	timer_id = _tmp22_;
	g_main_loop_run (_data1_->main_loop);
	g_source_remove (timer_id);
	libsocialweb_test_backend_tear_down (self->priv->_lsw_backend);
	_g_list_free0 (personas2);
	_g_list_free0 (personas1);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void aggregation_tests_class_init (AggregationTestsClass * klass) {
	aggregation_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AggregationTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = aggregation_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = aggregation_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = aggregation_tests_finalize;
}


static void aggregation_tests_instance_init (AggregationTests * self) {
	self->priv = AGGREGATION_TESTS_GET_PRIVATE (self);
}


static void aggregation_tests_finalize (GObject* obj) {
	AggregationTests * self;
	self = AGGREGATION_TESTS (obj);
	_libsocialweb_test_backend_unref0 (self->priv->_lsw_backend);
	G_OBJECT_CLASS (aggregation_tests_parent_class)->finalize (obj);
}


GType aggregation_tests_get_type (void) {
	static volatile gsize aggregation_tests_type_id__volatile = 0;
	if (g_once_init_enter (&aggregation_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AggregationTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregation_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregationTests), 0, (GInstanceInitFunc) aggregation_tests_instance_init, NULL };
		GType aggregation_tests_type_id;
		aggregation_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AggregationTests", &g_define_type_info, 0);
		g_once_init_leave (&aggregation_tests_type_id__volatile, aggregation_tests_type_id);
	}
	return aggregation_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AggregationTests* _tmp1_ = NULL;
	AggregationTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = aggregation_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



