/* avatar-details-interface.c generated by valac 0.12.0, the Vala compiler
 * generated from avatar-details-interface.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <stdlib.h>
#include <string.h>
#include <folks.h>
#include <gee.h>
#include <gio/gio.h>
#include <folks-tracker.h>


#define TYPE_AVATAR_DETAILS_INTERFACE_TESTS (avatar_details_interface_tests_get_type ())
#define AVATAR_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_DETAILS_INTERFACE_TESTS, AvatarDetailsInterfaceTests))
#define AVATAR_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_DETAILS_INTERFACE_TESTS, AvatarDetailsInterfaceTestsClass))
#define IS_AVATAR_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_DETAILS_INTERFACE_TESTS))
#define IS_AVATAR_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_DETAILS_INTERFACE_TESTS))
#define AVATAR_DETAILS_INTERFACE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_DETAILS_INTERFACE_TESTS, AvatarDetailsInterfaceTestsClass))

typedef struct _AvatarDetailsInterfaceTests AvatarDetailsInterfaceTests;
typedef struct _AvatarDetailsInterfaceTestsClass AvatarDetailsInterfaceTestsClass;
typedef struct _AvatarDetailsInterfaceTestsPrivate AvatarDetailsInterfaceTestsPrivate;
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData;

struct _AvatarDetailsInterfaceTests {
	FolksTestCase parent_instance;
	AvatarDetailsInterfaceTestsPrivate * priv;
};

struct _AvatarDetailsInterfaceTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AvatarDetailsInterfaceTestsPrivate {
	TrackerTestBackend* _tracker_backend;
	gchar* _avatar_uri;
	gboolean _avatars_are_equal;
	GMainLoop* _main_loop;
	FolksIndividualAggregator* _aggregator;
};

struct _AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AvatarDetailsInterfaceTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer avatar_details_interface_tests_parent_class = NULL;

GType avatar_details_interface_tests_get_type (void) G_GNUC_CONST;
#define AVATAR_DETAILS_INTERFACE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_DETAILS_INTERFACE_TESTS, AvatarDetailsInterfaceTestsPrivate))
enum  {
	AVATAR_DETAILS_INTERFACE_TESTS_DUMMY_PROPERTY
};
AvatarDetailsInterfaceTests* avatar_details_interface_tests_new (void);
AvatarDetailsInterfaceTests* avatar_details_interface_tests_construct (GType object_type);
void avatar_details_interface_tests_test_avatar_details_interface (AvatarDetailsInterfaceTests* self);
static void _avatar_details_interface_tests_test_avatar_details_interface_folks_test_case_test_method (gpointer self);
static void avatar_details_interface_tests_real_set_up (FolksTestCase* base);
static void avatar_details_interface_tests_real_tear_down (FolksTestCase* base);
static void avatar_details_interface_tests_test_avatar_details_interface_async (AvatarDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void avatar_details_interface_tests_test_avatar_details_interface_finish (AvatarDetailsInterfaceTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (AvatarDetailsInterfaceTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void avatar_details_interface_tests_test_avatar_details_interface_async_data_free (gpointer _data);
static gboolean avatar_details_interface_tests_test_avatar_details_interface_async_co (AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData* data);
static void avatar_details_interface_tests_test_avatar_details_interface_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _avatar_details_interface_tests_individuals_changed_cb (AvatarDetailsInterfaceTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __avatar_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _avatar_details_interface_tests_notify_avatar_cb (AvatarDetailsInterfaceTests* self, GObject* individual_obj, GParamSpec* ps);
static void __avatar_details_interface_tests_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _avatar_details_interface_tests_compare_files (AvatarDetailsInterfaceTests* self, GFile* a, GFile* b);
static void avatar_details_interface_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _avatar_details_interface_tests_test_avatar_details_interface_folks_test_case_test_method (gpointer self) {
	avatar_details_interface_tests_test_avatar_details_interface (self);
}


AvatarDetailsInterfaceTests* avatar_details_interface_tests_construct (GType object_type) {
	AvatarDetailsInterfaceTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (AvatarDetailsInterfaceTests*) folks_test_case_construct (object_type, "AvatarDetailsInterfaceTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test avatar details interface", _avatar_details_interface_tests_test_avatar_details_interface_folks_test_case_test_method, self);
	return self;
}


AvatarDetailsInterfaceTests* avatar_details_interface_tests_new (void) {
	return avatar_details_interface_tests_construct (TYPE_AVATAR_DETAILS_INTERFACE_TESTS);
}


static void avatar_details_interface_tests_real_set_up (FolksTestCase* base) {
	AvatarDetailsInterfaceTests * self;
	self = (AvatarDetailsInterfaceTests*) base;
}


static void avatar_details_interface_tests_real_tear_down (FolksTestCase* base) {
	AvatarDetailsInterfaceTests * self;
	self = (AvatarDetailsInterfaceTests*) base;
}


static gboolean _lambda0_ (AvatarDetailsInterfaceTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void avatar_details_interface_tests_test_avatar_details_interface (AvatarDetailsInterfaceTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* avatar_path;
	GFile* _tmp4_ = NULL;
	GFile* temp_file;
	gchar* _tmp5_ = NULL;
	gchar* full_avatar_path;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_getenv ("AVATAR_FILE_PATH");
	_tmp3_ = g_strdup (_tmp2_);
	avatar_path = _tmp3_;
	_tmp4_ = g_file_new_for_path (avatar_path);
	temp_file = _tmp4_;
	_tmp5_ = g_file_get_path (temp_file);
	full_avatar_path = _tmp5_;
	_tmp6_ = g_strconcat ("file://", full_avatar_path, NULL);
	_g_free0 (self->priv->_avatar_uri);
	self->priv->_avatar_uri = _tmp6_;
	self->priv->_avatars_are_equal = FALSE;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, "persona #1");
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_PHOTO, self->priv->_avatar_uri);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	avatar_details_interface_tests_test_avatar_details_interface_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_avatars_are_equal);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_free0 (full_avatar_path);
	_g_object_unref0 (temp_file);
	_g_free0 (avatar_path);
	_g_object_unref0 (c1);
}


static void avatar_details_interface_tests_test_avatar_details_interface_async_data_free (gpointer _data) {
	AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void avatar_details_interface_tests_test_avatar_details_interface_async (AvatarDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData* _data_;
	_data_ = g_slice_new0 (AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, avatar_details_interface_tests_test_avatar_details_interface_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, avatar_details_interface_tests_test_avatar_details_interface_async_data_free);
	_data_->self = _g_object_ref0 (self);
	avatar_details_interface_tests_test_avatar_details_interface_async_co (_data_);
}


static void avatar_details_interface_tests_test_avatar_details_interface_finish (AvatarDetailsInterfaceTests* self, GAsyncResult* _res_) {
	AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void avatar_details_interface_tests_test_avatar_details_interface_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	avatar_details_interface_tests_test_avatar_details_interface_async_co (data);
}


static void __avatar_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_avatar_details_interface_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean avatar_details_interface_tests_test_avatar_details_interface_async_co (AvatarDetailsInterfaceTestsTestAvatarDetailsInterfaceAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, avatar_details_interface_tests_test_avatar_details_interface_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __avatar_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, avatar_details_interface_tests_test_avatar_details_interface_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("avatar-details-interface.vala:95: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __avatar_details_interface_tests_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_avatar_details_interface_tests_notify_avatar_cb (self, _sender, pspec);
}


static void _avatar_details_interface_tests_individuals_changed_cb (AvatarDetailsInterfaceTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	g_return_if_fail (self != NULL);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				gchar* full_name;
				_tmp1_ = folks_name_details_get_full_name (FOLKS_NAME_DETAILS (i));
				_tmp2_ = g_strdup (_tmp1_);
				full_name = _tmp2_;
				if (full_name != NULL) {
					GFile* _tmp3_ = NULL;
					g_signal_connect_object ((GObject*) i, "notify::avatar", (GCallback) __avatar_details_interface_tests_notify_avatar_cb_g_object_notify, self, 0);
					_tmp3_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
					if (_tmp3_ != NULL) {
						GFile* _tmp4_ = NULL;
						GFile* src_avatar;
						GFile* _tmp5_ = NULL;
						gboolean _tmp6_;
						_tmp4_ = g_file_new_for_uri (self->priv->_avatar_uri);
						src_avatar = _tmp4_;
						_tmp5_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
						_tmp6_ = _avatar_details_interface_tests_compare_files (self, src_avatar, _tmp5_);
						self->priv->_avatars_are_equal = _tmp6_;
						g_main_loop_quit (self->priv->_main_loop);
						_g_object_unref0 (src_avatar);
					}
				}
				_g_free0 (full_name);
				_g_object_unref0 (i);
			}
		}
	}
}


static void _avatar_details_interface_tests_notify_avatar_cb (AvatarDetailsInterfaceTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* individual;
	GFile* _tmp1_ = NULL;
	GFile* src_avatar;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	individual = _tmp0_;
	_tmp1_ = g_file_new_for_uri (self->priv->_avatar_uri);
	src_avatar = _tmp1_;
	_tmp2_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) individual);
	_tmp3_ = _avatar_details_interface_tests_compare_files (self, src_avatar, _tmp2_);
	self->priv->_avatars_are_equal = _tmp3_;
	g_main_loop_quit (self->priv->_main_loop);
	_g_object_unref0 (src_avatar);
	_g_object_unref0 (individual);
}


static gboolean _avatar_details_interface_tests_compare_files (AvatarDetailsInterfaceTests* self, GFile* a, GFile* b) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* content_a;
	gchar* _tmp1_;
	gchar* content_b;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_strdup ("a");
	content_a = _tmp0_;
	_tmp1_ = g_strdup ("b");
	content_b = _tmp1_;
	g_file_load_contents (a, NULL, &_tmp2_, NULL, NULL, &_inner_error_);
	_g_free0 (content_a);
	content_a = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("avatar-details-interface.vala:143: couldn't load file a");
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (content_b);
		_g_free0 (content_a);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_file_load_contents (b, NULL, &_tmp3_, NULL, NULL, &_inner_error_);
	_g_free0 (content_b);
	content_b = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("avatar-details-interface.vala:152: couldn't load file b");
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (content_b);
		_g_free0 (content_a);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = g_strcmp0 (content_a, content_b) == 0;
	_g_free0 (content_b);
	_g_free0 (content_a);
	return result;
}


static void avatar_details_interface_tests_class_init (AvatarDetailsInterfaceTestsClass * klass) {
	avatar_details_interface_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarDetailsInterfaceTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = avatar_details_interface_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = avatar_details_interface_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = avatar_details_interface_tests_finalize;
}


static void avatar_details_interface_tests_instance_init (AvatarDetailsInterfaceTests * self) {
	self->priv = AVATAR_DETAILS_INTERFACE_TESTS_GET_PRIVATE (self);
}


static void avatar_details_interface_tests_finalize (GObject* obj) {
	AvatarDetailsInterfaceTests * self;
	self = AVATAR_DETAILS_INTERFACE_TESTS (obj);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_free0 (self->priv->_avatar_uri);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_g_object_unref0 (self->priv->_aggregator);
	G_OBJECT_CLASS (avatar_details_interface_tests_parent_class)->finalize (obj);
}


GType avatar_details_interface_tests_get_type (void) {
	static volatile gsize avatar_details_interface_tests_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_details_interface_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarDetailsInterfaceTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_details_interface_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarDetailsInterfaceTests), 0, (GInstanceInitFunc) avatar_details_interface_tests_instance_init, NULL };
		GType avatar_details_interface_tests_type_id;
		avatar_details_interface_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AvatarDetailsInterfaceTests", &g_define_type_info, 0);
		g_once_init_leave (&avatar_details_interface_tests_type_id__volatile, avatar_details_interface_tests_type_id);
	}
	return avatar_details_interface_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AvatarDetailsInterfaceTests* _tmp1_ = NULL;
	AvatarDetailsInterfaceTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = avatar_details_interface_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



