/* set-duplicate-email.c generated by valac 0.12.0, the Vala compiler
 * generated from set-duplicate-email.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_SET_DUPLICATE_EMAIL_TESTS (set_duplicate_email_tests_get_type ())
#define SET_DUPLICATE_EMAIL_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTests))
#define SET_DUPLICATE_EMAIL_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTestsClass))
#define IS_SET_DUPLICATE_EMAIL_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_DUPLICATE_EMAIL_TESTS))
#define IS_SET_DUPLICATE_EMAIL_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_DUPLICATE_EMAIL_TESTS))
#define SET_DUPLICATE_EMAIL_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTestsClass))

typedef struct _SetDuplicateEmailTests SetDuplicateEmailTests;
typedef struct _SetDuplicateEmailTestsClass SetDuplicateEmailTestsClass;
typedef struct _SetDuplicateEmailTestsPrivate SetDuplicateEmailTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData;
typedef struct _SetDuplicateEmailTestsTryToAddData SetDuplicateEmailTestsTryToAddData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SetDuplicateEmailTestsAddPersonasData SetDuplicateEmailTestsAddPersonasData;

struct _SetDuplicateEmailTests {
	FolksTestCase parent_instance;
	SetDuplicateEmailTestsPrivate * priv;
};

struct _SetDuplicateEmailTestsClass {
	FolksTestCaseClass parent_class;
};

struct _SetDuplicateEmailTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _email_1;
	gboolean _added_personas;
	GStaticRecMutex __lock__added_personas;
	TrfPersonaStore* _pstore;
	gboolean _email_found;
};

struct _SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SetDuplicateEmailTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GeeMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _backend_it;
	gboolean _tmp7_;
	gpointer _tmp8_;
	FolksBackend* backend;
	GeeMap* _tmp9_;
	gpointer _tmp10_;
	GError * e;
	GError * _inner_error_;
};

struct _SetDuplicateEmailTestsTryToAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SetDuplicateEmailTests* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_;
};

struct _SetDuplicateEmailTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SetDuplicateEmailTests* self;
	GHashTable* _tmp0_;
	GHashTable* details1;
	GValue* val;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GValue* _tmp7_;
	GValue _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_;
	GValue* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* emails1;
	FolksFieldDetails* _tmp13_;
	FolksFieldDetails* email_1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GValue* _tmp16_;
	FolksPersona* _tmp17_;
	FolksPersona* _tmp18_;
	GError * e;
	GError * _inner_error_;
};


static gpointer set_duplicate_email_tests_parent_class = NULL;

GType set_duplicate_email_tests_get_type (void) G_GNUC_CONST;
#define SET_DUPLICATE_EMAIL_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTestsPrivate))
enum  {
	SET_DUPLICATE_EMAIL_TESTS_DUMMY_PROPERTY
};
SetDuplicateEmailTests* set_duplicate_email_tests_new (void);
SetDuplicateEmailTests* set_duplicate_email_tests_construct (GType object_type);
void set_duplicate_email_tests_test_set_duplicate_email (SetDuplicateEmailTests* self);
static void _set_duplicate_email_tests_test_set_duplicate_email_folks_test_case_test_method (gpointer self);
static void set_duplicate_email_tests_real_set_up (FolksTestCase* base);
static void set_duplicate_email_tests_real_tear_down (FolksTestCase* base);
static void _set_duplicate_email_tests_test_set_duplicate_email_async (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _set_duplicate_email_tests_test_set_duplicate_email_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (SetDuplicateEmailTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _set_duplicate_email_tests_test_set_duplicate_email_async_data_free (gpointer _data);
static gboolean _set_duplicate_email_tests_test_set_duplicate_email_async_co (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* data);
static void _set_duplicate_email_tests_test_set_duplicate_email_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _set_duplicate_email_tests_individuals_changed_cb (SetDuplicateEmailTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __set_duplicate_email_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _set_duplicate_email_tests_notify_pstore_cb (SetDuplicateEmailTests* self, GObject* _pstore, GParamSpec* ps);
static void __set_duplicate_email_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _set_duplicate_email_tests_try_to_add (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _set_duplicate_email_tests_try_to_add_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_);
static void _set_duplicate_email_tests_reset_email_address (SetDuplicateEmailTests* self, FolksIndividual* i);
static gboolean _set_duplicate_email_tests_has_email (SetDuplicateEmailTests* self, TrfPersona* persona, const gchar* email);
static void _set_duplicate_email_tests_email_addresses_cb (SetDuplicateEmailTests* self, GObject* p, GParamSpec* ps);
static void __set_duplicate_email_tests_email_addresses_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _set_duplicate_email_tests_try_to_add_data_free (gpointer _data);
static gboolean _set_duplicate_email_tests_try_to_add_co (SetDuplicateEmailTestsTryToAddData* data);
static void _set_duplicate_email_tests_add_personas (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _set_duplicate_email_tests_add_personas_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_);
static void _set_duplicate_email_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _set_duplicate_email_tests_add_personas_data_free (gpointer _data);
static gboolean _set_duplicate_email_tests_add_personas_co (SetDuplicateEmailTestsAddPersonasData* data);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _set_duplicate_email_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void set_duplicate_email_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _set_duplicate_email_tests_test_set_duplicate_email_folks_test_case_test_method (gpointer self) {
	set_duplicate_email_tests_test_set_duplicate_email (self);
}


SetDuplicateEmailTests* set_duplicate_email_tests_construct (GType object_type) {
	SetDuplicateEmailTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (SetDuplicateEmailTests*) folks_test_case_construct (object_type, "SetDuplicateEmailTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test re-setting an existing e-mail address", _set_duplicate_email_tests_test_set_duplicate_email_folks_test_case_test_method, self);
	return self;
}


SetDuplicateEmailTests* set_duplicate_email_tests_new (void) {
	return set_duplicate_email_tests_construct (TYPE_SET_DUPLICATE_EMAIL_TESTS);
}


static void set_duplicate_email_tests_real_set_up (FolksTestCase* base) {
	SetDuplicateEmailTests * self;
	self = (SetDuplicateEmailTests*) base;
}


static void set_duplicate_email_tests_real_tear_down (FolksTestCase* base) {
	SetDuplicateEmailTests * self;
	self = (SetDuplicateEmailTests*) base;
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
}


static gboolean _lambda0_ (SetDuplicateEmailTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void set_duplicate_email_tests_test_set_duplicate_email (SetDuplicateEmailTests* self) {
	GMainLoop* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	self->priv->_email_found = FALSE;
	_set_duplicate_email_tests_test_set_duplicate_email_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_email_found == TRUE);
}


static void _set_duplicate_email_tests_test_set_duplicate_email_async_data_free (gpointer _data) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _set_duplicate_email_tests_test_set_duplicate_email_async (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_;
	_data_ = g_slice_new0 (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _set_duplicate_email_tests_test_set_duplicate_email_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _set_duplicate_email_tests_test_set_duplicate_email_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_set_duplicate_email_tests_test_set_duplicate_email_async_co (_data_);
}


static void _set_duplicate_email_tests_test_set_duplicate_email_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _set_duplicate_email_tests_test_set_duplicate_email_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_set_duplicate_email_tests_test_set_duplicate_email_async_co (data);
}


static void __set_duplicate_email_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_set_duplicate_email_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static void __set_duplicate_email_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_set_duplicate_email_tests_notify_pstore_cb (self, _sender, pspec);
}


static gboolean _set_duplicate_email_tests_test_set_duplicate_email_async_co (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _set_duplicate_email_tests_test_set_duplicate_email_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __set_duplicate_email_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _set_duplicate_email_tests_test_set_duplicate_email_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (data->self->priv->_pstore);
	data->self->priv->_pstore = NULL;
	{
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_map_get_values (data->_tmp2_);
		data->_tmp4_ = data->_tmp3_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_iterable_iterator ((GeeIterable*) data->_tmp4_);
		data->_tmp6_ = data->_tmp5_;
		_g_object_unref0 (data->_tmp4_);
		data->_backend_it = data->_tmp6_;
		while (TRUE) {
			data->_tmp7_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp7_) {
				break;
			}
			data->_tmp8_ = NULL;
			data->_tmp8_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp8_;
			data->_tmp9_ = NULL;
			data->_tmp9_ = folks_backend_get_persona_stores (data->backend);
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_map_get (data->_tmp9_, "tracker");
			_g_object_unref0 (data->self->priv->_pstore);
			data->self->priv->_pstore = TRF_PERSONA_STORE ((FolksPersonaStore*) data->_tmp10_);
			if (data->self->priv->_pstore != NULL) {
				_g_object_unref0 (data->backend);
				break;
			}
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	g_assert (data->self->priv->_pstore != NULL);
	g_signal_connect_object ((GObject*) data->self->priv->_pstore, "notify::is-prepared", (GCallback) __set_duplicate_email_tests_notify_pstore_cb_g_object_notify, data->self, 0);
	_set_duplicate_email_tests_try_to_add (data->self, NULL, NULL);
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("set-duplicate-email.vala:100: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _set_duplicate_email_tests_individuals_changed_cb (SetDuplicateEmailTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (_tmp3_, self->priv->_persona_fullname_1) == 0) {
				_set_duplicate_email_tests_reset_email_address (self, i);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp4_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp4_ == 0);
}


static void __set_duplicate_email_tests_email_addresses_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_set_duplicate_email_tests_email_addresses_cb (self, _sender, pspec);
}


static void _set_duplicate_email_tests_reset_email_address (SetDuplicateEmailTests* self, FolksIndividual* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	{
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = folks_individual_get_personas (i);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			FolksPersona* p;
			gboolean _tmp4_;
			_tmp2_ = gee_iterator_next (_p_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp3_;
			_tmp4_ = _set_duplicate_email_tests_has_email (self, TRF_PERSONA (p), self->priv->_email_1);
			if (_tmp4_) {
				GeeHashSet* _tmp5_ = NULL;
				GeeHashSet* emails1;
				FolksFieldDetails* _tmp6_ = NULL;
				FolksFieldDetails* email_1;
				_tmp5_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				emails1 = _tmp5_;
				_tmp6_ = folks_field_details_new (self->priv->_email_1);
				email_1 = _tmp6_;
				gee_abstract_collection_add ((GeeAbstractCollection*) emails1, email_1);
				folks_email_details_set_email_addresses (FOLKS_EMAIL_DETAILS (p), (GeeSet*) emails1);
				g_signal_connect_object ((GObject*) p, "notify::email-addresses", (GCallback) __set_duplicate_email_tests_email_addresses_cb_g_object_notify, self, 0);
				_g_object_unref0 (email_1);
				_g_object_unref0 (emails1);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


static void _set_duplicate_email_tests_email_addresses_cb (SetDuplicateEmailTests* self, GObject* p, GParamSpec* ps) {
	TrfPersona* _tmp0_;
	TrfPersona* persona;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (TRF_PERSONA (p));
	persona = _tmp0_;
	_tmp1_ = _set_duplicate_email_tests_has_email (self, persona, self->priv->_email_1);
	if (_tmp1_) {
		self->priv->_email_found = TRUE;
		g_main_loop_quit (self->priv->_main_loop);
	}
	_g_object_unref0 (persona);
}


static gboolean _set_duplicate_email_tests_has_email (SetDuplicateEmailTests* self, TrfPersona* persona, const gchar* email) {
	gboolean result = FALSE;
	GeeSet* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (persona != NULL, FALSE);
	g_return_val_if_fail (email != NULL, FALSE);
	_tmp0_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) persona);
	if (_tmp0_ != NULL) {
		{
			GeeSet* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _fd_it;
			_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) persona);
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_fd_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_;
				gpointer _tmp4_ = NULL;
				FolksFieldDetails* fd;
				const gchar* _tmp5_ = NULL;
				_tmp3_ = gee_iterator_next (_fd_it);
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = gee_iterator_get (_fd_it);
				fd = (FolksFieldDetails*) _tmp4_;
				_tmp5_ = folks_field_details_get_value (fd);
				if (g_strcmp0 (_tmp5_, email) == 0) {
					result = TRUE;
					_g_object_unref0 (fd);
					_g_object_unref0 (_fd_it);
					return result;
				}
				_g_object_unref0 (fd);
			}
			_g_object_unref0 (_fd_it);
		}
	}
	result = FALSE;
	return result;
}


static void _set_duplicate_email_tests_notify_pstore_cb (SetDuplicateEmailTests* self, GObject* _pstore, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_pstore != NULL);
	g_return_if_fail (ps != NULL);
	_set_duplicate_email_tests_try_to_add (self, NULL, NULL);
}


static void _set_duplicate_email_tests_try_to_add_data_free (gpointer _data) {
	SetDuplicateEmailTestsTryToAddData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SetDuplicateEmailTestsTryToAddData, data);
}


static void _set_duplicate_email_tests_try_to_add (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SetDuplicateEmailTestsTryToAddData* _data_;
	_data_ = g_slice_new0 (SetDuplicateEmailTestsTryToAddData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _set_duplicate_email_tests_try_to_add);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _set_duplicate_email_tests_try_to_add_data_free);
	_data_->self = _g_object_ref0 (self);
	_set_duplicate_email_tests_try_to_add_co (_data_);
}


static void _set_duplicate_email_tests_try_to_add_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_) {
	SetDuplicateEmailTestsTryToAddData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _set_duplicate_email_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SetDuplicateEmailTestsTryToAddData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_set_duplicate_email_tests_try_to_add_co (data);
}


static gboolean _set_duplicate_email_tests_try_to_add_co (SetDuplicateEmailTestsTryToAddData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__added_personas);
		data->_tmp1_ = folks_persona_store_get_is_prepared ((FolksPersonaStore*) data->self->priv->_pstore);
		if (data->_tmp1_) {
			data->_tmp0_ = data->self->priv->_added_personas == FALSE;
		} else {
			data->_tmp0_ = FALSE;
		}
		if (data->_tmp0_) {
			data->self->priv->_added_personas = TRUE;
			data->_state_ = 1;
			_set_duplicate_email_tests_add_personas (data->self, _set_duplicate_email_tests_try_to_add_ready, data);
			return FALSE;
			_state_1:
			_set_duplicate_email_tests_add_personas_finish (data->self, data->_res_);
		}
		__finally1:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__added_personas);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _set_duplicate_email_tests_add_personas_data_free (gpointer _data) {
	SetDuplicateEmailTestsAddPersonasData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SetDuplicateEmailTestsAddPersonasData, data);
}


static void _set_duplicate_email_tests_add_personas (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SetDuplicateEmailTestsAddPersonasData* _data_;
	_data_ = g_slice_new0 (SetDuplicateEmailTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _set_duplicate_email_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _set_duplicate_email_tests_add_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_set_duplicate_email_tests_add_personas_co (_data_);
}


static void _set_duplicate_email_tests_add_personas_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_) {
	SetDuplicateEmailTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add 1 persona and once we've seen it try to re-set it's
   * e-mail address (the Tracker backend should figure it already
   * exist so we don't bump into a constraint error).
   * See https://bugzilla.gnome.org/show_bug.cgi?id=647331 */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _set_duplicate_email_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SetDuplicateEmailTestsAddPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_set_duplicate_email_tests_add_personas_co (data);
}


static gboolean _set_duplicate_email_tests_add_personas_co (SetDuplicateEmailTestsAddPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details1 = data->_tmp0_;
	memset (&data->_tmp1_, 0, sizeof (GValue));
	g_value_init (&data->_tmp1_, G_TYPE_STRING);
	memset (&data->_tmp2_, 0, sizeof (GValue));
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = __g_value_dup0 (&data->_tmp3_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp4_;
	G_IS_VALUE (&data->_tmp3_) ? (g_value_unset (&data->_tmp3_), NULL) : NULL;
	g_value_set_string (data->val, data->self->priv->_persona_fullname_1);
	data->_tmp5_ = NULL;
	data->_tmp5_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp6_ = g_strdup (data->_tmp5_);
	data->_tmp7_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details1, data->_tmp6_, data->_tmp7_);
	memset (&data->_tmp8_, 0, sizeof (GValue));
	g_value_init (&data->_tmp8_, GEE_TYPE_SET);
	memset (&data->_tmp9_, 0, sizeof (GValue));
	data->_tmp9_ = data->_tmp8_;
	data->_tmp10_ = data->_tmp9_;
	data->_tmp11_ = __g_value_dup0 (&data->_tmp10_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp11_;
	G_IS_VALUE (&data->_tmp10_) ? (g_value_unset (&data->_tmp10_), NULL) : NULL;
	data->_tmp12_ = NULL;
	data->_tmp12_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->emails1 = data->_tmp12_;
	data->_tmp13_ = NULL;
	data->_tmp13_ = folks_field_details_new (data->self->priv->_email_1);
	data->email_1 = data->_tmp13_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->emails1, data->email_1);
	g_value_set_object (data->val, (GObject*) data->emails1);
	data->_tmp14_ = NULL;
	data->_tmp14_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
	data->_tmp15_ = g_strdup (data->_tmp14_);
	data->_tmp16_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details1, data->_tmp15_, data->_tmp16_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details1, _set_duplicate_email_tests_add_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp17_ = NULL;
	data->_tmp17_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp18_ = data->_tmp17_;
	_g_object_unref0 (data->_tmp18_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch2_folks_individual_aggregator_error;
		}
		_g_object_unref0 (data->email_1);
		_g_object_unref0 (data->emails1);
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally2;
	__catch2_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("set-duplicate-email.vala:212: [AddPersonaError] add_persona_from_detai" \
"ls: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->email_1);
		_g_object_unref0 (data->emails1);
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->email_1);
	_g_object_unref0 (data->emails1);
	__vala_GValue_free0 (data->val);
	_g_hash_table_unref0 (data->details1);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void set_duplicate_email_tests_class_init (SetDuplicateEmailTestsClass * klass) {
	set_duplicate_email_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetDuplicateEmailTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = set_duplicate_email_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = set_duplicate_email_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = set_duplicate_email_tests_finalize;
}


static void set_duplicate_email_tests_instance_init (SetDuplicateEmailTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SET_DUPLICATE_EMAIL_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("persona #1");
	self->priv->_persona_fullname_1 = _tmp0_;
	_tmp1_ = g_strdup ("some-address@example.org");
	self->priv->_email_1 = _tmp1_;
	g_static_rec_mutex_init (&self->priv->__lock__added_personas);
	self->priv->_added_personas = FALSE;
}


static void set_duplicate_email_tests_finalize (GObject* obj) {
	SetDuplicateEmailTests * self;
	self = SET_DUPLICATE_EMAIL_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_email_1);
	g_static_rec_mutex_free (&self->priv->__lock__added_personas);
	_g_object_unref0 (self->priv->_pstore);
	G_OBJECT_CLASS (set_duplicate_email_tests_parent_class)->finalize (obj);
}


GType set_duplicate_email_tests_get_type (void) {
	static volatile gsize set_duplicate_email_tests_type_id__volatile = 0;
	if (g_once_init_enter (&set_duplicate_email_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetDuplicateEmailTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) set_duplicate_email_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetDuplicateEmailTests), 0, (GInstanceInitFunc) set_duplicate_email_tests_instance_init, NULL };
		GType set_duplicate_email_tests_type_id;
		set_duplicate_email_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "SetDuplicateEmailTests", &g_define_type_info, 0);
		g_once_init_leave (&set_duplicate_email_tests_type_id__volatile, set_duplicate_email_tests_type_id);
	}
	return set_duplicate_email_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	SetDuplicateEmailTests* _tmp1_ = NULL;
	SetDuplicateEmailTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = set_duplicate_email_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



