/* swf-persona.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from swf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>


#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
typedef struct _SwfPersonaPrivate SwfPersonaPrivate;
#define __vala_SwContact_free0(var) ((var == NULL) ? NULL : (var = (_vala_SwContact_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;

struct _SwfPersona {
	FolksPersona parent_instance;
	SwfPersonaPrivate * priv;
};

struct _SwfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _SwfPersonaPrivate {
	GLoadableIcon* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksGender _gender;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashMultiMap* _im_addresses;
	GeeHashMultiMap* _web_service_addresses;
	SwContact* _lsw_contact;
};


static gpointer swf_persona_parent_class = NULL;
static FolksAvatarDetailsIface* swf_persona_folks_avatar_details_parent_iface = NULL;
static FolksGenderDetailsIface* swf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* swf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* swf_persona_folks_name_details_parent_iface = NULL;
static FolksUrlDetailsIface* swf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* swf_persona_folks_web_service_details_parent_iface = NULL;

GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA, SwfPersonaPrivate))
enum  {
	SWF_PERSONA_DUMMY_PROPERTY,
	SWF_PERSONA_LINKABLE_PROPERTIES,
	SWF_PERSONA_WRITEABLE_PROPERTIES,
	SWF_PERSONA_AVATAR,
	SWF_PERSONA_STRUCTURED_NAME,
	SWF_PERSONA_FULL_NAME,
	SWF_PERSONA_NICKNAME,
	SWF_PERSONA_GENDER,
	SWF_PERSONA_URLS,
	SWF_PERSONA_IM_ADDRESSES,
	SWF_PERSONA_WEB_SERVICE_ADDRESSES,
	SWF_PERSONA_LSW_CONTACT
};
static void _vala_SwContact_free (SwContact* self);
static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key);
gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
GType swf_persona_store_get_type (void) G_GNUC_CONST;
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* swf_persona_get_contact_id (SwContact* contact);
static void swf_persona_set_lsw_contact (SwfPersona* self, SwContact* value);
void swf_persona_update (SwfPersona* self, SwContact* contact);
SwContact* swf_persona_get_lsw_contact (SwfPersona* self);
static void swf_persona_finalize (GObject* obj);
static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SWF_PERSONA__linkable_properties[2] = {"im-addresses", "web-service-addresses"};
static const gchar* SWF_PERSONA__writeable_properties[0] = {};

static void _vala_SwContact_free (SwContact* self) {
	g_boxed_free (sw_contact_get_type (), self);
}


static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key) {
	guint result;
	result = folks_abstract_field_details_hash (key);
	return result;
}


/**
   * Build the Facebook JID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return the Facebook JID or null if it is not a Facebook contact
   *
   * @since 0.5.0
   */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp4_;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (lsw_id != NULL, NULL);
	facebook_jid = NULL;
	_tmp1_ = store_id;
	if (g_strcmp0 (_tmp1_, "facebook") == 0) {
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = lsw_id;
		_tmp3_ = string_contains (_tmp2_, "facebook-");
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = lsw_id;
		_tmp6_ = string_replace (_tmp5_, "facebook", "");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "@chat.facebook.com", NULL);
		_g_free0 (facebook_jid);
		facebook_jid = _tmp8_;
		_g_free0 (_tmp7_);
	}
	result = facebook_jid;
	return result;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gchar* iid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (lsw_id != NULL, NULL);
	facebook_jid = NULL;
	_tmp0_ = store_id;
	_tmp1_ = lsw_id;
	_tmp2_ = _swf_persona_build_facebook_jid (_tmp0_, _tmp1_);
	_g_free0 (facebook_jid);
	facebook_jid = _tmp2_;
	_tmp3_ = facebook_jid;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = facebook_jid;
		_tmp5_ = g_strconcat ("jabber:", _tmp4_, NULL);
		_g_free0 (iid);
		iid = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = store_id;
		_tmp7_ = g_strconcat (_tmp6_, ":", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = lsw_id;
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
		_g_free0 (iid);
		iid = _tmp10_;
		_g_free0 (_tmp8_);
	}
	result = iid;
	_g_free0 (facebook_jid);
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the libsocialweb contact given by `contact`.
   */
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact) {
	SwfPersona * self = NULL;
	SwContact* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	SwContact* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* service;
	SwfPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* uid;
	SwfPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* iid;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	SwfPersonaStore* _tmp18_;
	SwContact* _tmp19_;
	const gchar* _tmp20_;
	SwfPersonaStore* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	SwfPersonaStore* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* facebook_jid;
	const gchar* _tmp30_;
	GeeHashMultiMap* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	FolksWebServiceFieldDetails* _tmp53_;
	FolksWebServiceFieldDetails* _tmp54_;
	SwContact* _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = swf_persona_get_contact_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = _tmp2_->service;
	_tmp4_ = g_strdup (_tmp3_);
	service = _tmp4_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = id;
	_tmp9_ = folks_persona_build_uid (BACKEND_NAME, _tmp7_, _tmp8_);
	uid = _tmp9_;
	_tmp10_ = store;
	_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = id;
	_tmp14_ = _swf_persona_build_iid (_tmp12_, _tmp13_);
	iid = _tmp14_;
	_tmp15_ = id;
	_tmp16_ = uid;
	_tmp17_ = iid;
	_tmp18_ = store;
	self = (SwfPersona*) g_object_new (object_type, "display-id", _tmp15_, "uid", _tmp16_, "iid", _tmp17_, "store", _tmp18_, "is-user", FALSE, NULL);
	_tmp19_ = contact;
	swf_persona_set_lsw_contact (self, _tmp19_);
	_tmp20_ = uid;
	_tmp21_ = store;
	_tmp22_ = folks_persona_store_get_display_name ((FolksPersonaStore*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = id;
	g_debug ("swf-persona.vala:234: Creating new Sw.Persona '%s' for %s UID '%s': %p", _tmp20_, _tmp23_, _tmp24_, self);
	_tmp25_ = store;
	_tmp26_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = id;
	_tmp29_ = _swf_persona_build_facebook_jid (_tmp27_, _tmp28_);
	facebook_jid = _tmp29_;
	_tmp30_ = facebook_jid;
	if (_tmp30_ != NULL) {
		{
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* facebook_jid_copy;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* normalised_addr;
			gchar* _tmp42_;
			gchar* im_proto;
			const gchar* _tmp43_;
			FolksImFieldDetails* _tmp44_;
			FolksImFieldDetails* im_fd;
			GeeHashMultiMap* _tmp45_;
			const gchar* _tmp46_;
			FolksImFieldDetails* _tmp47_;
			_tmp31_ = facebook_jid;
			_tmp32_ = g_strdup (_tmp31_);
			facebook_jid_copy = _tmp32_;
			_tmp33_ = facebook_jid_copy;
			facebook_jid_copy = NULL;
			_tmp34_ = _tmp33_;
			_tmp35_ = folks_im_details_normalise_im_address (_tmp34_, "jabber", &_inner_error_);
			_tmp36_ = _tmp35_;
			_g_free0 (_tmp34_);
			_tmp37_ = _tmp36_;
			if (_inner_error_ != NULL) {
				_g_free0 (facebook_jid_copy);
				if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
					goto __catch1_folks_im_details_error;
				}
				_g_free0 (facebook_jid_copy);
				_g_free0 (facebook_jid);
				_g_free0 (iid);
				_g_free0 (uid);
				_g_free0 (service);
				_g_free0 (id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_;
			_tmp39_ = NULL;
			_tmp41_ = _tmp40_;
			_g_free0 (_tmp39_);
			normalised_addr = _tmp41_;
			_tmp42_ = g_strdup ("jabber");
			im_proto = _tmp42_;
			_tmp43_ = normalised_addr;
			_tmp44_ = folks_im_field_details_new (_tmp43_, NULL);
			im_fd = _tmp44_;
			_tmp45_ = self->priv->_im_addresses;
			_tmp46_ = im_proto;
			_tmp47_ = im_fd;
			gee_multi_map_set ((GeeMultiMap*) _tmp45_, _tmp46_, _tmp47_);
			_g_object_unref0 (im_fd);
			_g_free0 (im_proto);
			_g_free0 (normalised_addr);
			_g_free0 (facebook_jid_copy);
		}
		goto __finally1;
		__catch1_folks_im_details_error:
		{
			GError* e = NULL;
			GError* _tmp48_;
			const gchar* _tmp49_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp48_ = e;
			_tmp49_ = _tmp48_->message;
			g_warning ("swf-persona.vala:252: %s", _tmp49_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (facebook_jid);
			_g_free0 (iid);
			_g_free0 (uid);
			_g_free0 (service);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp50_ = self->priv->_web_service_addresses;
	_tmp51_ = service;
	_tmp52_ = id;
	_tmp53_ = folks_web_service_field_details_new (_tmp52_, NULL);
	_tmp54_ = _tmp53_;
	gee_multi_map_set ((GeeMultiMap*) _tmp50_, _tmp51_, _tmp54_);
	_g_object_unref0 (_tmp54_);
	_tmp55_ = contact;
	swf_persona_update (self, _tmp55_);
	_g_free0 (facebook_jid);
	_g_free0 (iid);
	_g_free0 (uid);
	_g_free0 (service);
	_g_free0 (id);
	return self;
}


SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact) {
	return swf_persona_construct (SWF_TYPE_PERSONA, store, contact);
}


gchar* swf_persona_get_contact_id (SwContact* contact) {
	gchar* result = NULL;
	SwContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = sw_contact_get_value (_tmp0_, "id");
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void swf_persona_update (SwfPersona* self, SwContact* contact) {
	SwContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* nickname;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp7_;
	SwContact* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* avatar_path;
	const gchar* _tmp13_;
	SwContact* _tmp28_;
	const gchar* _tmp29_ = NULL;
	SwContact* _tmp30_;
	const gchar* _tmp31_ = NULL;
	FolksStructuredName* _tmp32_;
	FolksStructuredName* structured_name;
	FolksStructuredName* _tmp33_;
	gboolean _tmp34_ = FALSE;
	SwContact* _tmp38_;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gchar* full_name;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GeeHashSet* _tmp45_;
	GeeHashSet* urls;
	SwContact* _tmp46_;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_;
	gchar* website;
	const gchar* _tmp49_;
	GeeSet* _tmp54_;
	GeeSet* _tmp55_;
	GeeHashSet* _tmp56_;
	SwContact* _tmp58_;
	const gchar* _tmp59_ = NULL;
	gchar* _tmp60_;
	gchar* gender_string;
	FolksGender gender = 0;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	gboolean _tmp66_;
	FolksGender _tmp73_;
	FolksGender _tmp74_;
	FolksGender _tmp75_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = contact;
	_tmp1_ = sw_contact_get_value (_tmp0_, "name");
	_tmp2_ = g_strdup (_tmp1_);
	nickname = _tmp2_;
	_tmp4_ = nickname;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->_nickname;
		_tmp6_ = nickname;
		_tmp3_ = g_strcmp0 (_tmp5_, _tmp6_) != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = nickname;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp9_;
		g_object_notify ((GObject*) self, "nickname");
	}
	_tmp10_ = contact;
	_tmp11_ = sw_contact_get_value (_tmp10_, "icon");
	_tmp12_ = g_strdup (_tmp11_);
	avatar_path = _tmp12_;
	_tmp13_ = avatar_path;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_;
		GFileIcon* _tmp17_;
		GFileIcon* _tmp18_;
		GFileIcon* icon;
		gboolean _tmp19_ = FALSE;
		GLoadableIcon* _tmp20_;
		GLoadableIcon* _tmp21_;
		gboolean _tmp26_;
		_tmp14_ = avatar_path;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = (GFileIcon*) g_file_icon_new (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		icon = _tmp18_;
		_tmp20_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
		_tmp21_ = _tmp20_;
		if (_tmp21_ == NULL) {
			_tmp19_ = TRUE;
		} else {
			GLoadableIcon* _tmp22_;
			GLoadableIcon* _tmp23_;
			GFileIcon* _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp22_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = icon;
			_tmp25_ = g_icon_equal ((GIcon*) _tmp23_, (GIcon*) _tmp24_);
			_tmp19_ = !_tmp25_;
		}
		_tmp26_ = _tmp19_;
		if (_tmp26_) {
			GFileIcon* _tmp27_;
			_tmp27_ = icon;
			folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, (GLoadableIcon*) _tmp27_);
		}
		_g_object_unref0 (icon);
	} else {
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, NULL);
	}
	_tmp28_ = contact;
	_tmp29_ = sw_contact_get_value (_tmp28_, "n.family");
	_tmp30_ = contact;
	_tmp31_ = sw_contact_get_value (_tmp30_, "n.given");
	_tmp32_ = folks_structured_name_new_simple (_tmp29_, _tmp31_);
	structured_name = _tmp32_;
	_tmp33_ = structured_name;
	_tmp34_ = folks_structured_name_is_empty (_tmp33_);
	if (!_tmp34_) {
		FolksStructuredName* _tmp35_;
		_tmp35_ = structured_name;
		folks_name_details_set_structured_name ((FolksNameDetails*) self, _tmp35_);
	} else {
		FolksStructuredName* _tmp36_;
		FolksStructuredName* _tmp37_;
		_tmp36_ = folks_name_details_get_structured_name ((FolksNameDetails*) self);
		_tmp37_ = _tmp36_;
		if (_tmp37_ != NULL) {
			folks_name_details_set_structured_name ((FolksNameDetails*) self, NULL);
		}
	}
	_tmp38_ = contact;
	_tmp39_ = sw_contact_get_value (_tmp38_, "fn");
	_tmp40_ = g_strdup (_tmp39_);
	full_name = _tmp40_;
	_tmp41_ = folks_name_details_get_full_name ((FolksNameDetails*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = full_name;
	if (g_strcmp0 (_tmp42_, _tmp43_) != 0) {
		const gchar* _tmp44_;
		_tmp44_ = full_name;
		folks_name_details_set_full_name ((FolksNameDetails*) self, _tmp44_);
	}
	_tmp45_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	urls = _tmp45_;
	_tmp46_ = contact;
	_tmp47_ = sw_contact_get_value (_tmp46_, "url");
	_tmp48_ = g_strdup (_tmp47_);
	website = _tmp48_;
	_tmp49_ = website;
	if (_tmp49_ != NULL) {
		GeeHashSet* _tmp50_;
		const gchar* _tmp51_;
		FolksUrlFieldDetails* _tmp52_;
		FolksUrlFieldDetails* _tmp53_;
		_tmp50_ = urls;
		_tmp51_ = website;
		_tmp52_ = folks_url_field_details_new (_tmp51_, NULL);
		_tmp53_ = _tmp52_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp53_);
		_g_object_unref0 (_tmp53_);
	}
	_tmp54_ = folks_url_details_get_urls ((FolksUrlDetails*) self);
	_tmp55_ = _tmp54_;
	_tmp56_ = urls;
	if (_tmp55_ != _tmp56_) {
		GeeHashSet* _tmp57_;
		_tmp57_ = urls;
		folks_url_details_set_urls ((FolksUrlDetails*) self, (GeeSet*) _tmp57_);
	}
	_tmp58_ = contact;
	_tmp59_ = sw_contact_get_value (_tmp58_, "x-gender");
	_tmp60_ = g_strdup (_tmp59_);
	gender_string = _tmp60_;
	_tmp62_ = gender_string;
	if (_tmp62_ != NULL) {
		const gchar* _tmp63_;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_;
		_tmp63_ = gender_string;
		_tmp64_ = g_utf8_strdown (_tmp63_, (gssize) (-1));
		_tmp65_ = _tmp64_;
		_tmp61_ = g_strcmp0 (_tmp65_, "male") == 0;
		_g_free0 (_tmp65_);
	} else {
		_tmp61_ = FALSE;
	}
	_tmp66_ = _tmp61_;
	if (_tmp66_) {
		gender = FOLKS_GENDER_MALE;
	} else {
		gboolean _tmp67_ = FALSE;
		const gchar* _tmp68_;
		gboolean _tmp72_;
		_tmp68_ = gender_string;
		if (_tmp68_ != NULL) {
			const gchar* _tmp69_;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			_tmp69_ = gender_string;
			_tmp70_ = g_utf8_strdown (_tmp69_, (gssize) (-1));
			_tmp71_ = _tmp70_;
			_tmp67_ = g_strcmp0 (_tmp71_, "female") == 0;
			_g_free0 (_tmp71_);
		} else {
			_tmp67_ = FALSE;
		}
		_tmp72_ = _tmp67_;
		if (_tmp72_) {
			gender = FOLKS_GENDER_FEMALE;
		} else {
			gender = FOLKS_GENDER_UNSPECIFIED;
		}
	}
	_tmp73_ = folks_gender_details_get_gender ((FolksGenderDetails*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = gender;
	if (_tmp74_ != _tmp75_) {
		FolksGender _tmp76_;
		_tmp76_ = gender;
		folks_gender_details_set_gender ((FolksGenderDetails*) self, _tmp76_);
	}
	_g_free0 (gender_string);
	_g_free0 (website);
	_g_object_unref0 (urls);
	_g_free0 (full_name);
	_g_object_unref0 (structured_name);
	_g_free0 (avatar_path);
	_g_free0 (nickname);
}


static gchar** swf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (SwfPersona*) base;
	_tmp0_ = SWF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (SWF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** swf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (SwfPersona*) base;
	_tmp0_ = SWF_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (SWF_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GLoadableIcon* swf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	SwfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void swf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	SwfPersona* self;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject *) self, "avatar");
}


static FolksStructuredName* swf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
	FolksStructuredName* _tmp1_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_structured_name);
	self->priv->_structured_name = _tmp1_;
	g_object_notify ((GObject *) self, "structured-name");
}


static const gchar* swf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	const gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp1_;
	g_object_notify ((GObject *) self, "full-name");
}


static const gchar* swf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	const gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	self = (SwfPersona*) base;
	g_object_notify ((GObject *) self, "nickname");
}


static FolksGender swf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	SwfPersona* self;
	FolksGender _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_gender;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	SwfPersona* self;
	FolksGender _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	self->priv->_gender = _tmp0_;
	g_object_notify ((GObject *) self, "gender");
}


static GeeSet* swf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	SwfPersona* self;
	GeeSet* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	SwfPersona* self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	self = (SwfPersona*) base;
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp0_;
	_tmp1_ = self->priv->_urls;
	_tmp2_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp3_;
	{
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _url_fd_it;
		_tmp4_ = value;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_url_fd_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			FolksUrlFieldDetails* url_fd;
			GeeHashSet* _tmp10_;
			FolksUrlFieldDetails* _tmp11_;
			_tmp6_ = _url_fd_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _url_fd_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			url_fd = (FolksUrlFieldDetails*) _tmp9_;
			_tmp10_ = self->priv->_urls;
			_tmp11_ = url_fd;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			_g_object_unref0 (url_fd);
		}
		_g_object_unref0 (_url_fd_it);
	}
	g_object_notify ((GObject *) self, "urls");
}


static GeeMultiMap* swf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void swf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	self = (SwfPersona*) base;
	g_object_notify ((GObject *) self, "im-addresses");
}


static GeeMultiMap* swf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_web_service_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void swf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	self = (SwfPersona*) base;
	g_object_notify ((GObject *) self, "web-service-addresses");
}


SwContact* swf_persona_get_lsw_contact (SwfPersona* self) {
	SwContact* result;
	SwContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lsw_contact;
	result = _tmp0_;
	return result;
}


static void swf_persona_set_lsw_contact (SwfPersona* self, SwContact* value) {
	gboolean _tmp0_ = FALSE;
	SwContact* _tmp1_;
	gboolean _tmp4_;
	SwContact* _tmp6_;
	SwContact* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_lsw_contact;
	if (_tmp1_ != NULL) {
		SwContact* _tmp2_;
		SwContact* _tmp3_;
		_tmp2_ = self->priv->_lsw_contact;
		_tmp3_ = value;
		_tmp0_ = _tmp2_ != _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		SwContact* _tmp5_;
		_tmp5_ = self->priv->_lsw_contact;
		sw_contact_unref (_tmp5_);
	}
	_tmp6_ = value;
	_tmp7_ = sw_contact_ref (_tmp6_);
	__vala_SwContact_free0 (self->priv->_lsw_contact);
	self->priv->_lsw_contact = _tmp7_;
	g_object_notify ((GObject *) self, "lsw-contact");
}


static void swf_persona_class_init (SwfPersonaClass * klass) {
	swf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = swf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = swf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_swf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = swf_persona_finalize;
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STRUCTURED_NAME, "structured-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_FULL_NAME, "full-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_NICKNAME, "nickname");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_GENDER, "gender");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_URLS, "urls");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
	/**
	   * The Contact from libsocialweb
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LSW_CONTACT, g_param_spec_boxed ("lsw-contact", "lsw-contact", "lsw-contact", sw_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void swf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	swf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = swf_persona_real_get_avatar;
	iface->set_avatar = swf_persona_real_set_avatar;
}


static void swf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	swf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_gender = swf_persona_real_get_gender;
	iface->set_gender = swf_persona_real_set_gender;
}


static void swf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	swf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = swf_persona_real_get_im_addresses;
	iface->set_im_addresses = swf_persona_real_set_im_addresses;
}


static void swf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	swf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = swf_persona_real_get_structured_name;
	iface->set_structured_name = swf_persona_real_set_structured_name;
	iface->get_full_name = swf_persona_real_get_full_name;
	iface->set_full_name = swf_persona_real_set_full_name;
	iface->get_nickname = swf_persona_real_get_nickname;
	iface->set_nickname = swf_persona_real_set_nickname;
}


static void swf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	swf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = swf_persona_real_get_urls;
	iface->set_urls = swf_persona_real_set_urls;
}


static void swf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	swf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_web_service_addresses = swf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = swf_persona_real_set_web_service_addresses;
}


static void swf_persona_instance_init (SwfPersona * self) {
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	self->priv = SWF_PERSONA_GET_PRIVATE (self);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, _folks_abstract_field_details_hash_ghash_func, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_im_addresses = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_web_service_addresses = _tmp1_;
}


static void swf_persona_finalize (GObject* obj) {
	SwfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SwContact* _tmp2_;
	self = SWF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("swf-persona.vala:264: Destroying Sw.Persona '%s': %p", _tmp1_, self);
	_tmp2_ = self->priv->_lsw_contact;
	sw_contact_unref (_tmp2_);
	__vala_SwContact_free0 (self->priv->_lsw_contact);
	self->priv->_lsw_contact = NULL;
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_web_service_addresses);
	__vala_SwContact_free0 (self->priv->_lsw_contact);
	G_OBJECT_CLASS (swf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single libsocialweb contact.
 */
GType swf_persona_get_type (void) {
	static volatile gsize swf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersona), 0, (GInstanceInitFunc) swf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) swf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) swf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) swf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) swf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) swf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) swf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType swf_persona_type_id;
		swf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "SwfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&swf_persona_type_id__volatile, swf_persona_type_id);
	}
	return swf_persona_type_id__volatile;
}


static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
	switch (property_id) {
		case SWF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case SWF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case SWF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case SWF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case SWF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case SWF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		case SWF_PERSONA_LSW_CONTACT:
		g_value_set_boxed (value, swf_persona_get_lsw_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
	switch (property_id) {
		case SWF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case SWF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case SWF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case SWF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_LSW_CONTACT:
		swf_persona_set_lsw_contact (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



