/* backend.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors :Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdio.h>
#include <gio/gio.h>
#include <folks/folks-tracker.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TEST_TYPE_BACKEND (tracker_test_backend_get_type ())
#define TRACKER_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend))
#define TRACKER_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))
#define TRACKER_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))

typedef struct _TrackerTestBackend TrackerTestBackend;
typedef struct _TrackerTestBackendClass TrackerTestBackendClass;
typedef struct _TrackerTestBackendPrivate TrackerTestBackendPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerTestParamSpecBackend TrackerTestParamSpecBackend;

typedef enum  {
	TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED
} TrackerTestBackendSetupError;
#define TRACKER_TEST_BACKEND_SETUP_ERROR tracker_test_backend_setup_error_quark ()
struct _TrackerTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerTestBackendPrivate * priv;
};

struct _TrackerTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerTestBackend *self);
};

struct _TrackerTestBackendPrivate {
	gboolean _debug;
	GList* _contacts;
	TrackerSparqlConnection* _connection;
};

struct _TrackerTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer tracker_test_backend_parent_class = NULL;

GQuark tracker_test_backend_setup_error_quark (void);
gpointer tracker_test_backend_ref (gpointer instance);
void tracker_test_backend_unref (gpointer instance);
GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_test_value_set_backend (GValue* value, gpointer v_object);
void tracker_test_value_take_backend (GValue* value, gpointer v_object);
gpointer tracker_test_value_get_backend (const GValue* value);
GType tracker_test_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendPrivate))
enum  {
	TRACKER_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define TRACKER_TEST_BACKEND_URN "urn:contact"
#define TRACKER_TEST_BACKEND_URLS "nco:urls"
TrackerTestBackend* tracker_test_backend_new (void);
TrackerTestBackend* tracker_test_backend_construct (GType object_type);
void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value);
void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c);
static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig);
void tracker_test_backend_tear_down (TrackerTestBackend* self);
void tracker_test_backend_reset (TrackerTestBackend* self);
void tracker_test_backend_set_up (TrackerTestBackend* self);
static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error);
static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error);
gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject);
static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query);
gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite);
gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id);
gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn);
gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c);
gboolean tracker_test_backend_get_debug (TrackerTestBackend* self);
static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact);
static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s);
static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1);
static void tracker_test_backend_finalize (TrackerTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark tracker_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("tracker_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


TrackerTestBackend* tracker_test_backend_construct (GType object_type) {
	TrackerTestBackend* self = NULL;
	self = (TrackerTestBackend*) g_type_create_instance (object_type);
	tracker_test_backend_set_debug (self, FALSE);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	self->priv->_contacts = NULL;
	return self;
}


TrackerTestBackend* tracker_test_backend_new (void) {
	return tracker_test_backend_construct (TRACKER_TEST_TYPE_BACKEND);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* contact;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = _tracker_test_backend_copy_hash_map (self, _tmp0_);
	contact = _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp3_);
	_g_object_unref0 (contact);
}


void tracker_test_backend_tear_down (TrackerTestBackend* self) {
	g_return_if_fail (self != NULL);
}


void tracker_test_backend_reset (TrackerTestBackend* self) {
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	self->priv->_contacts = NULL;
}


void tracker_test_backend_set_up (TrackerTestBackend* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		_tracker_test_backend_setup_connection (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
				goto __catch0_tracker_test_backend_setup_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tracker_test_backend_add_contacts (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
				goto __catch0_tracker_test_backend_setup_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_tracker_test_backend_setup_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("backend.vala:71: unable to create test data: %s\n", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject) {
	gboolean result = FALSE;
	static const char delete_query_t[] = "DELETE { %s %s ?a } WHERE " "{ ?p a nco:PersonContact " " ; %s ?a . FILTER(?p = %s ) } ";
	static const char update_query_t[] = "INSERT { %s %s '%s' } ";
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* delete_query;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* update_query;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contact_urn != NULL, FALSE);
	g_return_val_if_fail (predicate != NULL, FALSE);
	g_return_val_if_fail (literal_subject != NULL, FALSE);
	_tmp0_ = contact_urn;
	_tmp1_ = predicate;
	_tmp2_ = predicate;
	_tmp3_ = contact_urn;
	_tmp4_ = g_strdup_printf (delete_query_t, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	delete_query = _tmp4_;
	_tmp5_ = delete_query;
	_tmp6_ = _tracker_test_backend_do_update_query (self, _tmp5_);
	if (_tmp6_ == FALSE) {
		g_warning ("backend.vala:87: Couldn't delete the old triplet");
		result = FALSE;
		_g_free0 (delete_query);
		return result;
	}
	_tmp7_ = contact_urn;
	_tmp8_ = predicate;
	_tmp9_ = literal_subject;
	_tmp10_ = g_strdup_printf (update_query_t, _tmp7_, _tmp8_, _tmp9_);
	update_query = _tmp10_;
	_tmp11_ = update_query;
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
	if (_tmp12_ == FALSE) {
		g_warning ("backend.vala:95: Couldn't insert the triplet");
		result = FALSE;
		_g_free0 (update_query);
		_g_free0 (delete_query);
		return result;
	}
	result = TRUE;
	_g_free0 (update_query);
	_g_free0 (delete_query);
	return result;
}


gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* q;
	gboolean _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contact_urn != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	q = _tmp0_;
	_tmp1_ = is_favourite;
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = q;
		_tmp3_ = g_strconcat (_tmp2_, "INSERT { ", NULL);
		_g_free0 (q);
		q = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = q;
		_tmp5_ = g_strconcat (_tmp4_, "DELETE { ", NULL);
		_g_free0 (q);
		q = _tmp5_;
	}
	_tmp6_ = q;
	_tmp7_ = contact_urn;
	_tmp8_ = g_strconcat (_tmp7_, " nao:hasTag nao:predefined-tag-favorite } ", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
	_g_free0 (q);
	q = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = q;
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
	if (_tmp12_ == FALSE) {
		g_warning ("backend.vala:118: Couldn't change favourite status");
		result = FALSE;
		_g_free0 (q);
		return result;
	}
	result = TRUE;
	_g_free0 (q);
	return result;
}


gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* delete_query;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = g_strdup ("DELETE { ?p a nco:PersonContact } ");
	delete_query = _tmp0_;
	_tmp1_ = delete_query;
	_tmp2_ = g_strconcat (_tmp1_, "WHERE { ?p a nco:PersonContact . FILTER(tracker:id(?p) ", NULL);
	_g_free0 (delete_query);
	delete_query = _tmp2_;
	_tmp3_ = delete_query;
	_tmp4_ = tracker_id;
	_tmp5_ = g_strconcat ("= ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, ") } ", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp3_, _tmp8_, NULL);
	_g_free0 (delete_query);
	delete_query = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp10_ = delete_query;
	_tmp11_ = _tracker_test_backend_do_update_query (self, _tmp10_);
	if (_tmp11_ == FALSE) {
		g_warning ("backend.vala:133: Couldn't delete the contact");
		result = FALSE;
		_g_free0 (delete_query);
		return result;
	}
	result = TRUE;
	_g_free0 (delete_query);
	return result;
}


gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* _tmp0_;
	TrackerSparqlBuilder* builder;
	TrackerSparqlBuilder* _tmp1_;
	TrackerSparqlBuilder* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlBuilder* _tmp4_;
	const gchar* _tmp5_;
	TrackerSparqlBuilder* _tmp6_;
	const gchar* _tmp7_;
	TrackerSparqlBuilder* _tmp8_;
	TrackerSparqlBuilder* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subject_urn != NULL, FALSE);
	g_return_val_if_fail (pred != NULL, FALSE);
	g_return_val_if_fail (object_urn != NULL, FALSE);
	_tmp0_ = tracker_sparql_builder_new_update ();
	builder = _tmp0_;
	_tmp1_ = builder;
	tracker_sparql_builder_delete_open (_tmp1_, NULL);
	_tmp2_ = builder;
	_tmp3_ = subject_urn;
	tracker_sparql_builder_subject (_tmp2_, _tmp3_);
	_tmp4_ = builder;
	_tmp5_ = pred;
	tracker_sparql_builder_predicate (_tmp4_, _tmp5_);
	_tmp6_ = builder;
	_tmp7_ = object_urn;
	tracker_sparql_builder_object (_tmp6_, _tmp7_);
	_tmp8_ = builder;
	tracker_sparql_builder_delete_close (_tmp8_);
	_tmp9_ = builder;
	_tmp10_ = tracker_sparql_builder_get_result (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
	if (_tmp12_ == FALSE) {
		TrackerSparqlBuilder* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = builder;
		_tmp14_ = tracker_sparql_builder_get_result (_tmp13_);
		_tmp15_ = _tmp14_;
		g_warning ("backend.vala:152: Couldn't delete triplet with query: %s\n", _tmp15_);
		result = FALSE;
		_g_object_unref0 (builder);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (builder);
	return result;
}


gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* _tmp0_;
	TrackerSparqlBuilder* builder;
	TrackerSparqlBuilder* _tmp1_;
	TrackerSparqlBuilder* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlBuilder* _tmp4_;
	const gchar* _tmp5_;
	TrackerSparqlBuilder* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	TrackerSparqlBuilder* _tmp18_;
	TrackerSparqlBuilder* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subject_iri != NULL, FALSE);
	g_return_val_if_fail (pred != NULL, FALSE);
	g_return_val_if_fail (object_iri != NULL, FALSE);
	_tmp0_ = tracker_sparql_builder_new_update ();
	builder = _tmp0_;
	_tmp1_ = builder;
	tracker_sparql_builder_insert_open (_tmp1_, NULL);
	_tmp2_ = builder;
	_tmp3_ = subject_iri;
	tracker_sparql_builder_subject (_tmp2_, _tmp3_);
	_tmp4_ = builder;
	_tmp5_ = pred;
	tracker_sparql_builder_predicate (_tmp4_, _tmp5_);
	_tmp6_ = builder;
	_tmp7_ = object_iri;
	tracker_sparql_builder_object (_tmp6_, _tmp7_);
	_tmp8_ = pred_b;
	if (_tmp8_ != NULL) {
		TrackerSparqlBuilder* _tmp9_;
		const gchar* _tmp10_;
		TrackerSparqlBuilder* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = builder;
		_tmp10_ = pred_b;
		tracker_sparql_builder_predicate (_tmp9_, _tmp10_);
		_tmp11_ = builder;
		_tmp12_ = obj_literal_b;
		tracker_sparql_builder_object_string (_tmp11_, _tmp12_);
	}
	_tmp13_ = pred_c;
	if (_tmp13_ != NULL) {
		TrackerSparqlBuilder* _tmp14_;
		const gchar* _tmp15_;
		TrackerSparqlBuilder* _tmp16_;
		const gchar* _tmp17_;
		_tmp14_ = builder;
		_tmp15_ = pred_c;
		tracker_sparql_builder_predicate (_tmp14_, _tmp15_);
		_tmp16_ = builder;
		_tmp17_ = obj_literal_c;
		tracker_sparql_builder_object_string (_tmp16_, _tmp17_);
	}
	_tmp18_ = builder;
	tracker_sparql_builder_insert_close (_tmp18_);
	_tmp19_ = builder;
	_tmp20_ = tracker_sparql_builder_get_result (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tracker_test_backend_do_update_query (self, _tmp21_);
	if (_tmp22_ == FALSE) {
		TrackerSparqlBuilder* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = builder;
		_tmp24_ = tracker_sparql_builder_get_result (_tmp23_);
		_tmp25_ = _tmp24_;
		g_warning ("backend.vala:187: Couldn't insert triplet with query: %s\n", _tmp25_);
		result = FALSE;
		_g_object_unref0 (builder);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (builder);
	return result;
}


static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query) {
	gboolean result = FALSE;
	gboolean ret;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (query != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = self->priv->_debug;
	if (_tmp0_) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = stdout;
		_tmp2_ = query;
		fprintf (_tmp1_, "_do_update_query : %s\n", _tmp2_);
	}
	{
		TrackerSparqlConnection* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_connection;
		_tmp4_ = query;
		tracker_sparql_connection_update (_tmp3_, _tmp4_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			if (_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch1_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = TRUE;
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError* e1 = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e1;
		_tmp6_ = _tmp5_->message;
		g_warning ("backend.vala:211: Problem getting connection : %s\n", _tmp6_);
		_g_error_free0 (e1);
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e2 = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e2;
		_tmp8_ = _tmp7_->message;
		g_warning ("backend.vala:215: Problem saving data : %s\n", _tmp8_);
		_g_error_free0 (e2);
	}
	goto __finally1;
	__catch1_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e3;
		_tmp10_ = _tmp9_->message;
		g_warning ("backend.vala:219: Problem with the D-Bus connection : %s\n", _tmp10_);
		_g_error_free0 (e3);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = ret;
	return result;
}


static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* copy;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	copy = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _k_it;
		_tmp1_ = orig;
		_tmp2_ = gee_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_k_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* k;
			GeeHashMap* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* v;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			_tmp7_ = _k_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _k_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			k = (gchar*) _tmp10_;
			_tmp11_ = orig;
			_tmp12_ = k;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
			v = (gchar*) _tmp13_;
			_tmp14_ = copy;
			_tmp15_ = k;
			_tmp16_ = g_strdup (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = v;
			_tmp19_ = g_strdup (_tmp18_);
			_tmp20_ = _tmp19_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp17_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp17_);
			_g_free0 (v);
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	result = copy;
	return result;
}


static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
		_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			if (_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch2_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = _tmp1_;
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp2_;
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e1 = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e1;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", _tmp4_);
		_inner_error_ = _tmp5_;
		_g_error_free0 (e1);
		goto __finally2;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError* e2 = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e2;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp7_);
		_inner_error_ = _tmp8_;
		_g_error_free0 (e2);
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e3;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp10_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e3);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error) {
	gchar* _tmp0_;
	gchar* query;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	query = _tmp0_;
	self->priv->_contacts = g_list_reverse (self->priv->_contacts);
	_tmp1_ = self->priv->_contacts;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp1_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			GeeHashMap* _tmp2_;
			GeeHashMap* c = NULL;
			_tmp2_ = _g_object_ref0 ((GeeHashMap*) c_it->data);
			c = _tmp2_;
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GeeHashMap* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp3_ = query;
				_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = c;
				_tmp7_ = _tracker_test_backend_get_insert_query (self, _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
				_g_free0 (query);
				query = _tmp9_;
				_g_free0 (_tmp8_);
				_g_free0 (_tmp5_);
				_g_object_unref0 (c);
			}
		}
	}
	{
		TrackerSparqlConnection* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->_connection;
		_tmp11_ = query;
		tracker_sparql_connection_update (_tmp10_, _tmp11_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch3_tracker_sparql_error;
			}
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			if (_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch3_g_dbus_error;
			}
			_g_free0 (query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError* e1 = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e1;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Problem getting connection : %s\n", _tmp13_);
		_inner_error_ = _tmp14_;
		_g_error_free0 (e1);
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e2 = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e2;
		_tmp16_ = _tmp15_->message;
		_tmp17_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp16_);
		_inner_error_ = _tmp17_;
		_g_error_free0 (e2);
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e3;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", _tmp19_);
		_inner_error_ = _tmp20_;
		_g_error_free0 (e3);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (query);
			return;
		} else {
			_g_free0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (query);
}


static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact) {
	gchar* result = NULL;
	static const char q_photo_uri_t[] = " . <%s> a nfo:Image, " "nie:DataObject ; nie:url '%s' ; nie:title '%s' ";
	static const char im_addr_t[] = " . <%s> a nco:IMAddress, " "nie:InformationElement; nco:imProtocol " "'%s' ; nco:imID '%s';   " "nco:imNickname '%s'; " "nco:imPresence nco:presence-status-available " " . <%smyimaccount> a nco:IMAccount; " "nco:imDisplayName '%s'; nco:hasIMContact " "<%s>  ";
	static const char affl_t[] = " . <%smyaffiliation> a nco:Affiliation " " . <%smyaffiliation> nco:hasIMAddress " " <%s>  ";
	static const char af_t[] = " . <affl:001> a nco:Affiliation; " "nco:title '%s'; nco:department '%s'; nco:role '%s' ";
	static const char postal_t[] = " . <affl:001> a nco:Affiliation ; " "nco:hasPostalAddress <postal:001> . " " <postal:001> a nco:PostalAddress ; " "nco:pobox '%s'; " "nco:district '%s'; " "nco:county '%s'; " "nco:locality '%s'; " "nco:postalcode '%s'; " "nco:streetAddress '%s'; " "nco:addressLocation '%s'; " "nco:extendedAddress '%s'; " "nco:country '%s'; " "nco:region '%s' ";
	gchar* urn_contact = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp4_;
	gchar* photo_uri;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* q;
	GeeHashMap* addresses;
	gchar** phones;
	gint phones_length1;
	gint _phones_size_;
	gchar** emails;
	gint emails_length1;
	gint _emails_size_;
	gchar** urls;
	gint urls_length1;
	gint _urls_size_;
	gchar* _tmp10_;
	gchar* affiliation;
	gchar* _tmp11_;
	gchar* postal_address;
	const gchar* _tmp109_;
	gboolean _tmp117_ = FALSE;
	GeeHashMap* _tmp118_;
	gboolean _tmp122_;
	gboolean _tmp154_ = FALSE;
	gchar** _tmp155_;
	gint _tmp155__length1;
	gboolean _tmp157_;
	gboolean _tmp169_ = FALSE;
	gchar** _tmp170_;
	gint _tmp170__length1;
	gboolean _tmp172_;
	gboolean _tmp184_ = FALSE;
	gchar** _tmp185_;
	gint _tmp185__length1;
	gboolean _tmp187_;
	const gchar* _tmp201_;
	const gchar* _tmp215_;
	const gchar* _tmp243_;
	gchar* _tmp244_;
	gboolean _tmp245_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp2_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, TRACKER_TEST_BACKEND_URN, &_tmp1_);
	_g_free0 (urn_contact);
	urn_contact = _tmp1_;
	if (_tmp2_ == FALSE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("_:x");
		_g_free0 (urn_contact);
		urn_contact = _tmp3_;
	}
	_tmp4_ = g_strdup ("");
	photo_uri = _tmp4_;
	_tmp5_ = urn_contact;
	_tmp6_ = g_strconcat ("INSERT { ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " a nco:PersonContact  ", NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	q = _tmp9_;
	addresses = NULL;
	phones = NULL;
	phones_length1 = 0;
	_phones_size_ = phones_length1;
	emails = NULL;
	emails_length1 = 0;
	_emails_size_ = emails_length1;
	urls = NULL;
	urls_length1 = 0;
	_urls_size_ = urls_length1;
	_tmp10_ = g_strdup ("");
	affiliation = _tmp10_;
	_tmp11_ = g_strdup ("");
	postal_address = _tmp11_;
	{
		GeeHashMap* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _k_it;
		_tmp12_ = contact;
		_tmp13_ = gee_map_get_keys ((GeeMap*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_k_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* k;
			GeeHashMap* _tmp22_;
			const gchar* _tmp23_;
			gpointer _tmp24_ = NULL;
			gchar* v;
			const gchar* _tmp25_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* s;
			const gchar* _tmp106_;
			const gchar* _tmp107_;
			gchar* _tmp108_;
			_tmp18_ = _k_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _k_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			k = (gchar*) _tmp21_;
			_tmp22_ = contact;
			_tmp23_ = k;
			_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
			v = (gchar*) _tmp24_;
			_tmp25_ = k;
			if (g_strcmp0 (_tmp25_, TRF_ONTOLOGY_DEFS_NCO_PHOTO) == 0) {
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp26_ = v;
				_tmp27_ = g_strdup (_tmp26_);
				_g_free0 (photo_uri);
				photo_uri = _tmp27_;
				_tmp28_ = v;
				_tmp29_ = g_strconcat ("<", _tmp28_, NULL);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp30_, ">", NULL);
				_g_free0 (v);
				v = _tmp31_;
				_g_free0 (_tmp30_);
			} else {
				const gchar* _tmp32_;
				_tmp32_ = k;
				if (g_strcmp0 (_tmp32_, TRF_ONTOLOGY_DEFS_NCO_IMADDRESS) == 0) {
					const gchar* _tmp33_;
					GeeHashMap* _tmp34_ = NULL;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp33_ = v;
					_tmp34_ = _tracker_test_backend_parse_addrs (self, _tmp33_);
					_g_object_unref0 (addresses);
					addresses = _tmp34_;
					_tmp35_ = g_strdup ("");
					_g_free0 (k);
					k = _tmp35_;
					_tmp36_ = g_strdup ("");
					_g_free0 (v);
					v = _tmp36_;
					{
						GeeHashMap* _tmp37_;
						GeeSet* _tmp38_;
						GeeSet* _tmp39_;
						GeeSet* _tmp40_;
						GeeIterator* _tmp41_ = NULL;
						GeeIterator* _tmp42_;
						GeeIterator* _addr_it;
						_tmp37_ = addresses;
						_tmp38_ = gee_map_get_keys ((GeeMap*) _tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = _tmp39_;
						_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
						_tmp42_ = _tmp41_;
						_g_object_unref0 (_tmp40_);
						_addr_it = _tmp42_;
						while (TRUE) {
							GeeIterator* _tmp43_;
							gboolean _tmp44_ = FALSE;
							GeeIterator* _tmp45_;
							gpointer _tmp46_ = NULL;
							gchar* addr;
							gchar* vtemp = NULL;
							gchar* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							const gchar* _tmp55_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							gchar* _tmp60_;
							_tmp43_ = _addr_it;
							_tmp44_ = gee_iterator_next (_tmp43_);
							if (!_tmp44_) {
								break;
							}
							_tmp45_ = _addr_it;
							_tmp46_ = gee_iterator_get (_tmp45_);
							addr = (gchar*) _tmp46_;
							_tmp47_ = g_strdup (" nco:hasAffiliation [ a nco:Affiliation ; ");
							_g_free0 (vtemp);
							vtemp = _tmp47_;
							_tmp48_ = vtemp;
							_tmp49_ = addr;
							_tmp50_ = g_strconcat ("nco:hasIMAddress <", _tmp49_, NULL);
							_tmp51_ = _tmp50_;
							_tmp52_ = g_strconcat (_tmp51_, "> ] ", NULL);
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strconcat (_tmp48_, _tmp53_, NULL);
							_g_free0 (vtemp);
							vtemp = _tmp54_;
							_g_free0 (_tmp53_);
							_g_free0 (_tmp51_);
							_tmp55_ = v;
							if (g_strcmp0 (_tmp55_, "") != 0) {
								const gchar* _tmp56_;
								gchar* _tmp57_;
								_tmp56_ = v;
								_tmp57_ = g_strconcat (_tmp56_, "; ", NULL);
								_g_free0 (v);
								v = _tmp57_;
							}
							_tmp58_ = v;
							_tmp59_ = vtemp;
							_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
							_g_free0 (v);
							v = _tmp60_;
							_g_free0 (vtemp);
							_g_free0 (addr);
						}
						_g_object_unref0 (_addr_it);
					}
				} else {
					const gchar* _tmp61_;
					_tmp61_ = k;
					if (g_strcmp0 (_tmp61_, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP) == 0) {
						const gchar* _tmp62_;
						gchar** _tmp63_;
						gchar** _tmp64_ = NULL;
						gchar* _tmp65_;
						gchar** _tmp66_;
						gint _tmp66__length1;
						gchar* _tmp67_ = NULL;
						_tmp62_ = v;
						_tmp64_ = _tmp63_ = g_strsplit (_tmp62_, ",", 0);
						phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
						phones = _tmp64_;
						phones_length1 = _vala_array_length (_tmp63_);
						_phones_size_ = phones_length1;
						_tmp65_ = g_strdup ("");
						_g_free0 (k);
						k = _tmp65_;
						_tmp66_ = phones;
						_tmp66__length1 = phones_length1;
						_tmp67_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp66_, _tmp66__length1);
						_g_free0 (v);
						v = _tmp67_;
					} else {
						const gchar* _tmp68_;
						_tmp68_ = k;
						if (g_strcmp0 (_tmp68_, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP) == 0) {
							const gchar* _tmp69_;
							gchar** _tmp70_;
							gchar** _tmp71_ = NULL;
							gchar* _tmp72_;
							gchar** _tmp73_;
							gint _tmp73__length1;
							gchar* _tmp74_ = NULL;
							_tmp69_ = v;
							_tmp71_ = _tmp70_ = g_strsplit (_tmp69_, ",", 0);
							emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
							emails = _tmp71_;
							emails_length1 = _vala_array_length (_tmp70_);
							_emails_size_ = emails_length1;
							_tmp72_ = g_strdup ("");
							_g_free0 (k);
							k = _tmp72_;
							_tmp73_ = emails;
							_tmp73__length1 = emails_length1;
							_tmp74_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp73_, _tmp73__length1);
							_g_free0 (v);
							v = _tmp74_;
						} else {
							const gchar* _tmp75_;
							_tmp75_ = k;
							if (g_strcmp0 (_tmp75_, TRACKER_TEST_BACKEND_URLS) == 0) {
								const gchar* _tmp76_;
								gchar** _tmp77_;
								gchar** _tmp78_ = NULL;
								gchar* _tmp79_;
								gchar** _tmp80_;
								gint _tmp80__length1;
								gchar* _tmp81_ = NULL;
								_tmp76_ = v;
								_tmp78_ = _tmp77_ = g_strsplit (_tmp76_, ",", 0);
								urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
								urls = _tmp78_;
								urls_length1 = _vala_array_length (_tmp77_);
								_urls_size_ = urls_length1;
								_tmp79_ = g_strdup ("");
								_g_free0 (k);
								k = _tmp79_;
								_tmp80_ = urls;
								_tmp80__length1 = urls_length1;
								_tmp81_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp80_, _tmp80__length1);
								_g_free0 (v);
								v = _tmp81_;
							} else {
								const gchar* _tmp82_;
								_tmp82_ = k;
								if (g_strcmp0 (_tmp82_, TRF_ONTOLOGY_DEFS_NAO_TAG) == 0) {
									gchar* _tmp83_;
									_tmp83_ = g_strdup (TRF_ONTOLOGY_DEFS_NAO_FAVORITE);
									_g_free0 (v);
									v = _tmp83_;
								} else {
									const gchar* _tmp84_;
									_tmp84_ = k;
									if (g_strcmp0 (_tmp84_, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION) == 0) {
										const gchar* _tmp85_;
										gchar* _tmp86_;
										gchar* _tmp87_;
										_tmp85_ = v;
										_tmp86_ = g_strdup (_tmp85_);
										_g_free0 (affiliation);
										affiliation = _tmp86_;
										_tmp87_ = g_strdup ("<affl:001>");
										_g_free0 (v);
										v = _tmp87_;
									} else {
										const gchar* _tmp88_;
										_tmp88_ = k;
										if (g_strcmp0 (_tmp88_, TRF_ONTOLOGY_DEFS_NCO_GENDER) == 0) {
										} else {
											const gchar* _tmp89_;
											_tmp89_ = k;
											if (g_strcmp0 (_tmp89_, TRF_ONTOLOGY_DEFS_NCO_POSTAL_ADDRESS) == 0) {
												const gchar* _tmp90_;
												gchar* _tmp91_;
												gchar* _tmp92_;
												gchar* _tmp93_;
												_tmp90_ = v;
												_tmp91_ = g_strdup (_tmp90_);
												_g_free0 (postal_address);
												postal_address = _tmp91_;
												_tmp92_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION);
												_g_free0 (k);
												k = _tmp92_;
												_tmp93_ = g_strdup ("<affl:001>");
												_g_free0 (v);
												v = _tmp93_;
											} else {
												const gchar* _tmp94_;
												gchar* _tmp95_;
												gchar* _tmp96_;
												gchar* _tmp97_;
												_tmp94_ = v;
												_tmp95_ = g_strconcat ("'", _tmp94_, NULL);
												_tmp96_ = _tmp95_;
												_tmp97_ = g_strconcat (_tmp96_, "'", NULL);
												_g_free0 (v);
												v = _tmp97_;
												_g_free0 (_tmp96_);
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp98_ = q;
			_tmp99_ = g_strconcat (_tmp98_, "; ", NULL);
			_g_free0 (q);
			q = _tmp99_;
			_tmp100_ = k;
			_tmp101_ = g_strconcat (_tmp100_, " ", NULL);
			_tmp102_ = _tmp101_;
			_tmp103_ = v;
			_tmp104_ = g_strconcat (_tmp102_, _tmp103_, NULL);
			_tmp105_ = _tmp104_;
			_g_free0 (_tmp102_);
			s = _tmp105_;
			_tmp106_ = q;
			_tmp107_ = s;
			_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
			_g_free0 (q);
			q = _tmp108_;
			_g_free0 (s);
			_g_free0 (v);
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	_tmp109_ = photo_uri;
	if (g_strcmp0 (_tmp109_, "") != 0) {
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_;
		gchar* _tmp116_;
		_tmp110_ = q;
		_tmp111_ = photo_uri;
		_tmp112_ = photo_uri;
		_tmp113_ = photo_uri;
		_tmp114_ = g_strdup_printf (q_photo_uri_t, _tmp111_, _tmp112_, _tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = g_strconcat (_tmp110_, _tmp115_, NULL);
		_g_free0 (q);
		q = _tmp116_;
		_g_free0 (_tmp115_);
	}
	_tmp118_ = addresses;
	if (_tmp118_ != NULL) {
		GeeHashMap* _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
		_tmp119_ = addresses;
		_tmp120_ = gee_map_get_size ((GeeMap*) _tmp119_);
		_tmp121_ = _tmp120_;
		_tmp117_ = _tmp121_ > 0;
	} else {
		_tmp117_ = FALSE;
	}
	_tmp122_ = _tmp117_;
	if (_tmp122_) {
		{
			GeeHashMap* _tmp123_;
			GeeSet* _tmp124_;
			GeeSet* _tmp125_;
			GeeSet* _tmp126_;
			GeeIterator* _tmp127_ = NULL;
			GeeIterator* _tmp128_;
			GeeIterator* _addr_it;
			_tmp123_ = addresses;
			_tmp124_ = gee_map_get_keys ((GeeMap*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = _tmp125_;
			_tmp127_ = gee_iterable_iterator ((GeeIterable*) _tmp126_);
			_tmp128_ = _tmp127_;
			_g_object_unref0 (_tmp126_);
			_addr_it = _tmp128_;
			while (TRUE) {
				GeeIterator* _tmp129_;
				gboolean _tmp130_ = FALSE;
				GeeIterator* _tmp131_;
				gpointer _tmp132_ = NULL;
				gchar* addr;
				GeeHashMap* _tmp133_;
				const gchar* _tmp134_;
				gpointer _tmp135_ = NULL;
				gchar* proto;
				const gchar* _tmp136_;
				const gchar* _tmp137_;
				const gchar* _tmp138_;
				const gchar* _tmp139_;
				const gchar* _tmp140_;
				const gchar* _tmp141_;
				const gchar* _tmp142_;
				gchar* _tmp143_ = NULL;
				gchar* q1;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				const gchar* _tmp146_;
				gchar* _tmp147_ = NULL;
				gchar* q2;
				const gchar* _tmp148_;
				const gchar* _tmp149_;
				const gchar* _tmp150_;
				gchar* _tmp151_ = NULL;
				gchar* _tmp152_;
				gchar* _tmp153_;
				_tmp129_ = _addr_it;
				_tmp130_ = gee_iterator_next (_tmp129_);
				if (!_tmp130_) {
					break;
				}
				_tmp131_ = _addr_it;
				_tmp132_ = gee_iterator_get (_tmp131_);
				addr = (gchar*) _tmp132_;
				_tmp133_ = addresses;
				_tmp134_ = addr;
				_tmp135_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp133_, _tmp134_);
				proto = (gchar*) _tmp135_;
				_tmp136_ = addr;
				_tmp137_ = proto;
				_tmp138_ = addr;
				_tmp139_ = addr;
				_tmp140_ = addr;
				_tmp141_ = addr;
				_tmp142_ = addr;
				_tmp143_ = g_strdup_printf (im_addr_t, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_, _tmp142_);
				q1 = _tmp143_;
				_tmp144_ = addr;
				_tmp145_ = addr;
				_tmp146_ = addr;
				_tmp147_ = g_strdup_printf (affl_t, _tmp144_, _tmp145_, _tmp146_);
				q2 = _tmp147_;
				_tmp148_ = q;
				_tmp149_ = q1;
				_tmp150_ = q2;
				_tmp151_ = g_strdup_printf ("%s%s", _tmp149_, _tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = g_strconcat (_tmp148_, _tmp152_, NULL);
				_g_free0 (q);
				q = _tmp153_;
				_g_free0 (_tmp152_);
				_g_free0 (q2);
				_g_free0 (q1);
				_g_free0 (proto);
				_g_free0 (addr);
			}
			_g_object_unref0 (_addr_it);
		}
	}
	_tmp155_ = phones;
	_tmp155__length1 = phones_length1;
	if (_tmp155_ != NULL) {
		gchar** _tmp156_;
		gint _tmp156__length1;
		_tmp156_ = phones;
		_tmp156__length1 = phones_length1;
		_tmp154_ = _tmp156__length1 > 0;
	} else {
		_tmp154_ = FALSE;
	}
	_tmp157_ = _tmp154_;
	if (_tmp157_) {
		gchar** _tmp158_;
		gint _tmp158__length1;
		_tmp158_ = phones;
		_tmp158__length1 = phones_length1;
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp158_;
			p_collection_length1 = _tmp158__length1;
			for (p_it = 0; p_it < _tmp158__length1; p_it = p_it + 1) {
				gchar* _tmp159_;
				gchar* p = NULL;
				_tmp159_ = g_strdup (p_collection[p_it]);
				p = _tmp159_;
				{
					const gchar* _tmp160_;
					gchar* _tmp161_ = NULL;
					gchar* phone_urn;
					const gchar* _tmp162_;
					gchar* _tmp163_ = NULL;
					gchar* affl;
					const gchar* _tmp164_;
					const gchar* _tmp165_;
					const gchar* _tmp166_;
					const gchar* _tmp167_;
					const gchar* _tmp168_;
					_tmp160_ = p;
					_tmp161_ = g_strdup_printf ("<phone:%s>", _tmp160_);
					phone_urn = _tmp161_;
					_tmp162_ = p;
					_tmp163_ = g_strdup_printf ("<%s>", _tmp162_);
					affl = _tmp163_;
					_tmp164_ = phone_urn;
					_tmp165_ = p;
					tracker_test_backend_insert_triplet (self, _tmp164_, "a", TRF_ONTOLOGY_DEFS_NCO_PHONE, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP, _tmp165_, NULL, NULL);
					_tmp166_ = affl;
					tracker_test_backend_insert_triplet (self, _tmp166_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
					_tmp167_ = affl;
					_tmp168_ = phone_urn;
					tracker_test_backend_insert_triplet (self, _tmp167_, TRF_ONTOLOGY_DEFS_NCO_HAS_PHONE, _tmp168_, NULL, NULL, NULL, NULL);
					_g_free0 (affl);
					_g_free0 (phone_urn);
					_g_free0 (p);
				}
			}
		}
	}
	_tmp170_ = emails;
	_tmp170__length1 = emails_length1;
	if (_tmp170_ != NULL) {
		gchar** _tmp171_;
		gint _tmp171__length1;
		_tmp171_ = emails;
		_tmp171__length1 = emails_length1;
		_tmp169_ = _tmp171__length1 > 0;
	} else {
		_tmp169_ = FALSE;
	}
	_tmp172_ = _tmp169_;
	if (_tmp172_) {
		gchar** _tmp173_;
		gint _tmp173__length1;
		_tmp173_ = emails;
		_tmp173__length1 = emails_length1;
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp173_;
			p_collection_length1 = _tmp173__length1;
			for (p_it = 0; p_it < _tmp173__length1; p_it = p_it + 1) {
				gchar* _tmp174_;
				gchar* p = NULL;
				_tmp174_ = g_strdup (p_collection[p_it]);
				p = _tmp174_;
				{
					const gchar* _tmp175_;
					gchar* _tmp176_ = NULL;
					gchar* email_urn;
					const gchar* _tmp177_;
					gchar* _tmp178_ = NULL;
					gchar* affl;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
					const gchar* _tmp181_;
					const gchar* _tmp182_;
					const gchar* _tmp183_;
					_tmp175_ = p;
					_tmp176_ = g_strdup_printf ("<email:%s>", _tmp175_);
					email_urn = _tmp176_;
					_tmp177_ = p;
					_tmp178_ = g_strdup_printf ("<%s>", _tmp177_);
					affl = _tmp178_;
					_tmp179_ = email_urn;
					_tmp180_ = p;
					tracker_test_backend_insert_triplet (self, _tmp179_, "a", TRF_ONTOLOGY_DEFS_NCO_EMAIL, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP, _tmp180_, NULL, NULL);
					_tmp181_ = affl;
					tracker_test_backend_insert_triplet (self, _tmp181_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
					_tmp182_ = affl;
					_tmp183_ = email_urn;
					tracker_test_backend_insert_triplet (self, _tmp182_, TRF_ONTOLOGY_DEFS_NCO_HAS_EMAIL, _tmp183_, NULL, NULL, NULL, NULL);
					_g_free0 (affl);
					_g_free0 (email_urn);
					_g_free0 (p);
				}
			}
		}
	}
	_tmp185_ = urls;
	_tmp185__length1 = urls_length1;
	if (_tmp185_ != NULL) {
		gchar** _tmp186_;
		gint _tmp186__length1;
		_tmp186_ = urls;
		_tmp186__length1 = urls_length1;
		_tmp184_ = _tmp186__length1 > 0;
	} else {
		_tmp184_ = FALSE;
	}
	_tmp187_ = _tmp184_;
	if (_tmp187_) {
		gint i;
		gchar** _tmp188_;
		gint _tmp188__length1;
		i = 0;
		_tmp188_ = urls;
		_tmp188__length1 = urls_length1;
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp188_;
			p_collection_length1 = _tmp188__length1;
			for (p_it = 0; p_it < _tmp188__length1; p_it = p_it + 1) {
				gchar* _tmp189_;
				gchar* p = NULL;
				_tmp189_ = g_strdup (p_collection[p_it]);
				p = _tmp189_;
				{
					gchar* _tmp190_;
					gchar* website_type;
					const gchar* _tmp191_;
					gchar* _tmp192_ = NULL;
					gchar* affl;
					gint _tmp193_;
					const gchar* _tmp197_;
					const gchar* _tmp198_;
					const gchar* _tmp199_;
					gint _tmp200_;
					_tmp190_ = g_strdup ("");
					website_type = _tmp190_;
					_tmp191_ = p;
					_tmp192_ = g_strdup_printf ("<%s>", _tmp191_);
					affl = _tmp192_;
					_tmp193_ = i;
					switch (_tmp193_ % 3) {
						case 0:
						{
							gchar* _tmp194_;
							_tmp194_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_WEBSITE);
							_g_free0 (website_type);
							website_type = _tmp194_;
							break;
						}
						case 1:
						{
							gchar* _tmp195_;
							_tmp195_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_BLOG);
							_g_free0 (website_type);
							website_type = _tmp195_;
							break;
						}
						case 2:
						{
							gchar* _tmp196_;
							_tmp196_ = g_strdup ("nco:url");
							_g_free0 (website_type);
							website_type = _tmp196_;
							break;
						}
						default:
						break;
					}
					_tmp197_ = affl;
					_tmp198_ = website_type;
					_tmp199_ = p;
					tracker_test_backend_insert_triplet (self, _tmp197_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, _tmp198_, _tmp199_, NULL, NULL);
					_tmp200_ = i;
					i = _tmp200_ + 1;
					_g_free0 (affl);
					_g_free0 (website_type);
					_g_free0 (p);
				}
			}
		}
	}
	_tmp201_ = affiliation;
	if (g_strcmp0 (_tmp201_, "") != 0) {
		const gchar* _tmp202_;
		gchar** _tmp203_;
		gchar** _tmp204_ = NULL;
		gchar** role_info;
		gint role_info_length1;
		gint _role_info_size_;
		const gchar* _tmp205_;
		gchar** _tmp206_;
		gint _tmp206__length1;
		const gchar* _tmp207_;
		gchar** _tmp208_;
		gint _tmp208__length1;
		const gchar* _tmp209_;
		gchar** _tmp210_;
		gint _tmp210__length1;
		const gchar* _tmp211_;
		gchar* _tmp212_ = NULL;
		gchar* _tmp213_;
		gchar* _tmp214_;
		_tmp202_ = affiliation;
		_tmp204_ = _tmp203_ = g_strsplit (_tmp202_, ",", 0);
		role_info = _tmp204_;
		role_info_length1 = _vala_array_length (_tmp203_);
		_role_info_size_ = role_info_length1;
		_tmp205_ = q;
		_tmp206_ = role_info;
		_tmp206__length1 = role_info_length1;
		_tmp207_ = _tmp206_[0];
		_tmp208_ = role_info;
		_tmp208__length1 = role_info_length1;
		_tmp209_ = _tmp208_[1];
		_tmp210_ = role_info;
		_tmp210__length1 = role_info_length1;
		_tmp211_ = _tmp210_[2];
		_tmp212_ = g_strdup_printf (af_t, _tmp207_, _tmp209_, _tmp211_);
		_tmp213_ = _tmp212_;
		_tmp214_ = g_strconcat (_tmp205_, _tmp213_, NULL);
		_g_free0 (q);
		q = _tmp214_;
		_g_free0 (_tmp213_);
		role_info = (_vala_array_free (role_info, role_info_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp215_ = postal_address;
	if (g_strcmp0 (_tmp215_, "") != 0) {
		const gchar* _tmp216_;
		gchar** _tmp217_;
		gchar** _tmp218_ = NULL;
		gchar** postal_info;
		gint postal_info_length1;
		gint _postal_info_size_;
		const gchar* _tmp219_;
		gchar** _tmp220_;
		gint _tmp220__length1;
		const gchar* _tmp221_;
		gchar** _tmp222_;
		gint _tmp222__length1;
		const gchar* _tmp223_;
		gchar** _tmp224_;
		gint _tmp224__length1;
		const gchar* _tmp225_;
		gchar** _tmp226_;
		gint _tmp226__length1;
		const gchar* _tmp227_;
		gchar** _tmp228_;
		gint _tmp228__length1;
		const gchar* _tmp229_;
		gchar** _tmp230_;
		gint _tmp230__length1;
		const gchar* _tmp231_;
		gchar** _tmp232_;
		gint _tmp232__length1;
		const gchar* _tmp233_;
		gchar** _tmp234_;
		gint _tmp234__length1;
		const gchar* _tmp235_;
		gchar** _tmp236_;
		gint _tmp236__length1;
		const gchar* _tmp237_;
		gchar** _tmp238_;
		gint _tmp238__length1;
		const gchar* _tmp239_;
		gchar* _tmp240_ = NULL;
		gchar* _tmp241_;
		gchar* _tmp242_;
		_tmp216_ = postal_address;
		_tmp218_ = _tmp217_ = g_strsplit (_tmp216_, ":", 0);
		postal_info = _tmp218_;
		postal_info_length1 = _vala_array_length (_tmp217_);
		_postal_info_size_ = postal_info_length1;
		_tmp219_ = q;
		_tmp220_ = postal_info;
		_tmp220__length1 = postal_info_length1;
		_tmp221_ = _tmp220_[0];
		_tmp222_ = postal_info;
		_tmp222__length1 = postal_info_length1;
		_tmp223_ = _tmp222_[1];
		_tmp224_ = postal_info;
		_tmp224__length1 = postal_info_length1;
		_tmp225_ = _tmp224_[2];
		_tmp226_ = postal_info;
		_tmp226__length1 = postal_info_length1;
		_tmp227_ = _tmp226_[3];
		_tmp228_ = postal_info;
		_tmp228__length1 = postal_info_length1;
		_tmp229_ = _tmp228_[4];
		_tmp230_ = postal_info;
		_tmp230__length1 = postal_info_length1;
		_tmp231_ = _tmp230_[5];
		_tmp232_ = postal_info;
		_tmp232__length1 = postal_info_length1;
		_tmp233_ = _tmp232_[6];
		_tmp234_ = postal_info;
		_tmp234__length1 = postal_info_length1;
		_tmp235_ = _tmp234_[7];
		_tmp236_ = postal_info;
		_tmp236__length1 = postal_info_length1;
		_tmp237_ = _tmp236_[8];
		_tmp238_ = postal_info;
		_tmp238__length1 = postal_info_length1;
		_tmp239_ = _tmp238_[9];
		_tmp240_ = g_strdup_printf (postal_t, _tmp221_, _tmp223_, _tmp225_, _tmp227_, _tmp229_, _tmp231_, _tmp233_, _tmp235_, _tmp237_, _tmp239_);
		_tmp241_ = _tmp240_;
		_tmp242_ = g_strconcat (_tmp219_, _tmp241_, NULL);
		_g_free0 (q);
		q = _tmp242_;
		_g_free0 (_tmp241_);
		postal_info = (_vala_array_free (postal_info, postal_info_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp243_ = q;
	_tmp244_ = g_strconcat (_tmp243_, " . }", NULL);
	_g_free0 (q);
	q = _tmp244_;
	_tmp245_ = self->priv->_debug;
	if (_tmp245_) {
		FILE* _tmp246_;
		const gchar* _tmp247_;
		_tmp246_ = stdout;
		_tmp247_ = q;
		fprintf (_tmp246_, "_get_insert_query : %s\n", _tmp247_);
	}
	result = q;
	_g_free0 (postal_address);
	_g_free0 (affiliation);
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
	phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (addresses);
	_g_free0 (photo_uri);
	_g_free0 (urn_contact);
	return result;
}


static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* ret;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (addr_s != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp0_;
	_tmp1_ = addr_s;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
	im_addrs = _tmp3_;
	im_addrs_length1 = _vala_array_length (_tmp2_);
	_im_addrs_size_ = im_addrs_length1;
	_tmp4_ = im_addrs;
	_tmp4__length1 = im_addrs_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp4_;
		a_collection_length1 = _tmp4__length1;
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
			gchar* _tmp5_;
			gchar* a = NULL;
			_tmp5_ = g_strdup (a_collection[a_it]);
			a = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* proto;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* addr;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp6_ = a;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
				info = _tmp8_;
				info_length1 = _vala_array_length (_tmp7_);
				_info_size_ = info_length1;
				_tmp9_ = info;
				_tmp9__length1 = info_length1;
				_tmp10_ = _tmp9_[0];
				_tmp11_ = g_strdup (_tmp10_);
				proto = _tmp11_;
				_tmp12_ = info;
				_tmp12__length1 = info_length1;
				_tmp13_ = _tmp12_[1];
				_tmp14_ = g_strdup (_tmp13_);
				addr = _tmp14_;
				_tmp15_ = ret;
				_tmp16_ = addr;
				addr = NULL;
				_tmp17_ = _tmp16_;
				_tmp18_ = proto;
				proto = NULL;
				_tmp19_ = _tmp18_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_g_free0 (addr);
				_g_free0 (proto);
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (a);
			}
		}
	}
	result = ret;
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (predicate != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = objects;
	_tmp1__length1 = objects_length1;
	{
		gchar** obj_collection = NULL;
		gint obj_collection_length1 = 0;
		gint _obj_collection_size_ = 0;
		gint obj_it = 0;
		obj_collection = _tmp1_;
		obj_collection_length1 = _tmp1__length1;
		for (obj_it = 0; obj_it < _tmp1__length1; obj_it = obj_it + 1) {
			gchar* _tmp2_;
			gchar* obj = NULL;
			_tmp2_ = g_strdup (obj_collection[obj_it]);
			obj = _tmp2_;
			{
				gchar* vtemp1 = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp3_ = predicate;
				_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp5_, " <", NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = obj;
				_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp10_, "> ", NULL);
				_g_free0 (vtemp1);
				vtemp1 = _tmp11_;
				_g_free0 (_tmp10_);
				_g_free0 (_tmp7_);
				_g_free0 (_tmp5_);
				_tmp12_ = ret;
				if (g_strcmp0 (_tmp12_, "") != 0) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = ret;
					_tmp14_ = g_strconcat (_tmp13_, "; ", NULL);
					_g_free0 (ret);
					ret = _tmp14_;
				}
				_tmp15_ = ret;
				_tmp16_ = vtemp1;
				_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
				_g_free0 (ret);
				ret = _tmp17_;
				_g_free0 (vtemp1);
				_g_free0 (obj);
			}
		}
	}
	result = ret;
	return result;
}


gboolean tracker_test_backend_get_debug (TrackerTestBackend* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_debug;
	result = _tmp0_;
	return result;
}


void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_debug = _tmp0_;
}


static void tracker_test_value_backend_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_test_value_backend_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_test_backend_unref (value->data[0].v_pointer);
	}
}


static void tracker_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_test_backend_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_test_value_backend_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerTestBackend* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_test_backend_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_test_backend_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerTestParamSpecBackend* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TEST_TYPE_BACKEND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_test_value_get_backend (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND), NULL);
	return value->data[0].v_pointer;
}


void tracker_test_value_set_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_test_backend_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_test_backend_unref (old);
	}
}


void tracker_test_value_take_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_test_backend_unref (old);
	}
}


static void tracker_test_backend_class_init (TrackerTestBackendClass * klass) {
	tracker_test_backend_parent_class = g_type_class_peek_parent (klass);
	TRACKER_TEST_BACKEND_CLASS (klass)->finalize = tracker_test_backend_finalize;
	g_type_class_add_private (klass, sizeof (TrackerTestBackendPrivate));
}


static void tracker_test_backend_instance_init (TrackerTestBackend * self) {
	self->priv = TRACKER_TEST_BACKEND_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void tracker_test_backend_finalize (TrackerTestBackend* obj) {
	TrackerTestBackend * self;
	self = TRACKER_TEST_BACKEND (obj);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	_g_object_unref0 (self->priv->_connection);
}


GType tracker_test_backend_get_type (void) {
	static volatile gsize tracker_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_test_value_backend_init, tracker_test_value_backend_free_value, tracker_test_value_backend_copy_value, tracker_test_value_backend_peek_pointer, "p", tracker_test_value_backend_collect_value, "p", tracker_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTestBackend), 0, (GInstanceInitFunc) tracker_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_test_backend_type_id;
		tracker_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_test_backend_type_id__volatile, tracker_test_backend_type_id);
	}
	return tracker_test_backend_type_id__volatile;
}


gpointer tracker_test_backend_ref (gpointer instance) {
	TrackerTestBackend* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_test_backend_unref (gpointer instance) {
	TrackerTestBackend* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_TEST_BACKEND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



