/* backend.c generated by valac 0.13.3, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/e-book-client.h>
#include <gee.h>
#include <libedataserver/e-account.h>
#include <libedataserver/e-source.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	GList* _e_contacts;
	GList* _contacts;
	ESourceGroup* _source_group;
	ESource* _source;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* _tmp2_;
	EContact* contact;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	gchar* added_uid;
	EBookClient* _tmp5_;
	EContact* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define EDS_TEST_BACKEND_address_book_uri "local://test"
EdsTestBackend* eds_test_backend_new (void);
EdsTestBackend* eds_test_backend_construct (GType object_type);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self);
static void _eds_test_backend_prepare_source (EdsTestBackend* self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_addrs (EdsTestBackend* self, const gchar* addr_s);
static void _vala_EContactAddress_free (EContactAddress* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_free0_ (gpointer var) {
#line 38 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	var = (g_free (var), NULL);
#line 230 "backend.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 38 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 38 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 239 "backend.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 39 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 246 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 39 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 39 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 255 "backend.c"
}


EdsTestBackend* eds_test_backend_construct (GType object_type) {
	EdsTestBackend* self = NULL;
#line 43 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self = (EdsTestBackend*) g_type_create_instance (object_type);
#line 45 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 45 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 46 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 46 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = NULL;
#line 43 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return self;
#line 273 "backend.c"
}


EdsTestBackend* eds_test_backend_new (void) {
#line 43 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND);
#line 280 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 51 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 287 "backend.c"
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 49 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 49 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 51 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = c;
#line 51 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 51 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
#line 49 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (c);
#line 306 "backend.c"
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
#line 319 "backend.c"
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return self ? eds_test_backend_ref (self) : NULL;
#line 326 "backend.c"
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
	GeeHashMap* _tmp2_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp2_ = updated_data;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->updated_data = _tmp2_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 357 "backend.c"
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 365 "backend.c"
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 379 "backend.c"
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 0:
#line 388 "backend.c"
		goto _state_0;
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 1:
#line 392 "backend.c"
		goto _state_1;
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 2:
#line 396 "backend.c"
		goto _state_2;
		default:
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 401 "backend.c"
	}
	_state_0:
#line 57 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 57 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 57 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 57 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
#line 57 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
#line 57 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 416 "backend.c"
	{
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 430 "backend.c"
		_state_1:
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 61 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 440 "backend.c"
			goto __catch0_g_error;
		}
#line 62 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->contact;
#line 62 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->updated_data;
#line 62 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = _data_->contact;
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 459 "backend.c"
		_state_2:
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 63 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 465 "backend.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 67 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:67: Couldn't update contact\n");
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 480 "backend.c"
	}
	__finally0:
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->updated_data);
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 59 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 497 "backend.c"
	}
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 509 "backend.c"
	} else {
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 513 "backend.c"
	}
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 54 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 519 "backend.c"
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
#line 530 "backend.c"
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 554 "backend.c"
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 562 "backend.c"
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 576 "backend.c"
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 0:
#line 585 "backend.c"
		goto _state_0;
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 1:
#line 589 "backend.c"
		goto _state_1;
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 2:
#line 593 "backend.c"
		goto _state_2;
		default:
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 598 "backend.c"
	}
	_state_0:
#line 73 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 73 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 73 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 73 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
#line 73 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
#line 73 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 613 "backend.c"
	{
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 627 "backend.c"
		_state_1:
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 77 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 637 "backend.c"
			goto __catch1_g_error;
		}
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contact;
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 650 "backend.c"
		_state_2:
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 78 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 656 "backend.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 82 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:82: Couldn't remove contact\n");
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 671 "backend.c"
	}
	__finally1:
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 75 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 686 "backend.c"
	}
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 696 "backend.c"
	} else {
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 700 "backend.c"
	}
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 71 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 706 "backend.c"
}


void eds_test_backend_reset (EdsTestBackend* self) {
#line 86 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 88 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 88 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 89 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 89 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = NULL;
#line 721 "backend.c"
}


void eds_test_backend_set_up (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 93 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 729 "backend.c"
	{
		ESource* _tmp0_;
		EBookClient* _tmp1_;
		EBookClient* _tmp2_;
		EBookClient* _tmp3_;
		EBookClient* _tmp4_;
		ESource* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
#line 97 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source (self);
#line 98 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_source;
#line 98 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e_book_client_new (_tmp0_, &_inner_error_);
#line 98 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp2_ = _tmp1_;
#line 98 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 750 "backend.c"
			goto __catch2_g_error;
		}
#line 98 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 98 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = _tmp2_;
#line 99 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp3_ = self->priv->_addressbook;
#line 99 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_client_open_sync ((EClient*) _tmp3_, FALSE, NULL, &_inner_error_);
#line 99 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 763 "backend.c"
			goto __catch2_g_error;
		}
#line 100 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp4_ = self->priv->_addressbook;
#line 100 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp5_ = e_client_get_source ((EClient*) _tmp4_);
#line 100 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp6_ = e_source_peek_name (_tmp5_);
#line 100 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 100 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_free0 (self->priv->_addressbook_name);
#line 100 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook_name = _tmp7_;
#line 102 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp8_ = self->priv->_addressbook_name;
#line 102 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp8_, TRUE);
#line 782 "backend.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 107 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp9_ = e;
#line 107 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_->message;
#line 107 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:107: Unable to create test data: %s\n", _tmp10_);
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 802 "backend.c"
	}
	__finally2:
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 95 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return;
#line 813 "backend.c"
	}
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self) {
	gchar* _tmp0_;
	gchar* base_uri;
	const gchar* _tmp1_;
	ESourceGroup* _tmp2_;
	ESource* _tmp3_;
	ESourceGroup* _tmp4_;
	ESource* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
#line 111 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 113 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_strdup ("local:");
#line 113 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	base_uri = _tmp0_;
#line 114 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp1_ = base_uri;
#line 114 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp2_ = e_source_group_new ("Test", _tmp1_);
#line 114 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_group);
#line 114 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_source_group = _tmp2_;
#line 116 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp3_ = e_source_new ("Test", EDS_TEST_BACKEND_address_book_uri);
#line 116 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 116 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv->_source = _tmp3_;
#line 117 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp4_ = self->priv->_source_group;
#line 117 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp5_ = self->priv->_source;
#line 117 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp6_ = e_source_group_add_source (_tmp4_, _tmp5_, -1);
#line 117 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_tmp6_) {
#line 856 "backend.c"
		{
			ESourceList* sl = NULL;
			ESourceList* _tmp7_ = NULL;
			ESourceList* _tmp8_;
			ESourceGroup* _tmp9_;
			ESourceList* _tmp10_;
#line 122 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			e_book_client_get_sources (&_tmp7_, &_inner_error_);
#line 122 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_g_object_unref0 (sl);
#line 122 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			sl = _tmp7_;
#line 122 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			if (_inner_error_ != NULL) {
#line 122 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (sl);
#line 873 "backend.c"
				goto __catch3_g_error;
			}
#line 123 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp8_ = sl;
#line 123 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp9_ = self->priv->_source_group;
#line 123 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			e_source_list_add_group (_tmp8_, _tmp9_, 0);
#line 124 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp10_ = sl;
#line 124 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			e_source_list_sync (_tmp10_, &_inner_error_);
#line 124 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			if (_inner_error_ != NULL) {
#line 124 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (sl);
#line 890 "backend.c"
				goto __catch3_g_error;
			}
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_g_object_unref0 (sl);
#line 895 "backend.c"
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			e = _inner_error_;
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_inner_error_ = NULL;
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_g_error_free0 (e);
#line 907 "backend.c"
		}
		__finally3:
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_g_free0 (base_uri);
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			g_clear_error (&_inner_error_);
#line 119 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			return;
#line 920 "backend.c"
		}
	}
#line 111 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_free0 (base_uri);
#line 925 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
#line 936 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 955 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 963 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 977 "backend.c"
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 0:
#line 986 "backend.c"
		goto _state_0;
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		case 1:
#line 990 "backend.c"
		goto _state_1;
		default:
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 995 "backend.c"
	}
	_state_0:
#line 135 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_contacts;
#line 1002 "backend.c"
	{
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->c_collection = _data_->_tmp0_;
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_data_->c_it = NULL;
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_data_->c = _data_->_tmp1_;
#line 1014 "backend.c"
			{
#line 138 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = e_contact_new ();
#line 138 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_data_->contact = _data_->_tmp2_;
#line 140 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = _data_->contact;
#line 140 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = _data_->c;
#line 140 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
#line 1026 "backend.c"
				{
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_tmp5_ = _data_->self->priv->_addressbook;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_tmp6_ = _data_->contact;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_tmp7_ = NULL;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_state_ = 1;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					e_book_client_add_contact (_data_->_tmp5_, _data_->_tmp6_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					return FALSE;
#line 1040 "backend.c"
					_state_1:
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					e_book_client_add_contact_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_free0 (_data_->added_uid);
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->added_uid = _data_->_tmp7_;
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					if (_data_->_inner_error_ != NULL) {
#line 145 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_free0 (_data_->added_uid);
#line 1052 "backend.c"
						goto __catch4_g_error;
					}
#line 147 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_tmp8_ = _data_->added_uid;
#line 147 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->added_uid = NULL;
#line 147 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->self->priv->_e_contacts = g_list_prepend (_data_->self->priv->_e_contacts, _data_->_tmp8_);
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_free0 (_data_->added_uid);
#line 1063 "backend.c"
				}
				goto __finally4;
				__catch4_g_error:
				{
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->e = _data_->_inner_error_;
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_inner_error_ = NULL;
#line 151 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_tmp9_ = _data_->e;
#line 151 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = _data_->_tmp9_->message;
#line 151 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					g_warning ("backend.vala:151: Couldn't add contact: %s\n", _data_->_tmp10_);
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_error_free0 (_data_->e);
#line 1080 "backend.c"
				}
				__finally4:
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				if (_data_->_inner_error_ != NULL) {
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (_data_->contact);
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (_data_->c);
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 142 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					return FALSE;
#line 1095 "backend.c"
				}
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->contact);
#line 136 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->c);
#line 1101 "backend.c"
			}
		}
	}
#line 155 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_e_contacts = g_list_reverse (_data_->self->priv->_e_contacts);
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1111 "backend.c"
	} else {
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1115 "backend.c"
	}
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 133 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1121 "backend.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1332 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1332 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1156 "backend.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1333 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1333 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1333 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1165 "backend.c"
	}
#line 1335 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1335 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1171 "backend.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1336 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1336 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1336 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1180 "backend.c"
	}
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1186 "backend.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1195 "backend.c"
	} else {
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1199 "backend.c"
	}
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1338 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1209 "backend.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1218 "backend.c"
	} else {
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1222 "backend.c"
	}
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1339 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1340 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1340 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1340 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1341 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1341 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1341 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1341 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1341 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1341 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 1246 "backend.c"
}


static void _vala_GValue_free (GValue* self) {
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_value_unset (self);
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_free (self);
#line 1255 "backend.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 1051 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1051 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1052 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1052 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 1052 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 1052 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1054 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1054 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1282 "backend.c"
		gchar* _tmp4_;
#line 1055 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1055 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1055 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1290 "backend.c"
	} else {
#line 1057 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = -1;
#line 1057 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1296 "backend.c"
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_photo_get_type (), self);
#line 1304 "backend.c"
}


static void _vala_EContactName_free (EContactName* self) {
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_name_get_type (), self);
#line 1311 "backend.c"
}


static void _vala_EContactAddress_free (EContactAddress* self) {
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_address_get_type (), self);
#line 1318 "backend.c"
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name;
	EContactName* _tmp0_;
	EContactName* contact_name;
	gchar* _tmp1_;
	gchar* contact_field_name;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint min_len;
	gboolean _tmp182_;
	GError * _inner_error_ = NULL;
#line 158 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 158 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (contact != NULL);
#line 158 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 161 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	added_contact_name = FALSE;
#line 162 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = e_contact_name_new ();
#line 162 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	contact_name = _tmp0_;
#line 163 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp1_ = g_strdup ("contact_name");
#line 163 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	contact_field_name = _tmp1_;
#line 164 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp2_ = contact_field_name;
#line 164 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp3_ = strlen (_tmp2_);
#line 164 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp4_ = _tmp3_;
#line 164 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	min_len = _tmp4_;
#line 1358 "backend.c"
	{
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_;
		GeeIterator* _k_it;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp5_ = c;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp6_ = gee_map_get_keys ((GeeMap*) _tmp5_);
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp8_ = _tmp7_;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp8_);
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_k_it = _tmp10_;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		while (TRUE) {
#line 1385 "backend.c"
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			gchar* k;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean _tmp25_;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp11_ = _k_it;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			if (!_tmp12_) {
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				break;
#line 1405 "backend.c"
			}
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp13_ = _k_it;
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			k = (gchar*) _tmp14_;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp16_ = k;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp17_ = strlen (_tmp16_);
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp18_ = _tmp17_;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp19_ = min_len;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			if (_tmp18_ > _tmp19_) {
#line 1423 "backend.c"
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				const gchar* _tmp24_;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp20_ = k;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp21_ = min_len;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp23_ = _tmp22_;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp24_ = contact_field_name;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp23_);
#line 1443 "backend.c"
			} else {
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp15_ = FALSE;
#line 1447 "backend.c"
			}
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp25_ = _tmp15_;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			if (_tmp25_) {
#line 1453 "backend.c"
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				gpointer _tmp28_ = NULL;
				GValue* _tmp29_;
				GValue _tmp30_;
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* v;
				const gchar* _tmp34_;
				gint _tmp35_ = 0;
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp26_ = c;
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp27_ = k;
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp29_ = (GValue*) _tmp28_;
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp30_ = *_tmp29_;
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp31_ = g_value_get_string (&_tmp30_);
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp32_ = g_strdup (_tmp31_);
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp33_ = _tmp32_;
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				__vala_GValue_free0 (_tmp29_);
#line 170 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				v = _tmp33_;
#line 171 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp34_ = k;
#line 171 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp35_ = string_index_of (_tmp34_, "family", 0);
#line 171 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				if (_tmp35_ >= 0) {
#line 1491 "backend.c"
					EContactName* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
#line 173 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp36_ = contact_name;
#line 173 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp37_ = v;
#line 173 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp38_ = g_strdup (_tmp37_);
#line 173 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_free0 (_tmp36_->family);
#line 173 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp36_->family = _tmp38_;
#line 1505 "backend.c"
				} else {
					const gchar* _tmp39_;
					gint _tmp40_ = 0;
#line 175 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp39_ = k;
#line 175 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp40_ = string_index_of (_tmp39_, "given", 0);
#line 175 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					if (_tmp40_ >= 0) {
#line 1515 "backend.c"
						EContactName* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
#line 177 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp41_ = contact_name;
#line 177 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp42_ = v;
#line 177 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp43_ = g_strdup (_tmp42_);
#line 177 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_free0 (_tmp41_->given);
#line 177 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp41_->given = _tmp43_;
#line 1529 "backend.c"
					} else {
						const gchar* _tmp44_;
						gint _tmp45_ = 0;
#line 179 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp44_ = k;
#line 179 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp45_ = string_index_of (_tmp44_, "additional", 0);
#line 179 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						if (_tmp45_ >= 0) {
#line 1539 "backend.c"
							EContactName* _tmp46_;
							const gchar* _tmp47_;
							gchar* _tmp48_;
#line 181 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp46_ = contact_name;
#line 181 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp47_ = v;
#line 181 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp48_ = g_strdup (_tmp47_);
#line 181 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp46_->additional);
#line 181 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp46_->additional = _tmp48_;
#line 1553 "backend.c"
						} else {
							const gchar* _tmp49_;
							gint _tmp50_ = 0;
#line 183 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp49_ = k;
#line 183 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp50_ = string_index_of (_tmp49_, "prefixes", 0);
#line 183 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							if (_tmp50_ >= 0) {
#line 1563 "backend.c"
								EContactName* _tmp51_;
								const gchar* _tmp52_;
								gchar* _tmp53_;
#line 185 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp51_ = contact_name;
#line 185 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp52_ = v;
#line 185 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp53_ = g_strdup (_tmp52_);
#line 185 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp51_->prefixes);
#line 185 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp51_->prefixes = _tmp53_;
#line 1577 "backend.c"
							} else {
								const gchar* _tmp54_;
								gint _tmp55_ = 0;
#line 187 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp54_ = k;
#line 187 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp55_ = string_index_of (_tmp54_, "suffixes", 0);
#line 187 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								if (_tmp55_ >= 0) {
#line 1587 "backend.c"
									EContactName* _tmp56_;
									const gchar* _tmp57_;
									gchar* _tmp58_;
#line 189 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
									_tmp56_ = contact_name;
#line 189 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
									_tmp57_ = v;
#line 189 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
									_tmp58_ = g_strdup (_tmp57_);
#line 189 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
									_g_free0 (_tmp56_->suffixes);
#line 189 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
									_tmp56_->suffixes = _tmp58_;
#line 1601 "backend.c"
								}
							}
						}
					}
				}
#line 192 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				added_contact_name = TRUE;
#line 168 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (v);
#line 1611 "backend.c"
			} else {
				const gchar* _tmp59_;
#line 194 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp59_ = k;
#line 194 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				if (g_strcmp0 (_tmp59_, "avatar") == 0) {
#line 1618 "backend.c"
					GeeHashMap* _tmp60_;
					const gchar* _tmp61_;
					gpointer _tmp62_ = NULL;
					GValue* _tmp63_;
					GValue _tmp64_;
					const gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* v;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					const gchar* _tmp68_;
					GFile* _tmp69_ = NULL;
					GFile* file;
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp60_ = c;
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp61_ = k;
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp62_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp60_, _tmp61_);
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp63_ = (GValue*) _tmp62_;
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp64_ = *_tmp63_;
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp65_ = g_value_get_string (&_tmp64_);
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp66_ = g_strdup (_tmp65_);
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp67_ = _tmp66_;
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					__vala_GValue_free0 (_tmp63_);
#line 196 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					v = _tmp67_;
#line 198 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp68_ = v;
#line 198 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp69_ = g_file_new_for_path (_tmp68_);
#line 198 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					file = _tmp69_;
#line 1660 "backend.c"
					{
						GFile* _tmp70_;
						guint8* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						EContactPhoto* _tmp73_;
						EContactPhoto* cp;
						EContactPhoto* _tmp74_;
						EContactPhoto* _tmp75_;
						guint8* _tmp76_;
						gint _tmp76__length1;
						EContact* _tmp77_;
						EContactField _tmp78_ = 0;
						EContactPhoto* _tmp79_;
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp70_ = file;
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						g_file_load_contents (_tmp70_, NULL, &_tmp71_, &_tmp72_, NULL, &_inner_error_);
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						photo_content = _tmp71_;
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						photo_content_length1 = _tmp72_;
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_photo_content_size_ = photo_content_length1;
#line 202 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						if (_inner_error_ != NULL) {
#line 1688 "backend.c"
							goto __catch5_g_error;
						}
#line 204 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp73_ = e_contact_photo_new ();
#line 204 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						cp = _tmp73_;
#line 205 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp74_ = cp;
#line 205 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp74_->type = E_CONTACT_PHOTO_TYPE_INLINED;
#line 206 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp75_ = cp;
#line 206 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp76_ = photo_content;
#line 206 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp76__length1 = photo_content_length1;
#line 206 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						e_contact_photo_set_inlined (_tmp75_, _tmp76_, (gsize) _tmp76__length1);
#line 208 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp77_ = contact;
#line 208 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp78_ = e_contact_field_id ("photo");
#line 208 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp79_ = cp;
#line 208 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						e_contact_set (_tmp77_, _tmp78_, _tmp79_);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						__vala_EContactPhoto_free0 (cp);
#line 1717 "backend.c"
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp80_;
						GError* _tmp81_;
						const gchar* _tmp82_;
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						e = _inner_error_;
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_inner_error_ = NULL;
#line 212 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp80_ = v;
#line 212 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp81_ = e;
#line 212 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp82_ = _tmp81_->message;
#line 212 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						g_warning ("backend.vala:212: \n\nCan't load avatar %s: %s\n\n", _tmp80_, _tmp82_);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_error_free0 (e);
#line 1740 "backend.c"
					}
					__finally5:
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					if (_inner_error_ != NULL) {
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (file);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_free0 (k);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (_k_it);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_free0 (contact_field_name);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						__vala_EContactName_free0 (contact_name);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						g_clear_error (&_inner_error_);
#line 200 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						return;
#line 1765 "backend.c"
					}
#line 194 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (file);
#line 194 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					photo_content = (g_free (photo_content), NULL);
#line 194 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_g_free0 (v);
#line 1773 "backend.c"
				} else {
					const gchar* _tmp83_;
#line 216 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					_tmp83_ = k;
#line 216 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
					if (g_strcmp0 (_tmp83_, "im_addresses") == 0) {
#line 1780 "backend.c"
						GeeHashMap* _tmp84_;
						const gchar* _tmp85_;
						gpointer _tmp86_ = NULL;
						GValue* _tmp87_;
						GValue _tmp88_;
						const gchar* _tmp89_ = NULL;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar* v;
						const gchar* _tmp92_;
						GeeHashMap* _tmp93_ = NULL;
						GeeHashMap* addresses;
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp84_ = c;
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp85_ = k;
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp86_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp84_, _tmp85_);
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp87_ = (GValue*) _tmp86_;
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp88_ = *_tmp87_;
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp89_ = g_value_get_string (&_tmp88_);
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp90_ = g_strdup (_tmp89_);
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp91_ = _tmp90_;
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						__vala_GValue_free0 (_tmp87_);
#line 218 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						v = _tmp91_;
#line 219 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp92_ = v;
#line 219 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp93_ = _eds_test_backend_parse_addrs (self, _tmp92_);
#line 219 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						addresses = _tmp93_;
#line 1819 "backend.c"
						{
							GeeHashMap* _tmp94_;
							GeeSet* _tmp95_;
							GeeSet* _tmp96_;
							GeeSet* _tmp97_;
							GeeIterator* _tmp98_ = NULL;
							GeeIterator* _tmp99_;
							GeeIterator* _addr_it;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp94_ = addresses;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp95_ = gee_map_get_keys ((GeeMap*) _tmp94_);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp96_ = _tmp95_;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp97_ = _tmp96_;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp98_ = gee_iterable_iterator ((GeeIterable*) _tmp97_);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp99_ = _tmp98_;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (_tmp97_);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_addr_it = _tmp99_;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							while (TRUE) {
#line 1846 "backend.c"
								GeeIterator* _tmp100_;
								gboolean _tmp101_ = FALSE;
								GeeIterator* _tmp102_;
								gpointer _tmp103_ = NULL;
								gchar* addr;
								GeeHashMap* _tmp104_;
								const gchar* _tmp105_;
								gpointer _tmp106_ = NULL;
								gchar* proto;
								EContact* _tmp107_;
								const gchar* _tmp108_;
								EContactField _tmp109_ = 0;
								const gchar* _tmp110_;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp100_ = _addr_it;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp101_ = gee_iterator_next (_tmp100_);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								if (!_tmp101_) {
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
									break;
#line 1868 "backend.c"
								}
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp102_ = _addr_it;
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp103_ = gee_iterator_get (_tmp102_);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								addr = (gchar*) _tmp103_;
#line 222 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp104_ = addresses;
#line 222 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp105_ = addr;
#line 222 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp106_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp104_, _tmp105_);
#line 222 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								proto = (gchar*) _tmp106_;
#line 223 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp107_ = contact;
#line 223 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp108_ = proto;
#line 223 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp109_ = e_contact_field_id (_tmp108_);
#line 223 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_tmp110_ = addr;
#line 223 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp107_, _tmp109_, _tmp110_);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_g_free0 (proto);
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
								_g_free0 (addr);
#line 1898 "backend.c"
							}
#line 220 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (_addr_it);
#line 1902 "backend.c"
						}
#line 216 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (addresses);
#line 216 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 1908 "backend.c"
					} else {
						const gchar* _tmp111_;
						const gchar* _tmp112_;
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp111_ = k;
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						_tmp112_ = EDSF_PERSONA_address_fields[0];
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
						if (g_strcmp0 (_tmp111_, _tmp112_) == 0) {
#line 1918 "backend.c"
							GeeHashMap* _tmp113_;
							const gchar* _tmp114_;
							gpointer _tmp115_ = NULL;
							GValue* _tmp116_;
							GValue _tmp117_;
							GObject* _tmp118_ = NULL;
							FolksPostalAddressFieldDetails* _tmp119_;
							FolksPostalAddressFieldDetails* _tmp120_;
							FolksPostalAddressFieldDetails* pa_fd;
							FolksPostalAddressFieldDetails* _tmp121_;
							gconstpointer _tmp122_;
							FolksPostalAddress* _tmp123_;
							FolksPostalAddress* _tmp124_;
							FolksPostalAddress* pa;
							EContactAddress* _tmp125_;
							EContactAddress* address;
							EContactAddress* _tmp126_;
							FolksPostalAddress* _tmp127_;
							const gchar* _tmp128_;
							const gchar* _tmp129_;
							gchar* _tmp130_;
							EContactAddress* _tmp131_;
							FolksPostalAddress* _tmp132_;
							const gchar* _tmp133_;
							const gchar* _tmp134_;
							gchar* _tmp135_;
							EContactAddress* _tmp136_;
							FolksPostalAddress* _tmp137_;
							const gchar* _tmp138_;
							const gchar* _tmp139_;
							gchar* _tmp140_;
							EContactAddress* _tmp141_;
							FolksPostalAddress* _tmp142_;
							const gchar* _tmp143_;
							const gchar* _tmp144_;
							gchar* _tmp145_;
							EContactAddress* _tmp146_;
							FolksPostalAddress* _tmp147_;
							const gchar* _tmp148_;
							const gchar* _tmp149_;
							gchar* _tmp150_;
							EContactAddress* _tmp151_;
							FolksPostalAddress* _tmp152_;
							const gchar* _tmp153_;
							const gchar* _tmp154_;
							gchar* _tmp155_;
							EContactAddress* _tmp156_;
							FolksPostalAddress* _tmp157_;
							const gchar* _tmp158_;
							const gchar* _tmp159_;
							gchar* _tmp160_;
							EContactAddress* _tmp161_;
							FolksPostalAddress* _tmp162_;
							const gchar* _tmp163_;
							const gchar* _tmp164_;
							gchar* _tmp165_;
							EContact* _tmp166_;
							const gchar* _tmp167_;
							EContactField _tmp168_ = 0;
							EContactAddress* _tmp169_;
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp113_ = c;
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp114_ = k;
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp115_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp113_, _tmp114_);
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp116_ = (GValue*) _tmp115_;
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp117_ = *_tmp116_;
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp118_ = g_value_get_object (&_tmp117_);
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp119_ = _g_object_ref0 (FOLKS_POSTAL_ADDRESS_FIELD_DETAILS (_tmp118_));
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp120_ = _tmp119_;
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp116_);
#line 228 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							pa_fd = _tmp120_;
#line 229 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp121_ = pa_fd;
#line 229 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp122_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp121_);
#line 229 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp123_ = _tmp122_;
#line 229 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp124_ = _g_object_ref0 (FOLKS_POSTAL_ADDRESS ((FolksPostalAddress*) _tmp123_));
#line 229 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							pa = _tmp124_;
#line 230 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp125_ = e_contact_address_new ();
#line 230 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							address = _tmp125_;
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp126_ = address;
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp127_ = pa;
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp128_ = folks_postal_address_get_po_box (_tmp127_);
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp129_ = _tmp128_;
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp130_ = g_strdup (_tmp129_);
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp126_->po);
#line 231 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp126_->po = _tmp130_;
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp131_ = address;
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp132_ = pa;
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp133_ = folks_postal_address_get_extension (_tmp132_);
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp134_ = _tmp133_;
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp135_ = g_strdup (_tmp134_);
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp131_->ext);
#line 232 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp131_->ext = _tmp135_;
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp136_ = address;
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp137_ = pa;
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp138_ = folks_postal_address_get_street (_tmp137_);
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp139_ = _tmp138_;
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp140_ = g_strdup (_tmp139_);
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp136_->street);
#line 233 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp136_->street = _tmp140_;
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp141_ = address;
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp142_ = pa;
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp143_ = folks_postal_address_get_locality (_tmp142_);
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp144_ = _tmp143_;
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp145_ = g_strdup (_tmp144_);
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp141_->locality);
#line 234 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp141_->locality = _tmp145_;
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp146_ = address;
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp147_ = pa;
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp148_ = folks_postal_address_get_region (_tmp147_);
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp149_ = _tmp148_;
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp150_ = g_strdup (_tmp149_);
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp146_->region);
#line 235 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp146_->region = _tmp150_;
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp151_ = address;
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp152_ = pa;
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp153_ = folks_postal_address_get_postal_code (_tmp152_);
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp154_ = _tmp153_;
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp155_ = g_strdup (_tmp154_);
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp151_->code);
#line 236 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp151_->code = _tmp155_;
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp156_ = address;
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp157_ = pa;
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp158_ = folks_postal_address_get_country (_tmp157_);
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp159_ = _tmp158_;
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp160_ = g_strdup (_tmp159_);
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp156_->country);
#line 237 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp156_->country = _tmp160_;
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp161_ = address;
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp162_ = pa;
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp163_ = folks_postal_address_get_address_format (_tmp162_);
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp164_ = _tmp163_;
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp165_ = g_strdup (_tmp164_);
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp161_->address_format);
#line 238 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp161_->address_format = _tmp165_;
#line 240 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp166_ = contact;
#line 240 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp167_ = k;
#line 240 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp168_ = e_contact_field_id (_tmp167_);
#line 240 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp169_ = address;
#line 240 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							e_contact_set (_tmp166_, _tmp168_, _tmp169_);
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							__vala_EContactAddress_free0 (address);
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (pa);
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (pa_fd);
#line 2141 "backend.c"
						} else {
							GeeHashMap* _tmp170_;
							const gchar* _tmp171_;
							gpointer _tmp172_ = NULL;
							GValue* _tmp173_;
							GValue _tmp174_;
							const gchar* _tmp175_ = NULL;
							gchar* _tmp176_;
							gchar* _tmp177_;
							gchar* v;
							EContact* _tmp178_;
							const gchar* _tmp179_;
							EContactField _tmp180_ = 0;
							const gchar* _tmp181_;
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp170_ = c;
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp171_ = k;
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp172_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp170_, _tmp171_);
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp173_ = (GValue*) _tmp172_;
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp174_ = *_tmp173_;
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp175_ = g_value_get_string (&_tmp174_);
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp176_ = g_strdup (_tmp175_);
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp177_ = _tmp176_;
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp173_);
#line 244 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							v = _tmp177_;
#line 245 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp178_ = contact;
#line 245 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp179_ = k;
#line 245 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp180_ = e_contact_field_id (_tmp179_);
#line 245 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_tmp181_ = v;
#line 245 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							e_contact_set (_tmp178_, _tmp180_, _tmp181_);
#line 226 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
							_g_free0 (v);
#line 2188 "backend.c"
						}
					}
				}
			}
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_g_free0 (k);
#line 2195 "backend.c"
		}
#line 166 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_k_it);
#line 2199 "backend.c"
	}
#line 248 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp182_ = added_contact_name;
#line 248 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_tmp182_) {
#line 2205 "backend.c"
		EContact* _tmp183_;
		EContactField _tmp184_ = 0;
		EContactName* _tmp185_;
#line 250 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp183_ = contact;
#line 250 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp184_ = e_contact_field_id ("name");
#line 250 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp185_ = contact_name;
#line 250 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e_contact_set (_tmp183_, _tmp184_, _tmp185_);
#line 2217 "backend.c"
	}
#line 158 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_free0 (contact_field_name);
#line 158 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__vala_EContactName_free0 (contact_name);
#line 2223 "backend.c"
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 254 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 256 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
#line 2233 "backend.c"
	{
		EBookClient* _tmp0_;
		gboolean _tmp1_ = FALSE;
		gboolean ret;
#line 261 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_addressbook;
#line 261 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e_client_remove_sync ((EClient*) _tmp0_, NULL, &_inner_error_);
#line 261 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		ret = _tmp1_;
#line 261 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 2246 "backend.c"
			goto __catch6_g_error;
		}
#line 262 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (ret == FALSE) {
#line 2251 "backend.c"
			const gchar* _tmp2_;
#line 264 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp2_ = self->priv->_addressbook_name;
#line 264 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			g_warning ("backend.vala:264: remove() addressbook returned false on %s\n", _tmp2_);
#line 2257 "backend.c"
		}
#line 268 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 268 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = NULL;
#line 2263 "backend.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 272 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp3_ = self->priv->_addressbook_name;
#line 272 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp4_ = e;
#line 272 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_tmp5_ = _tmp4_->message;
#line 272 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:272: Unable to remove addressbook %s because: %s\n", _tmp3_, _tmp5_);
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 2286 "backend.c"
	}
	__finally6:
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 259 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return;
#line 2297 "backend.c"
	}
}


static GeeHashMap* _eds_test_backend_parse_addrs (EdsTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* ret;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 277 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 277 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (addr_s != NULL, NULL);
#line 279 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 279 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	ret = _tmp0_;
#line 280 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp1_ = addr_s;
#line 280 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 280 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	im_addrs = _tmp3_;
#line 280 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 280 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp4_ = im_addrs;
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 2336 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		a_collection = _tmp4_;
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 2348 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			a = _tmp5_;
#line 2355 "backend.c"
			{
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* proto;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* addr;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 284 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp6_ = a;
#line 284 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 284 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				info = _tmp8_;
#line 284 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 284 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_info_size_ = info_length1;
#line 285 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp9_ = info;
#line 285 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp9__length1 = info_length1;
#line 285 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 285 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 285 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				proto = _tmp11_;
#line 286 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp12_ = info;
#line 286 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp12__length1 = info_length1;
#line 286 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 286 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 286 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				addr = _tmp14_;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp15_ = ret;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp16_ = addr;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				addr = NULL;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp17_ = _tmp16_;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp18_ = proto;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				proto = NULL;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_tmp19_ = _tmp18_;
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp19_);
#line 288 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp17_);
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (addr);
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (proto);
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 282 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
				_g_free0 (a);
#line 2436 "backend.c"
			}
		}
	}
#line 291 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	result = ret;
#line 291 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 291 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return result;
#line 2446 "backend.c"
}


static void eds_test_value_backend_init (GValue* value) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	value->data[0].v_pointer = NULL;
#line 2453 "backend.c"
}


static void eds_test_value_backend_free_value (GValue* value) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (value->data[0].v_pointer) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (value->data[0].v_pointer);
#line 2462 "backend.c"
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
#line 2472 "backend.c"
	} else {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2476 "backend.c"
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 2484 "backend.c"
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (collect_values[0].v_pointer) {
#line 2491 "backend.c"
		EdsTestBackend* object;
		object = collect_values[0].v_pointer;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2498 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2502 "backend.c"
		}
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = eds_test_backend_ref (object);
#line 2506 "backend.c"
	} else {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2510 "backend.c"
	}
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 2514 "backend.c"
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (!object_p) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2525 "backend.c"
	}
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (!value->data[0].v_pointer) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		*object_p = NULL;
#line 2531 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 2535 "backend.c"
	} else {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
#line 2539 "backend.c"
	}
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 2543 "backend.c"
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return G_PARAM_SPEC (spec);
#line 2557 "backend.c"
}


gpointer eds_test_value_get_backend (const GValue* value) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 2566 "backend.c"
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		eds_test_backend_ref (value->data[0].v_pointer);
#line 2586 "backend.c"
	} else {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2590 "backend.c"
	}
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 2596 "backend.c"
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 2615 "backend.c"
	} else {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2619 "backend.c"
	}
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 2625 "backend.c"
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	EDS_TEST_BACKEND_CLASS (klass)->finalize = eds_test_backend_finalize;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
#line 2637 "backend.c"
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self->ref_count = 1;
#line 2646 "backend.c"
}


static void eds_test_backend_finalize (EdsTestBackend* obj) {
	EdsTestBackend * self;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	self = EDS_TEST_BACKEND (obj);
#line 36 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 37 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_addressbook);
#line 38 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 39 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 40 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_group);
#line 41 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 2666 "backend.c"
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	return instance;
#line 2691 "backend.c"
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 33 "/debian/rgs/devel/folks/tests/lib/eds/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2704 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



