/* command-backends.c generated by valac 0.13.3, the Vala compiler
 * generated from command-backends.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS (folks_inspect_commands_backends_get_type ())
#define FOLKS_INSPECT_COMMANDS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackends))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))

typedef struct _FolksInspectCommandsBackends FolksInspectCommandsBackends;
typedef struct _FolksInspectCommandsBackendsClass FolksInspectCommandsBackendsClass;
typedef struct _FolksInspectCommandsBackendsPrivate FolksInspectCommandsBackendsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsBackends {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsBackendsPrivate * priv;
};

struct _FolksInspectCommandsBackendsClass {
	FolksInspectCommandClass parent_class;
};


static gpointer folks_inspect_commands_backends_parent_class = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_backends_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_BACKENDS_DUMMY_PROPERTY
};
FolksInspectCommandsBackends* folks_inspect_commands_backends_new (FolksInspectClient* client);
FolksInspectCommandsBackends* folks_inspect_commands_backends_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_backends_real_run (FolksInspectCommand* base, const gchar* command_string);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
static gchar** folks_inspect_commands_backends_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsBackends* folks_inspect_commands_backends_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsBackends* self = NULL;
	FolksInspectClient* _tmp0_;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (FolksInspectCommandsBackends*) folks_inspect_command_construct (object_type, _tmp0_);
	return self;
}


FolksInspectCommandsBackends* folks_inspect_commands_backends_new (FolksInspectClient* client) {
	return folks_inspect_commands_backends_construct (FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, client);
}


static void folks_inspect_commands_backends_real_run (FolksInspectCommand* base, const gchar* command_string) {
	FolksInspectCommandsBackends * self;
	const gchar* _tmp0_;
	self = (FolksInspectCommandsBackends*) base;
	_tmp0_ = command_string;
	if (_tmp0_ == NULL) {
		FolksInspectClient* _tmp1_;
		FolksBackendStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* backends;
		GeeCollection* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = ((FolksInspectCommand*) self)->client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		backends = _tmp4_;
		_tmp5_ = backends;
		_tmp6_ = gee_collection_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		folks_inspect_utils_print_line ("%u backends:", (guint) _tmp7_);
		folks_inspect_utils_indent ();
		{
			GeeCollection* _tmp8_;
			GeeIterator* _tmp9_ = NULL;
			GeeIterator* _backend_it;
			_tmp8_ = backends;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_backend_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				gboolean _tmp11_ = FALSE;
				GeeIterator* _tmp12_;
				gpointer _tmp13_ = NULL;
				FolksBackend* backend;
				FolksBackend* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp10_ = _backend_it;
				_tmp11_ = gee_iterator_next (_tmp10_);
				if (!_tmp11_) {
					break;
				}
				_tmp12_ = _backend_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				backend = (FolksBackend*) _tmp13_;
				_tmp14_ = backend;
				_tmp15_ = folks_backend_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				folks_inspect_utils_print_line ("%s", _tmp16_);
				_g_object_unref0 (backend);
			}
			_g_object_unref0 (_backend_it);
		}
		folks_inspect_utils_unindent ();
		_g_object_unref0 (backends);
	} else {
		FolksInspectClient* _tmp17_;
		FolksBackendStore* _tmp18_;
		FolksBackendStore* _tmp19_;
		const gchar* _tmp20_;
		FolksBackend* _tmp21_ = NULL;
		FolksBackend* backend;
		FolksBackend* _tmp22_;
		FolksBackend* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		FolksBackend* _tmp27_;
		GeeMap* _tmp28_;
		GeeMap* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp17_ = ((FolksInspectCommand*) self)->client;
		_tmp18_ = folks_inspect_client_get_backend_store (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = command_string;
		_tmp21_ = folks_backend_store_dup_backend_by_name (_tmp19_, _tmp20_);
		backend = _tmp21_;
		_tmp22_ = backend;
		if (_tmp22_ == NULL) {
			const gchar* _tmp23_;
			_tmp23_ = command_string;
			folks_inspect_utils_print_line ("Unrecognised backend name '%s'.", _tmp23_);
			_g_object_unref0 (backend);
			return;
		}
		_tmp24_ = backend;
		_tmp25_ = folks_backend_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = backend;
		_tmp28_ = folks_backend_get_persona_stores (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = gee_map_get_size (_tmp29_);
		_tmp31_ = _tmp30_;
		folks_inspect_utils_print_line ("Backend '%s' with %u persona stores " "(type ID, ID ('display name')):", _tmp26_, _tmp31_);
		folks_inspect_utils_indent ();
		{
			FolksBackend* _tmp32_;
			GeeMap* _tmp33_;
			GeeMap* _tmp34_;
			GeeCollection* _tmp35_;
			GeeCollection* _tmp36_;
			GeeCollection* _tmp37_;
			GeeIterator* _tmp38_ = NULL;
			GeeIterator* _tmp39_;
			GeeIterator* _store_it;
			_tmp32_ = backend;
			_tmp33_ = folks_backend_get_persona_stores (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = gee_map_get_values (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
			_tmp39_ = _tmp38_;
			_g_object_unref0 (_tmp37_);
			_store_it = _tmp39_;
			while (TRUE) {
				GeeIterator* _tmp40_;
				gboolean _tmp41_ = FALSE;
				GeeIterator* _tmp42_;
				gpointer _tmp43_ = NULL;
				FolksPersonaStore* store;
				FolksPersonaStore* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				FolksPersonaStore* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				FolksPersonaStore* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				_tmp40_ = _store_it;
				_tmp41_ = gee_iterator_next (_tmp40_);
				if (!_tmp41_) {
					break;
				}
				_tmp42_ = _store_it;
				_tmp43_ = gee_iterator_get (_tmp42_);
				store = (FolksPersonaStore*) _tmp43_;
				_tmp44_ = store;
				_tmp45_ = folks_persona_store_get_type_id (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = store;
				_tmp48_ = folks_persona_store_get_id (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = store;
				_tmp51_ = folks_persona_store_get_display_name (_tmp50_);
				_tmp52_ = _tmp51_;
				folks_inspect_utils_print_line ("%s, %s ('%s')", _tmp46_, _tmp49_, _tmp52_);
				_g_object_unref0 (store);
			}
			_g_object_unref0 (_store_it);
		}
		folks_inspect_utils_unindent ();
		_g_object_unref0 (backend);
	}
}


static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_backend_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** folks_inspect_commands_backends_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsBackends * self;
	gchar** result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	self = (FolksInspectCommandsBackends*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = subcommand;
	_tmp2_ = _tmp1_ = rl_completion_matches (_tmp0_, _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static const gchar* folks_inspect_commands_backends_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsBackends* self;
	self = (FolksInspectCommandsBackends*) base;
	result = "backends";
	return result;
}


static const gchar* folks_inspect_commands_backends_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsBackends* self;
	self = (FolksInspectCommandsBackends*) base;
	result = "Inspect the backends loaded by the aggregator.";
	return result;
}


static const gchar* folks_inspect_commands_backends_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsBackends* self;
	self = (FolksInspectCommandsBackends*) base;
	result = "backends                   List all known backends.\n" "backends [backend name]    Display the details of the " "specified backend and list its persona stores.";
	return result;
}


static void folks_inspect_commands_backends_class_init (FolksInspectCommandsBackendsClass * klass) {
	folks_inspect_commands_backends_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_backends_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_backends_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_backends_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_backends_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_backends_real_get_help;
}


static void folks_inspect_commands_backends_instance_init (FolksInspectCommandsBackends * self) {
}


GType folks_inspect_commands_backends_get_type (void) {
	static volatile gsize folks_inspect_commands_backends_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_backends_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsBackendsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_backends_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsBackends), 0, (GInstanceInitFunc) folks_inspect_commands_backends_instance_init, NULL };
		GType folks_inspect_commands_backends_type_id;
		folks_inspect_commands_backends_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsBackends", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_backends_type_id__volatile, folks_inspect_commands_backends_type_id);
	}
	return folks_inspect_commands_backends_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



