/* memory-icon.c generated by valac 0.14.0.3-1a311, the Vala compiler
 * generated from memory-icon.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define EDSF_TYPE_MEMORY_ICON (edsf_memory_icon_get_type ())
#define EDSF_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIcon))
#define EDSF_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconClass))
#define EDSF_IS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDSF_TYPE_MEMORY_ICON))
#define EDSF_IS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDSF_TYPE_MEMORY_ICON))
#define EDSF_MEMORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconClass))

typedef struct _EdsfMemoryIcon EdsfMemoryIcon;
typedef struct _EdsfMemoryIconClass EdsfMemoryIconClass;
typedef struct _EdsfMemoryIconPrivate EdsfMemoryIconPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _EdsfMemoryIconLoadAsyncData EdsfMemoryIconLoadAsyncData;

struct _EdsfMemoryIcon {
	GObject parent_instance;
	EdsfMemoryIconPrivate * priv;
};

struct _EdsfMemoryIconClass {
	GObjectClass parent_class;
};

struct _EdsfMemoryIconPrivate {
	guint8* _image_data;
	gint _image_data_length1;
	gint __image_data_size_;
	gchar* _image_type;
};

struct _EdsfMemoryIconLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsfMemoryIcon* self;
	gint size;
	GCancellable* cancellable;
	gchar* type;
	GInputStream* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GMemoryInputStream* _tmp4_;
};


static gpointer edsf_memory_icon_parent_class = NULL;
static GIconIface* edsf_memory_icon_g_icon_parent_iface = NULL;
static GLoadableIconIface* edsf_memory_icon_g_loadable_icon_parent_iface = NULL;

GType edsf_memory_icon_get_type (void) G_GNUC_CONST;
#define EDSF_MEMORY_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconPrivate))
enum  {
	EDSF_MEMORY_ICON_DUMMY_PROPERTY
};
EdsfMemoryIcon* edsf_memory_icon_new (const gchar* image_type, guint8* image_data, int image_data_length1);
EdsfMemoryIcon* edsf_memory_icon_construct (GType object_type, const gchar* image_type, guint8* image_data, int image_data_length1);
static guint8* _vala_array_dup1 (guint8* self, int length);
static gboolean edsf_memory_icon_real_equal (GIcon* base, GIcon* icon2);
static guint edsf_memory_icon_real_hash (GIcon* base);
static GInputStream* edsf_memory_icon_real_load (GLoadableIcon* base, gint size, gchar** type, GCancellable* cancellable, GError** error);
static guint8* _vala_array_dup2 (guint8* self, int length);
static void _g_free_gdestroy_notify (void* data);
static void edsf_memory_icon_real_load_async_data_free (gpointer _data);
static void edsf_memory_icon_real_load_async (GLoadableIcon* base, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean edsf_memory_icon_real_load_async_co (EdsfMemoryIconLoadAsyncData* _data_);
static guint8* _vala_array_dup3 (guint8* self, int length);
static void edsf_memory_icon_finalize (GObject* obj);


/**
   * Construct a new in-memory icon.
   *
   * @param image_type the content type of the image
   * @param image_data the binary data of the image
   * @since 0.6.0
   */
static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


EdsfMemoryIcon* edsf_memory_icon_construct (GType object_type, const gchar* image_type, guint8* image_data, int image_data_length1) {
	EdsfMemoryIcon * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (image_type != NULL, NULL);
	self = (EdsfMemoryIcon*) g_object_new (object_type, NULL);
	_tmp0_ = image_data;
	_tmp0__length1 = image_data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_image_data = (g_free (self->priv->_image_data), NULL);
	self->priv->_image_data = _tmp1_;
	self->priv->_image_data_length1 = _tmp1__length1;
	self->priv->__image_data_size_ = self->priv->_image_data_length1;
	_tmp2_ = image_type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_image_type);
	self->priv->_image_type = _tmp3_;
	return self;
}


EdsfMemoryIcon* edsf_memory_icon_new (const gchar* image_type, guint8* image_data, int image_data_length1) {
	return edsf_memory_icon_construct (EDSF_TYPE_MEMORY_ICON, image_type, image_data, image_data_length1);
}


/**
   * Decide whether two {@link MemoryIcon} instances are equal. This compares
   * their image data and returns `true` if they are identical.
   *
   * @param icon2 the {@link MemoryIcon} instance to compare against
   * @return `true` if the instances are equal, `false` otherwise
   * @since 0.6.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean edsf_memory_icon_real_equal (GIcon* base, GIcon* icon2) {
	EdsfMemoryIcon * self;
	gboolean result = FALSE;
	GIcon* _tmp0_;
	EdsfMemoryIcon* _tmp1_;
	EdsfMemoryIcon* icon;
	EdsfMemoryIcon* _tmp2_;
	gboolean _tmp3_ = FALSE;
	guint8* _tmp4_;
	gint _tmp4__length1;
	EdsfMemoryIcon* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp12_;
	self = (EdsfMemoryIcon*) base;
	g_return_val_if_fail (icon2 != NULL, FALSE);
	_tmp0_ = icon2;
	_tmp1_ = _g_object_ref0 (EDSF_IS_MEMORY_ICON (_tmp0_) ? ((EdsfMemoryIcon*) _tmp0_) : NULL);
	icon = _tmp1_;
	_tmp2_ = icon;
	g_assert (_tmp2_ != NULL);
	_tmp4_ = self->priv->_image_data;
	_tmp4__length1 = self->priv->_image_data_length1;
	_tmp5_ = icon;
	_tmp6_ = _tmp5_->priv->_image_data;
	_tmp6__length1 = _tmp5_->priv->_image_data_length1;
	if (_tmp4__length1 == _tmp6__length1) {
		guint8* _tmp7_;
		gint _tmp7__length1;
		EdsfMemoryIcon* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		guint8* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_ = 0;
		_tmp7_ = self->priv->_image_data;
		_tmp7__length1 = self->priv->_image_data_length1;
		_tmp8_ = icon;
		_tmp9_ = _tmp8_->priv->_image_data;
		_tmp9__length1 = _tmp8_->priv->_image_data_length1;
		_tmp10_ = self->priv->_image_data;
		_tmp10__length1 = self->priv->_image_data_length1;
		_tmp11_ = memcmp (_tmp7_, _tmp9_, (gsize) _tmp10__length1);
		_tmp3_ = _tmp11_ == 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp12_ = _tmp3_;
	result = _tmp12_;
	_g_object_unref0 (icon);
	return result;
}


/**
   * Calculate a hash value of the image type and data, suitable for use as a
   * hash table key. This is not a cryptographic hash.
   *
   * @return hash value over the image type and data
   * @since 0.6.0
   */
static guint edsf_memory_icon_real_hash (GIcon* base) {
	EdsfMemoryIcon * self;
	guint result = 0U;
	const gchar* _tmp0_;
	guint _tmp1_ = 0U;
	guint hash;
	self = (EdsfMemoryIcon*) base;
	_tmp0_ = self->priv->_image_type;
	_tmp1_ = g_str_hash (_tmp0_);
	hash = _tmp1_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				guint _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				guint _tmp7_;
				guint _tmp8_;
				guint8* _tmp9_;
				gint _tmp9__length1;
				guint _tmp10_;
				guint8 _tmp11_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_image_data;
				_tmp6__length1 = self->priv->_image_data_length1;
				if (!(_tmp5_ < ((guint) _tmp6__length1))) {
					break;
				}
				_tmp7_ = hash;
				_tmp8_ = hash;
				_tmp9_ = self->priv->_image_data;
				_tmp9__length1 = self->priv->_image_data_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				hash = ((_tmp7_ << 5) + _tmp8_) + _tmp11_;
			}
		}
	}
	result = hash;
	return result;
}


/**
   * Build an input stream for loading the image data. This will return
   * without blocking on I/O.
   *
   * @param size the square dimensions to output the image at (unused), or -1
   * @param type return location for the content type of the image, or `null`
   * @param cancellable optional {@link GLib.Cancellable}, or `null`
   * @return an input stream providing access to the image data
   * @since 0.6.0
   */
static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void _g_free_gdestroy_notify (void* data) {
	g_free (data);
}


static GInputStream* edsf_memory_icon_real_load (GLoadableIcon* base, gint size, gchar** type, GCancellable* cancellable, GError** error) {
	EdsfMemoryIcon * self;
	gchar* _vala_type = NULL;
	GInputStream* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GMemoryInputStream* _tmp4_;
	self = (EdsfMemoryIcon*) base;
	_tmp0_ = self->priv->_image_type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_vala_type);
	_vala_type = _tmp1_;
	_tmp2_ = self->priv->_image_data;
	_tmp2__length1 = self->priv->_image_data_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, _g_free_gdestroy_notify);
	result = (GInputStream*) _tmp4_;
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	return result;
}


static void edsf_memory_icon_real_load_async_data_free (gpointer _data) {
	EdsfMemoryIconLoadAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (EdsfMemoryIconLoadAsyncData, _data_);
}


static void edsf_memory_icon_real_load_async (GLoadableIcon* base, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsfMemoryIcon * self;
	EdsfMemoryIconLoadAsyncData* _data_;
	EdsfMemoryIcon* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	self = (EdsfMemoryIcon*) base;
	_data_ = g_slice_new0 (EdsfMemoryIconLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, edsf_memory_icon_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, edsf_memory_icon_real_load_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = size;
	_data_->size = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data_->cancellable = _tmp3_;
	edsf_memory_icon_real_load_async_co (_data_);
}


static GInputStream* edsf_memory_icon_real_load_finish (GLoadableIcon* base, GAsyncResult* _res_, gchar** type, GError** error) {
	GInputStream* result;
	EdsfMemoryIconLoadAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (type) {
		*type = _data_->type;
	} else {
		_g_free0 (_data_->type);
	}
	_data_->type = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Asynchronously build an input stream for loading the image data. This
   * will complete without blocking on I/O.
   *
   * @param size the square dimensions to output the image at (unused), or -1
   * @param cancellable optional {@link GLib.Cancellable}, or `null`
   * @param type return location for the content type of the image, or `null`
   * @return an input stream providing access to the image data
   * @since 0.6.0
   */
static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean edsf_memory_icon_real_load_async_co (EdsfMemoryIconLoadAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_image_type;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_g_free0 (_data_->type);
	_data_->type = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_image_data;
	_data_->_tmp2__length1 = _data_->self->priv->_image_data_length1;
	_data_->_tmp3_ = (_data_->_tmp2_ != NULL) ? _vala_array_dup3 (_data_->_tmp2_, _data_->_tmp2__length1) : ((gpointer) _data_->_tmp2_);
	_data_->_tmp3__length1 = _data_->_tmp2__length1;
	_data_->_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_data_->_tmp3_, _data_->_tmp3__length1, _g_free_gdestroy_notify);
	_data_->result = (GInputStream*) _data_->_tmp4_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void edsf_memory_icon_class_init (EdsfMemoryIconClass * klass) {
	edsf_memory_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EdsfMemoryIconPrivate));
	G_OBJECT_CLASS (klass)->finalize = edsf_memory_icon_finalize;
}


static void edsf_memory_icon_g_icon_interface_init (GIconIface * iface) {
	edsf_memory_icon_g_icon_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal = (gboolean (*)(GIcon*, GIcon*)) edsf_memory_icon_real_equal;
	iface->hash = (guint (*)(GIcon*)) edsf_memory_icon_real_hash;
}


static void edsf_memory_icon_g_loadable_icon_interface_init (GLoadableIconIface * iface) {
	edsf_memory_icon_g_loadable_icon_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (GInputStream* (*)(GLoadableIcon*, gint, gchar**, GCancellable*, GError**)) edsf_memory_icon_real_load;
	iface->load_async = (GInputStream* (*)(GLoadableIcon*, gint, GCancellable*, gchar**, GError**)) edsf_memory_icon_real_load_async;
	iface->load_finish = edsf_memory_icon_real_load_finish;
}


static void edsf_memory_icon_instance_init (EdsfMemoryIcon * self) {
	self->priv = EDSF_MEMORY_ICON_GET_PRIVATE (self);
}


static void edsf_memory_icon_finalize (GObject* obj) {
	EdsfMemoryIcon * self;
	self = EDSF_MEMORY_ICON (obj);
	self->priv->_image_data = (g_free (self->priv->_image_data), NULL);
	_g_free0 (self->priv->_image_type);
	G_OBJECT_CLASS (edsf_memory_icon_parent_class)->finalize (obj);
}


/**
 * A wrapper around a blob of image data (with an associated content type) which
 * presents it as a {@link GLib.LoadableIcon}. This allows inlined avatars to be
 * returned as {@link GLib.LoadableIcon}s.
 *
 * @since 0.6.0
 */
GType edsf_memory_icon_get_type (void) {
	static volatile gsize edsf_memory_icon_type_id__volatile = 0;
	if (g_once_init_enter (&edsf_memory_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EdsfMemoryIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edsf_memory_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsfMemoryIcon), 0, (GInstanceInitFunc) edsf_memory_icon_instance_init, NULL };
		static const GInterfaceInfo g_icon_info = { (GInterfaceInitFunc) edsf_memory_icon_g_icon_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo g_loadable_icon_info = { (GInterfaceInitFunc) edsf_memory_icon_g_loadable_icon_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType edsf_memory_icon_type_id;
		edsf_memory_icon_type_id = g_type_register_static (G_TYPE_OBJECT, "EdsfMemoryIcon", &g_define_type_info, 0);
		g_type_add_interface_static (edsf_memory_icon_type_id, G_TYPE_ICON, &g_icon_info);
		g_type_add_interface_static (edsf_memory_icon_type_id, G_TYPE_LOADABLE_ICON, &g_loadable_icon_info);
		g_once_init_leave (&edsf_memory_icon_type_id__volatile, edsf_memory_icon_type_id);
	}
	return edsf_memory_icon_type_id__volatile;
}



