/* swf-persona-store.c generated by valac 0.13.4.11-4c506, the Vala compiler
 * generated from swf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gio/gio.h>


#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;
typedef struct _SwfPersonaStorePrivate SwfPersonaStorePrivate;

#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SwfPersonaStoreAddPersonaFromDetailsData SwfPersonaStoreAddPersonaFromDetailsData;
typedef struct _SwfPersonaStoreRemovePersonaData SwfPersonaStoreRemovePersonaData;
typedef struct _SwfPersonaStorePrepareData SwfPersonaStorePrepareData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SwfPersonaStore {
	FolksPersonaStore parent_instance;
	SwfPersonaStorePrivate * priv;
};

struct _SwfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _SwfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _is_quiescent;
	SwClientService* _service;
	SwClientContactView* _contact_view;
};

struct _SwfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	SwClientService* _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_;
};


static gpointer swf_persona_store_parent_class = NULL;
static gchar** swf_persona_store__always_writeable_properties;
static gint swf_persona_store__always_writeable_properties_length1;
static gchar** swf_persona_store__always_writeable_properties = NULL;
static gint swf_persona_store__always_writeable_properties_length1 = 0;
static gint _swf_persona_store__always_writeable_properties_size_ = 0;

GType swf_persona_store_get_type (void) G_GNUC_CONST;
GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA_STORE, SwfPersonaStorePrivate))
enum  {
	SWF_PERSONA_STORE_DUMMY_PROPERTY,
	SWF_PERSONA_STORE_TYPE_ID,
	SWF_PERSONA_STORE_CAN_ADD_PERSONAS,
	SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	SWF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	SWF_PERSONA_STORE_IS_PREPARED,
	SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	SWF_PERSONA_STORE_IS_QUIESCENT,
	SWF_PERSONA_STORE_PERSONAS
};
static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contacts, gpointer self);
static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contacts, gpointer self);
static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contacts, gpointer self);
SwfPersonaStore* swf_persona_store_new (SwClientService* service);
SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service);
static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* _data_);
static void swf_persona_store_real_remove_persona_data_free (gpointer _data);
static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* _data_);
static void swf_persona_store_real_prepare_data_free (gpointer _data);
static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* _data_);
static void _____lambda0_ (SwfPersonaStore* self, SwClientService* service, gchar** caps, int caps_length1, GError* _error_);
static void __lambda1_ (SwfPersonaStore* self, SwClientService* query, SwClientContactView* contact_view);
static void ___lambda1__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self);
static void ______lambda0__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self);
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
gchar* swf_persona_get_contact_id (SwContact* contact);
void swf_persona_update (SwfPersona* self, SwContact* contact);
static void swf_persona_store_finalize (GObject* obj);
static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);


static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contacts, gpointer self) {
#line 172 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_contacts_added_cb (self, contacts);
#line 176 "swf-persona-store.c"
}


static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contacts, gpointer self) {
#line 173 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_contacts_changed_cb (self, contacts);
#line 183 "swf-persona-store.c"
}


static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contacts, gpointer self) {
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_contacts_removed_cb (self, contacts);
#line 190 "swf-persona-store.c"
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * provided by the `service`.
   */
static gpointer _g_object_ref0 (gpointer self) {
#line 163 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 203 "swf-persona-store.c"
}


SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service) {
	SwfPersonaStore * self = NULL;
	SwClientService* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SwClientService* _tmp2_;
	const gchar* _tmp3_ = NULL;
	SwClientService* _tmp4_;
	SwClientService* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeMap* _tmp8_;
	GeeMap* _tmp9_;
#line 157 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_return_val_if_fail (service != NULL, NULL);
#line 159 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = service;
#line 159 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = sw_client_service_get_display_name (_tmp0_);
#line 159 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp2_ = service;
#line 159 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp3_ = sw_client_service_get_name (_tmp2_);
#line 159 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) g_object_new (object_type, "display-name", _tmp1_, "id", _tmp3_, NULL);
#line 162 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
#line 163 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp4_ = service;
#line 163 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 163 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_service);
#line 163 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_service = _tmp5_;
#line 164 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 164 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_personas);
#line 164 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_personas = _tmp6_;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp7_ = self->priv->_personas;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp8_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp7_);
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp9_ = _tmp8_;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_personas_ro);
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_personas_ro = _tmp9_;
#line 157 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return self;
#line 259 "swf-persona-store.c"
}


SwfPersonaStore* swf_persona_store_new (SwClientService* service) {
#line 157 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return swf_persona_store_construct (SWF_TYPE_PERSONA_STORE, service);
#line 266 "swf-persona-store.c"
}


static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_hash_table_unref0 (_data_->details);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (_data_->result);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_slice_free (SwfPersonaStoreAddPersonaFromDetailsData, _data_);
#line 281 "swf-persona-store.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 288 "swf-persona-store.c"
}


static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	SwfPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_ = g_slice_new0 (SwfPersonaStoreAddPersonaFromDetailsData);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_add_persona_from_details);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_add_persona_from_details_data_free);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->self = _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = details;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->details = _tmp2_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_real_add_persona_from_details_co (_data_);
#line 318 "swf-persona-store.c"
}


static FolksPersona* swf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return NULL;
#line 329 "swf-persona-store.c"
	}
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = _data_->result;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->result = NULL;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 339 "swf-persona-store.c"
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* _data_) {
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	switch (_data_->_state_) {
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case 0:
#line 353 "swf-persona-store.c"
		goto _state_0;
		default:
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_assert_not_reached ();
#line 358 "swf-persona-store.c"
	}
	_state_0:
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_inner_error_ = _data_->_tmp0_;
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_error_free (_data_->_inner_error_);
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		if (_data_->_state_ == 0) {
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 375 "swf-persona-store.c"
		} else {
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 379 "swf-persona-store.c"
		}
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_object_unref (_data_->_async_result);
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return FALSE;
#line 385 "swf-persona-store.c"
	} else {
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_clear_error (&_data_->_inner_error_);
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return FALSE;
#line 393 "swf-persona-store.c"
	}
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_data_->_state_ == 0) {
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 399 "swf-persona-store.c"
	} else {
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 403 "swf-persona-store.c"
	}
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_unref (_data_->_async_result);
#line 185 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return FALSE;
#line 409 "swf-persona-store.c"
}


static void swf_persona_store_real_remove_persona_data_free (gpointer _data) {
	SwfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (_data_->persona);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_slice_free (SwfPersonaStoreRemovePersonaData, _data_);
#line 422 "swf-persona-store.c"
}


static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreRemovePersonaData* _data_;
	SwfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_ = g_slice_new0 (SwfPersonaStoreRemovePersonaData);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_remove_persona);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_remove_persona_data_free);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->self = _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = persona;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->persona = _tmp2_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_real_remove_persona_co (_data_);
#line 452 "swf-persona-store.c"
}


static void swf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStoreRemovePersonaData* _data_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return;
#line 462 "swf-persona-store.c"
	}
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 466 "swf-persona-store.c"
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   */
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* _data_) {
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	switch (_data_->_state_) {
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case 0:
#line 480 "swf-persona-store.c"
		goto _state_0;
		default:
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_assert_not_reached ();
#line 485 "swf-persona-store.c"
	}
	_state_0:
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_inner_error_ = _data_->_tmp0_;
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_error_free (_data_->_inner_error_);
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		if (_data_->_state_ == 0) {
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 502 "swf-persona-store.c"
		} else {
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 506 "swf-persona-store.c"
		}
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_object_unref (_data_->_async_result);
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return FALSE;
#line 512 "swf-persona-store.c"
	} else {
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_clear_error (&_data_->_inner_error_);
#line 200 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return FALSE;
#line 520 "swf-persona-store.c"
	}
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_data_->_state_ == 0) {
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 526 "swf-persona-store.c"
	} else {
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 530 "swf-persona-store.c"
	}
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_unref (_data_->_async_result);
#line 197 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return FALSE;
#line 536 "swf-persona-store.c"
}


static void swf_persona_store_real_prepare_data_free (gpointer _data) {
	SwfPersonaStorePrepareData* _data_;
	_data_ = _data;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_slice_free (SwfPersonaStorePrepareData, _data_);
#line 547 "swf-persona-store.c"
}


static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStorePrepareData* _data_;
	SwfPersonaStore* _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_ = g_slice_new0 (SwfPersonaStorePrepareData);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_prepare);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_prepare_data_free);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_->self = _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_real_prepare_co (_data_);
#line 569 "swf-persona-store.c"
}


static void swf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStorePrepareData* _data_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 577 "swf-persona-store.c"
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   */
static void __lambda1_ (SwfPersonaStore* self, SwClientService* query, SwClientContactView* contact_view) {
	SwClientContactView* _tmp0_;
	SwClientContactView* _tmp1_;
	SwClientContactView* _tmp2_;
	SwClientContactView* _tmp3_;
	SwClientContactView* _tmp4_;
	SwClientContactView* _tmp5_;
	SwClientContactView* _tmp6_;
#line 228 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_return_if_fail (query != NULL);
#line 232 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = contact_view;
#line 232 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_tmp0_ == NULL) {
#line 233 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return;
#line 602 "swf-persona-store.c"
	}
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = contact_view;
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_signal_connect_object (_tmp1_, "contacts-added", (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self, 0);
#line 237 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp2_ = contact_view;
#line 237 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_signal_connect_object (_tmp2_, "contacts-changed", (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self, 0);
#line 239 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp3_ = contact_view;
#line 239 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_signal_connect_object (_tmp3_, "contacts-removed", (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self, 0);
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp4_ = contact_view;
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_contact_view);
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_contact_view = _tmp5_;
#line 243 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_is_prepared = TRUE;
#line 244 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_notify ((GObject*) self, "is-prepared");
#line 260 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_is_quiescent = TRUE;
#line 261 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_notify ((GObject*) self, "is-quiescent");
#line 263 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp6_ = self->priv->_contact_view;
#line 263 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	sw_client_contact_view_start (_tmp6_);
#line 636 "swf-persona-store.c"
}


static void ___lambda1__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self) {
#line 227 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	__lambda1_ (self, query, contact_view);
#line 643 "swf-persona-store.c"
}


static void _____lambda0_ (SwfPersonaStore* self, SwClientService* service, gchar** caps, int caps_length1, GError* _error_) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_ = FALSE;
	gboolean has_contacts;
	gboolean _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* parameters;
	SwClientService* _tmp7_;
	GHashTable* _tmp8_;
#line 216 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_return_if_fail (service != NULL);
#line 218 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = caps;
#line 218 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0__length1 = caps_length1;
#line 218 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_tmp0_ == NULL) {
#line 219 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return;
#line 671 "swf-persona-store.c"
	}
#line 221 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = caps;
#line 221 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1__length1 = caps_length1;
#line 221 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp2_ = sw_client_service_has_cap (_tmp1_, "has-contacts-query-iface");
#line 221 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	has_contacts = _tmp2_;
#line 223 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp3_ = has_contacts;
#line 223 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (!_tmp3_) {
#line 224 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		return;
#line 687 "swf-persona-store.c"
	}
#line 225 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp4_ = g_str_hash;
#line 225 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp5_ = g_str_equal;
#line 225 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, NULL, NULL);
#line 225 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	parameters = _tmp6_;
#line 227 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp7_ = self->priv->_service;
#line 227 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp8_ = parameters;
#line 227 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	sw_client_service_contacts_query_open_view (_tmp7_, "people", _tmp8_, ___lambda1__sw_client_service_contacts_query_open_view_callback, self);
#line 216 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_hash_table_unref0 (parameters);
#line 705 "swf-persona-store.c"
}


static void ______lambda0__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self) {
#line 215 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_____lambda0_ (self, service, caps, _vala_array_length (caps), _error_);
#line 712 "swf-persona-store.c"
}


static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* _data_) {
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	switch (_data_->_state_) {
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case 0:
#line 721 "swf-persona-store.c"
		goto _state_0;
		default:
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_assert_not_reached ();
#line 726 "swf-persona-store.c"
	}
	_state_0:
	{
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
#line 734 "swf-persona-store.c"
		{
#line 213 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
#line 213 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			if (!_data_->_tmp1_) {
#line 215 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_data_->_tmp2_ = _data_->self->priv->_service;
#line 215 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				sw_client_service_get_static_capabilities (_data_->_tmp2_, ______lambda0__sw_client_service_get_capabilities_callback, _data_->self);
#line 744 "swf-persona-store.c"
			}
		}
		__finally2:
		{
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			_data_->_tmp3_ = _data_->self->priv->_is_prepared;
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
#line 753 "swf-persona-store.c"
		}
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 211 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			return FALSE;
#line 763 "swf-persona-store.c"
		}
	}
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_data_->_state_ == 0) {
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 770 "swf-persona-store.c"
	} else {
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 774 "swf-persona-store.c"
	}
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_unref (_data_->_async_result);
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return FALSE;
#line 780 "swf-persona-store.c"
}


static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts) {
	GeeHashSet* _tmp0_;
	GeeHashSet* added_personas;
	GList* _tmp1_;
	GeeHashSet* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp15_;
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_return_if_fail (self != NULL);
#line 272 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = gee_hash_set_new (SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
#line 272 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	added_personas = _tmp0_;
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = contacts;
#line 800 "swf-persona-store.c"
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		contact_collection = _tmp1_;
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
#line 808 "swf-persona-store.c"
			SwContact* contact = NULL;
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			contact = (SwContact*) contact_it->data;
#line 812 "swf-persona-store.c"
			{
				SwContact* _tmp2_;
				SwfPersona* _tmp3_;
				SwfPersona* persona;
				GeeHashMap* _tmp4_;
				SwfPersona* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				SwfPersona* _tmp8_;
				GeeHashSet* _tmp9_;
				SwfPersona* _tmp10_;
#line 275 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp2_ = contact;
#line 275 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp3_ = swf_persona_new (self, _tmp2_);
#line 275 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				persona = _tmp3_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp4_ = self->priv->_personas;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp5_ = persona;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp6_ = folks_persona_get_iid ((FolksPersona*) _tmp5_);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp7_ = _tmp6_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp8_ = persona;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp7_, _tmp8_);
#line 277 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp9_ = added_personas;
#line 277 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp10_ = persona;
#line 277 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_object_unref0 (persona);
#line 850 "swf-persona-store.c"
			}
		}
	}
#line 280 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp11_ = added_personas;
#line 280 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
#line 280 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp13_ = _tmp12_;
#line 280 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_tmp13_ > 0) {
#line 862 "swf-persona-store.c"
		GeeHashSet* _tmp14_;
#line 282 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_tmp14_ = added_personas;
#line 282 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp14_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
#line 868 "swf-persona-store.c"
	}
#line 288 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp15_ = self->priv->_is_quiescent;
#line 288 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_tmp15_ == FALSE) {
#line 290 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		self->priv->_is_quiescent = TRUE;
#line 291 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_object_notify ((GObject*) self, "is-quiescent");
#line 878 "swf-persona-store.c"
	}
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (added_personas);
#line 882 "swf-persona-store.c"
}


static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts) {
	GList* _tmp0_;
#line 295 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_return_if_fail (self != NULL);
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = contacts;
#line 892 "swf-persona-store.c"
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		contact_collection = _tmp0_;
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
#line 900 "swf-persona-store.c"
			SwContact* contact = NULL;
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			contact = (SwContact*) contact_it->data;
#line 904 "swf-persona-store.c"
			{
				SwClientService* _tmp1_;
				const gchar* _tmp2_ = NULL;
				SwContact* _tmp3_;
				const gchar* _tmp4_;
				SwContact* _tmp5_;
				const gchar* _tmp6_;
				SwContact* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* iid;
				GeeHashMap* _tmp12_;
				const gchar* _tmp13_;
				gpointer _tmp14_ = NULL;
				SwfPersona* persona;
				SwfPersona* _tmp15_;
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp1_ = self->priv->_service;
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp2_ = sw_client_service_get_name (_tmp1_);
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp3_ = contact;
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp4_ = _tmp3_->service;
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
#line 301 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					continue;
#line 935 "swf-persona-store.c"
				}
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp5_ = contact;
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp6_ = _tmp5_->service;
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp7_ = contact;
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp8_ = swf_persona_get_contact_id (_tmp7_);
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp9_ = _tmp8_;
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp10_ = _swf_persona_build_iid (_tmp6_, _tmp9_);
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp11_ = _tmp10_;
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_free0 (_tmp9_);
#line 303 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				iid = _tmp11_;
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp12_ = self->priv->_personas;
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp13_ = iid;
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				persona = (SwfPersona*) _tmp14_;
#line 305 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp15_ = persona;
#line 305 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				if (_tmp15_ != NULL) {
#line 967 "swf-persona-store.c"
					SwfPersona* _tmp16_;
					SwContact* _tmp17_;
#line 306 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp16_ = persona;
#line 306 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp17_ = contact;
#line 306 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					swf_persona_update (_tmp16_, _tmp17_);
#line 976 "swf-persona-store.c"
				}
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_object_unref0 (persona);
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_free0 (iid);
#line 982 "swf-persona-store.c"
			}
		}
	}
}


static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts) {
	GeeHashSet* _tmp0_;
	GeeHashSet* removed_personas;
	GList* _tmp1_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
#line 310 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_return_if_fail (self != NULL);
#line 312 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = gee_hash_set_new (SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
#line 312 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	removed_personas = _tmp0_;
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = contacts;
#line 1004 "swf-persona-store.c"
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		contact_collection = _tmp1_;
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
#line 1012 "swf-persona-store.c"
			SwContact* contact = NULL;
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			contact = (SwContact*) contact_it->data;
#line 1016 "swf-persona-store.c"
			{
				SwClientService* _tmp2_;
				const gchar* _tmp3_ = NULL;
				SwContact* _tmp4_;
				const gchar* _tmp5_;
				SwContact* _tmp6_;
				const gchar* _tmp7_;
				SwContact* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* iid;
				GeeHashMap* _tmp13_;
				const gchar* _tmp14_;
				gpointer _tmp15_ = NULL;
				SwfPersona* persona;
				SwfPersona* _tmp16_;
#line 315 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp2_ = self->priv->_service;
#line 315 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp3_ = sw_client_service_get_name (_tmp2_);
#line 315 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp4_ = contact;
#line 315 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp5_ = _tmp4_->service;
#line 315 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
#line 317 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					continue;
#line 1047 "swf-persona-store.c"
				}
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp6_ = contact;
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp7_ = _tmp6_->service;
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp8_ = contact;
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp9_ = swf_persona_get_contact_id (_tmp8_);
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp10_ = _tmp9_;
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp11_ = _swf_persona_build_iid (_tmp7_, _tmp10_);
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp12_ = _tmp11_;
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_free0 (_tmp10_);
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				iid = _tmp12_;
#line 320 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp13_ = self->priv->_personas;
#line 320 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp14_ = iid;
#line 320 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
#line 320 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				persona = (SwfPersona*) _tmp15_;
#line 321 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_tmp16_ = persona;
#line 321 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				if (_tmp16_ != NULL) {
#line 1079 "swf-persona-store.c"
					GeeHashSet* _tmp17_;
					SwfPersona* _tmp18_;
					GeeHashMap* _tmp19_;
					SwfPersona* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
#line 323 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp17_ = removed_personas;
#line 323 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp18_ = persona;
#line 323 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 324 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp19_ = self->priv->_personas;
#line 324 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp20_ = persona;
#line 324 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp21_ = folks_persona_get_iid ((FolksPersona*) _tmp20_);
#line 324 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					_tmp22_ = _tmp21_;
#line 324 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp22_, NULL);
#line 1102 "swf-persona-store.c"
				}
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_object_unref0 (persona);
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
				_g_free0 (iid);
#line 1108 "swf-persona-store.c"
			}
		}
	}
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp23_ = removed_personas;
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp25_ = _tmp24_;
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_tmp25_ > 0) {
#line 1120 "swf-persona-store.c"
		GeeHashSet* _tmp26_;
#line 330 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_tmp26_ = removed_personas;
#line 330 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp26_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
#line 1126 "swf-persona-store.c"
	}
#line 310 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (removed_personas);
#line 1130 "swf-persona-store.c"
}


static const gchar* swf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	SwfPersonaStore* self;
#line 57 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 57 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = BACKEND_NAME;
#line 57 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1143 "swf-persona-store.c"
}


static FolksMaybeBool swf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
#line 68 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 68 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = FOLKS_MAYBE_BOOL_FALSE;
#line 68 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1156 "swf-persona-store.c"
}


static FolksMaybeBool swf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
#line 80 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 80 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = FOLKS_MAYBE_BOOL_FALSE;
#line 80 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1169 "swf-persona-store.c"
}


static FolksMaybeBool swf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = FOLKS_MAYBE_BOOL_FALSE;
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1182 "swf-persona-store.c"
}


static FolksMaybeBool swf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
#line 104 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 104 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = FOLKS_MAYBE_BOOL_FALSE;
#line 104 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1195 "swf-persona-store.c"
}


static gboolean swf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
#line 116 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 116 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = self->priv->_is_prepared;
#line 116 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = _tmp0_;
#line 116 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1211 "swf-persona-store.c"
}


static gchar** swf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	SwfPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = swf_persona_store__always_writeable_properties;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0__length1 = swf_persona_store__always_writeable_properties_length1;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1_ = _tmp0_;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp1__length1 = _tmp0__length1;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (result_length1) {
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		*result_length1 = _tmp1__length1;
#line 1236 "swf-persona-store.c"
	}
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = _tmp1_;
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1242 "swf-persona-store.c"
}


static gboolean swf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
#line 138 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 138 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = self->priv->_is_quiescent;
#line 138 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = _tmp0_;
#line 138 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1258 "swf-persona-store.c"
}


static GeeMap* swf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	SwfPersonaStore* self;
	GeeMap* _tmp0_;
#line 148 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = (SwfPersonaStore*) base;
#line 148 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = self->priv->_personas_ro;
#line 148 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	result = _tmp0_;
#line 148 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	return result;
#line 1274 "swf-persona-store.c"
}


static void swf_persona_store_class_init (SwfPersonaStoreClass * klass) {
	gchar** _tmp0_ = NULL;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store_parent_class = g_type_class_peek_parent (klass);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_type_class_add_private (klass, sizeof (SwfPersonaStorePrivate));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = swf_persona_store_real_add_persona_from_details;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = swf_persona_store_real_add_persona_from_details_finish;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = swf_persona_store_real_remove_persona;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = swf_persona_store_real_remove_persona_finish;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = swf_persona_store_real_prepare;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = swf_persona_store_real_prepare_finish;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = swf_persona_store_real_get_type_id;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = swf_persona_store_real_get_can_add_personas;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = swf_persona_store_real_get_can_alias_personas;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = swf_persona_store_real_get_can_group_personas;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = swf_persona_store_real_get_can_remove_personas;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = swf_persona_store_real_get_is_prepared;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = swf_persona_store_real_get_always_writeable_properties;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = swf_persona_store_real_get_is_quiescent;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = swf_persona_store_real_get_personas;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_store_get_property;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	G_OBJECT_CLASS (klass)->finalize = swf_persona_store_finalize;
#line 1318 "swf-persona-store.c"
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_TYPE_ID, "type-id");
#line 1326 "swf-persona-store.c"
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.5.0
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ADD_PERSONAS, "can-add-personas");
#line 1336 "swf-persona-store.c"
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.5.0
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS, "can-alias-personas");
#line 1346 "swf-persona-store.c"
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.5.0
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_GROUP_PERSONAS, "can-group-personas");
#line 1356 "swf-persona-store.c"
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.5.0
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS, "can-remove-personas");
#line 1366 "swf-persona-store.c"
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.5.0
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_PREPARED, "is-prepared");
#line 1376 "swf-persona-store.c"
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, "always-writeable-properties");
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_QUIESCENT, "is-quiescent");
#line 1386 "swf-persona-store.c"
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_PERSONAS, "personas");
#line 50 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 50 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store__always_writeable_properties = _tmp0_;
#line 50 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	swf_persona_store__always_writeable_properties_length1 = 0;
#line 1400 "swf-persona-store.c"
}


static void swf_persona_store_instance_init (SwfPersonaStore * self) {
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv = SWF_PERSONA_STORE_GET_PRIVATE (self);
#line 39 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
#line 39 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_is_prepared = FALSE;
#line 40 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self->priv->_is_quiescent = FALSE;
#line 1413 "swf-persona-store.c"
}


static void swf_persona_store_finalize (GObject* obj) {
	SwfPersonaStore * self;
	SwClientContactView* _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	self = SWF_PERSONA_STORE (obj);
#line 170 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_tmp0_ = self->priv->_contact_view;
#line 170 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	if (_tmp0_ != NULL) {
#line 1426 "swf-persona-store.c"
		SwClientContactView* _tmp1_;
		guint _tmp2_ = 0U;
		SwClientContactView* _tmp3_;
		guint _tmp4_ = 0U;
		SwClientContactView* _tmp5_;
		guint _tmp6_ = 0U;
#line 172 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_tmp1_ = self->priv->_contact_view;
#line 172 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_signal_parse_name ("contacts-added", sw_client_contact_view_get_type (), &_tmp2_, NULL, FALSE);
#line 172 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self);
#line 173 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_tmp3_ = self->priv->_contact_view;
#line 173 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_signal_parse_name ("contacts-changed", sw_client_contact_view_get_type (), &_tmp4_, NULL, FALSE);
#line 173 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self);
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		_tmp5_ = self->priv->_contact_view;
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_signal_parse_name ("contacts-removed", sw_client_contact_view_get_type (), &_tmp6_, NULL, FALSE);
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self);
#line 1451 "swf-persona-store.c"
	}
#line 37 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_personas);
#line 38 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_personas_ro);
#line 39 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
#line 41 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_service);
#line 42 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	_g_object_unref0 (self->priv->_contact_view);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	G_OBJECT_CLASS (swf_persona_store_parent_class)->finalize (obj);
#line 1465 "swf-persona-store.c"
}


/**
 * A persona store which is associated with a single libsocialweb service.
 * It will create {@link Persona}s for each of the contacts known to that
 * service.
 */
GType swf_persona_store_get_type (void) {
	static volatile gsize swf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersonaStore), 0, (GInstanceInitFunc) swf_persona_store_instance_init, NULL };
		GType swf_persona_store_type_id;
		swf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "SwfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&swf_persona_store_type_id__volatile, swf_persona_store_type_id);
	}
	return swf_persona_store_type_id__volatile;
}


static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersonaStore * self;
	self = SWF_PERSONA_STORE (object);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
	switch (property_id) {
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_TYPE_ID:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_CAN_ADD_PERSONAS:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_CAN_GROUP_PERSONAS:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_IS_PREPARED:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
#line 1529 "swf-persona-store.c"
		{
			int length;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
#line 1534 "swf-persona-store.c"
		}
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_IS_QUIESCENT:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		case SWF_PERSONA_STORE_PERSONAS:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 1550 "swf-persona-store.c"
		default:
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona-store.vala"
		break;
#line 1556 "swf-persona-store.c"
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



