/* swf-persona.c generated by valac 0.13.4.11-4c506, the Vala compiler
 * generated from swf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>


#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
typedef struct _SwfPersonaPrivate SwfPersonaPrivate;
#define __vala_SwContact_free0(var) ((var == NULL) ? NULL : (var = (_vala_SwContact_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;

struct _SwfPersona {
	FolksPersona parent_instance;
	SwfPersonaPrivate * priv;
};

struct _SwfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _SwfPersonaPrivate {
	GLoadableIcon* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksGender _gender;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashMultiMap* _im_addresses;
	GeeHashMultiMap* _web_service_addresses;
	SwContact* _lsw_contact;
};


static gpointer swf_persona_parent_class = NULL;
static gchar** swf_persona__writeable_properties;
static gint swf_persona__writeable_properties_length1;
static gchar** swf_persona__writeable_properties = NULL;
static gint swf_persona__writeable_properties_length1 = 0;
static gint _swf_persona__writeable_properties_size_ = 0;
static FolksAvatarDetailsIface* swf_persona_folks_avatar_details_parent_iface = NULL;
static FolksGenderDetailsIface* swf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* swf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* swf_persona_folks_name_details_parent_iface = NULL;
static FolksUrlDetailsIface* swf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* swf_persona_folks_web_service_details_parent_iface = NULL;

GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA, SwfPersonaPrivate))
enum  {
	SWF_PERSONA_DUMMY_PROPERTY,
	SWF_PERSONA_LINKABLE_PROPERTIES,
	SWF_PERSONA_WRITEABLE_PROPERTIES,
	SWF_PERSONA_AVATAR,
	SWF_PERSONA_STRUCTURED_NAME,
	SWF_PERSONA_FULL_NAME,
	SWF_PERSONA_NICKNAME,
	SWF_PERSONA_GENDER,
	SWF_PERSONA_URLS,
	SWF_PERSONA_IM_ADDRESSES,
	SWF_PERSONA_WEB_SERVICE_ADDRESSES,
	SWF_PERSONA_LSW_CONTACT
};
static void _vala_SwContact_free (SwContact* self);
static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key);
gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
GType swf_persona_store_get_type (void) G_GNUC_CONST;
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* swf_persona_get_contact_id (SwContact* contact);
static void swf_persona_set_lsw_contact (SwfPersona* self, SwContact* value);
void swf_persona_update (SwfPersona* self, SwContact* contact);
SwContact* swf_persona_get_lsw_contact (SwfPersona* self);
static void swf_persona_finalize (GObject* obj);
static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SWF_PERSONA__linkable_properties[2] = {"im-addresses", "web-service-addresses"};

static void _vala_SwContact_free (SwContact* self) {
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_boxed_free (sw_contact_get_type (), self);
#line 134 "swf-persona.c"
}


static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key) {
	guint result;
	result = folks_abstract_field_details_hash (key);
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 143 "swf-persona.c"
}


/**
   * Build the Facebook JID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return the Facebook JID or null if it is not a Facebook contact
   *
   * @since 0.5.0
   */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1378 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1378 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1379 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1379 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1379 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1379 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 172 "swf-persona.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1382 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1382 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1382 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 185 "swf-persona.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 215 "swf-persona.c"
				goto __catch0_g_regex_error;
			}
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1384 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 224 "swf-persona.c"
		}
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 240 "swf-persona.c"
				goto __catch0_g_regex_error;
			}
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 251 "swf-persona.c"
		}
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1385 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 259 "swf-persona.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1387 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 273 "swf-persona.c"
	}
	__finally0:
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1383 "/opt/gnome3/build/share/vala-0.14/vapi/glib-2.0.vapi"
		return NULL;
#line 284 "swf-persona.c"
	}
}


gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp4_;
#line 207 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (store_id != NULL, NULL);
#line 207 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (lsw_id != NULL, NULL);
#line 209 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	facebook_jid = NULL;
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = store_id;
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (g_strcmp0 (_tmp1_, "facebook") == 0) {
#line 305 "swf-persona.c"
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp2_ = lsw_id;
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp3_ = string_contains (_tmp2_, "facebook-");
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp0_ = _tmp3_;
#line 314 "swf-persona.c"
	} else {
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp0_ = FALSE;
#line 318 "swf-persona.c"
	}
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp4_ = _tmp0_;
#line 210 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp4_) {
#line 324 "swf-persona.c"
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp5_ = lsw_id;
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp6_ = string_replace (_tmp5_, "facebook", "");
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp7_ = _tmp6_;
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp8_ = g_strconcat (_tmp7_, "@chat.facebook.com", NULL);
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (facebook_jid);
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		facebook_jid = _tmp8_;
#line 214 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (_tmp7_);
#line 343 "swf-persona.c"
	}
#line 216 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = facebook_jid;
#line 216 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 349 "swf-persona.c"
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gchar* iid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
#line 228 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (store_id != NULL, NULL);
#line 228 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (lsw_id != NULL, NULL);
#line 233 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	facebook_jid = NULL;
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = store_id;
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = lsw_id;
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp2_ = _swf_persona_build_facebook_jid (_tmp0_, _tmp1_);
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (facebook_jid);
#line 235 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	facebook_jid = _tmp2_;
#line 236 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp3_ = facebook_jid;
#line 236 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp3_ != NULL) {
#line 390 "swf-persona.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 238 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp4_ = facebook_jid;
#line 238 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp5_ = g_strconcat ("jabber:", _tmp4_, NULL);
#line 238 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (iid);
#line 238 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		iid = _tmp5_;
#line 401 "swf-persona.c"
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp6_ = store_id;
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp7_ = g_strconcat (_tmp6_, ":", NULL);
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp8_ = _tmp7_;
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp9_ = lsw_id;
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (iid);
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		iid = _tmp10_;
#line 242 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (_tmp8_);
#line 424 "swf-persona.c"
	}
#line 244 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = iid;
#line 244 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (facebook_jid);
#line 244 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 432 "swf-persona.c"
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the libsocialweb contact given by `contact`.
   */
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact) {
	SwfPersona * self = NULL;
	SwContact* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	SwContact* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* service;
	SwfPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* uid;
	SwfPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* iid;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	SwfPersonaStore* _tmp18_;
	SwContact* _tmp19_;
	const gchar* _tmp20_;
	SwfPersonaStore* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	SwfPersonaStore* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* facebook_jid;
	const gchar* _tmp30_;
	GeeHashMultiMap* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	FolksWebServiceFieldDetails* _tmp52_;
	FolksWebServiceFieldDetails* _tmp53_;
	SwContact* _tmp54_;
	GError * _inner_error_ = NULL;
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (contact != NULL, NULL);
#line 255 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = contact;
#line 255 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = swf_persona_get_contact_id (_tmp0_);
#line 255 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	id = _tmp1_;
#line 256 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp2_ = contact;
#line 256 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp3_ = _tmp2_->service;
#line 256 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 256 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	service = _tmp4_;
#line 257 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp5_ = store;
#line 257 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp6_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp5_);
#line 257 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp7_ = _tmp6_;
#line 257 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp8_ = id;
#line 257 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp9_ = folks_persona_build_uid (BACKEND_NAME, _tmp7_, _tmp8_);
#line 257 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	uid = _tmp9_;
#line 258 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp10_ = store;
#line 258 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
#line 258 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp12_ = _tmp11_;
#line 258 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp13_ = id;
#line 258 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp14_ = _swf_persona_build_iid (_tmp12_, _tmp13_);
#line 258 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iid = _tmp14_;
#line 260 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp15_ = id;
#line 260 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp16_ = uid;
#line 260 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp17_ = iid;
#line 260 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp18_ = store;
#line 260 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) g_object_new (object_type, "display-id", _tmp15_, "uid", _tmp16_, "iid", _tmp17_, "store", _tmp18_, "is-user", FALSE, NULL);
#line 265 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp19_ = contact;
#line 265 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_set_lsw_contact (self, _tmp19_);
#line 267 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp20_ = uid;
#line 267 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp21_ = store;
#line 267 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp22_ = folks_persona_store_get_display_name ((FolksPersonaStore*) _tmp21_);
#line 267 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp23_ = _tmp22_;
#line 267 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp24_ = id;
#line 267 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_debug ("swf-persona.vala:267: Creating new Sw.Persona '%s' for %s UID '%s': %p", _tmp20_, _tmp23_, _tmp24_, self);
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp25_ = store;
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp26_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp25_);
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp27_ = _tmp26_;
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp28_ = id;
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp29_ = _swf_persona_build_facebook_jid (_tmp27_, _tmp28_);
#line 270 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	facebook_jid = _tmp29_;
#line 271 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp30_ = facebook_jid;
#line 271 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp30_ != NULL) {
#line 571 "swf-persona.c"
		{
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* facebook_jid_copy;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* normalised_addr;
			gchar* _tmp41_;
			gchar* im_proto;
			const gchar* _tmp42_;
			FolksImFieldDetails* _tmp43_;
			FolksImFieldDetails* im_fd;
			GeeHashMultiMap* _tmp44_;
			const gchar* _tmp45_;
			FolksImFieldDetails* _tmp46_;
#line 275 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp31_ = facebook_jid;
#line 275 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 275 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			facebook_jid_copy = _tmp32_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp33_ = facebook_jid_copy;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			facebook_jid_copy = NULL;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp34_ = _tmp33_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp35_ = folks_im_details_normalise_im_address (_tmp34_, "jabber", &_inner_error_);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp36_ = _tmp35_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (_tmp34_);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp37_ = _tmp36_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			if (_inner_error_ != NULL) {
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (facebook_jid_copy);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
#line 619 "swf-persona.c"
					goto __catch1_folks_im_details_error;
				}
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (facebook_jid_copy);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (facebook_jid);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (iid);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (uid);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (service);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				_g_free0 (id);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				g_clear_error (&_inner_error_);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
				return NULL;
#line 640 "swf-persona.c"
			}
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp38_ = _tmp37_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp39_ = _tmp38_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp38_ = NULL;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp40_ = _tmp39_;
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (_tmp38_);
#line 276 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			normalised_addr = _tmp40_;
#line 278 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp41_ = g_strdup ("jabber");
#line 278 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			im_proto = _tmp41_;
#line 279 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp42_ = normalised_addr;
#line 279 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp43_ = folks_im_field_details_new (_tmp42_, NULL);
#line 279 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			im_fd = _tmp43_;
#line 281 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp44_ = self->priv->_im_addresses;
#line 281 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp45_ = im_proto;
#line 281 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp46_ = im_fd;
#line 281 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			gee_multi_map_set ((GeeMultiMap*) _tmp44_, _tmp45_, _tmp46_);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_object_unref0 (im_fd);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (im_proto);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (normalised_addr);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (facebook_jid_copy);
#line 680 "swf-persona.c"
		}
		goto __finally1;
		__catch1_folks_im_details_error:
		{
			GError* e = NULL;
			GError* _tmp47_;
			const gchar* _tmp48_;
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			e = _inner_error_;
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_inner_error_ = NULL;
#line 285 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp47_ = e;
#line 285 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp48_ = _tmp47_->message;
#line 285 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_warning ("swf-persona.vala:285: %s", _tmp48_);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_error_free0 (e);
#line 700 "swf-persona.c"
		}
		__finally1:
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		if (_inner_error_ != NULL) {
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (facebook_jid);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (iid);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (uid);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (service);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (id);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_clear_error (&_inner_error_);
#line 273 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			return NULL;
#line 721 "swf-persona.c"
		}
	}
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp49_ = self->priv->_web_service_addresses;
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp50_ = service;
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp51_ = id;
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp52_ = folks_web_service_field_details_new (_tmp51_, NULL);
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp53_ = _tmp52_;
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	gee_multi_map_set ((GeeMultiMap*) _tmp49_, _tmp50_, _tmp53_);
#line 289 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (_tmp53_);
#line 292 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp54_ = contact;
#line 292 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_update (self, _tmp54_);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (facebook_jid);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (iid);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (uid);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (service);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (id);
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return self;
#line 754 "swf-persona.c"
}


SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact) {
#line 253 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return swf_persona_construct (SWF_TYPE_PERSONA, store, contact);
#line 761 "swf-persona.c"
}


gchar* swf_persona_get_contact_id (SwContact* contact) {
	gchar* result = NULL;
	SwContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 302 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (contact != NULL, NULL);
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = contact;
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = sw_contact_get_value (_tmp0_, "id");
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp2_;
#line 304 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 782 "swf-persona.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return self ? g_object_ref (self) : NULL;
#line 789 "swf-persona.c"
}


void swf_persona_update (SwfPersona* self, SwContact* contact) {
	SwContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* nickname;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SwContact* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* avatar_path;
	const gchar* _tmp12_;
	SwContact* _tmp26_;
	const gchar* _tmp27_ = NULL;
	SwContact* _tmp28_;
	const gchar* _tmp29_ = NULL;
	FolksStructuredName* _tmp30_;
	FolksStructuredName* structured_name;
	FolksStructuredName* _tmp31_;
	gboolean _tmp32_ = FALSE;
	SwContact* _tmp37_;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gchar* full_name;
	const gchar* _tmp40_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GeeHashSet* _tmp46_;
	GeeHashSet* urls;
	SwContact* _tmp47_;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_;
	gchar* website;
	const gchar* _tmp50_;
	GeeHashSet* _tmp55_;
	GeeHashSet* _tmp56_;
	SwContact* _tmp62_;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_;
	gchar* gender_string;
	FolksGender gender = 0;
	gboolean _tmp65_ = FALSE;
	const gchar* _tmp66_;
	gboolean _tmp70_;
	FolksGender _tmp77_;
	FolksGender _tmp78_;
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_if_fail (self != NULL);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_if_fail (contact != NULL);
#line 309 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = contact;
#line 309 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = sw_contact_get_value (_tmp0_, "name");
#line 309 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 309 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	nickname = _tmp2_;
#line 311 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp3_ = nickname;
#line 311 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp3_ == NULL) {
#line 856 "swf-persona.c"
		gchar* _tmp4_;
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp4_ = g_strdup ("");
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (nickname);
#line 313 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		nickname = _tmp4_;
#line 864 "swf-persona.c"
	}
#line 316 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp5_ = self->priv->_nickname;
#line 316 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp6_ = nickname;
#line 316 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
#line 872 "swf-persona.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 318 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp7_ = nickname;
#line 318 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 318 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (self->priv->_nickname);
#line 318 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_nickname = _tmp8_;
#line 319 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_object_notify ((GObject*) self, "nickname");
#line 885 "swf-persona.c"
	}
#line 322 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp9_ = contact;
#line 322 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp10_ = sw_contact_get_value (_tmp9_, "icon");
#line 322 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 322 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	avatar_path = _tmp11_;
#line 323 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp12_ = avatar_path;
#line 323 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp12_ != NULL) {
#line 899 "swf-persona.c"
		const gchar* _tmp13_;
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_;
		GFileIcon* _tmp16_;
		GFileIcon* _tmp17_;
		GFileIcon* icon;
		gboolean _tmp18_ = FALSE;
		GLoadableIcon* _tmp19_;
		gboolean _tmp23_;
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp13_ = avatar_path;
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp14_ = g_file_new_for_path (_tmp13_);
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp15_ = _tmp14_;
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp16_ = (GFileIcon*) g_file_icon_new (_tmp15_);
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp17_ = _tmp16_;
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (_tmp15_);
#line 325 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		icon = _tmp17_;
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp19_ = self->priv->_avatar;
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		if (_tmp19_ == NULL) {
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp18_ = TRUE;
#line 929 "swf-persona.c"
		} else {
			GLoadableIcon* _tmp20_;
			GFileIcon* _tmp21_;
			gboolean _tmp22_ = FALSE;
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp20_ = self->priv->_avatar;
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp21_ = icon;
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp22_ = g_icon_equal ((GIcon*) _tmp20_, (GIcon*) _tmp21_);
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp18_ = !_tmp22_;
#line 942 "swf-persona.c"
		}
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp23_ = _tmp18_;
#line 326 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		if (_tmp23_) {
#line 948 "swf-persona.c"
			GFileIcon* _tmp24_;
			GLoadableIcon* _tmp25_;
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp24_ = icon;
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp25_ = _g_object_ref0 ((GLoadableIcon*) _tmp24_);
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_object_unref0 (self->priv->_avatar);
#line 328 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			self->priv->_avatar = _tmp25_;
#line 329 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_object_notify ((GObject*) self, "avatar");
#line 961 "swf-persona.c"
		}
#line 323 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (icon);
#line 965 "swf-persona.c"
	} else {
#line 334 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (self->priv->_avatar);
#line 334 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_avatar = NULL;
#line 335 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_object_notify ((GObject*) self, "avatar");
#line 973 "swf-persona.c"
	}
#line 338 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp26_ = contact;
#line 338 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp27_ = sw_contact_get_value (_tmp26_, "n.family");
#line 338 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp28_ = contact;
#line 338 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp29_ = sw_contact_get_value (_tmp28_, "n.given");
#line 338 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp30_ = folks_structured_name_new_simple (_tmp27_, _tmp29_);
#line 338 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	structured_name = _tmp30_;
#line 340 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp31_ = structured_name;
#line 340 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp32_ = folks_structured_name_is_empty (_tmp31_);
#line 340 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (!_tmp32_) {
#line 993 "swf-persona.c"
		FolksStructuredName* _tmp33_;
		FolksStructuredName* _tmp34_;
#line 342 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp33_ = structured_name;
#line 342 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp34_ = _g_object_ref0 (_tmp33_);
#line 342 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (self->priv->_structured_name);
#line 342 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_structured_name = _tmp34_;
#line 343 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_object_notify ((GObject*) self, "structured-name");
#line 1006 "swf-persona.c"
	} else {
		FolksStructuredName* _tmp35_;
		FolksStructuredName* _tmp36_;
#line 345 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp35_ = folks_name_details_get_structured_name ((FolksNameDetails*) self);
#line 345 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp36_ = _tmp35_;
#line 345 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		if (_tmp36_ != NULL) {
#line 347 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_object_unref0 (self->priv->_structured_name);
#line 347 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			self->priv->_structured_name = NULL;
#line 348 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_object_notify ((GObject*) self, "structured-name");
#line 1022 "swf-persona.c"
		}
	}
#line 351 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp37_ = contact;
#line 351 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp38_ = sw_contact_get_value (_tmp37_, "fn");
#line 351 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp39_ = g_strdup (_tmp38_);
#line 351 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	full_name = _tmp39_;
#line 353 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp40_ = full_name;
#line 353 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp40_ == NULL) {
#line 1037 "swf-persona.c"
		gchar* _tmp41_;
#line 355 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp41_ = g_strdup ("");
#line 355 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (full_name);
#line 355 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		full_name = _tmp41_;
#line 1045 "swf-persona.c"
	}
#line 358 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp42_ = self->priv->_full_name;
#line 358 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp43_ = full_name;
#line 358 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (g_strcmp0 (_tmp42_, _tmp43_) != 0) {
#line 1053 "swf-persona.c"
		const gchar* _tmp44_;
		gchar* _tmp45_;
#line 360 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp44_ = full_name;
#line 360 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp45_ = g_strdup (_tmp44_);
#line 360 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (self->priv->_full_name);
#line 360 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_full_name = _tmp45_;
#line 361 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_object_notify ((GObject*) self, "full-name");
#line 1066 "swf-persona.c"
	}
#line 364 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp46_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
#line 364 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	urls = _tmp46_;
#line 368 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp47_ = contact;
#line 368 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp48_ = sw_contact_get_value (_tmp47_, "url");
#line 368 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp49_ = g_strdup (_tmp48_);
#line 368 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	website = _tmp49_;
#line 369 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp50_ = website;
#line 369 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp50_ != NULL) {
#line 1084 "swf-persona.c"
		GeeHashSet* _tmp51_;
		const gchar* _tmp52_;
		FolksUrlFieldDetails* _tmp53_;
		FolksUrlFieldDetails* _tmp54_;
#line 370 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp51_ = urls;
#line 370 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp52_ = website;
#line 370 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp53_ = folks_url_field_details_new (_tmp52_, NULL);
#line 370 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp54_ = _tmp53_;
#line 370 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp54_);
#line 370 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (_tmp54_);
#line 1101 "swf-persona.c"
	}
#line 377 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp55_ = self->priv->_urls;
#line 377 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp56_ = urls;
#line 377 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp55_ != _tmp56_) {
#line 1109 "swf-persona.c"
		GeeHashSet* _tmp57_;
		GeeHashSet* _tmp58_;
		GeeHashSet* _tmp59_;
		GeeSet* _tmp60_;
		GeeSet* _tmp61_;
#line 379 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp57_ = urls;
#line 379 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp58_ = _g_object_ref0 (_tmp57_);
#line 379 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (self->priv->_urls);
#line 379 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_urls = _tmp58_;
#line 380 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp59_ = urls;
#line 380 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp60_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp59_);
#line 380 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp61_ = _tmp60_;
#line 380 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_object_unref0 (self->priv->_urls_ro);
#line 380 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_urls_ro = _tmp61_;
#line 381 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_object_notify ((GObject*) self, "urls");
#line 1135 "swf-persona.c"
	}
#line 384 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp62_ = contact;
#line 384 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp63_ = sw_contact_get_value (_tmp62_, "x-gender");
#line 384 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp64_ = g_strdup (_tmp63_);
#line 384 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	gender_string = _tmp64_;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp66_ = gender_string;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp66_ != NULL) {
#line 1149 "swf-persona.c"
		const gchar* _tmp67_;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp67_ = gender_string;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp68_ = g_utf8_strdown (_tmp67_, (gssize) (-1));
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp69_ = _tmp68_;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp65_ = g_strcmp0 (_tmp69_, "male") == 0;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_g_free0 (_tmp69_);
#line 1163 "swf-persona.c"
	} else {
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp65_ = FALSE;
#line 1167 "swf-persona.c"
	}
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp70_ = _tmp65_;
#line 386 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp70_) {
#line 387 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		gender = FOLKS_GENDER_MALE;
#line 1175 "swf-persona.c"
	} else {
		gboolean _tmp71_ = FALSE;
		const gchar* _tmp72_;
		gboolean _tmp76_;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp72_ = gender_string;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		if (_tmp72_ != NULL) {
#line 1184 "swf-persona.c"
			const gchar* _tmp73_;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp73_ = gender_string;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp74_ = g_utf8_strdown (_tmp73_, (gssize) (-1));
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp75_ = _tmp74_;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp71_ = g_strcmp0 (_tmp75_, "female") == 0;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_g_free0 (_tmp75_);
#line 1198 "swf-persona.c"
		} else {
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			_tmp71_ = FALSE;
#line 1202 "swf-persona.c"
		}
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp76_ = _tmp71_;
#line 388 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		if (_tmp76_) {
#line 389 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			gender = FOLKS_GENDER_FEMALE;
#line 1210 "swf-persona.c"
		} else {
#line 391 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			gender = FOLKS_GENDER_UNSPECIFIED;
#line 1214 "swf-persona.c"
		}
	}
#line 392 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp77_ = self->priv->_gender;
#line 392 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp78_ = gender;
#line 392 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp77_ != _tmp78_) {
#line 1223 "swf-persona.c"
		FolksGender _tmp79_;
#line 394 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp79_ = gender;
#line 394 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		self->priv->_gender = _tmp79_;
#line 395 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_object_notify ((GObject*) self, "gender");
#line 1231 "swf-persona.c"
	}
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (gender_string);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (website);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (urls);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (full_name);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (structured_name);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (avatar_path);
#line 307 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (nickname);
#line 1247 "swf-persona.c"
}


static gchar** swf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = SWF_PERSONA__linkable_properties;
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0__length1 = G_N_ELEMENTS (SWF_PERSONA__linkable_properties);
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (result_length1) {
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		*result_length1 = _tmp0__length1;
#line 1266 "swf-persona.c"
	}
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1272 "swf-persona.c"
}


static gchar** swf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = swf_persona__writeable_properties;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0__length1 = swf_persona__writeable_properties_length1;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = _tmp0_;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1__length1 = _tmp0__length1;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (result_length1) {
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		*result_length1 = _tmp1__length1;
#line 1297 "swf-persona.c"
	}
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp1_;
#line 69 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1303 "swf-persona.c"
}


static GLoadableIcon* swf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	SwfPersona* self;
	GLoadableIcon* _tmp0_;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_avatar;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1319 "swf-persona.c"
}


static void swf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	SwfPersona* self;
	GLoadableIcon* _tmp0_;
#line 85 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 85 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 85 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
#line 1332 "swf-persona.c"
}


static FolksStructuredName* swf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_structured_name;
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1348 "swf-persona.c"
}


static void swf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
#line 1361 "swf-persona.c"
}


static const gchar* swf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	const gchar* _tmp0_;
#line 108 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 108 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_full_name;
#line 108 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 108 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1377 "swf-persona.c"
}


static void swf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	const gchar* _tmp0_;
#line 109 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 109 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 109 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
#line 1390 "swf-persona.c"
}


static const gchar* swf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	const gchar* _tmp0_;
#line 120 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 120 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_nickname;
#line 120 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 120 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1406 "swf-persona.c"
}


static void swf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	const gchar* _tmp0_;
#line 121 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 121 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 121 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
#line 1419 "swf-persona.c"
}


static FolksGender swf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	SwfPersona* self;
	FolksGender _tmp0_;
#line 132 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 132 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_gender;
#line 132 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 132 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1435 "swf-persona.c"
}


static void swf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	SwfPersona* self;
	FolksGender _tmp0_;
#line 133 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 133 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 133 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_gender_details_change_gender ((FolksGenderDetails*) self, _tmp0_, NULL, NULL);
#line 1448 "swf-persona.c"
}


static GeeSet* swf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	SwfPersona* self;
	GeeSet* _tmp0_;
#line 145 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 145 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_urls_ro;
#line 145 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 145 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1464 "swf-persona.c"
}


static void swf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	SwfPersona* self;
	GeeSet* _tmp0_;
#line 146 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 146 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 146 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
#line 1477 "swf-persona.c"
}


static GeeMultiMap* swf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	GeeHashMultiMap* _tmp0_;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_im_addresses;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = (GeeMultiMap*) _tmp0_;
#line 165 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1493 "swf-persona.c"
}


static void swf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	GeeMultiMap* _tmp0_;
#line 166 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 166 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 166 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
#line 1506 "swf-persona.c"
}


static GeeMultiMap* swf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	GeeHashMultiMap* _tmp0_;
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_web_service_addresses;
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = (GeeMultiMap*) _tmp0_;
#line 175 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1522 "swf-persona.c"
}


static void swf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	GeeMultiMap* _tmp0_;
#line 177 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = (SwfPersona*) base;
#line 177 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = value;
#line 177 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	folks_web_service_details_change_web_service_addresses ((FolksWebServiceDetails*) self, _tmp0_, NULL, NULL);
#line 1535 "swf-persona.c"
}


SwContact* swf_persona_get_lsw_contact (SwfPersona* self) {
	SwContact* result;
	SwContact* _tmp0_;
#line 187 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 187 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = self->priv->_lsw_contact;
#line 187 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	result = _tmp0_;
#line 187 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	return result;
#line 1550 "swf-persona.c"
}


static void swf_persona_set_lsw_contact (SwfPersona* self, SwContact* value) {
	gboolean _tmp0_ = FALSE;
	SwContact* _tmp1_;
	gboolean _tmp4_;
	SwContact* _tmp6_;
	SwContact* _tmp7_ = NULL;
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_return_if_fail (self != NULL);
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = self->priv->_lsw_contact;
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp1_ != NULL) {
#line 1566 "swf-persona.c"
		SwContact* _tmp2_;
		SwContact* _tmp3_;
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp2_ = self->priv->_lsw_contact;
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp3_ = value;
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp0_ = _tmp2_ != _tmp3_;
#line 1575 "swf-persona.c"
	} else {
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp0_ = FALSE;
#line 1579 "swf-persona.c"
	}
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp4_ = _tmp0_;
#line 190 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	if (_tmp4_) {
#line 1585 "swf-persona.c"
		SwContact* _tmp5_;
#line 192 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		_tmp5_ = self->priv->_lsw_contact;
#line 192 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		sw_contact_unref (_tmp5_);
#line 1591 "swf-persona.c"
	}
#line 194 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp6_ = value;
#line 194 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp7_ = sw_contact_ref (_tmp6_);
#line 194 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	__vala_SwContact_free0 (self->priv->_lsw_contact);
#line 194 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_lsw_contact = _tmp7_;
#line 188 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_notify ((GObject *) self, "lsw-contact");
#line 1603 "swf-persona.c"
}


static void swf_persona_class_init (SwfPersonaClass * klass) {
	gchar** _tmp0_ = NULL;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_parent_class = g_type_class_peek_parent (klass);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_type_class_add_private (klass, sizeof (SwfPersonaPrivate));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = swf_persona_real_get_linkable_properties;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = swf_persona_real_get_writeable_properties;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_get_property;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_swf_persona_set_property;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	G_OBJECT_CLASS (klass)->finalize = swf_persona_finalize;
#line 1623 "swf-persona.c"
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
#line 1631 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
#line 1639 "swf-persona.c"
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_AVATAR, "avatar");
#line 1649 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STRUCTURED_NAME, "structured-name");
#line 1655 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_FULL_NAME, "full-name");
#line 1661 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_NICKNAME, "nickname");
#line 1667 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_GENDER, "gender");
#line 1673 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_URLS, "urls");
#line 1679 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_IM_ADDRESSES, "im-addresses");
#line 1685 "swf-persona.c"
	/**
	   * {@inheritDoc}
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
#line 1691 "swf-persona.c"
	/**
	   * The Contact from libsocialweb
	   */
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LSW_CONTACT, g_param_spec_boxed ("lsw-contact", "lsw-contact", "lsw-contact", sw_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 50 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 50 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona__writeable_properties = _tmp0_;
#line 50 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona__writeable_properties_length1 = 0;
#line 1703 "swf-persona.c"
}


static void swf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_avatar = swf_persona_real_get_avatar;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_avatar = swf_persona_real_set_avatar;
#line 1714 "swf-persona.c"
}


static void swf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_gender = swf_persona_real_get_gender;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_gender = swf_persona_real_set_gender;
#line 1725 "swf-persona.c"
}


static void swf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_im_addresses = swf_persona_real_get_im_addresses;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_im_addresses = swf_persona_real_set_im_addresses;
#line 1736 "swf-persona.c"
}


static void swf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_structured_name = swf_persona_real_get_structured_name;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_structured_name = swf_persona_real_set_structured_name;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_full_name = swf_persona_real_get_full_name;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_full_name = swf_persona_real_set_full_name;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_nickname = swf_persona_real_get_nickname;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_nickname = swf_persona_real_set_nickname;
#line 1755 "swf-persona.c"
}


static void swf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_urls = swf_persona_real_get_urls;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_urls = swf_persona_real_set_urls;
#line 1766 "swf-persona.c"
}


static void swf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	swf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->get_web_service_addresses = swf_persona_real_get_web_service_addresses;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	iface->set_web_service_addresses = swf_persona_real_set_web_service_addresses;
#line 1777 "swf-persona.c"
}


static void swf_persona_instance_init (SwfPersona * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeHashMultiMap* _tmp2_;
	GeeHashMultiMap* _tmp3_;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv = SWF_PERSONA_GET_PRIVATE (self);
#line 72 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_avatar = NULL;
#line 88 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_structured_name = NULL;
#line 100 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = g_strdup ("");
#line 100 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_full_name = _tmp0_;
#line 112 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = g_strdup ("");
#line 112 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_nickname = _tmp1_;
#line 124 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, _folks_abstract_field_details_hash_ghash_func, (GEqualFunc) folks_abstract_field_details_equal);
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_im_addresses = _tmp2_;
#line 153 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
#line 153 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_web_service_addresses = _tmp3_;
#line 1810 "swf-persona.c"
}


static void swf_persona_finalize (GObject* obj) {
	SwfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SwContact* _tmp2_;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self = SWF_PERSONA (obj);
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp1_ = _tmp0_;
#line 297 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	g_debug ("swf-persona.vala:297: Destroying Sw.Persona '%s': %p", _tmp1_, self);
#line 298 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_tmp2_ = self->priv->_lsw_contact;
#line 298 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	sw_contact_unref (_tmp2_);
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	__vala_SwContact_free0 (self->priv->_lsw_contact);
#line 299 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	self->priv->_lsw_contact = NULL;
#line 72 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 88 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (self->priv->_structured_name);
#line 100 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (self->priv->_full_name);
#line 112 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_free0 (self->priv->_nickname);
#line 136 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (self->priv->_urls);
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (self->priv->_urls_ro);
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (self->priv->_im_addresses);
#line 153 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	_g_object_unref0 (self->priv->_web_service_addresses);
#line 180 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	__vala_SwContact_free0 (self->priv->_lsw_contact);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	G_OBJECT_CLASS (swf_persona_parent_class)->finalize (obj);
#line 1855 "swf-persona.c"
}


/**
 * A persona subclass which represents a single libsocialweb contact.
 */
GType swf_persona_get_type (void) {
	static volatile gsize swf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersona), 0, (GInstanceInitFunc) swf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) swf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) swf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) swf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) swf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) swf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) swf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType swf_persona_type_id;
		swf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "SwfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&swf_persona_type_id__volatile, swf_persona_type_id);
	}
	return swf_persona_type_id__volatile;
}


static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	switch (property_id) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_LINKABLE_PROPERTIES:
#line 1893 "swf-persona.c"
		{
			int length;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
#line 1898 "swf-persona.c"
		}
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_WRITEABLE_PROPERTIES:
#line 1904 "swf-persona.c"
		{
			int length;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
#line 1909 "swf-persona.c"
		}
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_AVATAR:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_STRUCTURED_NAME:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_FULL_NAME:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_NICKNAME:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_GENDER:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_URLS:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_IM_ADDRESSES:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_LSW_CONTACT:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		g_value_set_boxed (value, swf_persona_get_lsw_contact (self));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 1967 "swf-persona.c"
		default:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 1973 "swf-persona.c"
	}
}


static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
	switch (property_id) {
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_AVATAR:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_STRUCTURED_NAME:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_FULL_NAME:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_NICKNAME:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_GENDER:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_URLS:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_IM_ADDRESSES:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		case SWF_PERSONA_LSW_CONTACT:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		swf_persona_set_lsw_contact (self, g_value_get_boxed (value));
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 2037 "swf-persona.c"
		default:
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 30 "/opt/gnome2/source/folks/backends/libsocialweb/lib/swf-persona.vala"
		break;
#line 2043 "swf-persona.c"
	}
}



