#!/bin/sh
# with-session-bus-eds.sh - run a program with a temporary D-Bus session daemon
#
# interesting bits have been move into dbus to permit reusability
#
# Copyright (C) 2007-2008 Collabora Ltd. <http://www.collabora.co.uk/>
#
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.


cur_dir=`dirname $0`

. $cur_dir"/dbus-session.sh"
. $cur_dir"/eds.sh"

dbus_parse_args $@
while test "z$1" != "z--"; do
    shift
done
shift
if test "z$1" = "z"; then dbus_usage; fi

cleanup ()
{
    eds_stop
    dbus_stop
    test -d ../data/gconf.d && rm -rf ../data/gconf.d
}

trap cleanup INT HUP TERM

# In case the previous run left some junk around...
test -d ../data/gconf.d && rm -rf ../data/gconf.d

eds_init_settings
dbus_init 0

dbus_start
eds_start

e=0
"$@" || e=$?

trap - INT HUP TERM
cleanup

exit $e
