/* memory-icon.c generated by valac 0.17.6.5-65f99, the Vala compiler
 * generated from memory-icon.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define EDSF_TYPE_MEMORY_ICON (edsf_memory_icon_get_type ())
#define EDSF_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIcon))
#define EDSF_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconClass))
#define EDSF_IS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDSF_TYPE_MEMORY_ICON))
#define EDSF_IS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDSF_TYPE_MEMORY_ICON))
#define EDSF_MEMORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconClass))

typedef struct _EdsfMemoryIcon EdsfMemoryIcon;
typedef struct _EdsfMemoryIconClass EdsfMemoryIconClass;
typedef struct _EdsfMemoryIconPrivate EdsfMemoryIconPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _EdsfMemoryIconLoadAsyncData EdsfMemoryIconLoadAsyncData;

struct _EdsfMemoryIcon {
	GObject parent_instance;
	EdsfMemoryIconPrivate * priv;
};

struct _EdsfMemoryIconClass {
	GObjectClass parent_class;
};

struct _EdsfMemoryIconPrivate {
	guint8* _image_data;
	gint _image_data_length1;
	gint __image_data_size_;
	gchar* _image_type;
};

struct _EdsfMemoryIconLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsfMemoryIcon* self;
	gint size;
	GCancellable* cancellable;
	gchar* type;
	GInputStream* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GMemoryInputStream* _tmp4_;
};


static gpointer edsf_memory_icon_parent_class = NULL;
static GIconIface* edsf_memory_icon_g_icon_parent_iface = NULL;
static GLoadableIconIface* edsf_memory_icon_g_loadable_icon_parent_iface = NULL;

GType edsf_memory_icon_get_type (void) G_GNUC_CONST;
#define EDSF_MEMORY_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconPrivate))
enum  {
	EDSF_MEMORY_ICON_DUMMY_PROPERTY
};
EdsfMemoryIcon* edsf_memory_icon_new (const gchar* image_type, guint8* image_data, int image_data_length1);
EdsfMemoryIcon* edsf_memory_icon_construct (GType object_type, const gchar* image_type, guint8* image_data, int image_data_length1);
static guint8* _vala_array_dup2 (guint8* self, int length);
static gboolean edsf_memory_icon_real_equal (GIcon* base, GIcon* icon2);
static guint edsf_memory_icon_real_hash (GIcon* base);
static GInputStream* edsf_memory_icon_real_load (GLoadableIcon* base, gint size, gchar** type, GCancellable* cancellable, GError** error);
static guint8* _vala_array_dup3 (guint8* self, int length);
static void _g_free_gdestroy_notify (void* data);
static void edsf_memory_icon_real_load_async_data_free (gpointer _data);
static void edsf_memory_icon_real_load_async (GLoadableIcon* base, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean edsf_memory_icon_real_load_async_co (EdsfMemoryIconLoadAsyncData* _data_);
static guint8* _vala_array_dup4 (guint8* self, int length);
static void edsf_memory_icon_finalize (GObject* obj);


/**
   * Construct a new in-memory icon.
   *
   * @param image_type the content type of the image
   * @param image_data the binary data of the image
   * @since 0.6.0
   */
static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 116 "memory-icon.c"
}


EdsfMemoryIcon* edsf_memory_icon_construct (GType object_type, const gchar* image_type, guint8* image_data, int image_data_length1) {
	EdsfMemoryIcon * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 42 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self = (EdsfMemoryIcon*) g_object_new (object_type, NULL);
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp0_ = image_data;
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp0__length1 = image_data_length1;
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp1__length1 = _tmp0__length1;
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv->_image_data = (g_free (self->priv->_image_data), NULL);
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv->_image_data = _tmp1_;
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv->_image_data_length1 = _tmp1__length1;
#line 48 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv->__image_data_size_ = self->priv->_image_data_length1;
#line 49 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp2_ = image_type;
#line 49 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 49 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_free0 (self->priv->_image_type);
#line 49 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv->_image_type = _tmp3_;
#line 42 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return self;
#line 156 "memory-icon.c"
}


EdsfMemoryIcon* edsf_memory_icon_new (const gchar* image_type, guint8* image_data, int image_data_length1) {
#line 42 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return edsf_memory_icon_construct (EDSF_TYPE_MEMORY_ICON, image_type, image_data, image_data_length1);
#line 163 "memory-icon.c"
}


/**
   * Decide whether two {@link MemoryIcon} instances are equal. This compares
   * their image data and returns ``true`` if they are identical.
   *
   * @param icon2 the {@link MemoryIcon} instance to compare against
   * @return ``true`` if the instances are equal, ``false`` otherwise
   * @since 0.6.0
   */
static gpointer _g_object_ref0 (gpointer self) {
#line 64 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return self ? g_object_ref (self) : NULL;
#line 178 "memory-icon.c"
}


static gboolean edsf_memory_icon_real_equal (GIcon* base, GIcon* icon2) {
	EdsfMemoryIcon * self;
	gboolean result = FALSE;
	GIcon* _tmp0_;
	EdsfMemoryIcon* _tmp1_;
	EdsfMemoryIcon* icon;
	gboolean _tmp2_ = FALSE;
	guint8* _tmp3_;
	gint _tmp3__length1;
	EdsfMemoryIcon* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp11_;
#line 60 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self = (EdsfMemoryIcon*) base;
#line 64 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp0_ = icon2;
#line 64 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_ICON, GIcon), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIcon));
#line 64 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	icon = _tmp1_;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp3_ = self->priv->_image_data;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp3__length1 = self->priv->_image_data_length1;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp4_ = icon;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp5_ = _tmp4_->priv->_image_data;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp5__length1 = _tmp4_->priv->_image_data_length1;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	if (_tmp3__length1 == _tmp5__length1) {
#line 215 "memory-icon.c"
		guint8* _tmp6_;
		gint _tmp6__length1;
		EdsfMemoryIcon* _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		guint8* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_ = 0;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp6_ = self->priv->_image_data;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp6__length1 = self->priv->_image_data_length1;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp7_ = icon;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp8_ = _tmp7_->priv->_image_data;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp8__length1 = _tmp7_->priv->_image_data_length1;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp9_ = self->priv->_image_data;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp9__length1 = self->priv->_image_data_length1;
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp10_ = memcmp (_tmp6_, _tmp8_, (gsize) _tmp9__length1);
#line 67 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp2_ = _tmp10_ == 0;
#line 242 "memory-icon.c"
	} else {
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp2_ = FALSE;
#line 246 "memory-icon.c"
	}
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp11_ = _tmp2_;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	result = _tmp11_;
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_object_unref0 (icon);
#line 66 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return result;
#line 256 "memory-icon.c"
}


/**
   * Calculate a hash value of the image type and data, suitable for use as a
   * hash table key. This is not a cryptographic hash.
   *
   * @return hash value over the image type and data
   * @since 0.6.0
   */
static guint edsf_memory_icon_real_hash (GIcon* base) {
	EdsfMemoryIcon * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_;
	guint _tmp4_;
	guint hash;
#line 78 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self = (EdsfMemoryIcon*) base;
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp1_ = self->priv->_image_type;
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	if (_tmp1_ != NULL) {
#line 280 "memory-icon.c"
		const gchar* _tmp2_;
		guint _tmp3_ = 0U;
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp2_ = self->priv->_image_type;
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp3_ = g_str_hash ((const gchar*) _tmp2_);
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp0_ = _tmp3_;
#line 289 "memory-icon.c"
	} else {
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_tmp0_ = (guint) 0;
#line 293 "memory-icon.c"
	}
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp4_ = _tmp0_;
#line 90 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	hash = _tmp4_;
#line 299 "memory-icon.c"
	{
		guint i;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		i = (guint) 0;
#line 304 "memory-icon.c"
		{
			gboolean _tmp5_;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
			_tmp5_ = TRUE;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
			while (TRUE) {
#line 311 "memory-icon.c"
				gboolean _tmp6_;
				guint _tmp8_;
				guint8* _tmp9_;
				gint _tmp9__length1;
				guint _tmp10_;
				guint _tmp11_;
				guint8* _tmp12_;
				gint _tmp12__length1;
				guint _tmp13_;
				guint8 _tmp14_;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp6_ = _tmp5_;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				if (!_tmp6_) {
#line 326 "memory-icon.c"
					guint _tmp7_;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
					_tmp7_ = i;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
					i = _tmp7_ + 1;
#line 332 "memory-icon.c"
				}
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp5_ = FALSE;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp8_ = i;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp9_ = self->priv->_image_data;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp9__length1 = self->priv->_image_data_length1;
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				if (!(_tmp8_ < ((guint) _tmp9__length1))) {
#line 92 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
					break;
#line 346 "memory-icon.c"
				}
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp10_ = hash;
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp11_ = hash;
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp12_ = self->priv->_image_data;
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp12__length1 = self->priv->_image_data_length1;
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp13_ = i;
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 94 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
				hash = ((_tmp10_ << 5) + _tmp11_) + _tmp14_;
#line 362 "memory-icon.c"
			}
		}
	}
#line 97 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	result = hash;
#line 97 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return result;
#line 370 "memory-icon.c"
}


/**
   * Build an input stream for loading the image data. This will return
   * without blocking on I/O.
   *
   * @param size the square dimensions to output the image at (unused), or -1
   * @param type return location for the content type of the image, or ``null``
   * @param cancellable optional {@link GLib.Cancellable}, or ``null``
   * @return an input stream providing access to the image data
   * @since 0.6.0
   */
static guint8* _vala_array_dup3 (guint8* self, int length) {
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 387 "memory-icon.c"
}


static void _g_free_gdestroy_notify (void* data) {
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	g_free (data);
#line 394 "memory-icon.c"
}


static GInputStream* edsf_memory_icon_real_load (GLoadableIcon* base, gint size, gchar** type, GCancellable* cancellable, GError** error) {
	EdsfMemoryIcon * self;
	gchar* _vala_type = NULL;
	GInputStream* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GMemoryInputStream* _tmp4_;
#line 110 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self = (EdsfMemoryIcon*) base;
#line 113 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp0_ = self->priv->_image_type;
#line 113 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 113 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_free0 (_vala_type);
#line 113 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_vala_type = _tmp1_;
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp2_ = self->priv->_image_data;
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp2__length1 = self->priv->_image_data_length1;
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup3 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp3__length1 = _tmp2__length1;
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, _g_free_gdestroy_notify);
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	result = (GInputStream*) _tmp4_;
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	if (type) {
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		*type = _vala_type;
#line 435 "memory-icon.c"
	} else {
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_g_free0 (_vala_type);
#line 439 "memory-icon.c"
	}
#line 114 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return result;
#line 443 "memory-icon.c"
}


static void edsf_memory_icon_real_load_async_data_free (gpointer _data) {
	EdsfMemoryIconLoadAsyncData* _data_;
	_data_ = _data;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_object_unref0 (_data_->cancellable);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_object_unref0 (_data_->result);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_object_unref0 (_data_->self);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	g_slice_free (EdsfMemoryIconLoadAsyncData, _data_);
#line 458 "memory-icon.c"
}


static void edsf_memory_icon_real_load_async (GLoadableIcon* base, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsfMemoryIcon * self;
	EdsfMemoryIconLoadAsyncData* _data_;
	EdsfMemoryIcon* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self = (EdsfMemoryIcon*) base;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_ = g_slice_new0 (EdsfMemoryIconLoadAsyncData);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, edsf_memory_icon_real_load_async);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, edsf_memory_icon_real_load_async_data_free);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->self = _tmp0_;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp1_ = size;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->size = _tmp1_;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp2_ = cancellable;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_object_unref0 (_data_->cancellable);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->cancellable = _tmp3_;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	edsf_memory_icon_real_load_async_co (_data_);
#line 495 "memory-icon.c"
}


static GInputStream* edsf_memory_icon_real_load_finish (GLoadableIcon* base, GAsyncResult* _res_, gchar** type, GError** error) {
	GInputStream* result;
	EdsfMemoryIconLoadAsyncData* _data_;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	if (type) {
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		*type = _data_->type;
#line 508 "memory-icon.c"
	} else {
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		_g_free0 (_data_->type);
#line 512 "memory-icon.c"
	}
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->type = NULL;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	result = _data_->result;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->result = NULL;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return result;
#line 522 "memory-icon.c"
}


/**
   * Asynchronously build an input stream for loading the image data. This
   * will complete without blocking on I/O.
   *
   * @param size the square dimensions to output the image at (unused), or -1
   * @param cancellable optional {@link GLib.Cancellable}, or ``null``
   * @param type return location for the content type of the image, or ``null``
   * @return an input stream providing access to the image data
   * @since 0.6.0
   */
static guint8* _vala_array_dup4 (guint8* self, int length) {
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 539 "memory-icon.c"
}


static gboolean edsf_memory_icon_real_load_async_co (EdsfMemoryIconLoadAsyncData* _data_) {
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	switch (_data_->_state_) {
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		case 0:
#line 548 "memory-icon.c"
		goto _state_0;
		default:
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		g_assert_not_reached ();
#line 553 "memory-icon.c"
	}
	_state_0:
#line 130 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp0_ = _data_->self->priv->_image_type;
#line 130 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
#line 130 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_free0 (_data_->type);
#line 130 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->type = _data_->_tmp1_;
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp2_ = _data_->self->priv->_image_data;
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp2__length1 = _data_->self->priv->_image_data_length1;
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp3_ = (_data_->_tmp2_ != NULL) ? _vala_array_dup4 (_data_->_tmp2_, _data_->_tmp2__length1) : ((gpointer) _data_->_tmp2_);
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp3__length1 = _data_->_tmp2__length1;
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_data_->_tmp3_, _data_->_tmp3__length1, _g_free_gdestroy_notify);
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_data_->result = (GInputStream*) _data_->_tmp4_;
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	if (_data_->_state_ == 0) {
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 580 "memory-icon.c"
	} else {
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 584 "memory-icon.c"
	}
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	g_object_unref (_data_->_async_result);
#line 131 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return FALSE;
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	if (_data_->_state_ == 0) {
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 594 "memory-icon.c"
	} else {
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 598 "memory-icon.c"
	}
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	g_object_unref (_data_->_async_result);
#line 127 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	return FALSE;
#line 604 "memory-icon.c"
}


static void edsf_memory_icon_class_init (EdsfMemoryIconClass * klass) {
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	edsf_memory_icon_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	g_type_class_add_private (klass, sizeof (EdsfMemoryIconPrivate));
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	G_OBJECT_CLASS (klass)->finalize = edsf_memory_icon_finalize;
#line 615 "memory-icon.c"
}


static void edsf_memory_icon_g_icon_interface_init (GIconIface * iface) {
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	edsf_memory_icon_g_icon_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	iface->equal = (gboolean (*)(GIcon*, GIcon*)) edsf_memory_icon_real_equal;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	iface->hash = (guint (*)(GIcon*)) edsf_memory_icon_real_hash;
#line 626 "memory-icon.c"
}


static void edsf_memory_icon_g_loadable_icon_interface_init (GLoadableIconIface * iface) {
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	edsf_memory_icon_g_loadable_icon_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	iface->load = (GInputStream* (*)(GLoadableIcon*, gint, gchar**, GCancellable*, GError**)) edsf_memory_icon_real_load;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	iface->load_async = (GInputStream* (*)(GLoadableIcon*, gint, GCancellable*, gchar**, GError**)) edsf_memory_icon_real_load_async;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	iface->load_finish = edsf_memory_icon_real_load_finish;
#line 639 "memory-icon.c"
}


static void edsf_memory_icon_instance_init (EdsfMemoryIcon * self) {
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv = EDSF_MEMORY_ICON_GET_PRIVATE (self);
#line 646 "memory-icon.c"
}


static void edsf_memory_icon_finalize (GObject* obj) {
	EdsfMemoryIcon * self;
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDSF_TYPE_MEMORY_ICON, EdsfMemoryIcon);
#line 32 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	self->priv->_image_data = (g_free (self->priv->_image_data), NULL);
#line 33 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	_g_free0 (self->priv->_image_type);
#line 30 "/home/jpwhiting/devel/collabora/src/gnome/folks/backends/eds/lib/memory-icon.vala"
	G_OBJECT_CLASS (edsf_memory_icon_parent_class)->finalize (obj);
#line 660 "memory-icon.c"
}


/**
 * A wrapper around a blob of image data (with an associated content type) which
 * presents it as a {@link GLib.LoadableIcon}. This allows inlined avatars to be
 * returned as {@link GLib.LoadableIcon}s.
 *
 * @since 0.6.0
 */
GType edsf_memory_icon_get_type (void) {
	static volatile gsize edsf_memory_icon_type_id__volatile = 0;
	if (g_once_init_enter (&edsf_memory_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EdsfMemoryIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edsf_memory_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsfMemoryIcon), 0, (GInstanceInitFunc) edsf_memory_icon_instance_init, NULL };
		static const GInterfaceInfo g_icon_info = { (GInterfaceInitFunc) edsf_memory_icon_g_icon_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo g_loadable_icon_info = { (GInterfaceInitFunc) edsf_memory_icon_g_loadable_icon_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType edsf_memory_icon_type_id;
		edsf_memory_icon_type_id = g_type_register_static (G_TYPE_OBJECT, "EdsfMemoryIcon", &g_define_type_info, 0);
		g_type_add_interface_static (edsf_memory_icon_type_id, G_TYPE_ICON, &g_icon_info);
		g_type_add_interface_static (edsf_memory_icon_type_id, g_loadable_icon_get_type (), &g_loadable_icon_info);
		g_once_init_leave (&edsf_memory_icon_type_id__volatile, edsf_memory_icon_type_id);
	}
	return edsf_memory_icon_type_id__volatile;
}



